/************************************************************************
 * kcreateinst - part of kinst package - gui.h                          *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _GUI_H
#define _GUI_H

#include <qwidget.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <qpopupmenu.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <drag.h>

#include "preferences.h"
#include "createdlg.h"
#include "previnstdlg.h"
#include "tgzview.h"
#include "scriptbuild.h"
#include "tgzcompose.h"
#include "multipack.h"

class tYesNoDlg:public QDialog
{
  Q_OBJECT
 private:
  int i;
  QString text;
  QLabel* text_label;
  QPushButton* yes_button;
  QPushButton* no_button;
 private slots:
  void YesPressed();
  void NoPressed();
 protected:
  void resizeEvent(QResizeEvent*);
 public:
  int getYesNo(QString text_to_display);
  tYesNoDlg(QWidget* parent, const char* name);
};

class kcreateinstMainWidget:public KTMainWindow
{
  Q_OBJECT
 private:
  tParams* params;
  KConfig* config;
  kcreateinstPreferences* preferences_dlg;
  kcreateinstCreateDlg* create_dlg;
  kcreateinstPrevInstDlg* previnst_dlg;
  kcreateinstScriptBuild* scriptbuild_dlg;
  tYesNoDlg* NewProject_YesNoDlg;
  KMenuBar* menubar;
  KToolBar* toolbar;
  KStatusBar* statusbar;
  QPixmap* kinst_picture;
  QPixmap* exit_picture;
  QPixmap* start_picture;
  QPixmap* new_picture;
  QPixmap* open_picture;
  QPixmap* save_picture;
  QLabel* kinst_picture_label;
  QPopupMenu* filemenu;
  QPopupMenu* optionsmenu;
  QPopupMenu* scriptmenu;
  QPopupMenu* multipackagemenu;
  QWidget* mainview;
  QLineEdit* sourcefile_edit;
  QLineEdit* readmefile_edit;
  QLineEdit* graphicsfile_edit;
  QLineEdit* preinstallscript_edit;
  QLineEdit* defaultmenuentry_edit;
  QLineEdit* defaultinstallpath_edit;
  QLineEdit* librarydir_edit;
  QLineEdit* url_edit;
  QLabel* sourcefile_label;
  QLabel* readmefile_label;
  QLabel* graphicsfile_label;
  QLabel* preinstallscript_label;
  QLabel* defaultmenuentry_label;
  QLabel* defaultinstallpath_label;
  QLabel* librarydir_label;
  QLabel* url_label;
  KDNDDropZone* sourcefile_dnd;
  KDNDDropZone* readmefile_dnd;
  KDNDDropZone* graphicsfile_dnd;
  KDNDDropZone* preinstallscript_dnd;
  KDNDDropZone* defaultinstallpath_dnd;
  KDNDDropZone* url_dnd;
  QFrame* Separation;
  QFrame* Separation2;
  QFrame* Separation3;
  QPushButton* create_button;
  QPushButton* sourcefile_button;
  QPushButton* sourcefile_create_button;
  QPushButton* readmefile_button;
  QPushButton* readmefile_edit_button;
  QPushButton* graphicsfile_button;
  QPushButton* graphicsfile_edit_button;
  QPushButton* preinstallscript_button;
  QPushButton* preinstallscript_edit_button;
  QPushButton* previnstdetector_button;
  QPushButton* librarydir_button;
  QLabel* exec_label;
  QLabel* doneinstallscript_label;
  QLabel* icon_label;
  QLabel* kdelnkadd_label;
  QLabel* name_label;
  QLineEdit* exec_edit;
  QLineEdit* doneinstallscript_edit;
  QLineEdit* icon_edit;
  QLineEdit* kdelnkadd_edit;
  QLineEdit* name_edit;
  QPushButton* exec_button;
  QPushButton* doneinstallscript_button;
  QPushButton* icon_button;
  QPushButton* kdelnkadd_button;
  QLabel* Col1_Label;
  QLabel* Col2_Label;
  QLabel* Row2_Label;
  KFileDialog* FileSelector;
  QRadioButton* tgz_radio;
  QRadioButton* rpm_radio;
  QRadioButton* deb_radio;
  QButtonGroup* sourcefiletype_group;
  QRadioButton* reboot_yes_radio;
  QRadioButton* reboot_no_radio;
  QButtonGroup* reboot_group;
  QRadioButton* relocatable_yes_radio;
  QRadioButton* relocatable_no_radio;
  QButtonGroup* relocatable_group;
  tTGZViewDlg* TGZViewDlg;
  tTGZComposeDlg* TGZComposeDlg;
  tMultiPackDlg* MultiPackDlg;
  QString MainWindowCaption;
  QString ActProject;
 private slots:
  void surr_moved();
  void scriptbuildshow();
  void PreferencesDlgOpened();
  void CreatePressed();
  void Browse1Pressed();
  void Browse2Pressed();
  void Browse3Pressed();
  void Browse4Pressed();
  void Browse5Pressed();
  void Browse6Pressed();
  void Browse7Pressed();
  void Browse8Pressed();
  void Browse9Pressed();
  void InstDetectPressed();
  void NewProject();
  void LoadPressed();
  void SavePressed();
  void SaveAsPressed();
  void tgz_radio_pressed();
  void rpm_radio_pressed();
  void deb_radio_pressed();
  void sourcefile_dnd_drop();
  void readmefile_dnd_drop();
  void graphicsfile_dnd_drop();
  void preinstallscript_dnd_drop();
  void defaultinstallpath_dnd_drop();
  void url_dnd_drop();
  void sourcefile_create_button_pressed();
  void readmefile_edit_button_pressed();
  void preinstallscript_edit_button_pressed();
  void graphicsfile_edit_button_pressed();
  void multipackageshow();
 protected:
  void resizeEvent(QResizeEvent*);
 public:
  kcreateinstMainWidget();
};

#endif
