#include "KSheetDlg.h"
#include <qpushbt.h>
#include <qgrpbox.h>

#include "KSheetDlg.moc"

KSheetDlg::KSheetDlg(const char* name) : QDialog(0, name, TRUE) {
  m_nCurSheet = -1;

  setCaption(name);
  
  m_pSheetHolder = new QGroupBox(this);
  m_pSheetHolder->setFrameStyle(QFrame::Panel | QFrame::Raised);
  m_pSheetHolder->setLineWidth(2);

  m_pNext = new QPushButton("Next >", this);
  connect(m_pNext, SIGNAL(clicked()), SLOT(onNext()));

  m_pPrev = new QPushButton("< Prev", this);
  connect(m_pPrev, SIGNAL(clicked()), SLOT(onPrev()));

  m_pFinish = new QPushButton("Finish", this);
  connect(m_pFinish, SIGNAL(clicked()), SLOT(accept()));

  m_pCancel = new QPushButton("Cancel", this);
  connect(m_pCancel, SIGNAL(clicked()), SLOT(reject()));

  resize(400, 400);

  calcLayout();
  
  m_pNext->show();
  m_pPrev->show();
  m_pFinish->show();
  m_pCancel->show();
  m_pSheetHolder->show();
}

void KSheetDlg::addSheet(KSheet* sheet) {
  QPoint p(0, 0);
  sheet->recreate(m_pSheetHolder, 0, p);
  m_cSheets.append(sheet);
  connect(sheet, SIGNAL(disableNext()), SLOT(disableNext()));
  connect(sheet, SIGNAL(enableNext()), SLOT(enableNext()));
  connect(sheet, SIGNAL(disableFinish()), SLOT(disableFinish()));
  connect(sheet, SIGNAL(enableFinish()), SLOT(enableFinish()));
}

void KSheetDlg::setNextButton(const char* text) {
  m_pNext->setText(text);
}

void KSheetDlg::setPrevButton(const char* text) {
  m_pPrev->setText(text);
}

void KSheetDlg::setFinishButton(const char* text) {
  m_pFinish->setText(text);
}

void KSheetDlg::setCancelButton(const char* text) {
  m_pCancel->setText(text);
}

void KSheetDlg::updateButtons() {
  if(m_cSheets.count()) {
    // Allow previous if we are not on the first sheet
    m_pPrev->setEnabled(m_nCurSheet > 0);

    // If we are on the last sheet, then NO next
    if(m_nCurSheet + 1 >= (int)m_cSheets.count())
      m_pNext->setEnabled(FALSE);
    else // let the sheet decide
      m_pNext->setEnabled(m_cSheets.at(m_nCurSheet)->allowNext());

    // If we are on the last sheet, Finish must be enabled.
    if((int)m_cSheets.count() == m_nCurSheet + 1)
      m_pFinish->setEnabled(TRUE);
    else // let the sheet decide
      m_pFinish->setEnabled(m_cSheets.at(m_nCurSheet)->allowFinish());
    
  } else {
    m_pPrev->setEnabled(FALSE);
    m_pNext->setEnabled(FALSE);
    m_pFinish->setEnabled(FALSE);
  }
}

void KSheetDlg::calcLayout() {
  QSize dlgsize = size();

  int bw = (dlgsize.width() - 20 * 5) / 4;
  int by = dlgsize.height() - 50;

  m_pPrev->setGeometry(20, by, bw, 30);
  m_pNext->setGeometry(20+bw+20, by, bw, 30);
  m_pFinish->setGeometry(60+bw*2, by, bw, 30);
  m_pCancel->setGeometry(80+bw*3, by, bw, 30);
  m_pSheetHolder->setGeometry(20, 20, dlgsize.width() - 40, dlgsize.height() - 90);

  if(m_cSheets.count()) {
    int shw = m_cSheets.at(m_nCurSheet)->size().width();
    int shh = m_cSheets.at(m_nCurSheet)->size().height();
    int hw = m_pSheetHolder->size().width();
    int hh = m_pSheetHolder->size().height();
    
    m_cSheets.at(m_nCurSheet)->setGeometry((hw - shw) / 2, (hh - shh) / 2,
					   shw, shh);
    m_pSheetHolder->setTitle(m_cSheets.at(m_nCurSheet)->getTitle());
  }
}

void KSheetDlg::show() {
  m_nCurSheet = 0; // Begin with first sheet

  if(m_cSheets.count()) {
    KSheet* sheet = m_cSheets.at(m_nCurSheet);
    sheet->show();
  }
  calcLayout();
  updateButtons();
  QDialog::show();
}

void KSheetDlg::enableFinish() {
  m_pFinish->setEnabled(TRUE);
}

void KSheetDlg::enableNext() {
  // if we are not on the last sheet, then allow enabling next
  if(m_nCurSheet + 1 < (int)m_cSheets.count())
    m_pNext->setEnabled(TRUE);
}

void KSheetDlg::disableFinish() {
  m_pFinish->setEnabled(FALSE);
}

void KSheetDlg::disableNext() {
  m_pNext->setEnabled(FALSE);
}

void KSheetDlg::onNext() {
  m_cSheets.at(m_nCurSheet++)->hide();
  calcLayout();
  m_cSheets.at(m_nCurSheet)->show();
  updateButtons();
}

void KSheetDlg::onPrev() {
  m_cSheets.at(m_nCurSheet--)->hide();
  calcLayout();
  m_cSheets.at(m_nCurSheet)->show();
  updateButtons();
}

void KSheetDlg::resizeEvent(QResizeEvent* ev) {
  calcLayout();
}


