/***************************************************************************
                          khtab3.h  -  description                              
                             -------------------                                         
    begin                : Sat Aug 21 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHTAB3_H
#define KHTAB3_H

#include <kapp.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include "khglobals.h"

struct KHTab3Private{
	QBoxLayout *toplayout;
	QBoxLayout *hbox;
	QGroupBox *group;
	QButtonGroup *bg;
	QRadioButton *rb;
};

/**
  *@author Ruediger Anlauf
  *@short Config dialog: tab for selecting sensor types
  */

class KHTab3 : public QWidget  {

Q_OBJECT

public: 
	KHTab3( QWidget *parent = 0, const char* name = 0 );
	~KHTab3();

protected:
	enum SensorType { Thermistor, Transistor, PIIDiode };
	KConfig* config;
	KHTab3Private *d;

protected slots:
	void writeSensor1Type( int type );
	void writeSensor2Type( int type );
	void writeSensor3Type( int type );

};

#endif








