  /*

  kfirewall v 0.4.2

  Copyright (C) 1999 Kim Andre Norheim
  		     kim-nor@online.no

  This application is free software; you can redistribute it and/or
  modify it under the terms of the GNU Genereal Public License as
  published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  This application is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
  GNU General Public License for more details.

  */


#ifndef KFIREWALL_H
#define KFIREWALL_H

#include <qlistbox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qmessagebox.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <kpopmenu.h>
#include <kprocess.h>
#include <kstatusbar.h>

#define ID_HINTTEXT 1

class kfirewall : public KTMainWindow
{

  Q_OBJECT

protected:
  /* setup functions */
  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupkfirewallWidget(); 

  void setupConnect();

  /* check for ipchains function */
  void checkIpchains();

  /* check for masqurading function */
  void checkMasquerade();

public:
  kfirewall( QWidget *parent=0, const char *name=0 );
  ~kfirewall();

  void closeEvent (QCloseEvent *);

  /* defines some processes */
  KProcess addp;
  KProcess addp2;
  KProcess delp;
  KProcess delp2;
  KProcess stop;
  KProcess masqon;
  KProcess masqoff;
  KProcess rules;
  KProcess fetchIp;
  KProcess fetchNetmask;
  KProcess entries;

public slots:
  void addRule();
  void delRule();
  void stopAll();
  void slotExit();
  void addDone();
  void delDone();
  void stopDone();
  void checkMasqon();
  void masqonDone();
  void masqoffDone();
  void clearLog();

   /* interface functions */
  void startprobeInterface();
  void probeInterface(KProcess *, char *, int);
  void probeInterface2(KProcess *, char *, int); 
  void probeInterfaceDone();

  /* list rules functions */
  void ipchainsRules();
  void closeipchainsRules();
  void startlistRules();
  void listRulesDone();
  void listRules(KProcess *, char *, int);

  void interfaceActivated(int);
  void interfacenrActivated(int);


   /* list masq functions */
  void closemasqEntries();
  void startmasqEntries();
  void userEntries(KProcess *, char *, int);
  void userEntriesDone();
  void masqEntries();
  

private:
  /* some global objects */
  QPushButton *startBtn;
  QPushButton *stopBtn;
  QPushButton *helpBtn;
  QPushButton *exitBtn; 
  QListBox *messageLog;
  QPopupMenu *file;
  QPopupMenu *options;
  QPopupMenu *help;
  QLineEdit *ipAddr;
  QLineEdit *netmaskAddr;
  QLineEdit *addPort;
  QWidget *masqList;
  QListBox *masqBox;
  QComboBox *interface;
  QComboBox *interfacenr;


  /* the menubar, toolbar and statusbar */
  KMenuBar *menubar;
  KToolBar *toolbar;
  KStatusBar *statusbar;

  QWidget *masqWidget;

  /* checking for files */
  FILE *sbin;
  FILE *ip_masquerade;
  
  int toolbar1;
  
  bool isMasqon;
  int useMasq;
  char *use;
  
  char *interfaceChoice;
  int interfacenrChoice;

  int add;
  int del; 

};

#endif
