/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "advancedDialog.h"
#include "advancedDialog.moc"
#include <qlayout.h>
#include <klocale.h>

advancedDialog::advancedDialog (scopeAddresses *sa,QWidget* parent, const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 10);
  QBoxLayout *buttonLayout = new QHBoxLayout();
  
  Options_Box = new QGroupBox(i18n("Options"),this);
  topLayout->addWidget(Options_Box,10);

  topLayout->addLayout(buttonLayout);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );

  Help_Button = new QPushButton(i18n("Help"), this);
  Help_Button->setMinimumSize(Help_Button->sizeHint());
  connect( Help_Button, SIGNAL(clicked()), SLOT(Help_Click()) );
  buttonLayout->addWidget(Help_Button);
  Help_Button->setEnabled(false);

  buttonLayout->addStretch(10);

  Ok_Button = new QPushButton(i18n("OK"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);

  NetbiosDDServer_Label = new QLabel(i18n("Netbios DD server:"), Options_Box);
  NetbiosNodeType_Label = new QLabel(i18n("Netbios Node Type:"), Options_Box);
  NisDomain_Label = new QLabel(i18n("Nis Domain:"), Options_Box);
  NisServers_Label = new QLabel(i18n("Nis servers:"), Options_Box);

  DiplayManager_Label = new QLabel(i18n("X Window System Display Manager:"), Options_Box);
  FontServers_Label = new QLabel(i18n("X Window  System  Font servers:"), Options_Box);
  NtpServers_Label = new QLabel(i18n("NTP servers:"), Options_Box);
  SwapServer_Label = new QLabel(i18n("Swap server:"), Options_Box);
  ResourceLocationServers_Label = new QLabel(i18n("Resource Location servers:"), Options_Box);
  ImpressServers_Label = new QLabel(i18n("Imagen Impress servers:"), Options_Box);
  LprServers_Label = new QLabel(i18n("Lpr Servers:"), Options_Box);
  CookieServers_Label = new QLabel(i18n("Cookie servers:"), Options_Box);
  LogServers_Label = new QLabel(i18n("MIT-LCS UDP Log Servers:"), Options_Box);
  Ien116NameServers_Label = new QLabel(i18n("IEN 116 name servers:"), Options_Box);
  TimeServers_Label = new QLabel(i18n("Time servers:"), Options_Box);


  domainSize = NetbiosDDServer_Label->sizeHint().width();
  if(domainSize < NetbiosNodeType_Label->sizeHint().width())
    domainSize = NetbiosNodeType_Label->sizeHint().width();
  if(domainSize < NisDomain_Label->sizeHint().width())
    domainSize = NisDomain_Label->sizeHint().width();
  if(domainSize < NisServers_Label->sizeHint().width())
    domainSize = NisServers_Label->sizeHint().width();
  if(domainSize < DiplayManager_Label->sizeHint().width())
    domainSize = DiplayManager_Label->sizeHint().width();
  if(domainSize < FontServers_Label->sizeHint().width())
    domainSize = FontServers_Label->sizeHint().width();
  if(domainSize < NtpServers_Label->sizeHint().width())
    domainSize = NtpServers_Label->sizeHint().width();
  if(domainSize < SwapServer_Label->sizeHint().width())
    domainSize = SwapServer_Label->sizeHint().width();
  if(domainSize < ResourceLocationServers_Label->sizeHint().width())
    domainSize = ResourceLocationServers_Label->sizeHint().width();
  if(domainSize < ImpressServers_Label->sizeHint().width())
    domainSize = ImpressServers_Label->sizeHint().width();
  if(domainSize < LprServers_Label->sizeHint().width())
    domainSize = LprServers_Label->sizeHint().width();
  if(domainSize < CookieServers_Label->sizeHint().width())
    domainSize = CookieServers_Label->sizeHint().width();
  if(domainSize < LogServers_Label->sizeHint().width())
    domainSize = LogServers_Label->sizeHint().width();
  if(domainSize < Ien116NameServers_Label->sizeHint().width())
    domainSize = Ien116NameServers_Label->sizeHint().width();
  if(domainSize < TimeServers_Label->sizeHint().width())
    domainSize = TimeServers_Label->sizeHint().width();

  NetbiosDDServer_Label->setGeometry(10,20,domainSize,NetbiosDDServer_Label->sizeHint().height());
  NetbiosNodeType_Label->setGeometry(10,45,domainSize,NetbiosNodeType_Label->sizeHint().height());
  NisDomain_Label->setGeometry(10,70,domainSize,NisDomain_Label->sizeHint().height());
  NisServers_Label->setGeometry(10,95,domainSize,NisServers_Label->sizeHint().height());
  
  DiplayManager_Label->setGeometry(10,140,domainSize,DiplayManager_Label->sizeHint().height());
  FontServers_Label->setGeometry(10,165,domainSize,FontServers_Label->sizeHint().height());
  NtpServers_Label->setGeometry(10,190,domainSize,NtpServers_Label->sizeHint().height());
  SwapServer_Label->setGeometry(10,215,domainSize,SwapServer_Label->sizeHint().height());
  ResourceLocationServers_Label->setGeometry(10,240,domainSize,ResourceLocationServers_Label->sizeHint().height());
  ImpressServers_Label->setGeometry(10,265,domainSize,ImpressServers_Label->sizeHint().height());
  LprServers_Label->setGeometry(10,290,domainSize,LprServers_Label->sizeHint().height());
  CookieServers_Label->setGeometry(10,315,domainSize,CookieServers_Label->sizeHint().height());
  LogServers_Label->setGeometry(10,340,domainSize,LogServers_Label->sizeHint().height());
  Ien116NameServers_Label->setGeometry(10,365,domainSize,Ien116NameServers_Label->sizeHint().height());
  TimeServers_Label->setGeometry(10,390,domainSize,TimeServers_Label->sizeHint().height());

  NetbiosDDServer_Edit = new QLineEdit(Options_Box);
  NetbiosDDServer_Edit->setGeometry((domainSize+20), 20,130, 20 );
  NetbiosDDServer_Edit->setFont( font );

  NetbiosNodeType_ComboBox = new QComboBox(FALSE,Options_Box);
  NetbiosNodeType_ComboBox->insertItem(i18n("None"));
  NetbiosNodeType_ComboBox->insertItem(i18n("B-node (1)"));
  NetbiosNodeType_ComboBox->insertItem(i18n("P-node (2)"));
  NetbiosNodeType_ComboBox->insertItem(i18n("M-node (4)"));
  NetbiosNodeType_ComboBox->insertItem(i18n("H-node (8)"));
  NetbiosNodeType_ComboBox->setGeometry((domainSize+20), 45,NetbiosNodeType_ComboBox->sizeHint().width(), 20 );
  NetbiosNodeType_ComboBox->setFont( font );

  NisDomain_Edit = new QLineEdit(Options_Box);
  NisDomain_Edit->setGeometry((domainSize+20), 70,130, 20 );
  NisDomain_Edit->setFont( font );

  NisServers_Edit = new QLineEdit(Options_Box);
  NisServers_Edit->setGeometry((domainSize+20), 95,130, 20 );
  NisServers_Edit->setFont( font );


  DiplayManager_Edit = new QLineEdit(Options_Box);
  DiplayManager_Edit->setGeometry((domainSize+20), 140,130, 20 );
  DiplayManager_Edit->setFont( font );

  FontServers_Edit = new QLineEdit(Options_Box);
  FontServers_Edit->setGeometry((domainSize+20), 165,130, 20 );
  FontServers_Edit->setFont( font );

  NtpServers_Edit = new QLineEdit(Options_Box);
  NtpServers_Edit->setGeometry((domainSize+20), 190,130, 20 );
  NtpServers_Edit->setFont( font );

  SwapServer_Edit = new QLineEdit(Options_Box);
  SwapServer_Edit->setGeometry((domainSize+20), 215,130, 20 );
  SwapServer_Edit->setFont( font );
 
  ResourceLocationServers_Edit = new QLineEdit(Options_Box);
  ResourceLocationServers_Edit->setGeometry((domainSize+20), 240,130, 20 );
  ResourceLocationServers_Edit->setFont( font );

  ImpressServers_Edit = new QLineEdit(Options_Box);
  ImpressServers_Edit->setGeometry((domainSize+20), 265,130, 20 );
  ImpressServers_Edit->setFont( font );

  LprServers_Edit = new QLineEdit(Options_Box);
  LprServers_Edit->setGeometry((domainSize+20), 290,130, 20 );
  LprServers_Edit->setFont( font );

  CookieServers_Edit = new QLineEdit(Options_Box);
  CookieServers_Edit->setGeometry((domainSize+20), 315,130, 20 );
  CookieServers_Edit->setFont( font );

  LogServers_Edit = new QLineEdit(Options_Box);
  LogServers_Edit->setGeometry((domainSize+20), 340,130, 20 );
  LogServers_Edit->setFont( font );

  Ien116NameServers_Edit = new QLineEdit(Options_Box);
  Ien116NameServers_Edit->setGeometry((domainSize+20), 365,130, 20 );
  Ien116NameServers_Edit->setFont( font );

  TimeServers_Edit = new QLineEdit(Options_Box);
  TimeServers_Edit->setGeometry((domainSize+20), 390,130, 20 );
  TimeServers_Edit->setFont( font );

  Options_Box->setFixedSize((domainSize+170),420);
  
  sac = sa;
  
  setFixedSize(50,50);
  init();
  topLayout->activate();
}


advancedDialog::~advancedDialog()
{
}

void advancedDialog::init()
{

  caption.append(i18n("Advanced Options - "));
  setCaption((const char*)caption);

  NetbiosDDServer_Edit->setFocus();
  NetbiosDDServer_Edit->setText(sac->netbiosDDServer);
  if(sac->netbiosNodeType == 1)
    NetbiosNodeType_ComboBox->setCurrentItem(1);
  else if(sac->netbiosNodeType == 2)
    NetbiosNodeType_ComboBox->setCurrentItem(2);
  else if(sac->netbiosNodeType == 4)
    NetbiosNodeType_ComboBox->setCurrentItem(3);
  else if(sac->netbiosNodeType == 8)
    NetbiosNodeType_ComboBox->setCurrentItem(4);
  NisDomain_Edit->setText(sac->nisDomain);
  NisServers_Edit->setText(sac->nisServers);
  DiplayManager_Edit->setText(sac->displayManager);
  FontServers_Edit->setText(sac->fontServers);
  NtpServers_Edit->setText(sac->ntpServers);
  SwapServer_Edit->setText(sac->swapServer);
  ImpressServers_Edit->setText(sac->impressServers);
  ResourceLocationServers_Edit->setText(sac->resourceLocationServers);
  LprServers_Edit->setText(sac->lprServers);
  CookieServers_Edit->setText(sac->cookieServers);
  LogServers_Edit->setText(sac->logServers);
  Ien116NameServers_Edit->setText(sac->ien116nameServers);
  TimeServers_Edit->setText(sac->timeServers);

  caption.remove(0,caption.length());
  caption = i18n("Advanced Options - ") + sac->subnet;
  setCaption((const char*)caption);

  update();
}

void advancedDialog::Help_Click()
{
}

void advancedDialog::OK_Click()
{
  sac->netbiosDDServer = NetbiosDDServer_Edit->text();
  if(NetbiosNodeType_ComboBox->currentItem() == 0)
    sac->netbiosNodeType = 0;
  else if(NetbiosNodeType_ComboBox->currentItem() == 1)
    sac->netbiosNodeType = 1;
  else if(NetbiosNodeType_ComboBox->currentItem() == 2)
    sac->netbiosNodeType = 2;
  else if(NetbiosNodeType_ComboBox->currentItem() == 3)
    sac->netbiosNodeType = 4;
  else if(NetbiosNodeType_ComboBox->currentItem() == 4)
    sac->netbiosNodeType = 8;
  sac->nisDomain = NisDomain_Edit->text();
  sac->nisServers = NisServers_Edit->text();
  sac->displayManager = DiplayManager_Edit->text();
  sac->fontServers  = FontServers_Edit->text();
  sac->ntpServers = NtpServers_Edit->text();
  sac->swapServer = SwapServer_Edit->text();
  sac->impressServers = ImpressServers_Edit->text();
  sac->resourceLocationServers = ResourceLocationServers_Edit->text();
  sac->lprServers = LprServers_Edit->text();
  sac->cookieServers = CookieServers_Edit->text();
  sac->logServers = LogServers_Edit->text();
  sac->ien116nameServers = Ien116NameServers_Edit->text();
  sac->timeServers = TimeServers_Edit->text();
  close();
}

void advancedDialog::Cancel_Click()
{
  close();
}



void advancedDialog::update()
{

}

QString advancedDialog::getIP(int a,const char *text)
{
  QString tmp, tmp1;
  tmp.append(text);
  tmp1 = tmp.left(tmp.find("."));
  if(a == 0)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 1)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 2)
    return(tmp1);
  tmp = tmp.remove(0,tmp.find(".")+1);

  tmp1 = tmp.left(tmp.find("."));
  if(a == 3)
    return(tmp1);
  return(0);
}

QString advancedDialog::putIP(QString a, QString b, QString c, QString d)
{
  QString tmp;
  tmp.append(a);
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(b); 
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(c);
  tmp = tmp.stripWhiteSpace();
  tmp.append(".");
  tmp.append(d);
  tmp = tmp.stripWhiteSpace();
  return(tmp);
}
