/************************************************************
        Copyright (c) 1998-1999 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/


#ifndef _DHCP_
#define _DHCP_

#include <signal.h>
#include <unistd.h>
#include <time.h>

#include "kcmodule.h"

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qtabdlg.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qstrlist.h>
#include <qchkbox.h>
#include <qgroupbox.h>
#include <ktabctl.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtstream.h>
#include <qtextstream.h>
#include <qfont.h>
#include <qcombobox.h>

#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>

#include <kapp.h>
//#include <ktablistbox.h>
#include <kconfig.h>
#include <qlistview.h>


class scopeAddresses {
public:
   scopeAddresses(QString s, QString n) 
    {
       subnet=s;subnetMask=n;
       include = new QStrList();

       broadcast = "";
       broadcastAddress = "";
       cookieServers = "";
       displayManager = "";
       domainName = "";
       fontServers = "";
       ien116nameServers = "";
       impressServers = ""; 
       leaseDurations = -1;
       logServers = "";
       lprServers = "";
       maxLeaseDurations = -1;
       nameServers = "";
       netbiosDDServer = "";
       netbiosNameServers = "";
       netbiosNodeType = -1;
       nisDomain = "";
       nisServers = "";
       ntpServers = "";
       resourceLocationServers = "";
       routers = "";
       swapServer = "";
       timeOffset = 0;
       timeServers = "";
       ipForward = false;
    }
   QStrList *include;
   QString subnet;
   QString subnetMask;
   QString routers;
   QString broadcast;
   QString domainName ;
   QString nameServers;
   QString netbiosNameServers;
   QString netbiosDDServer;
   QString nisDomain;
   QString nisServers;

   QString displayManager;
   QString fontServers;
   QString ntpServers;
   QString swapServer;
   QString impressServers;
   QString resourceLocationServers;
   QString lprServers;
   QString cookieServers;
   QString logServers;
   QString ien116nameServers;
   QString timeServers;

   QString broadcastAddress;
   int netbiosNodeType;
   int leaseDurations;
   int maxLeaseDurations;
   int timeOffset;
   bool ipForward;
};

class leasesAddress {
public:
  leasesAddress(QString s) {ip=s;}
  QString ip;
  QString startsDate;
  QString startsTime;
  QString endsDate;
  QString endsTime;
  QString hardwareType;
  QString hardwareAddress;
  QString uid;
  QString hostName;
};
    
class hostAddress {
public:
  hostAddress(QString n) {name=n;}
  QString name;
  QString hardwareType;
  QString hardwareAddress;
  QString fixedAddress;
  QString hostName;
};

class DhcpWidget : public KCModule
{
  Q_OBJECT;

public:

  DhcpWidget(QWidget *parent, const char *name);
  void readConfig() {};
  void loadSettings() {};
  void save();

private:
  
  //QListBox *scopes;
  QListView *scopes;
  QListViewItem *globalsItem, *subnetItem, *groupItem;
  QListViewItem *subnetChildrenItem;
  QList<scopeAddresses> *scopeList;
  QPushButton *addButton, *delButton, *propButton, *leasesButton;

  void  init();
  void  parseconf();
  void  parselog();
  void  readStat();
  void  displaySettings();
  bool  isIP(QString ip);
  bool yes_no(const char *);
public slots:

private slots:
  void createScope();
  void deleteScope();
  void propScope();
  void leasesScope();
  void scopesHighlighted(QListViewItem *i);
};

#endif
