/*
   Copyright (C) 2012-2018 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "operaaddressbook.h"

#include <KContacts/Addressee>
#include <QUrl>
#include "operaplugin_debug.h"
#include <QFile>

OperaAddressBook::OperaAddressBook(const QString &filename)
    : mFileName(filename)
{
}

void OperaAddressBook::importAddressBook()
{
    QFile file(mFileName);
    if (!file.open(QIODevice::ReadOnly)) {
        qCDebug(OPERAPLUGIN_LOG) << " We can't open file" << mFileName;
        return;
    }

    QTextStream stream(&file);
    bool foundContact = false;
    KContacts::Addressee *contact = nullptr;
    while (!stream.atEnd()) {
        QString line = stream.readLine();
        if (line == QLatin1String("#CONTACT")) {
            appendContact(contact);
            foundContact = true;
        } else if (line == QLatin1String("#FOLDER")) {
            appendContact(contact);
            foundContact = false;
            //TODO
        } else if (foundContact) {
            line = line.trimmed();
            if (!contact) {
                contact = new KContacts::Addressee;
            }
            if (line.startsWith(QLatin1String("ID"))) {
                //Nothing
            } else if (line.startsWith(QLatin1String("NAME"))) {
                contact->setName(line.remove(QStringLiteral("NAME=")));
            } else if (line.startsWith(QLatin1String("URL"))) {
                KContacts::ResourceLocatorUrl url;
                url.setUrl(QUrl(line.remove(QStringLiteral("URL="))));
                contact->setUrl(url);
            } else if (line.startsWith(QLatin1String("DESCRIPTION"))) {
                contact->setNote(line.remove(QStringLiteral("DESCRIPTION=")));
            } else if (line.startsWith(QLatin1String("PHONE"))) {
                contact->insertPhoneNumber(KContacts::PhoneNumber(line.remove(QStringLiteral("PHONE=")), KContacts::PhoneNumber::Home));
            } else if (line.startsWith(QLatin1String("FAX"))) {
                contact->insertPhoneNumber(KContacts::PhoneNumber(line.remove(QStringLiteral("FAX=")), KContacts::PhoneNumber::Fax));
            } else if (line.startsWith(QLatin1String("POSTALADDRESS"))) {
                //TODO
            } else if (line.startsWith(QLatin1String("PICTUREURL"))) {
                //TODO
            } else if (line.startsWith(QLatin1String("ICON"))) {
                //TODO
            } else if (line.startsWith(QLatin1String("SHORT NAME"))) {
                contact->setNickName(line.remove(QStringLiteral("SHORT NAME=")));
            }
        }
    }
    appendContact(contact);
}

OperaAddressBook::~OperaAddressBook()
{
}

void OperaAddressBook::appendContact(KContacts::Addressee *contact)
{
    if (contact) {
        addImportContactNote(*contact, QStringLiteral("Opera"));
        createContact(*contact);
        delete contact;
    }
}
