import QtQuick 1.0
import org.kde.analitza 1.0
import widgets 1.0

KAlgebraPage
{
	ListModel { id: itemModel }
	
	ExpressionInput {
		id: input
		focus: true
		
		Analitza { id: a }
		
		Keys.onReturnPressed: {
			var res = a.execute(text)
			
			var toadd = ""
			if(!a.isCorrect)
				toadd = "Error: " + (res ? res : a.errors)
			else
				toadd = text + " = " + res.expression
			
			itemModel.insert(0, { result: toadd, resultsInput: text })
			input.selectAll()
			view.currentIndex = 0
		}
		
		width: parent.width
		anchors.top: parent.top
	}
	
	SimpleListView {
		model: itemModel
		id: view
		
		delegate: Label {
			text: result
			MouseArea {
				anchors.fill: parent
				onClicked:  {
					input.text = resultsInput
					input.selectAll()
					input.focus = true
				}
			}
		}
		
		anchors {
			top: input.bottom
			bottom: parent.bottom
			left: parent.left
			right: parent.right
		}
	}
}