//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \short An object which represents a position in a Document.
    ///  A Cursor is a basic class which contains the line() and column() a position
    ///  in a Document. It is very lightweight and maintains no affiliation with a
    ///  particular Document.
    ///  If you want additional functionality such as the ability to maintain position
    ///  in a document, see SmartCursor.
    ///  <b>Note:<> The Cursor class is designed to be passed via value, while SmartCursor
    ///  and derivatives must be passed via pointer or reference as they maintain a
    ///  connection with their document internally and cannot be copied.
    ///  <b>Note:<> Lines and columns start at 0.
    ///  <b>Note:<> Think of cursors as having their position at the start of a character,
    ///        not in the middle of one.
    ///  <b>Note:<> If a Cursor is associated with a Range the Range will be notified
    ///        whenever the cursor (i.e. start or end position) changes its position.
    ///        Read the class documentation about Range%s for further details.
    ///  \sa SmartCursor
    ///  </remarks>        <short>    \short An object which represents a position in a Document.</short>
    [SmokeClass("KTextEditor::Cursor")]
    public class Cursor : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Cursor(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Cursor), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Cursor() {
            staticInterceptor = new SmokeInvocation(typeof(Cursor), null);
        }
        // friend Cursor operator+(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend Cursor operator-(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend bool operator==(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend bool operator>(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend bool operator>=(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend bool operator<(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        // friend bool operator<=(const KTextEditor::Cursor& arg1,const KTextEditor::Cursor& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  The default constructor creates a cursor at position (0,0).
        ///      </remarks>        <short>    The default constructor creates a cursor at position (0,0).</short>
        public Cursor() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Cursor", "Cursor()", typeof(void));
        }
        /// <remarks>
        ///  This constructor creates a cursor initialized with <pre>line</pre>
        ///  and <pre>column</pre>.
        ///  \param line line for cursor
        ///  \param column column for cursor
        ///      </remarks>        <short>    This constructor creates a cursor initialized with \p line  and \p column.</short>
        public Cursor(int line, int column) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Cursor$$", "Cursor(int, int)", typeof(void), typeof(int), line, typeof(int), column);
        }
        /// <remarks>
        ///  Copy constructor.  Does not copy the owning range, as a range does not
        ///  have any association with copies of its cursors.
        ///  \param copy the cursor to copy.
        ///      </remarks>        <short>    Copy constructor.</short>
        public Cursor(KTextEditor.Cursor copy) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Cursor#", "Cursor(const KTextEditor::Cursor&)", typeof(void), typeof(KTextEditor.Cursor), copy);
        }
        /// <remarks>
        ///  Returns whether the current position of this cursor is a valid position
        ///  (line + column must both be >= 0).
        ///  Smart cursors should override this to return whether the cursor is valid
        ///  within the linked document.
        ///      </remarks>        <short>    Returns whether the current position of this cursor is a valid position  (line + column must both be >= 0).</short>
        [SmokeMethod("isValid() const")]
        public virtual bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns whether this cursor is a SmartCursor.
        ///      </remarks>        <short>    Returns whether this cursor is a SmartCursor.</short>
        [SmokeMethod("isSmartCursor() const")]
        public virtual bool IsSmartCursor() {
            return (bool) interceptor.Invoke("isSmartCursor", "isSmartCursor() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns this cursor as a SmartCursor, if it is one.
        ///      </remarks>        <short>    Returns this cursor as a SmartCursor, if it is one.</short>
        [SmokeMethod("toSmartCursor() const")]
        public virtual KTextEditor.SmartCursor ToSmartCursor() {
            return (KTextEditor.SmartCursor) interceptor.Invoke("toSmartCursor", "toSmartCursor() const", typeof(KTextEditor.SmartCursor));
        }
        /// <remarks>
        ///  Set the current cursor position to \e position.
        ///  \param position new cursor position
        ///  \todo add bool to indicate success or not, for smart cursors?
        ///      </remarks>        <short>    Set the current cursor position to \e position.</short>
        [SmokeMethod("setPosition(const KTextEditor::Cursor&)")]
        public virtual void SetPosition(KTextEditor.Cursor position) {
            interceptor.Invoke("setPosition#", "setPosition(const KTextEditor::Cursor&)", typeof(void), typeof(KTextEditor.Cursor), position);
        }
        /// <remarks>
        ///  \overload
        ///  Set the cursor position to \e line and \e column.
        ///  \param line new cursor line
        ///  \param column new cursor column
        ///      </remarks>        <short>    \overload </short>
        public void SetPosition(int line, int column) {
            interceptor.Invoke("setPosition$$", "setPosition(int, int)", typeof(void), typeof(int), line, typeof(int), column);
        }
        /// <remarks>
        ///  Retrieve the line on which this cursor is situated.
        ///  \return line number, where 0 is the first line.
        ///      </remarks>        <short>    Retrieve the line on which this cursor is situated.</short>
        [SmokeMethod("line() const")]
        public virtual int Line() {
            return (int) interceptor.Invoke("line", "line() const", typeof(int));
        }
        /// <remarks>
        ///  Set the cursor line to \e line.
        ///  \param line new cursor line
        ///      </remarks>        <short>    Set the cursor line to \e line.</short>
        [SmokeMethod("setLine(int)")]
        public virtual void SetLine(int line) {
            interceptor.Invoke("setLine$", "setLine(int)", typeof(void), typeof(int), line);
        }
        /// <remarks>
        ///  Retrieve the column on which this cursor is situated.
        ///  \return column number, where 0 is the first column.
        ///      </remarks>        <short>    Retrieve the column on which this cursor is situated.</short>
        public int Column() {
            return (int) interceptor.Invoke("column", "column() const", typeof(int));
        }
        /// <remarks>
        ///  Set the cursor column to \e column.
        ///  \param column new cursor column
        ///      </remarks>        <short>    Set the cursor column to \e column.</short>
        [SmokeMethod("setColumn(int)")]
        public virtual void SetColumn(int column) {
            interceptor.Invoke("setColumn$", "setColumn(int)", typeof(void), typeof(int), column);
        }
        /// <remarks>
        ///  Determine if this cursor is located at the start of a line.
        ///  \return \e true if the cursor is situated at the start of the line, \e false if it isn't.
        ///      </remarks>        <short>    Determine if this cursor is located at the start of a line.</short>
        public bool AtStartOfLine() {
            return (bool) interceptor.Invoke("atStartOfLine", "atStartOfLine() const", typeof(bool));
        }
        /// <remarks>
        ///  Determine if this cursor is located at the start of a document.
        ///  \return \e true if the cursor is situated at the start of the document, \e false if it isn't.
        ///      </remarks>        <short>    Determine if this cursor is located at the start of a document.</short>
        public bool AtStartOfDocument() {
            return (bool) interceptor.Invoke("atStartOfDocument", "atStartOfDocument() const", typeof(bool));
        }
        /// <remarks>
        ///  Get both the line and column of the cursor position.
        ///  \param line will be filled with current cursor line
        ///  \param column will be filled with current cursor column
        ///      </remarks>        <short>    Get both the line and column of the cursor position.</short>
        public void Position(ref int line, ref int column) {
            StackItem[] stack = new StackItem[3];
            stack[1].s_int = line;
            stack[2].s_int = column;
            interceptor.Invoke("position$$", "position(int&, int&) const", stack);
            line = stack[1].s_int;
            column = stack[2].s_int;
            return;
        }
        /// <remarks>
        ///  Returns the range that this cursor belongs to, if any.
        ///      </remarks>        <short>    Returns the range that this cursor belongs to, if any.</short>
        public KTextEditor.Range Range() {
            return (KTextEditor.Range) interceptor.Invoke("range", "range() const", typeof(KTextEditor.Range));
        }
        /// <remarks>
        ///  Addition operator. Takes two cursors and returns their summation.
        ///  \param c1 the first position
        ///  \param c2 the second position
        ///  \return a the summation of the two input cursors
        ///      </remarks>        <short>    Addition operator.</short>
        /// <remarks>
        ///  Subtraction operator. Takes two cursors and returns the subtraction
        ///  of <pre>c2</pre> from <pre>c1</pre>.
        ///  \param c1 the first position
        ///  \param c2 the second position
        ///  \return a cursor representing the subtraction of <pre>c2</pre> from <pre>c1</pre>
        ///      </remarks>        <short>    Subtraction operator.</short>
        /// <remarks>
        ///  Equality operator.
        ///  <b>Note:<> comparison between two invalid cursors is undefined.
        ///        comparison between and invalid and a valid cursor will always be \e false.
        ///  \param c1 first cursor to compare
        ///  \param c2 second cursor to compare
        ///  \return \e true, if c1's and c2's line and column are \e equal.
        ///      </remarks>        <short>    Equality operator.</short>
        /// <remarks>
        ///  Greater than operator.
        ///  \param c1 first cursor to compare
        ///  \param c2 second cursor to compare
        ///  \return \e true, if c1's position is greater than c2's position,
        ///          otherwise \e false.
        ///      </remarks>        <short>    Greater than operator.</short>
        /// <remarks>
        ///  Greater than or equal to operator.
        ///  \param c1 first cursor to compare
        ///  \param c2 second cursor to compare
        ///  \return \e true, if c1's position is greater than or equal to c2's
        ///          position, otherwise \e false.
        ///      </remarks>        <short>    Greater than or equal to operator.</short>
        /// <remarks>
        ///  Less than operator.
        ///  \param c1 first cursor to compare
        ///  \param c2 second cursor to compare
        ///  \return \e true, if c1's position is greater than or equal to c2's
        ///          position, otherwise \e false.
        ///      </remarks>        <short>    Less than operator.</short>
        /// <remarks>
        ///  Less than or equal to operator.
        ///  \param c1 first cursor to compare
        ///  \param c2 second cursor to compare
        ///  \return \e true, if c1's position is lesser than or equal to c2's
        ///          position, otherwise \e false.
        ///      </remarks>        <short>    Less than or equal to operator.</short>
        /// <remarks>
        ///  \internal
        ///  Sets the range that this cursor belongs to.
        ///  \param range the range that this cursor is referenced from.
        ///      </remarks>        <short>    \internal </short>
        [SmokeMethod("setRange(KTextEditor::Range*)")]
        protected virtual void SetRange(KTextEditor.Range range) {
            interceptor.Invoke("setRange#", "setRange(KTextEditor::Range*)", typeof(void), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  \internal
        ///  Notify the owning range, if any, that this cursor has changed directly.
        ///      </remarks>        <short>    \internal </short>
        protected void CursorChangedDirectly(KTextEditor.Cursor from) {
            interceptor.Invoke("cursorChangedDirectly#", "cursorChangedDirectly(const KTextEditor::Cursor&)", typeof(void), typeof(KTextEditor.Cursor), from);
        }
        ~Cursor() {
            interceptor.Invoke("~Cursor", "~Cursor()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Cursor", "~Cursor()", typeof(void));
        }
        /// <remarks>
        ///  Returns an invalid cursor.
        ///      </remarks>        <short>    Returns an invalid cursor.</short>
        public static KTextEditor.Cursor Invalid() {
            return (KTextEditor.Cursor) staticInterceptor.Invoke("invalid", "invalid()", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  Returns a cursor representing the start of any document - i.e., line 0, column 0.
        ///      </remarks>        <short>    Returns a cursor representing the start of any document - i.</short>
        public static KTextEditor.Cursor Start() {
            return (KTextEditor.Cursor) staticInterceptor.Invoke("start", "start()", typeof(KTextEditor.Cursor));
        }
    }
}
