//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  MetaInfoJob is a KIO Job to retrieve meta information from files.
    ///  See <see cref="IMetaInfoJobSignals"></see> for signals emitted by MetaInfoJob
    /// </remarks>        <short> KIO Job to retrieve meta information from files.      </short>
    [SmokeClass("KIO::MetaInfoJob")]
    public class MetaInfoJob : KIO.Job, IDisposable {
        protected MetaInfoJob(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(MetaInfoJob), this);
        }
        /// <remarks>
        ///  Creates a new MetaInfoJob.
        /// <param> name="items" A list of KFileItems to get the metainfo for
        /// </param><param> name="w" Flags which serve as a preset which can be customized
        ///                  with other parameters.
        /// </param><param> name="iocost" The allowed cost in terms of io to retrieve the
        ///                  metainfo. The approximate maximum number of bytes to
        ///                  be read is 10^iocost. Negative values mean that
        ///                  there is no limit on the cost. 0 means that no fields
        ///                  other than the required fields will be retrieved.
        ///                  The default value of 3 means about 1024 bytes per
        ///                  file may be read. This is merely a suggestion and not
        ///                  a hard limit.
        /// </param><param> name="cpucost" The allowed cost in terms of cpu to determine the
        ///                  information in the fields. The number mean the amount
        ///                  of instructions allowed is 10^cpucost and is a suggestion only.
        ///                  The default value of 6 means that about a million
        ///                  instructions (10^6) are allowed. This is useful for
        ///                  expensive fields like md5 or thumbnails.
        /// </param><param> name="requiredfields" The names of fields or groups of fields that should
        ///                   be retrieved regardless of cost.
        /// </param><param> name="requestedfields" The names of fields or groups of fields that should
        ///                   be retrieved first.
        ///          </param></remarks>        <short>    Creates a new MetaInfoJob.</short>
        public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost, List<string> requiredfields, List<string> requestedfields) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#$$$??", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int, const QStringList&, const QStringList&)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost, typeof(List<string>), requiredfields, typeof(List<string>), requestedfields);
        }
        public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost, List<string> requiredfields) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#$$$?", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int, const QStringList&)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost, typeof(List<string>), requiredfields);
        }
        public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#$$$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost);
        }
        public MetaInfoJob(List<KFileItem> items, uint w, int iocost) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#$$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost);
        }
        public MetaInfoJob(List<KFileItem> items, uint w) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w);
        }
        public MetaInfoJob(List<KFileItem> items) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MetaInfoJob#", "MetaInfoJob(const KFileItemList&)", typeof(void), typeof(List<KFileItem>), items);
        }
        /// <remarks>
        ///  Removes an item from metainfo extraction.
        /// <param> name="item" the item that should be removed from the queue
        ///          </param></remarks>        <short>    Removes an item from metainfo extraction.</short>
        public void RemoveItem(KFileItem item) {
            interceptor.Invoke("removeItem#", "removeItem(const KFileItem&)", typeof(void), typeof(KFileItem), item);
        }
        protected void GetMetaInfo() {
            interceptor.Invoke("getMetaInfo", "getMetaInfo()", typeof(void));
        }
        [Q_SLOT("void slotResult(KJob*)")]
        [SmokeMethod("slotResult(KJob*)")]
        protected override void SlotResult(KJob job) {
            interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
        }
        ~MetaInfoJob() {
            interceptor.Invoke("~MetaInfoJob", "~MetaInfoJob()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~MetaInfoJob", "~MetaInfoJob()", typeof(void));
        }
        protected new IMetaInfoJobSignals Emit {
            get { return (IMetaInfoJobSignals) Q_EMIT; }
        }
    }

    public interface IMetaInfoJobSignals : KIO.IJobSignals {
        /// <remarks>
        ///  Emitted when the meta info for <code>item</code> has been successfully
        ///  retrieved.
        /// <param> name="item" the KFileItem describing the fetched item
        ///          </param></remarks>        <short>    Emitted when the meta info for <code>item</code> has been successfully  retrieved.</short>
        [Q_SIGNAL("void gotMetaInfo(KFileItem)")]
        void GotMetaInfo(KFileItem item);
        /// <remarks>
        ///  Emitted when metainfo for <code>item</code> could not be extracted,
        ///  either because a plugin for its MIME type does not
        ///  exist, or because something went wrong.
        /// <param> name="item" the KFileItem of the file that failed
        ///          </param></remarks>        <short>    Emitted when metainfo for <code>item</code> could not be extracted,  either because a plugin for its MIME type does not  exist, or because something went wrong.</short>
        [Q_SIGNAL("void failed(KFileItem)")]
        void Failed(KFileItem item);
    }
}
