//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  The default constructor is designed to provide much the same
    ///  functionality as the most commonly used C-implementation, while
    ///  the other three constructors are meant to further simplify the
    ///  process of obtaining a digest by calculating the result in a
    ///  single step.
    ///  KMD5 is state-based, that means you can add new contents with
    ///  update() as long as you didn't request the digest value yet.
    ///  After the digest value was requested, the object is "finalized"
    ///  and you have to call reset() to be able to do another calculation
    ///  with it.  The reason for this behavior is that upon requesting
    ///  the message digest KMD5 has to pad the received contents up to a
    ///  64 byte boundary to calculate its value. After this operation it
    ///  is not possible to resume consuming data.
    ///  <b></b>sage:
    ///  A common usage of this class:
    ///  <pre>
    ///  string test1;
    ///  KMD5.Digest rawResult;
    ///  test1 = "This is a simple test.";
    ///  KMD5 context (test1);
    ///  cout << "Hex Digest output: " << context.hexDigest().data() << endl;
    ///  </pre>
    ///  To cut down on the unnecessary overhead of creating multiple KMD5
    ///  objects, you can simply invoke reset() to reuse the same object
    ///  in making another calculation:
    ///  <pre>
    ///  context.reset ();
    ///  context.update ("TWO");
    ///  context.update ("THREE");
    ///  cout << "Hex Digest output: " << context.hexDigest().data() << endl;
    ///  </pre>
    /// </remarks>        <author> Dirk Mueller <mueller@kde.org>, Dawit Alemayehu <adawit@kde.org>
    ///  </author>
    ///         <short> An adapted C++ implementation of RSA Data Securities MD5 algorithm. </short>
    [SmokeClass("KMD5")]
    public class KMD5 : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KMD5(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KMD5), this);
        }
        // const KMD5::Digest& rawDigest(); >>>> NOT CONVERTED
        // void rawDigest(KMD5::Digest& arg1); >>>> NOT CONVERTED
        // bool verify(const KMD5::Digest& arg1); >>>> NOT CONVERTED
        public KMD5() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMD5", "KMD5()", typeof(void));
        }
        /// <remarks>
        ///  Constructor that updates the digest for the given string.
        /// <param> name="in" C string or binary data
        /// </param><param> name="len" if negative, calculates the length by using
        ///              strlen on the first parameter, otherwise
        ///              it trusts the given length (does not stop on NUL byte).
        ///    </param></remarks>        <short>    Constructor that updates the digest for the given string.</short>
        public KMD5(string arg1, int len) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMD5$$", "KMD5(const char*, int)", typeof(void), typeof(string), arg1, typeof(int), len);
        }
        public KMD5(string arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMD5$", "KMD5(const char*)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  @overload
        ///  Same as above except it accepts a QByteArray as its argument.
        ///    </remarks>        <short>    @overload </short>
        public KMD5(QByteArray a) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMD5#", "KMD5(const QByteArray&)", typeof(void), typeof(QByteArray), a);
        }
        /// <remarks>
        ///  Updates the message to be digested. Be sure to add all data
        ///  before you read the digest. After reading the digest, you
        ///  can <b>not</b> add more data!
        /// <param> name="in" message to be added to digest
        /// </param><param> name="len" the length of the given message.
        ///    </param></remarks>        <short>    Updates the message to be digested.</short>
        public void Update(string arg1, int len) {
            interceptor.Invoke("update$$", "update(const char*, int)", typeof(void), typeof(string), arg1, typeof(int), len);
        }
        public void Update(string arg1) {
            interceptor.Invoke("update$", "update(const char*)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  @overload
        ///    </remarks>        <short>    @overload    </short>
        public void Update(Pointer<byte> arg1, int len) {
            interceptor.Invoke("update$$", "update(const unsigned char*, int)", typeof(void), typeof(Pointer<byte>), arg1, typeof(int), len);
        }
        public void Update(Pointer<byte> arg1) {
            interceptor.Invoke("update$", "update(const unsigned char*)", typeof(void), typeof(Pointer<byte>), arg1);
        }
        /// <remarks>
        ///  @overload
        /// <param> name="in" message to be added to the digest (QByteArray).
        ///    </param></remarks>        <short>    @overload </short>
        public void Update(QByteArray arg1) {
            interceptor.Invoke("update#", "update(const QByteArray&)", typeof(void), typeof(QByteArray), arg1);
        }
        /// <remarks>
        ///  @overload
        ///  reads the data from an I/O device, i.e. from a file (QFile).
        ///  NOTE that the file must be open for reading.
        /// <param> name="file" a pointer to FILE as returned by calls like f{d,re}open
        /// </param></remarks>        <return> false if an error occurred during reading.
        ///    </return>
        ///         <short>    @overload </short>
        public bool Update(QIODevice file) {
            return (bool) interceptor.Invoke("update#", "update(QIODevice&)", typeof(bool), typeof(QIODevice), file);
        }
        /// <remarks>
        ///  Calling this function will reset the calculated message digest.
        ///  Use this method to perform another message digest calculation
        ///  without recreating the KMD5 object.
        ///    </remarks>        <short>    Calling this function will reset the calculated message digest.</short>
        public void Reset() {
            interceptor.Invoke("reset", "reset()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> the raw representation of the digest
        ///    </return>
        ///         <short>   </short>
        /// <remarks>
        ///  Returns the value of the calculated message digest in
        ///  a hexadecimal representation.
        ///    </remarks>        <short>    Returns the value of the calculated message digest in  a hexadecimal representation.</short>
        public QByteArray HexDigest() {
            return (QByteArray) interceptor.Invoke("hexDigest", "hexDigest()", typeof(QByteArray));
        }
        /// <remarks>
        ///  @overload
        ///    </remarks>        <short>    @overload    </short>
        public void HexDigest(QByteArray arg1) {
            interceptor.Invoke("hexDigest#", "hexDigest(QByteArray&)", typeof(void), typeof(QByteArray), arg1);
        }
        /// <remarks>
        ///  Returns the value of the calculated message digest in
        ///  a base64-encoded representation.
        ///    </remarks>        <short>    Returns the value of the calculated message digest in  a base64-encoded representation.</short>
        public QByteArray Base64Digest() {
            return (QByteArray) interceptor.Invoke("base64Digest", "base64Digest()", typeof(QByteArray));
        }
        /// <remarks>
        ///  returns true if the calculated digest for the given
        ///  message matches the given one.
        ///    </remarks>        <short>    returns true if the calculated digest for the given  message matches the given one.</short>
        /// <remarks>
        ///  @overload
        ///    </remarks>        <short>    @overload    </short>
        public bool Verify(QByteArray arg1) {
            return (bool) interceptor.Invoke("verify#", "verify(const QByteArray&)", typeof(bool), typeof(QByteArray), arg1);
        }
        ~KMD5() {
            interceptor.Invoke("~KMD5", "~KMD5()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KMD5", "~KMD5()", typeof(void));
        }
    }
}
