//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  An enhanced QLineEdit widget for inputting text.
    ///  <li><b>Detail </b></li>
    ///  This widget inherits from QLineEdit and implements the following
    ///  additional functionalities: a completion object that provides both
    ///  automatic and manual text completion as well as multiple match iteration
    ///  features, configurable key-bindings to activate these features and a
    ///  popup-menu item that can be used to allow the user to set text completion
    ///  modes on the fly based on their preference.
    ///  To support these new features KLineEdit also emits a few more
    ///  additional signals.  These are: completion( string ),
    ///  textRotation( KeyBindingType ), and returnPressed( string ).
    ///  The completion signal can be connected to a slot that will assist the
    ///  user in filling out the remaining text.  The text rotation signal is
    ///  intended to be used to iterate through the list of all possible matches
    ///  whenever there is more than one match for the entered text.  The
    ///  <code>returnPressed</code>( string ) signals are the same as QLineEdit's
    ///  except it provides the current text in the widget as its argument whenever
    ///  appropriate.
    ///  This widget by default creates a completion object when you invoke
    ///  the completionObject( bool ) member function for the first time or
    ///  use setCompletionObject( KCompletion, bool ) to assign your own
    ///  completion object.  Additionally, to make this widget more functional,
    ///  KLineEdit will by default handle the text rotation and completion
    ///  events internally when a completion object is created through either one
    ///  of the methods mentioned above.  If you do not need this functionality,
    ///  simply use KCompletionBase.SetHandleSignals( bool ) or set the
    ///  boolean parameter in the above functions to false.
    ///  The default key-bindings for completion and rotation is determined
    ///  from the global settings in KStandardShortcut.  These values, however,
    ///  can be overridden locally by invoking KCompletionBase.SetKeyBinding().
    ///  The values can easily be reverted back to the default setting, by simply
    ///  calling useGlobalSettings(). An alternate method would be to default
    ///  individual key-bindings by using setKeyBinding() with the default
    ///  second argument.
    ///  If <code>EchoMode</code> for this widget is set to something other than <code>QLineEdit</code>.Normal,
    ///  the completion mode will always be defaulted to KGlobalSettings.CompletionNone.
    ///  This is done purposefully to guard against protected entries such as passwords being
    ///  cached in KCompletion's list. Hence, if the <code>EchoMode</code> is not QLineEdit.Normal, the
    ///  completion mode is automatically disabled.
    ///  A read-only KLineEdit will have the same background color as a
    ///  disabled KLineEdit, but its foreground color will be the one used
    ///  for the read-write mode. This differs from QLineEdit's implementation
    ///  and is done to give visual distinction between the three different modes:
    ///  disabled, read-only, and read-write.
    ///  KLineEdit has also a password mode which depends of globals KDE settings.  Use
    ///  KLineEdit.SetPasswordMode instead of QLineEdit.EchoMode property to have a password field.
    ///  <li><b>Usage </b></li>
    ///  To enable the basic completion feature:
    ///  <pre>
    ///  KLineEdit edit = new KLineEdit( this );
    ///  KCompletion comp = edit.CompletionObject();
    ///  // Connect to the return pressed signal - optional
    ///  connect(edit,SIGNAL("returnPressed(string)"),comp,SLOT("addItem(string)"));
    ///  </pre>
    ///  To use a customized completion objects or your
    ///  own completion object:
    ///  <pre>
    ///  KLineEdit edit = new KLineEdit( this );
    ///  KUrlCompletion comp = new KUrlCompletion();
    ///  edit.SetCompletionObject( comp );
    ///  // Connect to the return pressed signal - optional
    ///  connect(edit,SIGNAL("returnPressed(string)"),comp,SLOT("addItem(string)"));
    ///  </pre>
    ///  Note if you specify your own completion object you have to either delete
    ///  it when you don't need it anymore, or you can tell KLineEdit to delete it
    ///  for you:
    ///  <pre>
    ///  edit.SetAutoDeleteCompletionObject( true );
    ///  </pre>
    ///  <li><b>Miscellaneous function calls :</b></li>
    ///  <pre>
    ///  // Tell the widget to not handle completion and iteration automatically.
    ///  edit.SetHandleSignals( false );
    ///  // Set your own key-bindings for a text completion mode.
    ///  edit.SetKeyBinding( KCompletionBase.TextCompletion, Qt.End );
    ///  // Hide the context (popup) menu
    ///  edit.SetContextMenuPolicy( Qt.NoContextMenu );
    ///  // Default the key-bindings back to the default system settings.
    ///  edit.UseGlobalKeyBindings();
    ///  </pre>
    ///  See <see cref="IKLineEditSignals"></see> for signals emitted by KLineEdit
    /// </remarks>        <author> Dawit Alemayehu <adawit@kde.org>
    ///  </author>
    ///         <short>    An enhanced QLineEdit widget for inputting text.</short>
    [SmokeClass("KLineEdit")]
    public class KLineEdit : QLineEdit, IKCompletionBase, IDisposable {
        protected KLineEdit(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KLineEdit), this);
        }
        [Q_PROPERTY("bool", "contextMenuEnabled")]
        public bool ContextMenuEnabled {
            get { return (bool) interceptor.Invoke("isContextMenuEnabled", "isContextMenuEnabled()", typeof(bool)); }
            set { interceptor.Invoke("setContextMenuEnabled$", "setContextMenuEnabled(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "urlDropsEnabled")]
        public bool UrlDropsEnabled {
            get { return (bool) interceptor.Invoke("urlDropsEnabled", "urlDropsEnabled()", typeof(bool)); }
            set { interceptor.Invoke("setUrlDropsEnabled$", "setUrlDropsEnabled(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "trapEnterKeyEvent")]
        public bool TrapEnterKeyEvent {
            get { return (bool) interceptor.Invoke("trapReturnKey", "trapReturnKey()", typeof(bool)); }
            set { interceptor.Invoke("setTrapReturnKey$", "setTrapReturnKey(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "squeezedTextEnabled")]
        public bool SqueezedTextEnabled {
            get { return (bool) interceptor.Invoke("isSqueezedTextEnabled", "isSqueezedTextEnabled()", typeof(bool)); }
            set { interceptor.Invoke("setSqueezedTextEnabled$", "setSqueezedTextEnabled(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("QString", "clickMessage")]
        public string ClickMessage {
            get { return (string) interceptor.Invoke("clickMessage", "clickMessage()", typeof(string)); }
            set { interceptor.Invoke("setClickMessage$", "setClickMessage(QString)", typeof(void), typeof(string), value); }
        }
        [Q_PROPERTY("bool", "showClearButton")]
        public bool ShowClearButton {
            get { return (bool) interceptor.Invoke("isClearButtonShown", "isClearButtonShown()", typeof(bool)); }
            set { interceptor.Invoke("setClearButtonShown$", "setClearButtonShown(bool)", typeof(void), typeof(bool), value); }
        }
        [Q_PROPERTY("bool", "passwordMode")]
        public bool PasswordMode {
            get { return (bool) interceptor.Invoke("passwordMode", "passwordMode()", typeof(bool)); }
            set { interceptor.Invoke("setPasswordMode$", "setPasswordMode(bool)", typeof(void), typeof(bool), value); }
        }
        // QMap<KCompletionBase::KeyBindingType, KShortcut> getKeyBindings(); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructs a KLineEdit object with a default text, a parent,
        ///  and a name.
        /// <param> name="string" Text to be shown in the edit widget.
        /// </param><param> name="parent" The parent widget of the line edit.
        ///      </param></remarks>        <short>    Constructs a KLineEdit object with a default text, a parent,  and a name.</short>
        public KLineEdit(string arg1, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLineEdit$#", "KLineEdit(const QString&, QWidget*)", typeof(void), typeof(string), arg1, typeof(QWidget), parent);
        }
        public KLineEdit(string arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLineEdit$", "KLineEdit(const QString&)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  Constructs a line edit
        /// <param> name="parent" The parent widget of the line edit.
        ///      </param></remarks>        <short>    Constructs a line edit </short>
        public KLineEdit(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLineEdit#", "KLineEdit(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KLineEdit() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KLineEdit", "KLineEdit()", typeof(void));
        }
        /// <remarks>
        ///  Sets <code>url</code> into the lineedit. It uses KUrl.PrettyUrl() so
        ///  that the url is properly decoded for displaying.
        ///      </remarks>        <short>    Sets <code>url</code> into the lineedit.</short>
        public void SetUrl(KUrl url) {
            interceptor.Invoke("setUrl#", "setUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Re-implemented from KCompletionBase for internal reasons.
        ///  This function is re-implemented in order to make sure that
        ///  the EchoMode is acceptable before we set the completion mode.
        ///  See KCompletionBase.SetCompletionMode
        ///      </remarks>        <short>    Re-implemented from KCompletionBase for internal reasons.</short>
        [SmokeMethod("setCompletionMode(KGlobalSettings::Completion)")]
        public virtual void SetCompletionMode(KGlobalSettings.Completion mode) {
            interceptor.Invoke("setCompletionMode$", "setCompletionMode(KGlobalSettings::Completion)", typeof(void), typeof(KGlobalSettings.Completion), mode);
        }
        /// <remarks>
        ///  Disables completion modes by makeing them non-checkable.
        ///  The context menu allows to change the completion mode.
        ///  This method allows to disable some modes.
        ///     </remarks>        <short>    Disables completion modes by makeing them non-checkable.</short>
        public void SetCompletionModeDisabled(KGlobalSettings.Completion mode, bool disable) {
            interceptor.Invoke("setCompletionModeDisabled$$", "setCompletionModeDisabled(KGlobalSettings::Completion, bool)", typeof(void), typeof(KGlobalSettings.Completion), mode, typeof(bool), disable);
        }
        public void SetCompletionModeDisabled(KGlobalSettings.Completion mode) {
            interceptor.Invoke("setCompletionModeDisabled$", "setCompletionModeDisabled(KGlobalSettings::Completion)", typeof(void), typeof(KGlobalSettings.Completion), mode);
        }
        /// <remarks>
        /// <param> name="create" Set this to false if you don't want the box to be created
        ///                i.e. to test if it is available.
        ///      </param></remarks>        <return> the completion-box, that is used in completion mode
        ///  KGlobalSettings.CompletionPopup.
        ///  This method will create a completion-box if none is there, yet.
        /// </return>
        ///         <short>   </short>
        public KCompletionBox CompletionBox(bool create) {
            return (KCompletionBox) interceptor.Invoke("completionBox$", "completionBox(bool)", typeof(KCompletionBox), typeof(bool), create);
        }
        public KCompletionBox CompletionBox() {
            return (KCompletionBox) interceptor.Invoke("completionBox", "completionBox()", typeof(KCompletionBox));
        }
        /// <remarks>
        ///  Reimplemented for internal reasons, the API is not affected.
        ///      </remarks>        <short>    Reimplemented for internal reasons, the API is not affected.</short>
        [SmokeMethod("setCompletionObject(KCompletion*, bool)")]
        public virtual void SetCompletionObject(KCompletion arg1, bool hsig) {
            interceptor.Invoke("setCompletionObject#$", "setCompletionObject(KCompletion*, bool)", typeof(void), typeof(KCompletion), arg1, typeof(bool), hsig);
        }
        [SmokeMethod("setCompletionObject(KCompletion*)")]
        public virtual void SetCompletionObject(KCompletion arg1) {
            interceptor.Invoke("setCompletionObject#", "setCompletionObject(KCompletion*)", typeof(void), typeof(KCompletion), arg1);
        }
        /// <remarks>
        ///  Reimplemented for internal reasons, the API is not affected.
        ///      </remarks>        <short>    Reimplemented for internal reasons, the API is not affected.</short>
        [SmokeMethod("copy() const")]
        public virtual void Copy() {
            interceptor.Invoke("copy", "copy() const", typeof(void));
        }
        /// <remarks>
        ///  Returns the original text if text squeezing is enabled.
        ///  If the widget is not in "read-only" mode, this function
        ///  returns the same thing as QLineEdit.Text().
        /// </remarks>        <short>    Returns the original text if text squeezing is enabled.</short>
        ///         <see> QLineEdit</see>
        public string OriginalText() {
            return (string) interceptor.Invoke("originalText", "originalText() const", typeof(string));
        }
        /// <remarks>
        ///  Set the completion-box to be used in completion mode
        ///  KGlobalSettings.CompletionPopup.
        ///  This will do nothing if a completion-box already exists.
        /// <param> name="box" The KCompletionBox to set
        ///     </param></remarks>        <short>    Set the completion-box to be used in completion mode  KGlobalSettings.CompletionPopup.</short>
        public void SetCompletionBox(KCompletionBox box) {
            interceptor.Invoke("setCompletionBox#", "setCompletionBox(KCompletionBox*)", typeof(void), typeof(KCompletionBox), box);
        }
        /// <remarks>
        /// </remarks>        <return> the size used by the clear button
        /// </return>
        ///         <short>   </short>
        public QSize ClearButtonUsedSize() {
            return (QSize) interceptor.Invoke("clearButtonUsedSize", "clearButtonUsedSize() const", typeof(QSize));
        }
        /// <remarks>
        ///  Re-implemented for internal reasons. API not changed.
        ///      </remarks>        <short>    Re-implemented for internal reasons.</short>
        [Q_SLOT("void setReadOnly(bool)")]
        [SmokeMethod("setReadOnly(bool)")]
        public virtual void SetReadOnly(bool arg1) {
            interceptor.Invoke("setReadOnly$", "setReadOnly(bool)", typeof(void), typeof(bool), arg1);
        }
        /// <remarks>
        ///  Iterates through all possible matches of the completed text or
        ///  the history list.
        ///  This function simply iterates over all possible matches in case
        ///  multimple matches are found as a result of a text completion request.
        ///  It will have no effect if only a single match is found.
        /// <param> name="type" The key-binding invoked.
        ///      </param></remarks>        <short>    Iterates through all possible matches of the completed text or  the history list.</short>
        [Q_SLOT("void rotateText(KCompletionBase::KeyBindingType)")]
        public void RotateText(KCompletionBase.KeyBindingType type) {
            interceptor.Invoke("rotateText$", "rotateText(KCompletionBase::KeyBindingType)", typeof(void), typeof(KCompletionBase.KeyBindingType), type);
        }
        /// <remarks>
        ///  See KCompletionBase.SetCompletedText.
        ///      </remarks>        <short>    See KCompletionBase.SetCompletedText.</short>
        [Q_SLOT("void setCompletedText(QString)")]
        [SmokeMethod("setCompletedText(const QString&)")]
        public virtual void SetCompletedText(string arg1) {
            interceptor.Invoke("setCompletedText$", "setCompletedText(const QString&)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  Same as the above function except it allows you to temporarily
        ///  turn off text completion in CompletionPopupAuto mode.
        /// <param> name="items" list of completion matches to be shown in the completion box.
        /// </param><param> name="autoSuggest" true if you want automatic text completion (suggestion) enabled.
        ///      </param></remarks>        <short>    Same as the above function except it allows you to temporarily  turn off text completion in CompletionPopupAuto mode.</short>
        [Q_SLOT("void setCompletedItems(QStringList, bool)")]
        [SmokeMethod("setCompletedItems(const QStringList&, bool)")]
        public virtual void SetCompletedItems(List<string> items, bool autoSuggest) {
            interceptor.Invoke("setCompletedItems?$", "setCompletedItems(const QStringList&, bool)", typeof(void), typeof(List<string>), items, typeof(bool), autoSuggest);
        }
        [Q_SLOT("void setCompletedItems(QStringList)")]
        [SmokeMethod("setCompletedItems(const QStringList&)")]
        public virtual void SetCompletedItems(List<string> items) {
            interceptor.Invoke("setCompletedItems?", "setCompletedItems(const QStringList&)", typeof(void), typeof(List<string>), items);
        }
        /// <remarks>
        ///  Reimplemented to workaround a buggy QLineEdit.Clear()
        ///  (changing the clipboard to the text we just had in the lineedit)
        ///      </remarks>        <short>    Reimplemented to workaround a buggy QLineEdit.Clear()  (changing the clipboard to the text we just had in the lineedit)      </short>
        [Q_SLOT("void clear()")]
        [SmokeMethod("clear()")]
        public virtual void Clear() {
            interceptor.Invoke("clear", "clear()", typeof(void));
        }
        /// <remarks>
        ///  Squeezes <code>text</code> into the line edit.
        ///  This can only be used with read-only line-edits.
        ///      </remarks>        <short>    Squeezes <code>text</code> into the line edit.</short>
        [Q_SLOT("void setSqueezedText(QString)")]
        public void SetSqueezedText(string text) {
            interceptor.Invoke("setSqueezedText$", "setSqueezedText(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        ///  Re-implemented to enable text squeezing. API is not affected.
        ///      </remarks>        <short>    Re-implemented to enable text squeezing.</short>
        [Q_SLOT("void setText(QString)")]
        [SmokeMethod("setText(const QString&)")]
        public virtual void SetText(string arg1) {
            interceptor.Invoke("setText$", "setText(const QString&)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  @brief set the line edit in password mode.
        ///  this change the EchoMode according to KDE preferences.
        /// <param> name="b" true to set in password mode
        ///      </param></remarks>        <short>    @brief set the line edit in password mode.</short>
        [Q_SLOT("void setPasswordMode(bool)")]
        public void SetPasswordMode(bool b) {
            interceptor.Invoke("setPasswordMode$", "setPasswordMode(bool)", typeof(void), typeof(bool), b);
        }
        [Q_SLOT("void setPasswordMode()")]
        public void SetPasswordMode() {
            interceptor.Invoke("setPasswordMode", "setPasswordMode()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> returns true if the lineedit is set to password mode echoing
        ///      </return>
        ///         <short>   </short>
        [Q_SLOT("bool passwordMode()")]
        public bool passwordMode() {
            return (bool) interceptor.Invoke("passwordMode", "passwordMode() const", typeof(bool));
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///      </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("event(QEvent*)")]
        protected new virtual bool Event(QEvent arg1) {
            return (bool) interceptor.Invoke("event#", "event(QEvent*)", typeof(bool), typeof(QEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.ResizeEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("resizeEvent(QResizeEvent*)")]
        protected override void ResizeEvent(QResizeEvent arg1) {
            interceptor.Invoke("resizeEvent#", "resizeEvent(QResizeEvent*)", typeof(void), typeof(QResizeEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.KeyPressEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("keyPressEvent(QKeyEvent*)")]
        protected override void KeyPressEvent(QKeyEvent arg1) {
            interceptor.Invoke("keyPressEvent#", "keyPressEvent(QKeyEvent*)", typeof(void), typeof(QKeyEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.MousePressEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("mousePressEvent(QMouseEvent*)")]
        protected override void MousePressEvent(QMouseEvent arg1) {
            interceptor.Invoke("mousePressEvent#", "mousePressEvent(QMouseEvent*)", typeof(void), typeof(QMouseEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.MouseReleaseEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("mouseReleaseEvent(QMouseEvent*)")]
        protected override void MouseReleaseEvent(QMouseEvent arg1) {
            interceptor.Invoke("mouseReleaseEvent#", "mouseReleaseEvent(QMouseEvent*)", typeof(void), typeof(QMouseEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QWidget.MouseDoubleClickEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("mouseDoubleClickEvent(QMouseEvent*)")]
        protected override void MouseDoubleClickEvent(QMouseEvent arg1) {
            interceptor.Invoke("mouseDoubleClickEvent#", "mouseDoubleClickEvent(QMouseEvent*)", typeof(void), typeof(QMouseEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.ContextMenuEvent().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        [SmokeMethod("contextMenuEvent(QContextMenuEvent*)")]
        protected override void ContextMenuEvent(QContextMenuEvent arg1) {
            interceptor.Invoke("contextMenuEvent#", "contextMenuEvent(QContextMenuEvent*)", typeof(void), typeof(QContextMenuEvent), arg1);
        }
        /// <remarks>
        ///  Re-implemented for internal reasons.  API not affected.
        ///  See QLineEdit.CreateStandardContextMenu().
        ///     </remarks>        <short>    Re-implemented for internal reasons.</short>
        protected new QMenu CreateStandardContextMenu() {
            return (QMenu) interceptor.Invoke("createStandardContextMenu", "createStandardContextMenu()", typeof(QMenu));
        }
        /// <remarks>
        ///  Re-implemented to handle URI drops.
        ///  See QLineEdit.DropEvent().
        ///     </remarks>        <short>    Re-implemented to handle URI drops.</short>
        [SmokeMethod("dropEvent(QDropEvent*)")]
        protected override void DropEvent(QDropEvent arg1) {
            interceptor.Invoke("dropEvent#", "dropEvent(QDropEvent*)", typeof(void), typeof(QDropEvent), arg1);
        }
        /// <remarks>
        ///  This function simply sets the lineedit text and
        ///  highlights the text appropriately if the boolean
        ///  value is set to true.
        /// <param> name="marked"     </param></remarks>        <short>    This function simply sets the lineedit text and  highlights the text appropriately if the boolean  value is set to true.</short>
        [SmokeMethod("setCompletedText(const QString&, bool)")]
        protected virtual void SetCompletedText(string arg1, bool arg2) {
            interceptor.Invoke("setCompletedText$$", "setCompletedText(const QString&, bool)", typeof(void), typeof(string), arg1, typeof(bool), arg2);
        }
        /// <remarks>
        ///  Sets the widget in userSelection mode or in automatic completion
        ///  selection mode. This changes the colors of selections.
        ///      </remarks>        <short>    Sets the widget in userSelection mode or in automatic completion  selection mode.</short>
        protected void SetUserSelection(bool userSelection) {
            interceptor.Invoke("setUserSelection$", "setUserSelection(bool)", typeof(void), typeof(bool), userSelection);
        }
        /// <remarks>
        ///  Reimplemented for internal reasons, the API is not affected.
        ///      </remarks>        <short>    Reimplemented for internal reasons, the API is not affected.</short>
        [SmokeMethod("create(WId, bool, bool)")]
        protected virtual void Create(uint arg1, bool initializeWindow, bool destroyOldWindow) {
            interceptor.Invoke("create$$$", "create(WId, bool, bool)", typeof(void), typeof(uint), arg1, typeof(bool), initializeWindow, typeof(bool), destroyOldWindow);
        }
        [SmokeMethod("create(WId, bool)")]
        protected virtual void Create(uint arg1, bool initializeWindow) {
            interceptor.Invoke("create$$", "create(WId, bool)", typeof(void), typeof(uint), arg1, typeof(bool), initializeWindow);
        }
        [SmokeMethod("create(WId)")]
        protected virtual void Create(uint arg1) {
            interceptor.Invoke("create$", "create(WId)", typeof(void), typeof(uint), arg1);
        }
        [SmokeMethod("create()")]
        protected virtual void Create() {
            interceptor.Invoke("create", "create()", typeof(void));
        }
        /// <remarks>
        ///  Whether in current state text should be auto-suggested
        ///     </remarks>        <short>    Whether in current state text should be auto-suggested     </short>
        protected bool AutoSuggest() {
            return (bool) interceptor.Invoke("autoSuggest", "autoSuggest() const", typeof(bool));
        }
        [SmokeMethod("paintEvent(QPaintEvent*)")]
        protected override void PaintEvent(QPaintEvent ev) {
            interceptor.Invoke("paintEvent#", "paintEvent(QPaintEvent*)", typeof(void), typeof(QPaintEvent), ev);
        }
        [SmokeMethod("focusInEvent(QFocusEvent*)")]
        protected override void FocusInEvent(QFocusEvent ev) {
            interceptor.Invoke("focusInEvent#", "focusInEvent(QFocusEvent*)", typeof(void), typeof(QFocusEvent), ev);
        }
        [SmokeMethod("focusOutEvent(QFocusEvent*)")]
        protected override void FocusOutEvent(QFocusEvent ev) {
            interceptor.Invoke("focusOutEvent#", "focusOutEvent(QFocusEvent*)", typeof(void), typeof(QFocusEvent), ev);
        }
        /// <remarks>
        ///  Completes the remaining text with a matching one from
        ///  a given list.
        ///     </remarks>        <short>    Completes the remaining text with a matching one from  a given list.</short>
        [Q_SLOT("void makeCompletion(QString)")]
        [SmokeMethod("makeCompletion(const QString&)")]
        protected virtual void MakeCompletion(string arg1) {
            interceptor.Invoke("makeCompletion$", "makeCompletion(const QString&)", typeof(void), typeof(string), arg1);
        }
        /// <remarks>
        ///  Resets the current displayed text.
        ///  Call this function to revert a text completion if the user
        ///  cancels the request. Mostly applies to popup completions.
        ///      </remarks>        <short>    Resets the current displayed text.</short>
        [Q_SLOT("void userCancelled(QString)")]
        protected void UserCancelled(string cancelText) {
            interceptor.Invoke("userCancelled$", "userCancelled(const QString&)", typeof(void), typeof(string), cancelText);
        }
        ~KLineEdit() {
            interceptor.Invoke("~KLineEdit", "~KLineEdit()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KLineEdit", "~KLineEdit()", typeof(void));
        }
        /// <remarks>
        ///  Returns a pointer to the current completion object.
        ///  If the completion object does not exist, it is automatically created and
        ///  by default handles all the completion signals internally unless <code>hsig</code>
        ///  is set to false. It is also automatically destroyed when the destructor
        ///  is called. You can change this default behavior using the
        ///  <see cref="#setAutoDeleteCompletionObject"></see> and <see cref="#setHandleSignals"></see> member
        ///  functions.
        ///  See also <see cref="#compObj"></see>.
        /// <param> name="hsig" if true, handles completion signals internally.
        /// </param></remarks>        <return> a pointer the completion object.
        ///      </return>
        ///         <short>    Returns a pointer to the current completion object.</short>
        public KCompletion CompletionObject(bool hsig) {
            return (KCompletion) interceptor.Invoke("completionObject$", "completionObject(bool)", typeof(KCompletion), typeof(bool), hsig);
        }
        public KCompletion CompletionObject() {
            return (KCompletion) interceptor.Invoke("completionObject", "completionObject()", typeof(KCompletion));
        }
        /// <remarks>
        ///  Enables this object to handle completion and rotation
        ///  events internally.
        ///  This function simply assigns a boolean value that
        ///  indicates whether it should handle rotation and
        ///  completion events or not.  Note that this does not
        ///  stop the object from emitting signals when these
        ///  events occur.
        /// <param> name="handle" if true, handle completion & rotation internally.
        ///      </param></remarks>        <short>    Enables this object to handle completion and rotation  events internally.</short>
        [SmokeMethod("setHandleSignals(bool)")]
        public virtual void SetHandleSignals(bool handle) {
            interceptor.Invoke("setHandleSignals$", "setHandleSignals(bool)", typeof(void), typeof(bool), handle);
        }
        /// <remarks>
        ///  Returns true if the completion object is deleted
        ///  upon this widget's destruction.
        ///  See setCompletionObject() and enableCompletion()
        ///  for details.
        /// </remarks>        <return> true if the completion object will be deleted
        ///               automatically
        ///      </return>
        ///         <short>    Returns true if the completion object is deleted  upon this widget's destruction.</short>
        public bool IsCompletionObjectAutoDeleted() {
            return (bool) interceptor.Invoke("isCompletionObjectAutoDeleted", "isCompletionObjectAutoDeleted() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets the completion object when this widget's destructor
        ///  is called.
        ///  If the argument is set to true, the completion object
        ///  is deleted when this widget's destructor is called.
        /// <param> name="autoDelete" if true, delete completion object on destruction.
        ///      </param></remarks>        <short>    Sets the completion object when this widget's destructor  is called.</short>
        public void SetAutoDeleteCompletionObject(bool autoDelete) {
            interceptor.Invoke("setAutoDeleteCompletionObject$", "setAutoDeleteCompletionObject(bool)", typeof(void), typeof(bool), autoDelete);
        }
        /// <remarks>
        ///  Sets the widget's ability to emit text completion and
        ///  rotation signals.
        ///  Invoking this function with <code>enable</code> set to <code>false</code> will
        ///  cause the completion & rotation signals not to be emitted.
        ///  However, unlike setting the completion object to <code>NULL</code>
        ///  using setCompletionObject, disabling the emition of
        ///  the signals through this method does not affect the current
        ///  completion object.
        ///  There is no need to invoke this function by default.  When a
        ///  completion object is created through completionObject or
        ///  setCompletionObject, these signals are set to emit
        ///  automatically.  Also note that disabling this signals will not
        ///  necessarily interfere with the objects ability to handle these
        ///  events internally.  See setHandleSignals.
        /// <param> name="enable" if false, disables the emition of completion & rotation signals.
        ///      </param></remarks>        <short>    Sets the widget's ability to emit text completion and  rotation signals.</short>
        public void SetEnableSignals(bool enable) {
            interceptor.Invoke("setEnableSignals$", "setEnableSignals(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Returns true if the object handles the signals.
        /// </remarks>        <return> true if this signals are handled internally.
        ///      </return>
        ///         <short>    Returns true if the object handles the signals.</short>
        public bool HandleSignals() {
            return (bool) interceptor.Invoke("handleSignals", "handleSignals() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns true if the object emits the signals.
        /// </remarks>        <return> true if signals are emitted
        ///      </return>
        ///         <short>    Returns true if the object emits the signals.</short>
        public bool EmitSignals() {
            return (bool) interceptor.Invoke("emitSignals", "emitSignals() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the current completion mode.
        ///  The return values are of type KGlobalSettings.Completion.
        ///  See setCompletionMode() for details.
        /// </remarks>        <return> the completion mode.
        ///      </return>
        ///         <short>    Returns the current completion mode.</short>
        public KGlobalSettings.Completion CompletionMode() {
            return (KGlobalSettings.Completion) interceptor.Invoke("completionMode", "completionMode() const", typeof(KGlobalSettings.Completion));
        }
        /// <remarks>
        ///  Sets the key-binding to be used for manual text
        ///  completion, text rotation in a history list as
        ///  well as a completion list.
        ///  When the keys set by this function are pressed, a
        ///  signal defined by the inheriting widget will be activated.
        ///  If the default value or 0 is specified by the second
        ///  parameter, then the key-binding as defined in the global
        ///  setting should be used.  This method returns false value
        ///  for <code>key</code> is negative or the supplied key-binding conflicts
        ///  with the ones set for one of the other features.
        ///  NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
        ///  the key-binding simply simply <code>sum</code> up the values of the
        ///  modifier and the actual key.  For example, to use CTRL+E as
        ///  a key binding for one of the items, you would simply supply
        ///  <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
        ///  function.
        /// <param> name="item" the feature whose key-binding needs to be set:
        /// </param>
        /// <li>
        /// TextCompletion the manual completion key-binding.
        /// </li>
        /// 
        /// <li>
        /// PrevCompletionMatch    the previous match key for multiple completion.
        /// </li>
        /// 
        /// <li>
        /// NextCompletionMatch    the next match key for for multiple completion.
        /// </li>
        /// 
        /// <li>
        /// SubstringCompletion  the key for substring completion
        /// </li>
        /// <param> name="key" key-binding used to rotate down in a list.
        /// </param></remarks>        <return> true if key-binding can successfully be set.
        /// </return>
        ///         <short>    Sets the key-binding to be used for manual text  completion, text rotation in a history list as  well as a completion list.</short>
        ///         <see> getKeyBinding</see>
        public bool SetKeyBinding(KCompletionBase.KeyBindingType item, KShortcut key) {
            return (bool) interceptor.Invoke("setKeyBinding$#", "setKeyBinding(KCompletionBase::KeyBindingType, const KShortcut&)", typeof(bool), typeof(KCompletionBase.KeyBindingType), item, typeof(KShortcut), key);
        }
        /// <remarks>
        ///  Returns the key-binding used for the specified item.
        ///  This methods returns the key-binding used to activate
        ///  the feature feature given by <code>item.</code>  If the binding
        ///  contains modifier key(s), the SUM of the modifier key
        ///  and the actual key code are returned.
        /// <param> name="item" the item to check
        /// </param></remarks>        <return> the key-binding used for the feature given by <code>item.</code>
        /// </return>
        ///         <short>    Returns the key-binding used for the specified item.</short>
        ///         <see> setKeyBinding</see>
        public KShortcut GetKeyBinding(KCompletionBase.KeyBindingType item) {
            return (KShortcut) interceptor.Invoke("getKeyBinding$", "getKeyBinding(KCompletionBase::KeyBindingType) const", typeof(KShortcut), typeof(KCompletionBase.KeyBindingType), item);
        }
        /// <remarks>
        ///  Sets this object to use global values for key-bindings.
        ///  This method changes the values of the key bindings for
        ///  rotation and completion features to the default values
        ///  provided in KGlobalSettings.
        ///  NOTE: By default inheriting widgets should uses the
        ///  global key-bindings so that there will be no need to
        ///  call this method.
        ///      </remarks>        <short>    Sets this object to use global values for key-bindings.</short>
        public void UseGlobalKeyBindings() {
            interceptor.Invoke("useGlobalKeyBindings", "useGlobalKeyBindings()", typeof(void));
        }
        /// <remarks>
        ///  Returns a pointer to the completion object.
        ///  This method is only different from completionObject()
        ///  in that it does not create a new KCompletion object even if
        ///  the internal pointer is <code>NULL.</code> Use this method to get the
        ///  pointer to a completion object when inheriting so that you
        ///  won't inadvertently create it!!
        /// </remarks>        <return> the completion object or @c NULL if one does not exist.
        ///      </return>
        ///         <short>    Returns a pointer to the completion object.</short>
        public KCompletion CompObj() {
            return (KCompletion) interceptor.Invoke("compObj", "compObj() const", typeof(KCompletion));
        }
        /// <remarks>
        ///  Returns a key-binding map.
        ///  This method is the same as getKeyBinding() except it
        ///  returns the whole keymap containing the key-bindings.
        /// </remarks>        <return> the key-binding used for the feature given by <code>item.</code>
        ///      </return>
        ///         <short>    Returns a key-binding map.</short>
        /// <remarks>
        ///  Sets or removes the delegation object. If a delegation object is
        ///  set, all function calls will be forwarded to the delegation object.
        /// <param> name="delegate" the delegation object, or 0 to remove it
        ///      </param></remarks>        <short>    Sets or removes the delegation object.</short>
        protected void SetDelegate(IKCompletionBase arg1) {
            interceptor.Invoke("setDelegate#", "setDelegate(KCompletionBase*)", typeof(void), typeof(IKCompletionBase), arg1);
        }
        /// <remarks>
        ///  Returns the delegation object.
        /// </remarks>        <return> the delegation object, or 0 if there is none
        /// </return>
        ///         <short>    Returns the delegation object.</short>
        ///         <see> setDelegate</see>
        protected IKCompletionBase Delegate() {
            return (IKCompletionBase) interceptor.Invoke("delegate", "delegate() const", typeof(IKCompletionBase));
        }
        protected new IKLineEditSignals Emit {
            get { return (IKLineEditSignals) Q_EMIT; }
        }
    }

    public interface IKLineEditSignals : IQLineEditSignals {
        /// <remarks>
        ///  Emitted whenever the completion box is activated.
        ///      </remarks>        <short>    Emitted whenever the completion box is activated.</short>
        [Q_SIGNAL("void completionBoxActivated(QString)")]
        void CompletionBoxActivated(string arg1);
        /// <remarks>
        ///  Emitted when the user presses the return key.
        ///   The argument is the current text.  Note that this
        ///  signal is <b>not</b> emitted if the widget's <code>EchoMode</code> is set to
        ///  QLineEdit.EchoMode.
        ///      </remarks>        <short>    Emitted when the user presses the return key.</short>
        [Q_SIGNAL("void returnPressed(QString)")]
        void ReturnPressed(string arg1);
        /// <remarks>
        ///  Emitted when the completion key is pressed.
        ///  Please note that this signal is <b>not</b> emitted if the
        ///  completion mode is set to <code>CompletionNone</code> or <code>EchoMode</code> is
        ///  <b>normal</b>.
        ///      </remarks>        <short>    Emitted when the completion key is pressed.</short>
        [Q_SIGNAL("void completion(QString)")]
        void Completion(string arg1);
        /// <remarks>
        ///  Emitted when the shortcut for substring completion is pressed.
        ///      </remarks>        <short>    Emitted when the shortcut for substring completion is pressed.</short>
        [Q_SIGNAL("void substringCompletion(QString)")]
        void SubstringCompletion(string arg1);
        /// <remarks>
        ///  Emitted when the text rotation key-bindings are pressed.
        ///  The argument indicates which key-binding was pressed.
        ///  In KLineEdit's case this can be either one of two values:
        ///  PrevCompletionMatch or NextCompletionMatch. See
        ///  KCompletionBase.SetKeyBinding for details.
        ///  Note that this signal is <b>not</b> emitted if the completion
        ///  mode is set to <code>KGlobalSettings</code>.CompletionNone or <code>echoMode</code>() is <b>not</b>  normal.
        ///      </remarks>        <short>    Emitted when the text rotation key-bindings are pressed.</short>
        [Q_SIGNAL("void textRotation(KCompletionBase::KeyBindingType)")]
        void TextRotation(KCompletionBase.KeyBindingType arg1);
        /// <remarks>
        ///  Emitted when the user changed the completion mode by using the
        ///  popupmenu.
        ///      </remarks>        <short>    Emitted when the user changed the completion mode by using the  popupmenu.</short>
        [Q_SIGNAL("void completionModeChanged(KGlobalSettings::Completion)")]
        void CompletionModeChanged(KGlobalSettings.Completion arg1);
        /// <remarks>
        ///  Emitted before the context menu is displayed.
        ///  The signal allows you to add your own entries into the
        ///  the context menu that is created on demand.
        ///  NOTE: Do not store the pointer to the QPopupMenu
        ///  provided through since it is created and deleted
        ///  on demand.
        /// <param> name="p" the context menu about to be displayed
        ///      </param></remarks>        <short>    Emitted before the context menu is displayed.</short>
        [Q_SIGNAL("void aboutToShowContextMenu(QMenu*)")]
        void AboutToShowContextMenu(QMenu p);
        /// <remarks>
        ///  Emitted when the user clicked on the clear button
        ///      </remarks>        <short>    Emitted when the user clicked on the clear button      </short>
        [Q_SIGNAL("void clearButtonClicked()")]
        void ClearButtonClicked();
    }
}
