/* logf.c -- Log file and error reporting routines. */

/* Copyright 1992 Godfrey Paul, University of Kent of Canterbury. */

char ukcprog_logf_sccsid[] = "$Id: logf.c,v 1.22 1999/07/15 11:10:21 djb1 Exp $ UKC";

#ifndef MSDOS
#include <sys/types.h>
#else
#include <sys/tk_types.h>
#endif

#include <fcntl.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#ifdef __STDC__
#ifndef VMS
#include <unistd.h>
#endif /* VMS */
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifndef MSDOS
#ifndef __FreeBSD__
#ifndef linux
extern int sys_nerr, errno;
extern char *sys_errlist[];
#endif /* !linux */
#endif /* !__FreeBSD__ */
#endif /* !MSDOS */

#include "ukcprog.h"

static void write_logstr PROTO((const char *str, bool err));
static const char *get_errno_str PROTO((void));

static int Log_fd = 2;		/* just print to stderr by default */
static int Log_level = LG_INFO;	/* by default */
static char *Log_prefix;	/* identification tag */
static int Log_prefix_len = 0;

/*  This is to avoid using %m in logf_set_ofile.  We should really make
 *  this public and use it in formf().
 */
static const char *
get_errno_str()
{
	static char buf[40];
		
	if (errno > 0 && errno < sys_nerr && *sys_errlist[errno] != '\0')
		return sys_errlist[errno];
	
	sprintf(buf, "[errno=%d (unknown value)]", errno);
	return buf;
}

int
logf_set_ofile(filename, prefix)
const char *filename, *prefix;
{
	static bool first_time = TRUE;
	int fd;

	if (filename != NULL) {
		if ((fd = open(filename, O_RDWR|O_APPEND|O_CREAT, 0666)) < 0) {
			errf("Can't open logfile %s (%s)",
			     filename, get_errno_str());
			return -1;
		}

		if (!first_time)
			(void)close(Log_fd);
		else
			first_time = FALSE;

		Log_fd = fd;
	}

	if (prefix != NULL) {
		if (Log_prefix != NULL)
			free(Log_prefix);
		Log_prefix = strsave(prefix);
		Log_prefix_len = strlen(Log_prefix);
	}

	return 0;
}


static void
write_logstr(str, err)
const char *str;
bool err;
{
	time_t now;
	const char *errstr;

	if (Log_fd < 0) {
		fprintf(stderr, "%s: %s\n", errf_get_progname(), str);
		return;
	}

	now = time((time_t *)NULL);
	errstr = err ? " ERROR: " : " ";
	
	write(Log_fd, ctime(&now), sizeof("Fri Sep  9 15:10:00 ") - 1);
	write(Log_fd, Log_prefix, Log_prefix_len);
	write(Log_fd, errstr, strlen(errstr));
	write(Log_fd, str, strlen(str));
	write(Log_fd, "\n", 1);
}


#ifdef __STDC__
void
logf(int level, const char *fmt, ...)
{

#else /* !__STDC__ */
void
logf(va_alist)
va_dcl
{
	int level;
	char *fmt;
#endif /* !__STDC__ */
	va_list args;
	char buffer[100];
	char *s;

#ifdef __STDC__
	va_start(args, fmt);
#else
	va_start(args);
	level = va_arg(args, int);
	fmt = va_arg(args, char *);
#endif
	if (level < Log_level) {
		va_end(args);
		return;
	}

	s = formf(buffer, sizeof(buffer), fmt, args);
	va_end(args);
	write_logstr(s, FALSE);

	if (s != buffer)
		free(s);	/* allocated by formf() */
}

int
logf_set_level(new_level)
int new_level;
{
	int old;

	old = Log_level;
	Log_level = new_level;
	logf(LG_LOG, "Log level changed from %d to %d", old, new_level);

	return old;
}


void
logf_errf_ofunc(str)
const char *str;
{
	write_logstr(str, TRUE);
}
