/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.org.iscream.cms.conient.Configuration;
import uk.org.iscream.cms.conient.Conient;
import uk.org.iscream.cms.conient.HostDisplayPanel;
import uk.org.iscream.cms.conient.QueueFrame;
import uk.org.iscream.cms.conient.SwingSafeAddCard;
import uk.org.iscream.cms.server.util.Queue;
import uk.org.iscream.cms.server.util.XMLPacket;
import uk.org.iscream.cms.server.util.XMLPacketMaker;

public class DataPanel
extends JSplitPane
implements Runnable {
    public final String REVISION = "$Revision: 1.26 $";
    boolean _running = true;
    private CardLayout _displayPaneLayout = new CardLayout();
    private JPanel _displayPane = new JPanel(this._displayPaneLayout);
    private JList _hostChooserList = new JList();
    private Queue _dataQueue;
    int _myQueue;
    private ImageIcon _serverIcon;
    private QueueFrame _qFrame;
    private Configuration _config;
    private HashMap _hostList;
    boolean _usingConfiguredList;
    private XMLPacketMaker _xmlPacketMaker;

    public DataPanel() {
        super(1);
        this._hostChooserList.setSelectionMode(0);
        this._hostChooserList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = DataPanel.this._hostChooserList.getSelectedIndex();
                if (n > -1) {
                    DataPanel.this._displayPaneLayout.show(DataPanel.this._displayPane, (String)DataPanel.this._hostChooserList.getSelectedValue());
                }
            }
        });
        this._serverIcon = new ImageIcon("./uk/ac/ukc/iscream/conient/server.gif");
        this._qFrame = null;
        this._config = Configuration.getInstance();
        this._hostList = null;
        this._usingConfiguredList = false;
        JScrollPane jScrollPane = new JScrollPane(this._hostChooserList);
        JScrollPane jScrollPane2 = new JScrollPane(this._displayPane);
        this.setOneTouchExpandable(true);
        this.setLeftComponent(jScrollPane);
        this.setRightComponent(jScrollPane2);
        this.setDividerLocation(150);
        this._xmlPacketMaker = new XMLPacketMaker();
    }

    public void run() {
        this.refreshHostList();
        if (Configuration.getInstance().getProperty("displayQueueInformation").equals("1")) {
            if (this._qFrame == null) {
                this._qFrame = new QueueFrame();
            }
            if (!this._qFrame.isVisible()) {
                ((Component)this._qFrame).setVisible(true);
            }
        }
        try {
            while (this._running) {
                String string = (String)this._dataQueue.get(this._myQueue);
                if (Configuration.getInstance().getProperty("packetDump").equals("1")) {
                    System.out.println("[PACKET DUMP]\n" + string);
                }
                Conient.setQueueStatus(this._dataQueue.queueSize(this._myQueue), this._dataQueue.elementCount());
                if (string == null) continue;
                XMLPacket xMLPacket = this._xmlPacketMaker.createXMLPacket(string);
                String string2 = xMLPacket.getParam("packet.attributes.type");
                if (string2.equals("heartbeat") || string2.equals("data")) {
                    String string3 = xMLPacket.getParam("packet.attributes.machine_name");
                    if (!this._usingConfiguredList && !this._hostList.containsKey(string3)) {
                        this.addHostPanel(string3);
                        if (this._config.getProperty("hostDiscoveryMode").equals("1")) {
                            this.addToKnownHosts(string3);
                        }
                    }
                    if (this._hostList.containsKey(string3)) {
                        if (((HostDisplayPanel)this._hostList.get(string3)).updateHost(xMLPacket)) continue;
                        Conient.addMessage("WARNING{data panel}: " + string3 + " sent an invalid data or heartbeat packet");
                        continue;
                    }
                    Conient.addMessage("WARNING{data panel}: server sent data for an unexpected host - " + string3);
                    continue;
                }
                if (string2.equals("queueStat")) {
                    if (!Configuration.getInstance().getProperty("displayQueueInformation").equals("1") || this._qFrame == null || !this._qFrame.isVisible()) continue;
                    this._qFrame.update(xMLPacket);
                    continue;
                }
                Conient.addMessage("WARNING{data panel}: and unknown packet type was received - " + string2);
            }
        }
        catch (Exception exception) {
            Conient.addMessage("ERROR{data panel}: +" + exception);
            exception.printStackTrace();
        }
    }

    public void shutdown() {
        this._running = false;
    }

    private void refreshHostList() {
        this._hostList = new HashMap();
        if (this._config.getProperty("useHostList").equals("1")) {
            String string = this._config.getProperty("hostList");
            if (!string.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this.addHostPanel(string2);
                }
                this._usingConfiguredList = true;
            } else {
                this._usingConfiguredList = false;
            }
        } else {
            this._usingConfiguredList = false;
        }
    }

    private void addHostPanel(String string) {
        HostDisplayPanel hostDisplayPanel = new HostDisplayPanel(string);
        SwingSafeAddCard swingSafeAddCard = new SwingSafeAddCard(this._displayPane, hostDisplayPanel, string);
        SwingUtilities.invokeLater(swingSafeAddCard);
        this._displayPane.add((Component)hostDisplayPanel, string);
        this._hostList.put(string, hostDisplayPanel);
        this._hostChooserList.setListData(new TreeSet(this._hostList.keySet()).toArray());
        Conient.addMessage("New Host added: " + string);
    }

    private void addToKnownHosts(String string) {
        String string2 = this._config.getProperty("knownHostsList");
        if (string2.indexOf(string) == -1) {
            this._config.setProperty("knownHostsList", string2 + string + ";");
        }
    }

    public void cleanUpTabs() {
        int n = this.getDividerLocation();
        this._displayPaneLayout = new CardLayout();
        this._displayPane = new JPanel(this._displayPaneLayout);
        JScrollPane jScrollPane = new JScrollPane(this._displayPane);
        this.setRightComponent(jScrollPane);
        this.setDividerLocation(n);
    }

    public void setQueue(Queue queue) {
        this._dataQueue = queue;
        this._myQueue = this._dataQueue.getQueue();
    }
}

