/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.conient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import uk.org.iscream.cms.conient.ConfigurationDialog;
import uk.org.iscream.cms.conient.Conient;
import uk.org.iscream.cms.conient.ConnectionHandler;

public class Configuration {
    public static final String REVISION = "$Revision: 1.10 $";
    public static final String CONFIG_HEADER = "!!! Conient Local Configuration File !!!\n#-----------------------------------------\n# This file was auto-generated by Conient.\n# It is recommended that you use the GUI\n# configuration facility to make changes\n# to this file.\n#";
    private Properties _properties = null;
    private ConnectionHandler _connectionHandler = null;
    private boolean _usingSpecificConfig = false;
    private File _configFile;
    private File _defaultConfigFile;
    private final FileFilter filter = new SuffixFileFilter("conf", "Conient Configuration Files");
    private final JFileChooser fc = new JFileChooser();
    private static Configuration _instance = null;

    public static void initialise(String string) {
        _instance = new Configuration(string);
    }

    public static Configuration getInstance() {
        if (_instance == null) {
            throw new RuntimeException("Configuration class requested but HASN'T been initialised!");
        }
        return _instance;
    }

    private Configuration(String string) {
        this.fc.setFileSelectionMode(0);
        this.fc.setMultiSelectionEnabled(false);
        this.fc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file != null && (file.isDirectory() || Configuration.this.filter.accept(file));
            }

            public String getDescription() {
                return "Folders and Conient Configuration Files";
            }
        });
        this.fc.addChoosableFileFilter(this.filter);
        this._defaultConfigFile = this._configFile = new File(string);
        try {
            this._properties = this.readFileConfiguration(this._configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Configuration file not found - " + this._configFile.getName(), "Configuration Error", 0);
            System.exit(1);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Unable to read configuration file - " + this._configFile.getName() + "\nReason: " + iOException, "Configuration Error", 0);
            System.exit(1);
        }
    }

    public String getServerProperty(String string, String string2) {
        String string3 = null;
        if (this._connectionHandler != null) {
            string3 = this._connectionHandler.getConfigFromServer(string, string2);
        }
        return string3;
    }

    public void GUIReconfiguration() {
        ConfigurationDialog configurationDialog = new ConfigurationDialog();
    }

    public void saveNewConfiguration() {
        this.fc.setCurrentDirectory(this._configFile.getParentFile());
        int n = this.fc.showSaveDialog(Conient.getFrame());
        if (n == 0) {
            this._configFile = this.fc.getSelectedFile();
            this._usingSpecificConfig = true;
            this.saveConfiguration();
        }
    }

    public void saveConfiguration() {
        this.saveFileConfiguration(this._configFile);
    }

    public void saveDefaultConfiguration() {
        this.saveFileConfiguration(this._defaultConfigFile);
    }

    public void loadConfiguration() {
        this.fc.setCurrentDirectory(this._configFile.getParentFile());
        int n = this.fc.showOpenDialog(Conient.getFrame());
        if (n == 0) {
            this._configFile = this.fc.getSelectedFile();
            this._usingSpecificConfig = true;
            try {
                this._properties = this.readFileConfiguration(this._configFile);
                JOptionPane.showMessageDialog(null, "Configuration sucessfully read in - " + this._configFile.getName(), "Configuration Loaded", 1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, "Configuration file not found - " + this._configFile.getName(), "Configuration Error", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Unable to read configuration file - " + this._configFile.getName() + "\nReason: " + iOException, "Configuration Error", 0);
            }
        }
    }

    private Properties readFileConfiguration(File file) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties;
    }

    private void saveFileConfiguration(File file) {
        try {
            this._properties.store(new FileOutputStream(file), CONFIG_HEADER);
            JOptionPane.showMessageDialog(null, "Configuration written out - " + this._configFile.getName(), "Configuration Saved", 1);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Unable to write default configuration file - " + file.getName() + "\nReason: " + iOException, "Configuration Error", 0);
        }
    }

    public String getProperty(String string) {
        String string2 = this._properties.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public void setProperty(String string, String string2) {
        this._properties.setProperty(string, string2);
    }

    public boolean getUsingSpecificConfig() {
        return this._usingSpecificConfig;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this._connectionHandler = connectionHandler;
    }

    private class SuffixFileFilter
    extends FileFilter {
        private final String _suffix;
        private final String _description;

        public SuffixFileFilter(String string, String string2) {
            this._suffix = string.charAt(0) != '.' ? '.' + string : string;
            this._description = string2;
        }

        public boolean accept(File file) {
            String string;
            boolean bl = false;
            if (file != null && (string = file.getName()) != null) {
                int n = string.length();
                int n2 = string.lastIndexOf(".");
                bl = n2 >= 1 && this.getSuffix().equalsIgnoreCase(string.substring(n2));
            }
            return bl;
        }

        public String getDescription() {
            return this._description;
        }

        public String getSuffix() {
            return this._suffix;
        }
    }
}

