/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import uk.org.iscream.cms.server.util.FormatName;

public class Smtp {
    public static final String REVISION = "$Revision: 1.6 $";
    private String _name = null;
    private BufferedReader _socketIn;
    private PrintWriter _socketOut;
    private Socket _socket;

    public Smtp(String string) throws IOException {
        this(string, 25);
    }

    public Smtp(String string, int n) throws IOException {
        this._socket = new Socket(string, n);
        this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
        this._socketIn.readLine();
        this.sendCommand("HELO " + InetAddress.getLocalHost().getHostName(), 250);
    }

    public void close() throws IOException {
        this.sendCommand("QUIT", 221);
        this._socketIn.close();
        this._socketOut.close();
        this._socket.close();
    }

    public void setSender(String string) throws IOException {
        this.sendCommand("MAIL FROM: <" + string + ">", 250);
    }

    public void setTo(String string) throws IOException {
        this.sendCommand("RCPT TO: <" + string + ">", 250);
    }

    public PrintWriter getOutputStream() throws IOException {
        this.sendCommand("DATA", 354);
        return this._socketOut;
    }

    public void sendMessage() throws IOException {
        this.sendCommand(".", 250);
    }

    public void sendCommand(String string, int n) throws IOException {
        this._socketOut.println(string);
        String string2 = this._socketIn.readLine();
        if (!string2.startsWith(new Integer(n).toString())) {
            throw new IOException("Expected " + n + ", got " + string2);
        }
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), REVISION);
    }
}

