/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Amount } from "../../components/Amount.js";
import { Part } from "../../components/Part.js";
import { Button } from "../../mui/Button.js";
import { State } from "./index.js";
import { TermsOfService } from "../../components/TermsOfService/index.js";

export function IgnoredView(state: State.Ignored): VNode {
  const { i18n } = useTranslationContext();

  return (
    <Fragment>
      <section>
        <p>
          <i18n.Translate>You&apos;ve ignored the refund.</i18n.Translate>
        </p>
      </section>
    </Fragment>
  );
}
// export function InProgressView(state: State.InProgress): VNode {
//   const { i18n } = useTranslationContext();

//   return (
//     <Fragment>
//       <section>
//         <p>
//           <i18n.Translate>The refund is in progress.</i18n.Translate>
//         </p>
//       </section>
//       <section>
//         <Part
//           big
//           title={i18n.str`Total to refund`}
//           text={<Amount value={state.awaitingAmount} />}
//           kind="negative"
//         />
//         <Part
//           big
//           title={i18n.str`Refunded`}
//           text={<Amount value={state.amount} />}
//           kind="negative"
//         />
//       </section>
//       {state.products && state.products.length ? (
//         <section>
//           <ProductList products={state.products} />
//         </section>
//       ) : undefined}
//     </Fragment>
//   );
// }
export function ReadyView(state: State.Ready): VNode {
  const { i18n } = useTranslationContext();
  return (
    <Fragment>
      <section>
        <p>
          <i18n.Translate>
            The merchant &quot;<b>{state.merchantName}</b>&quot; is offering you
            a refund.
          </i18n.Translate>
        </p>
      </section>
      <section>
        <Part
          big
          title={i18n.str`Order amount`}
          text={<Amount value={state.amount} />}
          kind="neutral"
        />
        {/* {Amounts.isNonZero(state.granted) && (
          <Part
            big
            title={i18n.str`Already refunded`}
            text={<Amount value={state.granted} />}
            kind="neutral"
          />
        )}
        <Part
          big
          title={i18n.str`Refund offered (without fee)`}
          text={<Amount value={state.awaitingAmount} />}
          kind="positive"
        /> */}
      </section>
      {/* {state.products && state.products.length ? (
        <section>
          <ProductList products={state.products} />
        </section>
      ) : undefined} */}
      <section>
        <Button
          variant="contained"
          color="success"
          onClick={state.accept.onClick}
        >
          <i18n.Translate>
            {/* Accept &nbsp; <Amount value={state.awaitingAmount} /> */}
            Accept
          </i18n.Translate>
        </Button>
      </section>
    </Fragment>
  );
}
