/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Translator } from "./i18n.js";

// From https://en.wikipedia.org/wiki/ISO_4217

export const enum CurrencyCode {
  AED,
  AFN,
  ALL,
  AMD,
  ANG,
  AOA,
  ARS,
  AUD,
  AWG,
  AZN,
  BAM,
  BBD,
  BDT,
  BGN,
  BHD,
  BIF,
  BMD,
  BND,
  BOB,
  BOV,
  BRL,
  BSD,
  BTN,
  BWP,
  BYN,
  BZD,
  CAD,
  CDF,
  CHE,
  CHF,
  CHW,
  CLF,
  CLP,
  CNY,
  COP,
  COU,
  CRC,
  CUP,
  CVE,
  CZK,
  DJF,
  DKK,
  DOP,
  DZD,
  EGP,
  ERN,
  ETB,
  EUR,
  FJD,
  FKP,
  GBP,
  GEL,
  GHS,
  GIP,
  GMD,
  GNF,
  GTQ,
  GYD,
  HKD,
  HNL,
  HTG,
  HUF,
  IDR,
  ILS,
  INR,
  IQD,
  IRR,
  ISK,
  JMD,
  JOD,
  JPY,
  KES,
  KGS,
  KHR,
  KMF,
  KPW,
  KRW,
  KWD,
  KYD,
  KZT,
  LAK,
  LBP,
  LKR,
  LRD,
  LSL,
  LYD,
  MAD,
  MDL,
  MGA,
  MKD,
  MMK,
  MNT,
  MOP,
  MRU,
  MUR,
  MVR,
  MWK,
  MXN,
  MXV,
  MYR,
  MZN,
  NAD,
  NGN,
  NIO,
  NOK,
  NPR,
  NZD,
  OMR,
  PAB,
  PEN,
  PGK,
  PHP,
  PKR,
  PLN,
  PYG,
  QAR,
  RON,
  RSD,
  RUB,
  RWF,
  SAR,
  SBD,
  SCR,
  SDG,
  SEK,
  SGD,
  SHP,
  SLE,
  SOS,
  SRD,
  SSP,
  STN,
  SVC,
  SYP,
  SZL,
  THB,
  TJS,
  TMT,
  TND,
  TOP,
  TRY,
  TTD,
  TWD,
  TZS,
  UAH,
  UGX,
  USD,
  USN,
  UYI,
  UYU,
  UYW,
  UZS,
  VED,
  VES,
  VND,
  VUV,
  WST,
  XAF,
  XCD,
  XOF,
  XPF,
  XSU,
  YER,
  ZAR,
  ZMW,
  ZWG,
}

export const currencyInfoByCode: {
  [c in CurrencyCode]: {
    c: number; //numeric code
    d: number; //number of decimal digits
  };
} = {
  [CurrencyCode.AED]: { c: 784, d: 2 },
  [CurrencyCode.AFN]: { c: 971, d: 2 },
  [CurrencyCode.ALL]: { c: 8, d: 2 },
  [CurrencyCode.AMD]: { c: 51, d: 2 },
  [CurrencyCode.ANG]: { c: 532, d: 2 },
  [CurrencyCode.AOA]: { c: 973, d: 2 },
  [CurrencyCode.ARS]: { c: 32, d: 2 },
  [CurrencyCode.AUD]: { c: 36, d: 2 },
  [CurrencyCode.AWG]: { c: 533, d: 2 },
  [CurrencyCode.AZN]: { c: 944, d: 2 },
  [CurrencyCode.BAM]: { c: 977, d: 2 },
  [CurrencyCode.BBD]: { c: 52, d: 2 },
  [CurrencyCode.BDT]: { c: 50, d: 2 },
  [CurrencyCode.BGN]: { c: 975, d: 2 },
  [CurrencyCode.BHD]: { c: 48, d: 3 },
  [CurrencyCode.BIF]: { c: 108, d: 0 },
  [CurrencyCode.BMD]: { c: 60, d: 2 },
  [CurrencyCode.BND]: { c: 96, d: 2 },
  [CurrencyCode.BOB]: { c: 68, d: 2 },
  [CurrencyCode.BOV]: { c: 984, d: 2 },
  [CurrencyCode.BRL]: { c: 986, d: 2 },
  [CurrencyCode.BSD]: { c: 44, d: 2 },
  [CurrencyCode.BTN]: { c: 64, d: 2 },
  [CurrencyCode.BWP]: { c: 72, d: 2 },
  [CurrencyCode.BYN]: { c: 933, d: 2 },
  [CurrencyCode.BZD]: { c: 84, d: 2 },
  [CurrencyCode.CAD]: { c: 124, d: 2 },
  [CurrencyCode.CDF]: { c: 976, d: 2 },
  [CurrencyCode.CHE]: { c: 947, d: 2 },
  [CurrencyCode.CHF]: { c: 756, d: 2 },
  [CurrencyCode.CHW]: { c: 948, d: 2 },
  [CurrencyCode.CLF]: { c: 990, d: 4 },
  [CurrencyCode.CLP]: { c: 152, d: 0 },
  [CurrencyCode.CNY]: { c: 156, d: 2 },
  [CurrencyCode.COP]: { c: 170, d: 2 },
  [CurrencyCode.COU]: { c: 970, d: 2 },
  [CurrencyCode.CRC]: { c: 188, d: 2 },
  [CurrencyCode.CUP]: { c: 192, d: 2 },
  [CurrencyCode.CVE]: { c: 132, d: 2 },
  [CurrencyCode.CZK]: { c: 203, d: 2 },
  [CurrencyCode.DJF]: { c: 262, d: 0 },
  [CurrencyCode.DKK]: { c: 208, d: 2 },
  [CurrencyCode.DOP]: { c: 214, d: 2 },
  [CurrencyCode.DZD]: { c: 12, d: 2 },
  [CurrencyCode.EGP]: { c: 818, d: 2 },
  [CurrencyCode.ERN]: { c: 232, d: 2 },
  [CurrencyCode.ETB]: { c: 230, d: 2 },
  [CurrencyCode.EUR]: { c: 978, d: 2 },
  [CurrencyCode.FJD]: { c: 242, d: 2 },
  [CurrencyCode.FKP]: { c: 238, d: 2 },
  [CurrencyCode.GBP]: { c: 826, d: 2 },
  [CurrencyCode.GEL]: { c: 981, d: 2 },
  [CurrencyCode.GHS]: { c: 936, d: 2 },
  [CurrencyCode.GIP]: { c: 292, d: 2 },
  [CurrencyCode.GMD]: { c: 270, d: 2 },
  [CurrencyCode.GNF]: { c: 324, d: 0 },
  [CurrencyCode.GTQ]: { c: 320, d: 2 },
  [CurrencyCode.GYD]: { c: 328, d: 2 },
  [CurrencyCode.HKD]: { c: 344, d: 2 },
  [CurrencyCode.HNL]: { c: 340, d: 2 },
  [CurrencyCode.HTG]: { c: 332, d: 2 },
  [CurrencyCode.HUF]: { c: 348, d: 2 },
  [CurrencyCode.IDR]: { c: 360, d: 2 },
  [CurrencyCode.ILS]: { c: 376, d: 2 },
  [CurrencyCode.INR]: { c: 356, d: 2 },
  [CurrencyCode.IQD]: { c: 368, d: 3 },
  [CurrencyCode.IRR]: { c: 364, d: 2 },
  [CurrencyCode.ISK]: { c: 352, d: 0 },
  [CurrencyCode.JMD]: { c: 388, d: 2 },
  [CurrencyCode.JOD]: { c: 400, d: 3 },
  [CurrencyCode.JPY]: { c: 392, d: 0 },
  [CurrencyCode.KES]: { c: 404, d: 2 },
  [CurrencyCode.KGS]: { c: 417, d: 2 },
  [CurrencyCode.KHR]: { c: 116, d: 2 },
  [CurrencyCode.KMF]: { c: 174, d: 0 },
  [CurrencyCode.KPW]: { c: 408, d: 2 },
  [CurrencyCode.KRW]: { c: 410, d: 0 },
  [CurrencyCode.KWD]: { c: 414, d: 3 },
  [CurrencyCode.KYD]: { c: 136, d: 2 },
  [CurrencyCode.KZT]: { c: 398, d: 2 },
  [CurrencyCode.LAK]: { c: 418, d: 2 },
  [CurrencyCode.LBP]: { c: 422, d: 2 },
  [CurrencyCode.LKR]: { c: 144, d: 2 },
  [CurrencyCode.LRD]: { c: 430, d: 2 },
  [CurrencyCode.LSL]: { c: 426, d: 2 },
  [CurrencyCode.LYD]: { c: 434, d: 3 },
  [CurrencyCode.MAD]: { c: 504, d: 2 },
  [CurrencyCode.MDL]: { c: 498, d: 2 },
  [CurrencyCode.MGA]: { c: 969, d: 2 },
  [CurrencyCode.MKD]: { c: 807, d: 2 },
  [CurrencyCode.MMK]: { c: 104, d: 2 },
  [CurrencyCode.MNT]: { c: 496, d: 2 },
  [CurrencyCode.MOP]: { c: 446, d: 2 },
  [CurrencyCode.MRU]: { c: 929, d: 2 },
  [CurrencyCode.MUR]: { c: 480, d: 2 },
  [CurrencyCode.MVR]: { c: 462, d: 2 },
  [CurrencyCode.MWK]: { c: 454, d: 2 },
  [CurrencyCode.MXN]: { c: 484, d: 2 },
  [CurrencyCode.MXV]: { c: 979, d: 2 },
  [CurrencyCode.MYR]: { c: 458, d: 2 },
  [CurrencyCode.MZN]: { c: 943, d: 2 },
  [CurrencyCode.NAD]: { c: 516, d: 2 },
  [CurrencyCode.NGN]: { c: 566, d: 2 },
  [CurrencyCode.NIO]: { c: 558, d: 2 },
  [CurrencyCode.NOK]: { c: 578, d: 2 },
  [CurrencyCode.NPR]: { c: 524, d: 2 },
  [CurrencyCode.NZD]: { c: 554, d: 2 },
  [CurrencyCode.OMR]: { c: 512, d: 3 },
  [CurrencyCode.PAB]: { c: 590, d: 2 },
  [CurrencyCode.PEN]: { c: 604, d: 2 },
  [CurrencyCode.PGK]: { c: 598, d: 2 },
  [CurrencyCode.PHP]: { c: 608, d: 2 },
  [CurrencyCode.PKR]: { c: 586, d: 2 },
  [CurrencyCode.PLN]: { c: 985, d: 2 },
  [CurrencyCode.PYG]: { c: 600, d: 0 },
  [CurrencyCode.QAR]: { c: 634, d: 2 },
  [CurrencyCode.RON]: { c: 946, d: 2 },
  [CurrencyCode.RSD]: { c: 941, d: 2 },
  [CurrencyCode.RUB]: { c: 643, d: 2 },
  [CurrencyCode.RWF]: { c: 646, d: 0 },
  [CurrencyCode.SAR]: { c: 682, d: 2 },
  [CurrencyCode.SBD]: { c: 90, d: 2 },
  [CurrencyCode.SCR]: { c: 690, d: 2 },
  [CurrencyCode.SDG]: { c: 938, d: 2 },
  [CurrencyCode.SEK]: { c: 752, d: 2 },
  [CurrencyCode.SGD]: { c: 702, d: 2 },
  [CurrencyCode.SHP]: { c: 654, d: 2 },
  [CurrencyCode.SLE]: { c: 925, d: 2 },
  [CurrencyCode.SOS]: { c: 706, d: 2 },
  [CurrencyCode.SRD]: { c: 968, d: 2 },
  [CurrencyCode.SSP]: { c: 728, d: 2 },
  [CurrencyCode.STN]: { c: 930, d: 2 },
  [CurrencyCode.SVC]: { c: 222, d: 2 },
  [CurrencyCode.SYP]: { c: 760, d: 2 },
  [CurrencyCode.SZL]: { c: 748, d: 2 },
  [CurrencyCode.THB]: { c: 764, d: 2 },
  [CurrencyCode.TJS]: { c: 972, d: 2 },
  [CurrencyCode.TMT]: { c: 934, d: 2 },
  [CurrencyCode.TND]: { c: 788, d: 3 },
  [CurrencyCode.TOP]: { c: 776, d: 2 },
  [CurrencyCode.TRY]: { c: 949, d: 2 },
  [CurrencyCode.TTD]: { c: 780, d: 2 },
  [CurrencyCode.TWD]: { c: 901, d: 2 },
  [CurrencyCode.TZS]: { c: 834, d: 2 },
  [CurrencyCode.UAH]: { c: 980, d: 2 },
  [CurrencyCode.UGX]: { c: 800, d: 0 },
  [CurrencyCode.USD]: { c: 840, d: 2 },
  [CurrencyCode.USN]: { c: 997, d: 2 },
  [CurrencyCode.UYI]: { c: 940, d: 0 },
  [CurrencyCode.UYU]: { c: 858, d: 2 },
  [CurrencyCode.UYW]: { c: 927, d: 4 },
  [CurrencyCode.UZS]: { c: 860, d: 2 },
  [CurrencyCode.VED]: { c: 926, d: 2 },
  [CurrencyCode.VES]: { c: 928, d: 2 },
  [CurrencyCode.VND]: { c: 704, d: 0 },
  [CurrencyCode.VUV]: { c: 548, d: 0 },
  [CurrencyCode.WST]: { c: 882, d: 2 },
  [CurrencyCode.XAF]: { c: 950, d: 0 },
  [CurrencyCode.XCD]: { c: 951, d: 2 },
  [CurrencyCode.XOF]: { c: 952, d: 0 },
  [CurrencyCode.XPF]: { c: 953, d: 0 },
  [CurrencyCode.XSU]: { c: 994, d: 0 },
  [CurrencyCode.YER]: { c: 886, d: 2 },
  [CurrencyCode.ZAR]: { c: 710, d: 2 },
  [CurrencyCode.ZMW]: { c: 967, d: 2 },
  [CurrencyCode.ZWG]: { c: 924, d: 2 },
};

export const currencyNamesByCode: { [c in CurrencyCode]: Translator } = {
  [CurrencyCode.AED]: (i18n) => i18n.str`UAE Dirham`,
  [CurrencyCode.AFN]: (i18n) => i18n.str`Afghani`,
  [CurrencyCode.ALL]: (i18n) => i18n.str`Lek`,
  [CurrencyCode.AMD]: (i18n) => i18n.str`Armenian Dram`,
  [CurrencyCode.ANG]: (i18n) => i18n.str`Netherlands Antillean Guilder`,
  [CurrencyCode.AOA]: (i18n) => i18n.str`Kwanza`,
  [CurrencyCode.ARS]: (i18n) => i18n.str`Argentine Peso`,
  [CurrencyCode.AUD]: (i18n) => i18n.str`Australian Dollar`,
  [CurrencyCode.AWG]: (i18n) => i18n.str`Aruban Florin`,
  [CurrencyCode.AZN]: (i18n) => i18n.str`Azerbaijan Manat`,
  [CurrencyCode.BAM]: (i18n) => i18n.str`Convertible Mark`,
  [CurrencyCode.BBD]: (i18n) => i18n.str`Barbados Dollar`,
  [CurrencyCode.BDT]: (i18n) => i18n.str`Taka`,
  [CurrencyCode.BGN]: (i18n) => i18n.str`Bulgarian Lev`,
  [CurrencyCode.BHD]: (i18n) => i18n.str`Bahraini Dinar`,
  [CurrencyCode.BIF]: (i18n) => i18n.str`Burundi Franc`,
  [CurrencyCode.BMD]: (i18n) => i18n.str`Bermudian Dollar`,
  [CurrencyCode.BND]: (i18n) => i18n.str`Brunei Dollar`,
  [CurrencyCode.BOB]: (i18n) => i18n.str`Boliviano`,
  [CurrencyCode.BOV]: (i18n) => i18n.str`Mvdol`,
  [CurrencyCode.BRL]: (i18n) => i18n.str`Brazilian Real`,
  [CurrencyCode.BSD]: (i18n) => i18n.str`Bahamian Dollar`,
  [CurrencyCode.BTN]: (i18n) => i18n.str`Ngultrum`,
  [CurrencyCode.BWP]: (i18n) => i18n.str`Pula`,
  [CurrencyCode.BYN]: (i18n) => i18n.str`Belarusian Ruble`,
  [CurrencyCode.BZD]: (i18n) => i18n.str`Belize Dollar`,
  [CurrencyCode.CAD]: (i18n) => i18n.str`Canadian Dollar`,
  [CurrencyCode.CDF]: (i18n) => i18n.str`Congolese Franc`,
  [CurrencyCode.CHE]: (i18n) => i18n.str`WIR Euro`,
  [CurrencyCode.CHF]: (i18n) => i18n.str`Swiss Franc`,
  [CurrencyCode.CHW]: (i18n) => i18n.str`WIR Franc`,
  [CurrencyCode.CLF]: (i18n) => i18n.str`Unidad de Fomento`,
  [CurrencyCode.CLP]: (i18n) => i18n.str`Chilean Peso`,
  [CurrencyCode.CNY]: (i18n) => i18n.str`Yuan Renminbi`,
  [CurrencyCode.COP]: (i18n) => i18n.str`Colombian Peso`,
  [CurrencyCode.COU]: (i18n) => i18n.str`Unidad de Valor Real`,
  [CurrencyCode.CRC]: (i18n) => i18n.str`Costa Rican Colon`,
  [CurrencyCode.CUP]: (i18n) => i18n.str`Cuban Peso`,
  [CurrencyCode.CVE]: (i18n) => i18n.str`Cabo Verde Escudo`,
  [CurrencyCode.CZK]: (i18n) => i18n.str`Czech Koruna`,
  [CurrencyCode.DJF]: (i18n) => i18n.str`Djibouti Franc`,
  [CurrencyCode.DKK]: (i18n) => i18n.str`Danish Krone`,
  [CurrencyCode.DOP]: (i18n) => i18n.str`Dominican Peso`,
  [CurrencyCode.DZD]: (i18n) => i18n.str`Algerian Dinar`,
  [CurrencyCode.EGP]: (i18n) => i18n.str`Egyptian Pound`,
  [CurrencyCode.ERN]: (i18n) => i18n.str`Nakfa`,
  [CurrencyCode.ETB]: (i18n) => i18n.str`Ethiopian Birr`,
  [CurrencyCode.EUR]: (i18n) => i18n.str`Euro`,
  [CurrencyCode.FJD]: (i18n) => i18n.str`Fiji Dollar`,
  [CurrencyCode.FKP]: (i18n) => i18n.str`Falkland Islands Pound`,
  [CurrencyCode.GBP]: (i18n) => i18n.str`Pound Sterling`,
  [CurrencyCode.GEL]: (i18n) => i18n.str`Lari`,
  [CurrencyCode.GHS]: (i18n) => i18n.str`Ghana Cedi`,
  [CurrencyCode.GIP]: (i18n) => i18n.str`Gibraltar Pound`,
  [CurrencyCode.GMD]: (i18n) => i18n.str`Dalasi`,
  [CurrencyCode.GNF]: (i18n) => i18n.str`Guinean Franc`,
  [CurrencyCode.GTQ]: (i18n) => i18n.str`Quetzal`,
  [CurrencyCode.GYD]: (i18n) => i18n.str`Guyana Dollar`,
  [CurrencyCode.HKD]: (i18n) => i18n.str`Hong Kong Dollar`,
  [CurrencyCode.HNL]: (i18n) => i18n.str`Lempira`,
  [CurrencyCode.HTG]: (i18n) => i18n.str`Gourde`,
  [CurrencyCode.HUF]: (i18n) => i18n.str`Forint`,
  [CurrencyCode.IDR]: (i18n) => i18n.str`Rupiah`,
  [CurrencyCode.ILS]: (i18n) => i18n.str`New Israeli Sheqel`,
  [CurrencyCode.INR]: (i18n) => i18n.str`Indian Rupee`,
  [CurrencyCode.IQD]: (i18n) => i18n.str`Iraqi Dinar`,
  [CurrencyCode.IRR]: (i18n) => i18n.str`Iranian Rial`,
  [CurrencyCode.ISK]: (i18n) => i18n.str`Iceland Krona`,
  [CurrencyCode.JMD]: (i18n) => i18n.str`Jamaican Dollar`,
  [CurrencyCode.JOD]: (i18n) => i18n.str`Jordanian Dinar`,
  [CurrencyCode.JPY]: (i18n) => i18n.str`Yen`,
  [CurrencyCode.KES]: (i18n) => i18n.str`Kenyan Shilling`,
  [CurrencyCode.KGS]: (i18n) => i18n.str`Som`,
  [CurrencyCode.KHR]: (i18n) => i18n.str`Riel`,
  [CurrencyCode.KMF]: (i18n) => i18n.str`Comorian Franc `,
  [CurrencyCode.KPW]: (i18n) => i18n.str`North Korean Won`,
  [CurrencyCode.KRW]: (i18n) => i18n.str`Won`,
  [CurrencyCode.KWD]: (i18n) => i18n.str`Kuwaiti Dinar`,
  [CurrencyCode.KYD]: (i18n) => i18n.str`Cayman Islands Dollar`,
  [CurrencyCode.KZT]: (i18n) => i18n.str`Tenge`,
  [CurrencyCode.LAK]: (i18n) => i18n.str`Lao Kip`,
  [CurrencyCode.LBP]: (i18n) => i18n.str`Lebanese Pound`,
  [CurrencyCode.LKR]: (i18n) => i18n.str`Sri Lanka Rupee`,
  [CurrencyCode.LRD]: (i18n) => i18n.str`Liberian Dollar`,
  [CurrencyCode.LSL]: (i18n) => i18n.str`Loti`,
  [CurrencyCode.LYD]: (i18n) => i18n.str`Libyan Dinar`,
  [CurrencyCode.MAD]: (i18n) => i18n.str`Moroccan Dirham`,
  [CurrencyCode.MDL]: (i18n) => i18n.str`Moldovan Leu`,
  [CurrencyCode.MGA]: (i18n) => i18n.str`Malagasy Ariary`,
  [CurrencyCode.MKD]: (i18n) => i18n.str`Denar`,
  [CurrencyCode.MMK]: (i18n) => i18n.str`Kyat`,
  [CurrencyCode.MNT]: (i18n) => i18n.str`Tugrik`,
  [CurrencyCode.MOP]: (i18n) => i18n.str`Pataca`,
  [CurrencyCode.MRU]: (i18n) => i18n.str`Ouguiya`,
  [CurrencyCode.MUR]: (i18n) => i18n.str`Mauritius Rupee`,
  [CurrencyCode.MVR]: (i18n) => i18n.str`Rufiyaa`,
  [CurrencyCode.MWK]: (i18n) => i18n.str`Malawi Kwacha`,
  [CurrencyCode.MXN]: (i18n) => i18n.str`Mexican Peso`,
  [CurrencyCode.MXV]: (i18n) => i18n.str`Mexican Unidad de Inversion (UDI)`,
  [CurrencyCode.MYR]: (i18n) => i18n.str`Malaysian Ringgit`,
  [CurrencyCode.MZN]: (i18n) => i18n.str`Mozambique Metical`,
  [CurrencyCode.NAD]: (i18n) => i18n.str`Namibia Dollar`,
  [CurrencyCode.NGN]: (i18n) => i18n.str`Naira`,
  [CurrencyCode.NIO]: (i18n) => i18n.str`Cordoba Oro`,
  [CurrencyCode.NOK]: (i18n) => i18n.str`Norwegian Krone`,
  [CurrencyCode.NPR]: (i18n) => i18n.str`Nepalese Rupee`,
  [CurrencyCode.NZD]: (i18n) => i18n.str`New Zealand Dollar`,
  [CurrencyCode.OMR]: (i18n) => i18n.str`Rial Omani`,
  [CurrencyCode.PAB]: (i18n) => i18n.str`Balboa`,
  [CurrencyCode.PEN]: (i18n) => i18n.str`Sol`,
  [CurrencyCode.PGK]: (i18n) => i18n.str`Kina`,
  [CurrencyCode.PHP]: (i18n) => i18n.str`Philippine Peso`,
  [CurrencyCode.PKR]: (i18n) => i18n.str`Pakistan Rupee`,
  [CurrencyCode.PLN]: (i18n) => i18n.str`Zloty`,
  [CurrencyCode.PYG]: (i18n) => i18n.str`Guarani`,
  [CurrencyCode.QAR]: (i18n) => i18n.str`Qatari Rial`,
  [CurrencyCode.RON]: (i18n) => i18n.str`Romanian Leu`,
  [CurrencyCode.RSD]: (i18n) => i18n.str`Serbian Dinar`,
  [CurrencyCode.RUB]: (i18n) => i18n.str`Russian Ruble`,
  [CurrencyCode.RWF]: (i18n) => i18n.str`Rwanda Franc`,
  [CurrencyCode.SAR]: (i18n) => i18n.str`Saudi Riyal`,
  [CurrencyCode.SBD]: (i18n) => i18n.str`Solomon Islands Dollar`,
  [CurrencyCode.SCR]: (i18n) => i18n.str`Seychelles Rupee`,
  [CurrencyCode.SDG]: (i18n) => i18n.str`Sudanese Pound`,
  [CurrencyCode.SEK]: (i18n) => i18n.str`Swedish Krona`,
  [CurrencyCode.SGD]: (i18n) => i18n.str`Singapore Dollar`,
  [CurrencyCode.SHP]: (i18n) => i18n.str`Saint Helena Pound`,
  [CurrencyCode.SLE]: (i18n) => i18n.str`Leone`,
  [CurrencyCode.SOS]: (i18n) => i18n.str`Somali Shilling`,
  [CurrencyCode.SRD]: (i18n) => i18n.str`Surinam Dollar`,
  [CurrencyCode.SSP]: (i18n) => i18n.str`South Sudanese Pound`,
  [CurrencyCode.STN]: (i18n) => i18n.str`Dobra`,
  [CurrencyCode.SVC]: (i18n) => i18n.str`El Salvador Colon`,
  [CurrencyCode.SYP]: (i18n) => i18n.str`Syrian Pound`,
  [CurrencyCode.SZL]: (i18n) => i18n.str`Lilangeni`,
  [CurrencyCode.THB]: (i18n) => i18n.str`Baht`,
  [CurrencyCode.TJS]: (i18n) => i18n.str`Somoni`,
  [CurrencyCode.TMT]: (i18n) => i18n.str`Turkmenistan New Manat`,
  [CurrencyCode.TND]: (i18n) => i18n.str`Tunisian Dinar`,
  [CurrencyCode.TOP]: (i18n) => i18n.str`Pa’anga`,
  [CurrencyCode.TRY]: (i18n) => i18n.str`Turkish Lira`,
  [CurrencyCode.TTD]: (i18n) => i18n.str`Trinidad and Tobago Dollar`,
  [CurrencyCode.TWD]: (i18n) => i18n.str`New Taiwan Dollar`,
  [CurrencyCode.TZS]: (i18n) => i18n.str`Tanzanian Shilling`,
  [CurrencyCode.UAH]: (i18n) => i18n.str`Hryvnia`,
  [CurrencyCode.UGX]: (i18n) => i18n.str`Uganda Shilling`,
  [CurrencyCode.USD]: (i18n) => i18n.str`US Dollar`,
  [CurrencyCode.USN]: (i18n) => i18n.str`US Dollar (Next day)`,
  [CurrencyCode.UYI]: (i18n) =>
    i18n.str`Uruguay Peso en Unidades Indexadas (UI)`,
  [CurrencyCode.UYU]: (i18n) => i18n.str`Peso Uruguayo`,
  [CurrencyCode.UYW]: (i18n) => i18n.str`Unidad Previsional`,
  [CurrencyCode.UZS]: (i18n) => i18n.str`Uzbekistan Sum`,
  [CurrencyCode.VED]: (i18n) => i18n.str`Bolívar Soberano`,
  [CurrencyCode.VES]: (i18n) => i18n.str`Bolívar Soberano`,
  [CurrencyCode.VND]: (i18n) => i18n.str`Dong`,
  [CurrencyCode.VUV]: (i18n) => i18n.str`Vatu`,
  [CurrencyCode.WST]: (i18n) => i18n.str`Tala`,
  [CurrencyCode.XAF]: (i18n) => i18n.str`CFA Franc BEAC`,
  [CurrencyCode.XCD]: (i18n) => i18n.str`East Caribbean Dollar`,
  [CurrencyCode.XOF]: (i18n) => i18n.str`CFA Franc BCEAO`,
  [CurrencyCode.XPF]: (i18n) => i18n.str`CFP Franc`,
  [CurrencyCode.XSU]: (i18n) => i18n.str`Sucre`,
  [CurrencyCode.YER]: (i18n) => i18n.str`Yemeni Rial`,
  [CurrencyCode.ZAR]: (i18n) => i18n.str`Rand`,
  [CurrencyCode.ZMW]: (i18n) => i18n.str`Zambian Kwacha`,
  [CurrencyCode.ZWG]: (i18n) => i18n.str`Zimbabwe Gold`,
};
