/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file donaudb/pg_lookup_donation_unit_amount.c
 * @brief Implmentation of getting the donation unit amount
 *          from the donation_units table.
 * @author Bohdan Potuzhnyi
 */
#include <donau_config.h>
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_template.h"
#include "pg_helper.h"
#include "donau_pq_lib.h"
#include "pg_lookup_donation_unit_amount.h"


enum GNUNET_DB_QueryStatus
DH_PG_lookup_donation_unit_amount (
  void *cls,
  const struct DONAU_DonationUnitHashP *h_donation_unit_pub,
  struct TALER_Amount *value)
{
  struct PostgresClosure *pg = cls;

  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_auto_from_type (h_donation_unit_pub),
    GNUNET_PQ_query_param_end
  };

  struct GNUNET_PQ_ResultSpec rs[] = {
    TALER_PQ_RESULT_SPEC_AMOUNT ("value",
                                 value),
    GNUNET_PQ_result_spec_end
  };

  PREPARE (pg,
           "lookup_donation_unit",
           "SELECT value"
           " FROM donation_units"
           " WHERE h_donation_unit_pub=$1;");

  return GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                   "lookup_donation_unit",
                                                   params,
                                                   rs);
}
