%{
/*
 * Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string>

#include "my_sstream.h"

#include "tags.h"
#include "colors.h"
#include "keys.h"
#include "messages.h"
#include "parsetags.h"
#include "fileutil.h"

using std::cerr;

static int yyparse() ;
static void yyerror( char *s ) ;

int line = 1 ;

static void add_tag(Tags *tags, Tag *t);
static Tags *parsed_tags = 0;

extern int opsc_lex() ;
extern FILE *opsc_in ;

%}

%union {
  int tok ; /* command */
  const std::string * string ; /* string : id, ... */
  TagStyle flag ;
  Tag *tag ;
  Tags *tags ;
  TagStyles *tagstyles;
} ;

%token <flag> BOLD ITALICS UNDERLINE FIXED NOTFIXED
%token <string> KEY COLOR

%type <tag> option
%type <tags> options
%type <flag> value
%type <tagstyles> stylevalues values

%%

globaltags : options { parsed_tags = $1; }
;

options : options option { add_tag( $1, $2 ) ; }
        | option { $$ = new Tags() ; $$->AddTag( $1 ) ;  }
        ;

option : KEY COLOR
             {
                 printMessage( *$1 ) ;
                 printMessage( *$2 ) ;
             }
         stylevalues ';'
             {
               $$ = new Tag( *$1, *$2 ) ;
               $$->setStyles(TagStylesPtr($4)) ;
               delete $1;
               delete $2;
             }
       ;

stylevalues : { $$ = 0 ; printMessage( " (no options) " ) ; }
            | values
            ;

values : values ',' value { $$ = $1; $$->push_back($3) ; }
       | value { $$ = new TagStyles; $$->push_back($1); }
       ;

value : BOLD { printMessage( " - bold" ) ; $$ = ISBOLD ; }
      | ITALICS { printMessage( " - italics" ) ; $$ = ISITALIC ; }
      | UNDERLINE { printMessage( " - underline" ) ; $$ = ISUNDERLINE ; }
      | FIXED { printMessage( " - fixed" ) ; $$ = ISFIXED ; }
      | NOTFIXED { printMessage( " - notfixed" ) ; $$ = ISNOTFIXED ; }
      ;

%%

string current_file;

Tags *
parseTags(const string &path, const string &name)
{
  // opens the file for yylex
  opsc_in = open_data_file_stream(path, name);

  current_file = (path.size() ? path + "/" : "") + name;

  printMessage_noln( "Parsing ", cerr ) ;
  printMessage_noln (current_file, cerr);
  printMessage( " file ...", cerr ) ;
  parsed_tags = 0;
  yyparse() ;
  printMessage( "Parsing done!", cerr ) ;
  fclose(opsc_in);
  return parsed_tags;
}

void
yyerror( char *s )
{
  ostringstream str ;
  str << current_file << ":" << line << ": " << s << ", in option declaration";
  printError( str.str().c_str(), cerr ) ;
  exit(EXIT_FAILURE);
}

void
add_tag(Tags *tags, Tag *t)
{
  if (! tags->AddTag(t))
  {
    yyerror("already defined");
  }
}