# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# gnome emu

import gtk
from uiconsts import *
import uiconsts
from src import gu
from src.i18n import _
def _add_help(self, a, b):
    print "add_help not implemented"
gtk.GtkWidget.add_help = _add_help

class GnomeApp(gtk.GtkWindow):
    def __init__(self, a, b):
        gtk.GtkWindow.__init__(self, gtk.WINDOW_TOPLEVEL)
        self._cid = 4
        self.__vbox = gtk.GtkVBox()
        self.add(self.__vbox)
        self.__menubox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__toolbarbox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__contentsbox = gu.bVBox(self.__vbox)
        self.__appbarbox = gu.bHBox(self.__vbox, gtk.FALSE)
        self.__dockitems = {}
    def show(self):
        self.__vbox.show()
        self.__menubox.show()
        self.__toolbarbox.show()
        self.__contentsbox.show()
        self.__appbarbox.show()
        gtk.GtkWindow.show(self)
    def flash(self, msg):
        self.__appbar.g_statusbar.push(self._cid, msg)
        gtk.timeout_add(2000, self._pop_message, self._cid)
        self._cid = self._cid + 1
    def _pop_message(self, cid):
        self.__appbar.g_statusbar.pop(cid)
    def set_statusbar(self, bar):
        self.__appbarbox.pack_start(bar)
        bar.show()
        self.__appbar = bar
    def set_contents(self, c):
        self.__contentsbox.pack_start(c)
    def create_menus(self, uiinfo):
        hdlbox = gtk.GtkHandleBox()
        hdlbox.show()
        self.__dockitems['Menubar'] = hdlbox

        self.__menubox.pack_start(hdlbox, gtk.TRUE, gtk.TRUE)
        ag = gtk.GtkAccelGroup()
        itemf = gtk.GtkItemFactory(gtk.GtkMenuBar.get_type(), "<main>", ag)
        self.add_accel_group(ag)
        v = []
        def func(data, item, self=self):
            item.set_data('uidata', self._m_cbdict[data][1])
            self._m_cbdict[data][0](item)
        idx = 0
        self._m_cbdict = {}
        for menu in uiinfo:
            v.append(("/"+menu[1], None, None, 0, "<Branch>"))
            for m in menu[3]:
                if m[0] == APP_UI_ITEM:
                    v.append(("/"+menu[1]+"/"+m[1], "<ctrl>a", func, idx, ""))
                    self._m_cbdict[idx] =  (m[3], m[4])
                    idx = idx + 1
                elif m[0] == APP_UI_ITEM_CONFIGURABLE:
                    label = {
                     uiconsts._APP_CONFIGURABLE_ITEM_PREFERENCES: _("Preferences"),
                     uiconsts._APP_CONFIGURABLE_ITEM_EXIT: _("Quit"),
                     uiconsts._APP_CONFIGURABLE_ITEM_ABOUT: _("About")}[m[7]]
                    v.append(("/"+menu[1]+"/"+label, None, func, idx, ""))
                    self._m_cbdict[idx] = (m[3], m[4])
                elif m[0] == APP_UI_SEPARATOR:
                    v.append(("/"+menu[1]+"/sep%i"%idx, None, func, 0, "<Separator>"))
                idx = idx + 1
        itemf.create_items(v)
        mb = itemf.get_widget("<main>")
        hdlbox.add(mb)
        mb.show()
    def add_toolbar(self, toolbar, name, behavior, placement, band_num,
                    band_position, offset):
        hdlbox = gtk.GtkHandleBox()
        hdlbox.show()
        self.__dockitems[name] = hdlbox
        self.__toolbarbox.pack_start(hdlbox)
        self.__toolbarbox.reorder_child(hdlbox, band_position)
        hdlbox.add(toolbar)
        toolbar.show()
    def get_dock_item_by_name(self, name):
        return self.__dockitems[name]

class GnomePropertyBox(gtk.GtkDialog):
    def __init__(self):
        gtk.GtkDialog.__init__(self)
        self.vbox.set_border_width(uiconsts.PAD)
        self.vbox.set_spacing(uiconsts.PAD)
        self.g_notebook = gtk.GtkNotebook()
        self.g_notebook.show()
        self.vbox.pack_start(self.g_notebook)
        self.g_ok = gu.bButton(self.action_area, _("Ok"), self._ok)
        self.g_ok.set_sensitive(gtk.FALSE)
        self.g_apply = gu.bButton(self.action_area, _("Apply"), self._apply)
        self.g_apply.set_sensitive(gtk.FALSE)
        self.g_cancel = gu.bButton(self.action_area, _("Close"), self.destroy)
        self.g_help = gu.bButton(self.action_area, _("Help"), self.on_help)
    def connect(self, event, cb):
        if event in ('apply', 'help'):
                pass
        else:
                gtk.GtkDialog.connect(self, event, cb)
    def append_page(self, page, label):
        self.g_notebook.append_page(page, label)
    def set_modified(self, m):
        self.g_ok.set_sensitive(gtk.TRUE)
        self.g_apply.set_sensitive(gtk.TRUE)
    def _ok(self, widget):
        self._apply(widget)
        self.destroy()
    def _apply(self, widget):
        for x in range(len(self.g_notebook.children())):
            self.on_apply(self.g_notebook.children()[x], x)
        self.on_apply(self.g_notebook, -1)
        self.g_apply.set_sensitive(gtk.FALSE)

class GnomeAppBar(gtk.GtkHBox):
    def __init__(self):
        gtk.GtkHBox.__init__(self)
        self.g_statusbar = gtk.GtkStatusbar()
        self.g_statusbar.show()
        self.pack_start(self.g_statusbar, gtk.TRUE, gtk.TRUE)
        self.g_progressbar = gtk.GtkProgressBar()
        self.g_progressbar.show()
        self.pack_start(self.g_progressbar)
    def set_progress(self, p):
        self.g_progressbar.set_percentage(p)
    def pop(self):
        self.g_statusbar.pop(1)
    def push(self, msg):
        self.g_statusbar.push(msg, 1)

class GnomeCanvas(gtk.GtkLabel):
    def __init__(self):
        gtk.GtkLabel.__init__(self, "Not on windows")
        self.show()
    def root(self): pass

def GnomeStock(name):
    return gtk.GtkPixmap(None, 'gnomeemu/xpm/%s.xpm' % name, None)

def GnomeStockButton(pixmapname):
    p = GnomeStock(pixmapname)
    p.show()
    b = gtk.GtkButton()
    b.add(p)
    return b

def GnomeAbout(name, version, copyright, authors, text):
    w = gtk.GtkDialog()
    w.vbox.set_border_width(uiconsts.PAD_SMALL)
    w.vbox.set_spacing(uiconsts.PAD_SMALL)

    frame = gtk.GtkFrame()
    w.vbox.pack_start(frame)
    mbox = gtk.GtkVBox()
    mbox.set_border_width(uiconsts.PAD_SMALL)
    mbox.set_spacing(uiconsts.PAD_SMALL)
    frame.add(mbox)
    
    label = gtk.GtkLabel(name + " " + version)
    label.set_name("AboutHeading")
    evbox = gtk.GtkEventBox()
    evbox.set_name('AboutHeadingBox')
    vbox = gtk.GtkHBox()
    evbox.add(vbox)
    vbox.set_border_width(uiconsts.PAD)
    vbox.pack_start(label)
    mbox.pack_start(evbox, gtk.FALSE)

    evbox = gtk.GtkEventBox()
    evbox.set_name("AboutBodyBox")
    bodybox = gtk.GtkVBox()
    bodybox.set_border_width(uiconsts.PAD)
    evbox.add(bodybox)
    mbox.pack_start(evbox)

    label = gtk.GtkLabel(copyright)
    label.set_name("Heading2")
    label.set_alignment(0.0, 0.0)
    bodybox.pack_start(label)

    ahbox = gtk.GtkHBox()
    bodybox.pack_start(ahbox)
    
    label = gtk.GtkLabel(_("Authors:"))
    label.set_alignment(0.0, 0.0)
    label.set_name("Heading3")
    ahbox.pack_start(label, gtk.FALSE)

    avbox = gtk.GtkVBox()
    ahbox.pack_start(avbox)

    for author in authors:
        label = gtk.GtkLabel(author)
        label.set_alignment(0.0, 0.0)
        avbox.pack_start(label)

    label = gtk.GtkLabel(text)
    label.set_alignment(0.0, 1.0)
    label.set_justify(gtk.JUSTIFY_LEFT)
    bodybox.pack_start(label)
    b = gtk.GtkButton(_("Close"))
    b.connect('clicked', w.destroy)
    w.action_area.pack_start(b)
    w.show_all()
    return w

class GnomeErrorDialog(gtk.GtkDialog):
    def __init__(self, msg, parent=None):
        gtk.GtkDialog.__init__(self, parent)
        self.vbox.set_border_width(uiconsts.PAD)
        label = gtk.GtkLabel(msg)
        self.vbox.pack_start(label)
        b = gtk.GtkButton(_("Close"))
        self.action_area.pack_start(b)
        b.connect('clicked', self.close)
        self.set_modal(gtk.TRUE)
        self.show_all()
    def close(self, *v):
        self.destroy()
