/******************************** -*- C -*- ****************************
 *
 *	Simple string support
 *
 *
 ***********************************************************************/


/***********************************************************************
 *
 * Copyright 1988,89,90,91,92,94,95,99,2000,2001,2002,2006
 * Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * Linking GNU Smalltalk statically or dynamically with other modules is
 * making a combined work based on GNU Smalltalk.  Thus, the terms and
 * conditions of the GNU General Public License cover the whole
 * combination.
 *
 * In addition, as a special exception, the Free Software Foundation
 * give you permission to combine GNU Smalltalk with free software
 * programs or libraries that are released under the GNU LGPL and with
 * independent programs running under the GNU Smalltalk virtual machine.
 *
 * You may copy and distribute such a system following the terms of the
 * GNU GPL for GNU Smalltalk and the licenses of the other code
 * concerned, provided that you include the source code of that other
 * code when and as the GNU GPL requires distribution of source code.
 *
 * Note that people who make modified versions of GNU Smalltalk are not
 * obligated to grant this special exception for their modified
 * versions; it is their choice whether to do so.  The GNU General
 * Public License gives permission to release a modified version without
 * this exception; this exception also makes it possible to release a
 * modified version which carries forward this exception.
 *
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.  
 *
 ***********************************************************************/


#ifndef GST_STR_H
#define GST_STR_H

/* Returns the currently accumulated string, as a C string, and resets
   the pointer to start with a new string.  The string returned is
   unique.  */
extern char *_gst_cur_str_buf (void)
  ATTRIBUTE_HIDDEN;

/* Returns the currently accumulated string, as a C string, and resets
   the pointer to start with a new string.  The string returned is
   unique and is allocated in the obstack H.  */
extern char *_gst_obstack_cur_str_buf (struct obstack *h)
  ATTRIBUTE_HIDDEN;

/* Returns the currently accumulated buffer, and resets the pointer
   to start with a new string.  Instead of allocating fresh memory for
   the data, it is moved to the location pointed by WHERE. WHERE is
   returned */
extern PTR _gst_copy_buffer (PTR where)
  ATTRIBUTE_HIDDEN;

/* Answer the current size of the buffer.  */
extern size_t _gst_buffer_size (void)
  ATTRIBUTE_HIDDEN;

/* Adds a character C to the string being accumulated.  The character
   can be any valid ASCII character.  */
extern void _gst_add_str_buf_char (char c)
  ATTRIBUTE_HIDDEN;

/* Resets the pointer to start with a new string.  */
extern void _gst_reset_buffer (void)
  ATTRIBUTE_HIDDEN;

/* Adds a pointer PTR to the buffer being built.  */
extern void _gst_add_buf_pointer (PTR ptr)
  ATTRIBUTE_HIDDEN;

/* Adds N bytes of data starting from PTR to the string being
   accumulated.  */
extern void _gst_add_buf_data (PTR ptr,
			       int n)
  ATTRIBUTE_HIDDEN;

#endif /* GST_STR_H */
