## Copyright (C) 2013-2016 Vytautas Jančauskas
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or (at
## your option) any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, see
## <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {} {} isplaying (@var{player})
## Return true if the audioplayer object @var{player} is currently playing back
## audio and false otherwise.
## @end deftypefn

function result = isplaying (player)

  if (nargin != 1)
    print_usage ();
  endif

  result = __player_isplaying__ (struct (player).player);

endfunction
