/**e/
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

importScripts('./jsdefs.js', './jslex.js', './jsparse.js');

var lexer = Narcissus.lexer;
var definitions = Narcissus.definitions;
const StringMap = definitions.StringMap;
const Stack = definitions.Stack;

// Set constants in the local scope.
eval(definitions.consts);

// Banned statement types by language version.
const blackLists = { 160: {}, 185: {}, harmony: {} };
blackLists[160][IMPORT] = true;
blackLists[160][EXPORT] = true;
blackLists[160][LET] = true;
blackLists[160][MODULE] = true;
blackLists[160][YIELD] = true;
blackLists[185][IMPORT] = true;
blackLists[185][EXPORT] = true;
blackLists[185][MODULE] = true;
blackLists.harmony[WITH] = true;


self.onmessage = function (event) {
    //console.log('script text passed is', event.data);
    // nontrivial global.

    if (event.data === 'stop') {
	self.close();
	return;
    }
    
    var obj = JSON.parse(event.data);
    try {

	var tree = new Narcissus.parser.parse(obj.code);
	self.postMessage({'tree': tree, 'hash': obj.hash});

    } catch (x) {
	// error with parsing.
	self.postMessage({'hash': obj.hash});

    }
    
};

