### $Id: libcdio-suse.spec.in,v 1.1 2005/01/25 02:13:47 rocky Exp $
### autogenerated---edit *.spec.in

%define ver     0.72
%define rel     1

Name:         %{name}
Version:      %{ver}
Release:      %{rel}
%define libcddb_version 0.9.6
URL:          http://www.gnu.org/software/libcdio/
Group:        Productivity/Multimedia/Other
License:      GPL
Summary:      CD-ROM access library
Source:       %{name}-%{version}.tar.bz2
Source1:      libcddb-%{libcddb_version}.tar.bz2
NoSource:     1
Autoreqprov:  on
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
This library is to encapsulate CD-ROM reading and control. Applications
wishing to be oblivious of the OS- and device-dependent properties of a
CD-ROM can use this library.



Authors:
--------
    Herbert Valerio Riedel <hvr@gnu.org>
    Rocky Bernstein <rocky@panix.com>

%description -l de
Diese Bibliothek dient zur Kapselung von CD-ROM Zugriffen und
dessen Kontrolle. Anwendungen brauchen sich nicht um die
Betriebssystemspezifischen oder Device-Abh¤ngigen Eigenschaften
des CD-ROM zu k¼mmern, dies erledigt die Bibliothek.

%package devel
Group:        Productivity/Multimedia/Other
Summary:      CD-ROM access library
Requires:     libcdio = %{version}

%description devel
This library is to encapsulate CD-ROM reading and control. Applications
wishing to be oblivious of the OS- and device-dependent properties of a
CD-ROM can use this library.



Authors:
--------
    Herbert Valerio Riedel <hvr@gnu.org>
    Rocky Bernstein <rocky@panix.com>

%description -l de devel
Diese Bibliothek dient zur Kapselung von CD-ROM Zugriffen und
dessen Kontrolle. Anwendungen brauchen sich nicht um die
Betriebssystemspezifischen oder Device-Abh¤ngigen Eigenschaften
des CD-ROM zu k¼mmern, dies erledigt die Bibliothek.

%prep
%setup -a1

%build
# libvcdinfo depends on libcdio, which is not yet built.
# We must build featureless libcdio first, then install and build fully featured package.
LIBCDIO_INSTALL=$PWD/libcdio-install
LIBCDDB_INSTALL=$PWD/libcddb-install
export CFLAGS="$RPM_OPT_FLAGS"
%{?suse_update_config:%{suse_update_config  -f -l}}
./configure\
	--prefix=/usr\
	--libdir=%{_libdir}\
	--infodir=%{_infodir}\
	--mandir=%{_mandir}
make
make DESTDIR="$LIBCDIO_INSTALL" install
# We need to adjust path to libiso9660.la.
# To make this trick, we need to disable norootforbuild.
cp -a /usr/%_lib/libvcdinfo.* $LIBCDIO_INSTALL%{_libdir}
mv /usr/%_lib/libvcdinfo.la /usr/%_lib/libvcdinfo.la.hidden
for lib in $LIBCDIO_INSTALL%{_libdir}/*.la ; do
    sed -i "s@%{_libdir}@$LIBCDIO_INSTALL%{_libdir}@g" $lib
done
export C_INCLUDE_PATH="$LIBCDIO_INSTALL/usr/include"
export LIBRARY_PATH="$LIBCDIO_INSTALL%{_libdir}"
export PKG_CONFIG_PATH="$LIBCDIO_INSTALL%{_libdir}/pkgconfig"
# Now build libcddb, which has circular dependency on libcdio.
cd libcddb-%{libcddb_version}
%{?suse_update_config:%{suse_update_config  -f -l}}
./configure\
	--prefix=/usr\
	--libdir=%{_libdir}\
	--infodir=%{_infodir}\
	--mandir=%{_mandir}
make
make DESTDIR="$LIBCDDB_INSTALL" install
export C_INCLUDE_PATH="$LIBCDIO_INSTALL/usr/include:$LIBCDDB_INSTALL/usr/include"
export LIBRARY_PATH="$LIBCDIO_INSTALL%{_libdir}:$LIBCDDB_INSTALL%{_libdir}"
export PKG_CONFIG_PATH="$LIBCDIO_INSTALL%{_libdir}/pkgconfig:$LIBCDDB_INSTALL%{_libdir}/pkgconfig"
# Now build final version of libcdio.
cd ..
./configure\
	--prefix=/usr\
	--libdir=/usr/%{_lib}\
	--infodir=/usr/share/info\
	--mandir=/usr/share/man
make
mv /usr/%_lib/libvcdinfo.la.hidden /usr/%_lib/libvcdinfo.la

%install
LIBCDIO_INSTALL=$PWD/libcdio-install
LIBCDDB_INSTALL=$PWD/libcddb-install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
for lib in $RPM_BUILD_ROOT%{_libdir}/*.la ; do
  sed -i "s@$LIBCDIO_INSTALL@@g;s@$LIBCDDB_INSTALL@@g" $lib
done

%clean
rm -rf $RPM_BUILD_ROOT

%post
%run_ldconfig
%install_info --info-dir=%{_infodir} %{_infodir}/%name.info.gz

%postun
%install_info_delete --info-dir=%{_infodir} %{_infodir}/%name.info.gz

%files
%defattr (-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README README.libcdio THANKS TODO
/usr/%{_lib}/*.so
/usr/%{_lib}/*.so.*
/usr/bin/*
%doc /usr/share/info/*.info*

%files devel
%defattr (-, root, root)
/usr/%{_lib}/*.*a
/usr/%{_lib}/pkgconfig/*.pc
/usr/include/*

%changelog -n libcdio
* Mon Jan 24 2005 - sbrabec@suse.cz
- Updated to version 0.71.
* Tue Nov 09 2004 - sbrabec@suse.cz
- New SuSE package, version 0.70.
- Work-around of circular dependency on libcddb and vcdimager.
