/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.CompileReflect;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotSet;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;

public class CompileBuildObject {
    ApplyExp exp;
    InlineCalls visitor;
    Type required;
    int keywordStart;
    ObjectType ctype;
    ClassType caller;
    boolean defaultConstructorSet;
    PrimProcedure defaultConstructor;

    public Compilation getCompilation() {
        return this.visitor.getCompilation();
    }

    public Language getLanguage() {
        return this.getCompilation().getLanguage();
    }

    public ObjectType getResultType() {
        return this.ctype;
    }

    public boolean resultTypeExtends(ObjectType other) {
        return this.ctype.isSubtype(other);
    }

    public boolean resultTypeExtends(Class other) {
        return this.ctype.isSubtype(ClassType.make(other));
    }

    public Expression getArg(int i) {
        return this.exp.getArg(i);
    }

    public int getArgCount() {
        return this.exp.getArgCount();
    }

    public void setArg(int i, Expression arg) {
        this.exp.setArg(i, arg);
    }

    public void insertArgument(int index, Expression arg) {
        Expression[] args = this.exp.getArgs();
        Expression[] xargs = new Expression[args.length + 1];
        System.arraycopy(args, 0, xargs, 0, index);
        xargs[index] = arg;
        System.arraycopy(args, index, xargs, index + 1, args.length - index);
        this.exp.setArgs(xargs);
        if (this.keywordStart >= index) {
            ++this.keywordStart;
        }
    }

    public static CompileBuildObject make(ApplyExp exp, InlineCalls visitor, Type required, int keywordStart, ObjectType ctype, ClassType caller) {
        CompileBuildObject builder;
        String builderName = null;
        Compilation comp = visitor.getCompilation();
        Namespace ns = Namespace.valueOfNoCreate("gnu.kawa.reflect/ObjectBuilder");
        if (ns != null) {
            ObjectType btype = ctype;
            do {
                Object val;
                Symbol sym;
                if ((sym = ns.lookup(btype.getName())) == null) continue;
                ModuleExp mexp = comp.getModule();
                Declaration builderDecl = comp.lookup(sym, 1);
                if (builderDecl == null || !((val = builderDecl.getValue().valueIfConstant()) instanceof String)) continue;
                builderName = (String)val;
            } while (btype instanceof ClassType && (btype = ((ClassType)btype).getSuperclass()) != null && btype != Type.objectType);
        }
        if (builderName != null) {
            try {
                builder = (CompileBuildObject)Class.forName(builderName).newInstance();
            }
            catch (Exception ex) {
                comp.error('w', "while creating JavafxObjectBuilder for " + ctype + " - caught " + ex);
                builder = new CompileBuildObject();
            }
        } else {
            builder = new CompileBuildObject();
        }
        builder.exp = exp;
        builder.visitor = visitor;
        builder.required = required;
        builder.keywordStart = keywordStart;
        builder.ctype = ctype;
        builder.caller = caller;
        return builder;
    }

    public void setDefaultConstructor(PrimProcedure proc) {
        this.defaultConstructor = proc;
        this.defaultConstructorSet = true;
    }

    public PrimProcedure getDefaultConstructor() {
        if (!this.defaultConstructorSet) {
            Method meth;
            Type rtype = this.ctype.getRealType();
            if (rtype instanceof ClassType && (meth = ((ClassType)rtype).getDefaultConstructor()) != null) {
                this.defaultConstructor = new PrimProcedure(meth, this.getLanguage());
            }
            this.defaultConstructorSet = true;
        }
        return this.defaultConstructor;
    }

    public boolean hasDefaultConstructor() {
        return this.getDefaultConstructor() != null;
    }

    public boolean hasAddChildMethod() {
        return ClassMethods.selectApplicable(ClassMethods.getMethods(this.ctype, "add", 'V', null, this.getLanguage()), 2, false) > 0;
    }

    public Member findNamedMember(String name) {
        Member member = SlotSet.lookupMember(this.ctype, name, this.caller);
        if (member == null) {
            member = this.ctype.getMethod(ClassExp.slotToMethodName("add", name), SlotSet.type1Array);
        }
        return member;
    }

    public Expression buildSetter(Declaration target, Member member, Expression value) {
        return CompileReflect.makeSetterCall(new ReferenceExp(target), member, value);
    }

    public String getAddChildMethodName() {
        return "add";
    }

    public Expression buildAddChild(Declaration target, Expression child) {
        Expression[] iargs = new Expression[]{new ReferenceExp(target), QuoteExp.getInstance(this.getAddChildMethodName()), child};
        return new ApplyExp(Invoke.invoke, iargs);
    }

    public boolean useBuilder(int numCode, InlineCalls visitor) {
        if (this.getArgCount() > this.keywordStart && numCode > 0) {
            return true;
        }
        if (numCode == -917504 && this.hasDefaultConstructor() && this.hasAddChildMethod()) {
            this.keywordStart = 1;
            return true;
        }
        return false;
    }

    public Expression build() {
        Object value;
        Expression e;
        Compilation comp = this.getCompilation();
        Expression[] args = this.exp.getArgs();
        Object errbuf = null;
        if (this.keywordStart < args.length) {
            Expression[] xargs = new Expression[this.keywordStart];
            System.arraycopy(args, 0, xargs, 0, this.keywordStart);
            e = this.visitor.visit((Expression)new ApplyExp(this.exp.getFunction(), xargs), this.ctype);
        } else {
            ApplyExp ae = new ApplyExp(this.defaultConstructor, args[0]);
            ae.setType(this.ctype);
            e = ae;
        }
        comp.letStart();
        Declaration adecl = comp.letVariable(null, this.ctype, e);
        adecl.setFlag(0x2000000000L);
        adecl.setCanRead(true);
        BeginExp begin2 = new BeginExp();
        int i = this.keywordStart;
        while (i + 1 < args.length && (value = args[i].valueIfConstant()) instanceof Keyword) {
            String name = ((Keyword)value).getName();
            Member slot = this.findNamedMember(name);
            if (slot == null) {
                comp.error('w', "no field or setter '" + name + "' in class " + this.ctype.getName());
            } else {
                begin2.add(this.visitor.visit(this.buildSetter(adecl, slot, args[i + 1]), Type.voidType));
            }
            i += 2;
        }
        while (i < args.length) {
            begin2.add(this.visitor.visit(this.buildAddChild(adecl, args[i]), null));
            ++i;
        }
        ReferenceExp aref = new ReferenceExp(adecl);
        aref.setFlag(32);
        begin2.add(aref);
        return this.visitor.checkType(comp.letDone(begin2).setLine(this.exp), this.required);
    }
}

