/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.Literal;
import gnu.expr.QuoteExp;

public class BindingInitializer
extends Initializer {
    Declaration decl;
    Expression value;
    static final Method makeSymbolMethod = Compilation.typeSymbol.getDeclaredMethod("make", Compilation.string1Arg);
    boolean createNewSymbol = false;

    public BindingInitializer(Declaration declaration, Field field, Expression expression) {
        this.decl = declaration;
        this.value = expression;
        this.field = field;
    }

    public void emit(Compilation compilation) {
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        if (this.value instanceof QuoteExp && (object2 = ((QuoteExp)this.value).getValue()) != null && !(object2 instanceof String)) {
            Literal literal = compilation.litTable.findLiteral(object2);
            if (literal.field == this.field) {
                return;
            }
        }
        if (!this.field.getStaticFlag()) {
            codeAttr.emitPushThis();
        }
        if (this.value == null) {
            if (!this.createNewSymbol) {
                codeAttr.emitInvokeStatic(Compilation.getCurrentEnvironmentMethod);
            }
            if ((object2 = this.decl.getName()) == null) {
                codeAttr.emitPushNull();
            } else {
                codeAttr.emitPushString((String)object2);
            }
            if (this.createNewSymbol) {
                codeAttr.emitInvokeStatic(makeSymbolMethod);
            } else {
                codeAttr.emitInvokeVirtual(Compilation.getSymbolEnvironmentMethod);
            }
        } else {
            this.value.compile(compilation, this.field.getType());
        }
        if (this.field.getStaticFlag()) {
            codeAttr.emitPutStatic(this.field);
        } else {
            codeAttr.emitPutField(this.field);
        }
    }
}

