/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.ExpressionImage;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OP_binary;
import gnu.jel.OP_call;
import gnu.jel.OP_conditional;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_load_array;
import gnu.jel.OP_logical_not;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OP_unary;
import gnu.jel.OPlist;
import gnu.jel.debug.Tester;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Stack;

public class Optimizer {
    static Class string_class = null;
    private Library lib;
    private Stack types = new Stack();
    protected OPlist code = new OPlist();
    private Stack functions = new Stack();
    private Stack functionsDescriptors = new Stack();
    private boolean finished = false;

    public Optimizer(Library library) {
        this.lib = library;
    }

    public void load(boolean bl) {
        this.load(Boolean.TYPE, new Boolean(bl));
    }

    public void load(byte by) {
        this.load(Byte.TYPE, new Byte(by));
    }

    public void load(char c) {
        this.load(Character.TYPE, new Character(c));
    }

    public void load(short s) {
        this.load(Short.TYPE, new Short(s));
    }

    public void load(int n) {
        this.load(Integer.TYPE, new Integer(n));
    }

    public void load(long l) {
        this.load(Long.TYPE, new Long(l));
    }

    public void load(float f) {
        this.load(Float.TYPE, new Float(f));
    }

    public void load(double d) {
        this.load(Double.TYPE, new Double(d));
    }

    public void load(String string) {
        this.load(string_class, string);
    }

    private void load(Class clazz, Object object) {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_load oP_load = new OP_load(clazz, object);
        this.types.push(clazz);
        this.code.addLast(oP_load);
    }

    public void load_array_param() {
        Class clazz = (Class)this.types.peek();
        if (clazz.getComponentType() == null) {
            throw new IllegalStateException("The class " + clazz.toString() + " is not an array.");
        }
    }

    public void load_array() {
        this.convert(Integer.TYPE, true);
        Class cfr_ignored_0 = (Class)this.types.pop();
        Class clazz = (Class)this.types.pop();
        Class<?> clazz2 = clazz.getComponentType();
        this.types.push(clazz2);
        OP_load_array oP_load_array = new OP_load_array();
        this.code.addLast(oP_load_array);
    }

    public void convert(Class clazz, boolean bl) throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        Class clazz2 = (Class)this.types.peek();
        if (!ExpressionImage.canConvert(clazz2, clazz)) {
            throw new IllegalStateException("Can not convert " + clazz2.toString() + " to " + clazz.toString() + ".");
        }
        if (bl && !ExpressionImage.canConvertByWidening(clazz2, clazz)) {
            throw new IllegalStateException("You must specify narrowing conversion from " + clazz2.toString() + " to " + clazz.toString() + " explicitly");
        }
        if (clazz2 != clazz) {
            OP oP = this.code.getLast();
            if (oP instanceof OP_convert) {
                ((OP_convert)oP).setType(clazz);
            } else {
                this.code.addLast(new OP_convert(clazz));
            }
        }
        this.types.pop();
        this.types.push(clazz);
    }

    public void convert(Class clazz) throws IllegalStateException {
        this.convert(clazz, false);
    }

    public void unary(int n) {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        Class clazz = (Class)this.types.peek();
        if (!ExpressionImage.canGenerateUnary(n, clazz)) {
            throw new IllegalStateException("Unary " + ExpressionImage.unaryNames[n] + " is not supported on " + clazz.getName() + "'s");
        }
        this.code.addLast(new OP_unary(n));
    }

    public void logical_not_start() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_logical_not oP_logical_not = new OP_logical_not();
        this.functions.push(oP_logical_not);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_start(oP_logical_not));
    }

    public void logical_not() throws IllegalStateException {
        if (this.types.peek() != Boolean.TYPE) {
            throw new IllegalStateException("You tried to use logical complement on " + ((Class)this.types.peek()).getName() + ". This operation is supported only" + " on booleans.");
        }
        OP_logical_not oP_logical_not = (OP_logical_not)this.functions.pop();
        int[] cfr_ignored_0 = (int[])this.functionsDescriptors.pop();
        this.code.addLast(oP_logical_not);
    }

    public void function_start() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_call oP_call = new OP_call();
        this.functions.push(oP_call);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_start(oP_call));
    }

    public void binaryOP_param() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_binary oP_binary = new OP_binary();
        this.functions.push(oP_binary);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_param(oP_binary, (Class)this.types.peek()));
    }

    public boolean function_param() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_function oP_function = (OP_function)this.functions.peek();
        int[] nArray = (int[])this.functionsDescriptors.peek();
        nArray[0] = nArray[0] + 1;
        this.code.addLast(new OP_param(oP_function, (Class)this.types.peek()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void function_call(String var1_1) throws IllegalStateException {
        block7: {
            if (this.finished) {
                throw new IllegalStateException("Attempt to modify finished function.");
            }
            var2_2 = (OP_call)this.functions.peek();
            var3_3 = (int[])this.functionsDescriptors.peek();
            var4_4 = var3_3[0];
            var5_5 = new Class[var4_4];
            var6_6 = var4_4 - 1;
            while (var6_6 >= 0) {
                var5_5[var6_6] = (Class)this.types.pop();
                --var6_6;
            }
            try {
                var7_7 = this.lib.getMethod(var1_1, var5_5);
                break block7;
            }
            catch (NoSuchMethodException var8_8) {
                var9_10 = 0;
                ** while (var9_10 < var4_4)
            }
lbl-1000:
            // 1 sources

            {
                this.types.push(var5_5[var9_10]);
                ++var9_10;
                continue;
            }
lbl22:
            // 1 sources

            throw new IllegalStateException(var8_8.getMessage());
        }
        var8_9 = var2_2;
        this.code.addLast(var8_9);
        if (var7_7 instanceof Method) {
            var8_9.setMethod(this.code, (Method)var7_7, this.lib.getDynamicMethodClassID(var7_7), this.lib.isStateless(var7_7));
            this.types.push(((Method)var7_7).getReturnType());
        } else {
            var8_9.setField(this.code, (Field)var7_7, this.lib.getDynamicMethodClassID(var7_7), this.lib.isStateless(var7_7));
            this.types.push(((Field)var7_7).getType());
        }
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void binaryOP(int n, boolean bl) throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_binary oP_binary = (OP_binary)this.functions.peek();
        int[] cfr_ignored_0 = (int[])this.functionsDescriptors.peek();
        OP_param oP_param = new OP_param(oP_binary, (Class)this.types.peek());
        oP_param.setbinaryparam = false;
        this.code.addLast(oP_param);
        Class clazz = (Class)this.types.pop();
        Class clazz2 = (Class)this.types.pop();
        String string = null;
        boolean bl2 = false;
        if (!bl) {
            if (!ExpressionImage.canGenerateBinary(n, clazz2, clazz)) {
                bl2 = true;
                string = "Types " + clazz2.toString() + " and " + clazz.toString() + " are not suitable " + "for the operation \"" + ExpressionImage.binaryNames[n] + "\"";
            }
        } else if (clazz2 != Boolean.TYPE || clazz != Boolean.TYPE) {
            bl2 = true;
            string = "Types " + clazz2.toString() + " and " + clazz.toString() + " are not suitable for \"" + ExpressionImage.logicalNames[n] + "\" operation. Both operands must be boolean.";
        }
        if (bl2) {
            this.types.push(clazz2);
            this.types.push(clazz);
            throw new IllegalStateException(string);
        }
        Class clazz3 = Boolean.TYPE;
        Class clazz4 = Boolean.TYPE;
        if (!bl) {
            clazz3 = ExpressionImage.isPromotionBinary(n) ? (n == 0 && clazz2 == string_class ? string_class : ExpressionImage.getBinaryPromoted(clazz2, clazz)) : (clazz4 = ExpressionImage.getUnaryPromoted(clazz2));
            clazz4 = clazz3;
            if (n >= 8 && n <= 13) {
                clazz4 = Boolean.TYPE;
            }
        }
        OP_binary oP_binary2 = oP_binary;
        this.code.addLast(oP_binary2);
        oP_binary2.setOperation(this.code, n, bl, clazz3);
        this.types.push(clazz4);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void conditional_true() throws IllegalStateException {
        if (this.types.pop() != Boolean.TYPE) {
            throw new IllegalStateException("The first operand of conditional must be of boolean type.");
        }
        OP_conditional oP_conditional = new OP_conditional();
        this.functions.push(oP_conditional);
        int[] nArray = new int[1];
        this.functionsDescriptors.push(nArray);
        this.code.addLast(new OP_start(oP_conditional));
    }

    public void conditional_false() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_conditional oP_conditional = (OP_conditional)this.functions.peek();
        int[] nArray = (int[])this.functionsDescriptors.peek();
        nArray[0] = nArray[0] + 1;
        OP oP = this.code.getLast();
        while (!(oP instanceof OP_start) || ((OP_start)oP).getFunction() != oP_conditional) {
            oP = oP.prev;
        }
        oP_conditional.setTrueList(this.code.cut_end(oP.next));
    }

    public void conditional_end() throws IllegalStateException {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        OP_conditional oP_conditional = (OP_conditional)this.functions.peek();
        int[] nArray = (int[])this.functionsDescriptors.peek();
        nArray[0] = nArray[0] + 1;
        OP oP = this.code.getLast();
        while (!(oP instanceof OP_start) || ((OP_start)oP).getFunction() != oP_conditional) {
            oP = oP.prev;
        }
        oP_conditional.setFalseList(this.code.cut_end(oP.next));
        this.code.remove(oP);
        Class clazz = (Class)this.types.pop();
        Class clazz2 = (Class)this.types.pop();
        Class clazz3 = null;
        if (clazz2.isPrimitive() && clazz.isPrimitive()) {
            clazz3 = ExpressionImage.getBinaryPromoted(clazz2, clazz);
        } else if (clazz2 == clazz) {
            clazz3 = clazz2;
        } else if (ExpressionImage.canConvertByWidening(clazz2, clazz)) {
            clazz3 = clazz;
        } else if (ExpressionImage.canConvertByWidening(clazz, clazz2)) {
            clazz3 = clazz2;
        }
        if (clazz3 == null) {
            throw new IllegalStateException("Operands of conditional have types " + clazz2.getName() + " and " + clazz.getName() + " . These types are not compatible.");
        }
        oP_conditional.setType(clazz3);
        this.types.push(clazz3);
        this.code.addLast(oP_conditional);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void finish() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
        this.finished = true;
    }

    /*
     * Unable to fully structure code
     */
    public void optimize(int var1_1) {
        if (this.finished) ** GOTO lbl4
        throw new IllegalStateException("Attempt to instantiate unfinished function.");
lbl-1000:
        // 1 sources

        {
            --var1_1;
lbl4:
            // 2 sources

            ** while (var1_1 > 0 && (var2_2 = this.code).optimize())
        }
lbl5:
        // 1 sources

    }

    protected static boolean optimizeIteration(OPlist oPlist) {
        return oPlist.optimize();
    }

    public CompiledExpression compile() {
        return this.compileBits().getExpression();
    }

    public ExpressionBits compileBits() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
        ExpressionImage expressionImage = new ExpressionImage();
        this.code.compile(expressionImage);
        expressionImage.asm_return();
        return expressionImage.getBits();
    }

    public String toString() {
        return this.code.toString();
    }

    private void seeFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
    }

    private void seeNonFinished() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
    }

    public static void main(String[] stringArray) {
    }

    public static void test(Tester tester) {
    }

    static {
        try {
            string_class = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

