/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OPlist;
import gnu.jel.debug.Debug;

class OP_binary
extends OP_function {
    int opc = 999;

    OP_binary() {
    }

    void setOperation(OPlist list, int opc, Class type) {
        this.opc = opc;
        int cpar = 2;
        OP cop = this.prev;
        while (cop != null && cpar >= 0) {
            OP_param copp;
            if (cop instanceof OP_param && (copp = (OP_param)cop).getFunction() == this) {
                copp.setConvert(list, type);
            }
            cop = cop.prev;
        }
    }

    boolean canInterpret() {
        return this.operandsReady(2, false);
    }

    void interpret(OPlist list) throws Throwable {
        OP_load c2 = (OP_load)this.prev.prev;
        OP_load c1 = (OP_load)this.prev.prev.prev.prev;
        Debug.assert(c1.type != null && c1.type == c2.type && c2.type.isPrimitive(), "Wrong types for binary OP");
        int id = ExpressionImage.primitiveID(c1.type);
        Number n1 = OP_function.widen(c1.what, id);
        Number n2 = OP_function.widen(c2.what, id);
        if (OP_function.isFloat(id)) {
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            switch (this.opc) {
                case 0: {
                    d1 += d2;
                    break;
                }
                case 1: {
                    d1 -= d2;
                    break;
                }
                case 2: {
                    d1 *= d2;
                    break;
                }
                case 3: {
                    d1 /= d2;
                    break;
                }
                case 4: {
                    d1 %= d2;
                    break;
                }
                default: {
                    Debug.println("Wrong operation on float (" + this.opc + ").");
                }
            }
            n1 = new Double(d1);
        } else {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            switch (this.opc) {
                case 0: {
                    l1 += l2;
                    break;
                }
                case 1: {
                    l1 -= l2;
                    break;
                }
                case 2: {
                    l1 *= l2;
                    break;
                }
                case 3: {
                    l1 /= l2;
                    break;
                }
                case 4: {
                    l1 %= l2;
                    break;
                }
                case 5: {
                    l1 &= l2;
                    break;
                }
                case 6: {
                    l1 |= l2;
                    break;
                }
                case 7: {
                    l1 ^= l2;
                    break;
                }
                default: {
                    Debug.println("Wrong operation on integer (" + this.opc + ").");
                }
            }
            n1 = new Long(l1);
        }
        c1.what = OP_function.narrow(n1, id);
        this.consume(list, c1, 2, false);
    }

    void compile(ExpressionImage ei) {
        ei.asm_binary(this.opc);
    }

    public String toString() {
        char ch = '?';
        switch (this.opc) {
            case 0: {
                ch = '+';
                break;
            }
            case 1: {
                ch = '-';
                break;
            }
            case 2: {
                ch = '*';
                break;
            }
            case 3: {
                ch = '/';
                break;
            }
            case 4: {
                ch = '%';
                break;
            }
            case 5: {
                ch = '&';
                break;
            }
            case 6: {
                ch = '|';
                break;
            }
            case 7: {
                ch = '^';
                break;
            }
            default: {
                Debug.println("Wrong operation on integer (" + this.opc + ").");
            }
        }
        return String.valueOf(ch);
    }
}

