/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io.parser.gen;

import gnu.prolog.io.Operator;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.parser.NameToken;
import gnu.prolog.io.parser.ReaderCharStream;
import gnu.prolog.io.parser.TermParserUtils;
import gnu.prolog.io.parser.gen.CharStream;
import gnu.prolog.io.parser.gen.JJTermParserCalls;
import gnu.prolog.io.parser.gen.ParseException;
import gnu.prolog.io.parser.gen.TermParserConstants;
import gnu.prolog.io.parser.gen.TermParserTokenManager;
import gnu.prolog.io.parser.gen.Token;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.DoubleQuotesTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.TermConstants;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public final class TermParser
implements TermParserConstants {
    CharStream stream;
    protected Environment environment;
    public TermParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[2];
    private final int[] jj_la1_0 = new int[]{1, 64};
    private final int[] jj_la1_1 = new int[]{0x2000000, 0};
    private final int[] jj_la1_2 = new int[]{0, 0};
    private final JJTermParserCalls[] jj_2_rtns = new JJTermParserCalls[14];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public int getCurrentLine() {
        return this.stream.getEndLine();
    }

    public int getCurrentColumn() {
        return this.stream.getEndColumn();
    }

    public boolean isFunctor() {
        return this.getToken((int)1).kind == 6 && this.getToken((int)2).kind == 49 && this.getToken((int)2).specialToken == null;
    }

    boolean testOp(ReadOptions options, int i) {
        Token tk = this.getToken(i);
        return tk instanceof NameToken && ((NameToken)tk).isOperator(options.operatorSet);
    }

    boolean testNoOp(ReadOptions options) {
        Token tk = this.getToken(1);
        return tk instanceof NameToken && ((NameToken)tk).isNonOperator(options.operatorSet);
    }

    boolean testFX(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return !this.isFunctor() && tk instanceof NameToken && ((NameToken)tk).isFxOperator(options.operatorSet, priority);
    }

    boolean testFY(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return !this.isFunctor() && tk instanceof NameToken && ((NameToken)tk).isFyOperator(options.operatorSet, priority);
    }

    boolean testXFX(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return tk instanceof NameToken && ((NameToken)tk).isXfxOperator(options.operatorSet, priority);
    }

    boolean testXFY(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return priority >= options.operatorSet.getCommaLevel() && tk.kind == 56 || tk instanceof NameToken && ((NameToken)tk).isXfyOperator(options.operatorSet, priority);
    }

    boolean testYFX(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return tk instanceof NameToken && ((NameToken)tk).isYfxOperator(options.operatorSet, priority);
    }

    boolean testXF(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return tk instanceof NameToken && ((NameToken)tk).isXfOperator(options.operatorSet, priority);
    }

    boolean testYF(ReadOptions options, int priority) {
        Token tk = this.getToken(1);
        return tk instanceof NameToken && ((NameToken)tk).isYfOperator(options.operatorSet, priority);
    }

    boolean isExpSeparator(int i) {
        Token tk = this.getToken(i);
        switch (tk.kind) {
            case 0: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    boolean is1201Separator(int i) {
        Token tk = this.getToken(i);
        switch (tk.kind) {
            case 0: 
            case 50: 
            case 54: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    Term createTerm(CompoundTermTag op, Term t) {
        if (op.arity != 1) {
            throw new IllegalArgumentException("Arity of term tag must be 1");
        }
        return new CompoundTerm(op, new Term[]{t});
    }

    Term createTerm(CompoundTermTag op, Term t1, Term t2) {
        if (op.arity != 2) {
            throw new IllegalArgumentException("Arity of term tag must be 2");
        }
        return new CompoundTerm(op, new Term[]{t1, t2});
    }

    public TermParser(Reader r, int line, int col, Environment environment) {
        this(new ReaderCharStream(r, line, col), environment);
    }

    public TermParser(ReaderCharStream str, Environment env) {
        this(str);
        this.stream = str;
        this.environment = env;
        if (env == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
    }

    public final Term readTerm(ReadOptions options) throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    return null;
                }
                case 57: {
                    this.jj_consume_token(57);
                    return null;
                }
            }
            this.jj_la1[0] = this.jj_gen;
            Term t = this.term(options, options.operatorSet.getMaxLevel());
            this.end();
            return t;
        }
        catch (ParseException ex) {
            this.skipToDot();
            throw ex;
        }
    }

    void skipToDot() throws ParseException {
        Token tok = this.getToken(0);
        while (tok.kind != 57 && tok.kind != 0) {
            tok = this.getNextToken();
        }
    }

    public final Term readTermEof(ReadOptions options) throws ParseException {
        try {
            Term t = this.term(options, options.operatorSet.getMaxLevel());
            this.jj_consume_token(0);
            return t;
        }
        catch (ParseException ex) {
            this.skipToEof();
            throw ex;
        }
    }

    void skipToEof() throws ParseException {
        Token tok = this.getToken(0);
        while (tok.kind != 0) {
            tok = this.getNextToken();
        }
    }

    public final Term term(ReadOptions options, int priority) throws ParseException {
        int p = options.operatorSet.getNextLevel(priority);
        Term t = p == 0 ? this.simpleTerm(options) : (this.jj_2_1(Integer.MAX_VALUE) && priority == 1201 && this.is1201Separator(2) ? this.name() : this.operatorTerm(options, p));
        return t;
    }

    Term exp(ReadOptions options) throws ParseException {
        Term t = this.testOp(options, 1) && this.isExpSeparator(2) ? this.name() : this.term(options, options.operatorSet.getCommaLevel() - 1);
        return t;
    }

    public final CompoundTermTag op(ReadOptions options, int priority) throws ParseException {
        this.jj_consume_token(6);
        NameToken tk = (NameToken)this.token;
        return tk.fxOp.tag;
    }

    public final CompoundTermTag op2(ReadOptions options, int priority) throws ParseException {
        if (this.jj_2_2(Integer.MAX_VALUE) && priority >= 1000) {
            this.comma();
            CompoundTermTag f = CompoundTermTag.comma;
            return f;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                NameToken tk = (NameToken)this.token;
                return tk.xfOp.tag;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    Term operatorTerm(ReadOptions options, int priority) throws ParseException {
        Term t1;
        int p = priority;
        if (this.testFY(options, p)) {
            CompoundTermTag f = this.op(options, p);
            t1 = this.term(options, p);
            t1 = this.createTerm(f, t1);
        } else if (this.testFX(options, p)) {
            CompoundTermTag f = this.op(options, p);
            t1 = this.term(options, p - 1);
            t1 = this.createTerm(f, t1);
        } else {
            t1 = this.term(options, p - 1);
            if (this.testXFX(options, p)) {
                CompoundTermTag f = this.op2(options, p);
                Term t2 = this.term(options, p - 1);
                t1 = this.createTerm(f, t1, t2);
            } else if (this.testXF(options, p)) {
                CompoundTermTag f = this.op2(options, p);
                t1 = this.createTerm(f, t1);
            } else if (this.testXFY(options, p)) {
                CompoundTermTag f = this.op2(options, p);
                Term t2 = this.term(options, p);
                t1 = this.createTerm(f, t1, t2);
            } else {
                while (true) {
                    CompoundTermTag f;
                    Token tk = this.getToken(1);
                    if ((tk.kind == 36 || tk.kind == 42) && tk.image.charAt(0) == '-') {
                        if (options.operatorSet.lookupXf("-") == Operator.nonOperator) break;
                        if (tk.kind == 36) {
                            this.jj_consume_token(36);
                            t1 = this.createTerm(CompoundTermTag.minus2, t1, IntegerTerm.get(-IntegerTerm.get((String)tk.image).value));
                            continue;
                        }
                        this.jj_consume_token(42);
                        t1 = this.createTerm(CompoundTermTag.minus2, t1, new FloatTerm(-new FloatTerm((String)tk.image).value));
                        continue;
                    }
                    if (this.testYFX(options, p)) {
                        f = this.op2(options, p);
                        Term t2 = this.term(options, p - 1);
                        t1 = this.createTerm(f, t1, t2);
                        continue;
                    }
                    if (!this.testYF(options, p)) break;
                    f = this.op2(options, p);
                    t1 = this.createTerm(f, t1);
                }
            }
        }
        return t1;
    }

    public final Term simpleTerm(ReadOptions options) throws ParseException {
        Term t;
        if (this.jj_2_3(Integer.MAX_VALUE) && this.getToken((int)2).kind == 49 && this.getToken((int)2).specialToken == null) {
            t = this.compound(options);
        } else if (this.testNoOp(options)) {
            t = this.name();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            t = this.variable(options);
        } else if (this.jj_2_5(Integer.MAX_VALUE)) {
            t = this.integer();
        } else if (this.jj_2_6(Integer.MAX_VALUE)) {
            t = this.float_number();
        } else if (this.jj_2_7(Integer.MAX_VALUE)) {
            t = this.list_term(options);
        } else if (this.jj_2_8(Integer.MAX_VALUE)) {
            t = this.curly_term(options);
        } else if (this.jj_2_9(Integer.MAX_VALUE)) {
            t = this.char_code_list();
        } else if (this.jj_2_10(Integer.MAX_VALUE)) {
            this.open();
            t = this.term(options, 1201);
            this.close();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return t;
    }

    public final Term list_term(ReadOptions options) throws ParseException {
        Term rc = null;
        Term t1 = null;
        this.open_list();
        if (!this.jj_2_13(Integer.MAX_VALUE)) {
            Term t2;
            t1 = this.exp(options);
            rc = t1 = this.createTerm(TermConstants.listTag, t1, null);
            while (this.jj_2_11(Integer.MAX_VALUE)) {
                this.comma();
                t2 = this.exp(options);
                ((CompoundTerm)t1).args[1] = t2 = this.createTerm(TermConstants.listTag, t2, null);
                t1 = t2;
            }
            if (this.jj_2_12(Integer.MAX_VALUE)) {
                this.ht_sep();
                ((CompoundTerm)t1).args[1] = t2 = this.exp(options);
            }
        }
        this.close_list();
        if (rc == null) {
            return TermConstants.emptyListAtom;
        }
        if (((CompoundTerm)t1).args[1] == null) {
            ((CompoundTerm)t1).args[1] = TermConstants.emptyListAtom;
        }
        return rc;
    }

    public final Term curly_term(ReadOptions options) throws ParseException {
        Term t = null;
        this.open_curly();
        t = this.term(options, 1201);
        this.close_curly();
        if (t == null) {
            return TermConstants.emptyCurlyAtom;
        }
        return this.createTerm(CompoundTermTag.curly1, t);
    }

    public final CompoundTerm compound(ReadOptions options) throws ParseException {
        ArrayList<Term> args = new ArrayList<Term>();
        AtomTerm functor = this.name();
        this.open_ct();
        Term el = this.exp(options);
        args.add(el);
        while (this.jj_2_14(Integer.MAX_VALUE)) {
            this.comma();
            el = this.exp(options);
            args.add(el);
        }
        this.close();
        int n = args.size();
        CompoundTerm rc = new CompoundTerm(functor, n);
        for (int i = 0; i < n; ++i) {
            rc.args[i] = (Term)args.get(i);
        }
        return rc;
    }

    public final AtomTerm name() throws ParseException {
        this.jj_consume_token(6);
        return AtomTerm.get(((NameToken)this.token).getValue());
    }

    public final VariableTerm variable(ReadOptions options) throws ParseException {
        this.jj_consume_token(32);
        VariableTerm var = options.variableNames.get(this.token.image);
        if (var == null) {
            var = new VariableTerm(this.token.image);
            if (!"_".equals(this.token.image)) {
                options.variableNames.put(this.token.image, var);
                options.singletons.put(this.token.image, var);
            }
            options.variables.add(var);
        } else {
            options.singletons.remove(this.token.image);
        }
        return var;
    }

    public final IntegerTerm integer() throws ParseException {
        this.jj_consume_token(36);
        return IntegerTerm.get(this.token.image);
    }

    public final FloatTerm float_number() throws ParseException {
        this.jj_consume_token(42);
        return new FloatTerm(this.token.image);
    }

    public final Term char_code_list() throws ParseException {
        this.jj_consume_token(45);
        String val = TermParserUtils.convertQuotedString(this.token.image, '\"');
        AtomTerm atomValue = AtomTerm.get(val);
        int n = val.length();
        Term codesValue = TermConstants.emptyListAtom;
        char[] valChars = val.toCharArray();
        Term[] valAtoms = new AtomTerm[valChars.length];
        for (int i = n - 1; i >= 0; --i) {
            codesValue = CompoundTerm.getList(IntegerTerm.get(val.charAt(i)), codesValue);
            valAtoms[i] = AtomTerm.get(valChars[i]);
        }
        Term charsValue = CompoundTerm.getList(valAtoms);
        return new DoubleQuotesTerm(this.environment, codesValue, charsValue, atomValue);
    }

    public final void open() throws ParseException {
        this.jj_consume_token(49);
    }

    public final void open_ct() throws ParseException {
        if (this.getToken((int)1).specialToken != null) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(49);
    }

    public final void close() throws ParseException {
        this.jj_consume_token(50);
    }

    public final void open_list() throws ParseException {
        this.jj_consume_token(51);
    }

    public final void close_list() throws ParseException {
        this.jj_consume_token(52);
    }

    public final void open_curly() throws ParseException {
        this.jj_consume_token(53);
    }

    public final void close_curly() throws ParseException {
        this.jj_consume_token(54);
    }

    public final void ht_sep() throws ParseException {
        this.jj_consume_token(55);
    }

    public final void comma() throws ParseException {
        this.jj_consume_token(56);
    }

    public final void end() throws ParseException {
        this.jj_consume_token(57);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_14();
        this.jj_save(13, xla);
        return retval;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public TermParser(CharStream stream) {
        int i;
        this.token_source = new TermParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJTermParserCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJTermParserCalls();
        }
    }

    public TermParser(TermParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJTermParserCalls();
        }
    }

    public void ReInit(TermParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJTermParserCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (JJTermParserCalls c : this.jj_2_rtns) {
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enum_ = this.jj_expentries.elements();
            while (enum_.hasMoreElements()) {
                int[] oldentry = (int[])enum_.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[92];
        for (i = 0; i < 92; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 2; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 92; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 14; ++i) {
            JJTermParserCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJTermParserCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJTermParserCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }
}

