/* -*- mode:c -*-
 *
 * Copyright 2021 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

/* Power State interrupts */
GPIO_INT(SLP_S4_L,		PIN(I, 5), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(SLP_S3_L,		PIN(H, 3), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(SLP_S0_L,		PIN(E, 4), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(SLP_SUS_L,		PIN(G, 2), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(VCCIN_AUX_VID0,	PIN(D, 0), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(RSMRST_PWRGD_L,	PIN(E, 1), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(CPU_C10_GATE_L,	PIN(G, 1), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(PG_DRAM_OD,		PIN(D, 3), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(PG_PP1050_ST_OD,	PIN(L, 1), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(VCCIN_AUX_VID1,	PIN(K, 1), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(PG_VCCIO_EXT_OD,	PIN(D, 7), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(ESPI_RESET_L, 	 PIN(D, 2), GPIO_INT_FALLING | GPIO_SEL_1P8V, espi_reset_pin_asserted_interrupt)

GPIO_INT(H1_EC_PWR_BTN_ODL,	PIN(E, 2), GPIO_INT_BOTH | GPIO_PULL_UP, power_button_interrupt)
#ifdef CONFIG_LOW_POWER_IDLE
/* Used to wake up the EC from Deep Doze mode when writing to console */
GPIO_INT(UART1_RX,	 PIN(B, 0), GPIO_INT_BOTH, uart_deepsleep_interrupt)	/* UART_DBG_TX_EC_RX */
#endif

/* USB-C interrupts */
GPIO_INT(USB_C0_INT_ODL,	PIN(K, 0), GPIO_INT_FALLING | GPIO_PULL_UP, usb_c0_interrupt) /* BC12 and charger */
GPIO_INT(USB_C0_CCSBU_OVP_ODL,	PIN(K, 6), GPIO_INT_FALLING | GPIO_PULL_UP, c0_ccsbu_ovp_interrupt) /* Fault protection */

/* Other interrupts */
GPIO_INT(LID_OPEN,		PIN(F, 3), GPIO_INT_BOTH, lid_interrupt)
GPIO_INT(EC_WP_OD,		PIN(A, 6), GPIO_INT_BOTH, switch_interrupt)
GPIO_INT(HDMI_HPD_SUB_ODL,	PIN(E, 7), GPIO_INT_BOTH, hdmi_hpd_interrupt)

/* Power sequence GPIOs */
GPIO(EC_AP_RTCRST,		PIN(K, 2), GPIO_OUT_LOW)
GPIO(EC_AP_PWR_BTN_ODL,		PIN(B, 6), GPIO_ODR_HIGH)
GPIO(EC_AP_DPWROK,		PIN(L, 7), GPIO_OUT_LOW)
GPIO(EC_AP_RSMRST_L,		PIN(H, 0), GPIO_OUT_LOW)
GPIO(EC_AP_WAKE_ODL,		PIN(D, 5), GPIO_ODR_HIGH)
GPIO(SYS_RST_ODL,		PIN(D, 1), GPIO_ODR_HIGH)
GPIO(EC_AP_SYS_PWROK,		PIN(F, 2), GPIO_OUT_LOW)
GPIO(PG_PP5000_U_OD,		PIN(E, 3), GPIO_INPUT)
GPIO(EN_PP3300_A,		PIN(C, 5), GPIO_OUT_LOW)
GPIO(EC_AP_PCH_PWROK_OD,	PIN(D, 6), GPIO_ODR_LOW)
GPIO(EN_PP5000_U,		PIN(K, 5), GPIO_OUT_LOW)
/* TODO(b:149775160) - Modify if needed if we ever use this signal. */
GPIO(EN_VCCST,			PIN(D, 4), GPIO_INPUT)
GPIO(EN_VCCIO_EXT,		PIN(B, 2), GPIO_OUT_LOW)
GPIO(EC_PROCHOT_ODL,		PIN(I, 1), GPIO_ODR_HIGH | GPIO_SEL_1P8V)
GPIO(EC_AP_VCCST_PWRGD_OD,	PIN(E, 5), GPIO_ODR_LOW)
GPIO(ALL_SYS_PWRGD,		PIN(B, 7), GPIO_OUT_LOW)
GPIO(EN_SLP_Z,			PIN(K, 3), GPIO_OUT_LOW)

/* Required for icelake chipset code, but implemented through other means for dedede */
UNIMPLEMENTED(AC_PRESENT)
UNIMPLEMENTED(PG_EC_DSW_PWROK)
UNIMPLEMENTED(PG_EC_ALL_SYS_PWRGD)

/* Used by baseboard z-state enable, but not present on blipper */
UNIMPLEMENTED(USB_C1_INT_ODL)

/* I2C pins - Alternate function below configures I2C module on these pins */
GPIO(EC_I2C_EEPROM_SCL,		PIN(B, 3), GPIO_INPUT)
GPIO(EC_I2C_EEPROM_SDA,		PIN(B, 4), GPIO_INPUT)
GPIO(EC_I2C_BATTERY_SCL,	PIN(C, 1), GPIO_INPUT)
GPIO(EC_I2C_BATTERY_SDA,	PIN(C, 2), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SCL,		PIN(A, 4), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SDA,		PIN(A, 5), GPIO_INPUT)

/* USB pins */
GPIO(EN_USB_A0_VBUS,		PIN(L, 6), GPIO_OUT_LOW)
GPIO(EN_USB_A1_VBUS,		PIN(E, 6), GPIO_OUT_LOW)
GPIO(EC_AP_USB_C0_HPD,		PIN(L, 4), GPIO_OUT_LOW)
GPIO(EC_AP_USB_C1_HDMI_HPD,	PIN(K, 7), GPIO_OUT_LOW)
GPIO(HDMI_SEL_L,		PIN(C, 6), GPIO_OUT_LOW)

/* MKBP event synchronization */
GPIO(EC_AP_MKBP_INT_L,	PIN(L, 5), GPIO_ODR_HIGH)

/* Misc pins which will run to the I/O board */


/* Misc */
GPIO(EN_BL_OD,			PIN(K, 4), GPIO_ODR_LOW)
GPIO(EC_ENTERING_RW,		PIN(G, 0), GPIO_OUT_LOW)
GPIO(EC_ENTERING_RW2,		PIN(C, 7), GPIO_OUT_LOW)
GPIO(CCD_MODE_ODL,		PIN(H, 5), GPIO_ODR_HIGH)
GPIO(EC_BATTERY_PRES_ODL,	PIN(I, 4), GPIO_INPUT)
GPIO(ECH1_PACKET_MODE,		PIN(H, 1), GPIO_OUT_LOW)

/* NC pins, enable internal pull-down to avoid floating state. */
GPIO(GPIOA0_NC, PIN(A, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOA3_NC, PIN(A, 3), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOA7_NC, PIN(A, 7), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOB5_NC, PIN(B, 5), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOC0_NC, PIN(C, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOC3_NC, PIN(C, 3), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOC4_NC, PIN(C, 4), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOE0_NC, PIN(E, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF0_NC, PIN(F, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF1_NC, PIN(F, 1), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF4_NC, PIN(F, 4), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF5_NC, PIN(F, 5), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF6_NC, PIN(F, 6), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOF7_NC, PIN(F, 7), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOG3_NC, PIN(G, 3), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOG4_NC, PIN(G, 4), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOG5_NC, PIN(G, 5), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOG6_NC, PIN(G, 6), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOG7_NC, PIN(G, 7), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOH2_NC, PIN(H, 2), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOH4_NC, PIN(H, 4), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOH6_NC, PIN(H, 6), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOI6_NC, PIN(I, 6), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOI7_NC, PIN(I, 7), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ0_NC, PIN(J, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ1_NC, PIN(J, 1), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ3_NC, PIN(J, 3), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ4_NC, PIN(J, 4), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ5_NC, PIN(J, 5), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOJ6_NC, PIN(J, 6), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOL0_NC, PIN(L, 0), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOL3_NC, PIN(L, 3), GPIO_INPUT | GPIO_PULL_DOWN)
GPIO(GPIOM6_NC, PIN(M, 6), GPIO_INPUT | GPIO_PULL_DOWN)

/* Alternate functions GPIO definitions */
/* UART */
ALTERNATE(PIN_MASK(B, BIT(0) | BIT(1)), 0, MODULE_UART, 0)		/* UART for debug */

/* I2C */
ALTERNATE(PIN_MASK(B, BIT(3) | BIT(4)), 0, MODULE_I2C, 0)		/* I2C0 */
ALTERNATE(PIN_MASK(C, BIT(1) | BIT(2)), 0, MODULE_I2C, 0)		/* I2C1 */
ALTERNATE(PIN_MASK(A, BIT(4) | BIT(5)), 0, MODULE_I2C, 0)		/* I2C5 */

/* ADC */
ALTERNATE(PIN_MASK(L, BIT(2)), 0, MODULE_ADC, 0)		    	/* ADC15: TEMP_SENSOR_3 */
ALTERNATE(PIN_MASK(I, BIT(0) | BIT(2) | BIT(3)), 0, MODULE_ADC, 0)	/* ADC0: EC_VSNS_PP3300_A, ADC2: TEMP_SENSOR_1, ADC3: TEMP_SENSOR_2 */

/* DAC */
ALTERNATE(PIN_MASK(J, BIT(2)), 0, MODULE_DAC, 0)			/* DAC2: EC_AP_PSYS */

/* PWM */
ALTERNATE(PIN_MASK(A, BIT(1) | BIT(2)), 0, MODULE_PWM, 0) /* RED led, GREEN led */
