---
title: GRUB payload 
x-unreviewed: true
...

TODO: this guide should be reviewed and updated. Some info might be out of
date.

[GNU GRUB](https://www.gnu.org/software/grub/) already has excellent
documentation, but there are aspects of Libreboot that deserve special
treatment. Libreboot provides the option to boot GNU GRUB directly, running on
bare metal (instead of using BIOS or UEFI services).

[The GNU+Linux section](../gnulinux/) also has Libreboot-specific guides for
dealing with GNU+Linux distributions when using GNU GRUB directly, in this
setup. [A similar section exists for BSD operating systems](../bsd/)

GRUB keyboard layouts
=====================

It is possible to use *any* keymap in GNU GRUB.

Custom keyboard layout
----------------------

Keymaps are stored in `resources/grub/keymap/`

You can use the `ckbcomp` program to generate a keymap, based on Xorg keymap
files:

    ckbcomp fr > frazerty

When you build GRUB from source, you can use the `grub-mklayout` program to
create a special keymap file for GRUB. [Learn how to build GRUB](../build/)

When you've built GRUB, using `lbmk` (libreboot build system), take your kepmap
file (generated by ckbcomp) and run it through `grub-mklayout` like so:

    cat frazerty | ./grub/grub-mklayout -o frazerty.gkb

Place the newly created `.gkb` file under `resources/grub/keymap` in lbmk. When
you build Libreboot, a ROM image with GRUB payload and your newly created
keymap will be available under the `bin/` directory.
[Learn how to build Libreboot ROM images](../build/)

Many keymaps exist in the Libreboot build system, but sometimes you must
manually tweak the file created by `ckbcomp`, adjusting the scan codes in that
file, before converting to a GRUB keymap file. Therefore, it would be unwise to
automatically add all keymaps in GRUB.

If you've added a keymap to lbmk, and it works,
[please submit a patch!](../../git.md)
