/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public class BERInputStream
extends DERInputStream {
    private DERObject END_OF_STREAM;

    private /* synthetic */ void finit$() {
        this.END_OF_STREAM = new DERObject(this){
            private /* synthetic */ BERInputStream this$0;
            {
                this.this$0 = this$0;
            }

            void encode(DEROutputStream out) throws IOException {
                throw new IOException("Eeek!");
            }
        };
    }

    public BERInputStream(InputStream is) {
        super(is);
        this.finit$();
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int b;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int b1 = this.read();
        while ((b = this.read()) >= 0 && (b1 != 0 || b != 0)) {
            bOut.write(b1);
            b1 = b;
        }
        return bOut.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject o;
        Vector<DERObject> octs = new Vector<DERObject>();
        while ((o = this.readObject()) != this.END_OF_STREAM) {
            octs.addElement(o);
        }
        return new BERConstructedOctetString(octs);
    }

    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            throw new EOFException();
        }
        int length = this.readLength();
        if (length < 0) {
            switch (tag) {
                case 5: {
                    return null;
                }
                case 48: {
                    DERObject obj;
                    BERConstructedSequence seq = new BERConstructedSequence();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        seq.addObject(obj);
                    }
                    return seq;
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
                case 49: {
                    DERObject obj;
                    DEREncodableVector v = new DEREncodableVector();
                    while ((obj = this.readObject()) != this.END_OF_STREAM) {
                        v.add(obj);
                    }
                    return new BERSet(v);
                }
            }
            if ((tag & 0x80) != 0) {
                if ((tag & 0x1F) == 31) {
                    throw new IOException("unsupported high tag encountered");
                }
                if ((tag & 0x20) == 0) {
                    byte[] bytes = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, tag & 0x1F, new DEROctetString(bytes));
                }
                DERObject dObj = this.readObject();
                if (dObj == this.END_OF_STREAM) {
                    return new DERTaggedObject(tag & 0x1F);
                }
                DERObject next = this.readObject();
                if (next == this.END_OF_STREAM) {
                    return new BERTaggedObject(tag & 0x1F, dObj);
                }
                BERConstructedSequence seq = new BERConstructedSequence();
                seq.addObject(dObj);
                do {
                    seq.addObject(next);
                    next = this.readObject();
                } while (next != this.END_OF_STREAM);
                return new BERTaggedObject(false, tag & 0x1F, seq);
            }
            throw new IOException("unknown BER object encountered");
        }
        if (tag == 0 && length == 0) {
            return this.END_OF_STREAM;
        }
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        return this.buildObject(tag, bytes);
    }
}

