/*
  File autogenerated by gengetopt version 2.13.1
  generated with the following command:
  ../src/gengetopt -i ./sample1.ggo -Fcmdline1 --long-help -u 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline1.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

char *enum_opt_values[] = {"foo", "bar", "hello", 0} ;	/* Possible values for enum-opt.  */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->str_opt_given = 0 ;
  args_info->my_opt_given = 0 ;
  args_info->int_opt_given = 0 ;
  args_info->flag_opt_given = 0 ;
  args_info->funct_opt_given = 0 ;
  args_info->long_opt_given = 0 ;
  args_info->def_opt_given = 0 ;
  args_info->enum_opt_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->str_opt_arg = NULL;
  args_info->flag_opt_flag = 0;
  args_info->def_opt_arg = gengetopt_strdup ("Hello");
  args_info->enum_opt_arg = gengetopt_strdup ("hello");
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\nUsage: sample1 -iINT|--int-opt=INT [-h|--help] [-V|--version] -sfilename|--str-opt=filename -mINT|--my-opt=INT [--flag-opt] [-F|--funct-opt] --long-opt=LONG --def-opt=STRING --enum-opt=STRING  [FILES]...\n\n");
  printf("%s\n","  -h, --help              Print help and exit");
  printf("%s\n","  -V, --version           Print version and exit");
  printf("%s\n","  -s, --str-opt=filename  A string option, for a filename");
  printf("%s\n","  -m, --my-opt=INT        Another integer option, this time the description of \n                            the option should be quite long to require \n                            wrapping... possibly more than one wrapping :-) \n                            especially if I\n                            require a line break");
  printf("%s\n","  -i, --int-opt=INT       A int option");
  printf("%s\n","\nmore involved options:");
  printf("%s\n","  the following options\n  are more complex");
  printf("%s\n","      --flag-opt          A flag option  (default=off)");
  printf("%s\n","  -F, --funct-opt         A function option");
  printf("%s\n","\nlast option section:");
  printf("%s\n","      --long-opt=LONG     A long option");
  printf("%s\n","      --def-opt=STRING    A string option with default  (default=`Hello')");
  printf("%s\n","      --enum-opt=STRING   A string option with list of values  (possible \n                            values=\"foo\", \"bar\", \"hello\" default=`hello')");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->str_opt_arg)
    {
      free (args_info->str_opt_arg); /* free previous argument */
      args_info->str_opt_arg = 0;
    }
  if (args_info->def_opt_arg)
    {
      free (args_info->def_opt_arg); /* free previous argument */
      args_info->def_opt_arg = 0;
    }
  if (args_info->enum_opt_arg)
    {
      free (args_info->enum_opt_arg); /* free previous argument */
      args_info->enum_opt_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

static int
check_possible_values(const char *val, char *values[])
{
  int i, found;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return 0; /* NULL means no argument for the option */

  for (found = i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          found++;
          if (strlen(values[i]) == len)
            return 1; /* exact macth no need to check more */
        }
    }

  return found; /* return how many values are matched */
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, NULL) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;

  if (! args_info->int_opt_given)
    {
      fprintf (stderr, "%s: '--int-opt' ('-i') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }

  return error;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int found = 0;
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "str-opt",	1, NULL, 's' },
        { "my-opt",	1, NULL, 'm' },
        { "int-opt",	1, NULL, 'i' },
        { "flag-opt",	0, NULL, 0 },
        { "funct-opt",	0, NULL, 'F' },
        { "long-opt",	1, NULL, 0 },
        { "def-opt",	1, NULL, 0 },
        { "enum-opt",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVs:m:i:F", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 's':	/* A string option, for a filename.  */
          if (local_args_info.str_opt_given)
            {
              fprintf (stderr, "%s: `--str-opt' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->str_opt_given && ! override)
            continue;
          local_args_info.str_opt_given = 1;
          args_info->str_opt_given = 1;
          if (args_info->str_opt_arg)
            free (args_info->str_opt_arg); /* free previous string */
          args_info->str_opt_arg = gengetopt_strdup (optarg);
          break;

        case 'm':	/* Another integer option, this time the description of the option should be quite long to require wrapping... possibly more than one wrapping :-) especially if I\nrequire a line break.  */
          if (local_args_info.my_opt_given)
            {
              fprintf (stderr, "%s: `--my-opt' (`-m') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->my_opt_given && ! override)
            continue;
          local_args_info.my_opt_given = 1;
          args_info->my_opt_given = 1;
          args_info->my_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'i':	/* A int option.  */
          if (local_args_info.int_opt_given)
            {
              fprintf (stderr, "%s: `--int-opt' (`-i') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->int_opt_given && ! override)
            continue;
          local_args_info.int_opt_given = 1;
          args_info->int_opt_given = 1;
          args_info->int_opt_arg = strtol (optarg,&stop_char,0);
          break;

        case 'F':	/* A function option.  */
          if (local_args_info.funct_opt_given)
            {
              fprintf (stderr, "%s: `--funct-opt' (`-F') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->funct_opt_given && ! override)
            continue;
          local_args_info.funct_opt_given = 1;
          args_info->funct_opt_given = 1;
          break;


        case 0:	/* Long option with no short option */
          /* A flag option.  */
          if (strcmp (long_options[option_index].name, "flag-opt") == 0)
          {
            if (local_args_info.flag_opt_given)
              {
                fprintf (stderr, "%s: `--flag-opt' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->flag_opt_given && ! override)
              continue;
            local_args_info.flag_opt_given = 1;
            args_info->flag_opt_given = 1;
            args_info->flag_opt_flag = !(args_info->flag_opt_flag);
          }
          /* A long option.  */
          else if (strcmp (long_options[option_index].name, "long-opt") == 0)
          {
            if (local_args_info.long_opt_given)
              {
                fprintf (stderr, "%s: `--long-opt' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->long_opt_given && ! override)
              continue;
            local_args_info.long_opt_given = 1;
            args_info->long_opt_given = 1;
            args_info->long_opt_arg = strtol (optarg,&stop_char,0);
          }
          /* A string option with default.  */
          else if (strcmp (long_options[option_index].name, "def-opt") == 0)
          {
            if (local_args_info.def_opt_given)
              {
                fprintf (stderr, "%s: `--def-opt' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->def_opt_given && ! override)
              continue;
            local_args_info.def_opt_given = 1;
            args_info->def_opt_given = 1;
            if (args_info->def_opt_arg)
              free (args_info->def_opt_arg); /* free previous string */
            args_info->def_opt_arg = gengetopt_strdup (optarg);
          }
          /* A string option with list of values.  */
          else if (strcmp (long_options[option_index].name, "enum-opt") == 0)
          {
            if (local_args_info.enum_opt_given)
              {
                fprintf (stderr, "%s: `--enum-opt' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if ((found = check_possible_values(optarg, enum_opt_values)) != 1)
              {
                fprintf (stderr, "%s: %s argument, \"%s\", for option `--enum-opt'%s\n", argv[0], found ? "ambiguous" : "invalid", optarg, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->enum_opt_given && ! override)
              continue;
            local_args_info.enum_opt_given = 1;
            args_info->enum_opt_given = 1;
            if (args_info->enum_opt_arg)
              free (args_info->enum_opt_arg); /* free previous string */
            args_info->enum_opt_arg = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_free (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
