;; DFA-based pipeline description for 5500
(define_automaton "vr55")
(define_cpu_unit "vr55_dp0"     "vr55")
(define_cpu_unit "vr55_dp1"     "vr55")
(define_cpu_unit "vr55_mem"     "vr55")
(define_cpu_unit "vr55_mac"     "vr55")
(define_cpu_unit "vr55_fp"      "vr55")
(define_cpu_unit "vr55_bru"     "vr55")

;;
;; The ordering of the instruction-execution-path/resource-usage
;; descriptions (also known as reservation RTL) is roughly ordered
;; based on the define attribute RTL for the "type" classification.
;; When modifying, remember that the first test that matches is the
;; reservation used!
;;

(define_insn_reservation "ir_vr55_unknown" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "unknown"))
  "vr55_dp0+vr55_dp1+vr55_mem+vr55_mac+vr55_fp+vr55_bru")

;; Assume prediction fails.
(define_insn_reservation "ir_vr55_branch" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "branch,jump,call"))
  "vr55_bru")

(define_insn_reservation "ir_vr55_load" 3
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "load"))
  "vr55_mem")

(define_insn_reservation "ir_vr55_store" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "store"))
  "vr55_mem")

;; This reservation is for conditional move based on integer
;; or floating point CC.
(define_insn_reservation "ir_vr55_condmove" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "condmove"))
  "vr55_dp0|vr55_dp1")

;; Move to/from FPU registers
(define_insn_reservation "ir_vr55_xfer" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "xfer"))
  "vr55_dp0|vr55_dp1")

(define_insn_reservation "ir_vr55_hilo" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "hilo"))
  "vr55_dp0|vr55_dp1")

(define_insn_reservation "ir_vr55_arith" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "move,arith,darith,const,icmp,nop"))
  "vr55_dp0|vr55_dp1")

(define_insn_reservation "ir_vr55_imul_si" 3
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "imul")
            (eq_attr "mode" "SI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_imul_di" 4
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "imul")
            (eq_attr "mode" "DI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_imadd_si" 3
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "imul"))
  "vr55_mac")

;; Divide algorithm is early out with best latency of 7 pcycles.
;; Use worst case for scheduling purposes.
(define_insn_reservation "ir_vr55_idiv_si" 42
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "SI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_idiv_di" 74
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "idiv")
            (eq_attr "mode" "DI")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fadd" 4
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fadd"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fmul_sf" 5
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmul_df" 6
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmul")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmadd_sf" 9
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fmadd_df" 10
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fmadd")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fdiv_sf" 30
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fdiv,fsqrt")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fdiv_df" 59
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fdiv,fsqrt")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_fabs" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fabs,fneg"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcmp" 2
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "fcmp"))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcvt_sf" 4
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fcvt")
            (eq_attr "mode" "SF")))
  "vr55_fp")

(define_insn_reservation "ir_vr55_fcvt_df" 6
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "fcvt")
            (eq_attr "mode" "DF")))
  "vr55_fp")

(define_insn_reservation "ir_vr55_frsqrt_sf" 60
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "SF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_frsqrt_df" 118
  (and (eq_attr "cpu" "r5500")
       (and (eq_attr "type" "frsqrt")
            (eq_attr "mode" "DF")))
  "vr55_mac")

(define_insn_reservation "ir_vr55_multi" 1
  (and (eq_attr "cpu" "r5500")
       (eq_attr "type" "multi"))
  "vr55_dp0+vr55_dp1+vr55_mem+vr55_mac+vr55_fp+vr55_bru")
