;; Quail package `chinese-sw
;;   Generated by the command `titdic-convert'
;;	Original TIT dictionary file: SW.tit

;; # Header added for Emacs -*- coding: euc-china -*-
;; #
;; # This file is included in the directory contrib/clients/cxterm of the
;; # distribution of X11R6.  As the file itself doesn't contain copyright
;; # and license notices, the following statements in the section 6 of
;; # the file .../cxterm/README covers it.
;; #
;; # X11R6 CXTERM (C) 1994 BY YONGGUANG ZHANG.
;; # X11R5 CXTERM (C) 1991 BY YONGGUANG ZHANG AND MAN-CHI PONG.
;; # 
;; # Permission to use, copy, modify, and distribute this software and
;; # its documentation for any purpose is hereby granted without fee,
;; # provided that this entire copyright and permission notice appear
;; # in all such copies, and that the name of the authors may not be
;; # used to endorse or promote products derived from this material
;; # without specific prior written permission.  The authors make no
;; # representations about the suitability of this software for any
;; # purpose.  It is provided "as is" without express or implied warranty.
;; #
;; # End of header added for Emacs
;; # HANZI input table for cxterm
;; # To be used by cxterm, convert me to .cit format first
;; # .cit version 2
;; ENCODE:	GB
;; AUTOSELECT:	NO
;; PROMPT:	汉字输入∷首尾∷\040
;; #
;; COMMENT	(源于 CCDOS)
;; COMMENT	书写该汉字时的「首笔」及「尾笔」。例如，【吕】首尾笔皆为「口」，故在
;; COMMENT 「首尾」模式中用 ff0 三键输入。（ f 键在「首尾」模式中表示「口」）
;; # define keys
;; VALIDINPUTKEY:	abcdefghijklmnopqrstuvwxyz
;; WILDCARDKEY:	*
;; WILDCHARKEY:	?
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; REPEATKEY:	\020\022
;; KEYPROMPT(a):	心又
;; KEYPROMPT(b):	冖山
;; KEYPROMPT(c):	尸土
;; KEYPROMPT(d):	丶刀
;; KEYPROMPT(e):	火阝
;; KEYPROMPT(f):	口口
;; KEYPROMPT(g):	扌衣
;; KEYPROMPT(h):	氵疋
;; KEYPROMPT(i):	讠大
;; KEYPROMPT(j):	艹丁
;; KEYPROMPT(k):	亻厶
;; KEYPROMPT(l):	木灬
;; KEYPROMPT(m):	礻十
;; KEYPROMPT(n):	饣歹
;; KEYPROMPT(o):	月冂
;; KEYPROMPT(p):	纟门
;; KEYPROMPT(q):	石今
;; KEYPROMPT(r):	王丨
;; KEYPROMPT(s):	八女
;; KEYPROMPT(t):	丿乙
;; KEYPROMPT(u):	日囗
;; KEYPROMPT(v):	辶小
;; KEYPROMPT(w):	犭厂
;; KEYPROMPT(x):	竹虫
;; KEYPROMPT(y):	一弋
;; KEYPROMPT(z):	人卜
;; # the following line must not be removed
;; BEGINDICTIONARY

;;; End of the header of original TIT dictionary.

;;; Code:

(require 'quail)

(quail-define-package "chinese-sw" "Chinese-GB" "首尾"
 '(   (122 . "人卜")
   (121 . "一弋")
   (120 . "竹虫")
   (119 . "犭厂")
   (118 . "辶小")
   (117 . "日囗")
   (116 . "丿乙")
   (115 . "八女")
   (114 . "王丨")
   (113 . "石今")
   (112 . "纟门")
   (111 . "月冂")
   (110 . "饣歹")
   (109 . "礻十")
   (108 . "木灬")
   (107 . "亻厶")
   (106 . "艹丁")
   (105 . "讠大")
   (104 . "氵疋")
   (103 . "扌衣")
   (102 . "口口")
   (101 . "火阝")
   (100 . "丶刀")
   (99 . "尸土")
   (98 . "冖山")
   (97 . "心又")
)"汉字输入∷首尾∷

	(源于 CCDOS)
	书写该汉字时的「首笔」及「尾笔」。例如，【吕】首尾笔皆为「口」，故在
 「首尾」模式中用 ff0 三键输入。（ f 键在「首尾」模式中表示「口」）

Radical base input method for Chinese charset GB2312 (`chinese-gb2312').

In this input method, you enter a Chinese character by typing two
keys.  The first key corresponds to the first (首) radical, the second
key corresponds to the last (尾) radical.  The correspondence of keys
and radicals is as below:

 first radical:
 a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z
 心 冖 尸 丶 火 口 扌 氵 讠 艹 亻 木 礻 饣 月 纟 石 王 八 丿 日 辶 犭 竹 一 人
 last radical:
 a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z
 又 山 土 刀 阝 口 衣 疋 大 丁 厶 灬 十 歹 冂 门 今 丨 女 乙 囗 小 厂 虫 弋 卜

\\<quail-translation-docstring>
"
 '(("\C-?" . quail-delete-last-char)
   
   ("." . quail-next-translation)
   (">" . quail-next-translation)
   ("," . quail-prev-translation)
   ("<" . quail-prev-translation))
 nil nil nil nil)

(quail-define-rules
("aa" "叉憾慢慑双心又忄忮悛惚愎怼")
("ac" "懂怪难圣惟惺性悭悝憧")
("ad" "怖鸡怜劝惕忉怫恸恂悌愕愣")
("ae" "邓恢愀")
("af" "惦恰恬悟怙怊怡恪")
("ag" "恨艰怅")
("ah" "憷")
("ai" "懊快怏恹")
("aj" "对悸恃愉忖恻悖")
("ak" "怯忪")
("al" "桑怵憔")
("am" "惮悼悍懈忏忤怦怿恽悻悴")
("ao" "恫惰恼懦悄情怄惬惝惘惆惴慵")
("ap" "悯")
("ar" "惭惶忻忡")
("as" "惧慎")
("at" "必惨忱观慌恍慨愧惋忆忧悦怃怆怩恺悒")
("au" "悔怕惜憎悃慊懵")
("av" "怀惊慷悚愫憬懔")
("ax" "蚤")
("ay" "叠恒忙戏恤怔忾忸怛愠")
("az" "愤惯欢懒忭怍悱愦颡")
("ba" "寂峻寝岐崽宓皲")
("bb" "出窟密山窑冖崛")
("bc" "崔窿塞室堂崖窒")
("bd" "常寡寒鹤帘岭幂窍窃穷写屿岣峋崂骞鸩穹窈")
("be" "炭灾郓峁")
("bf" "宫官害豁家窖窘客容峪冢喾岵寤謇")
("bg" "农裳宸褰寰")
("bh" "定嶷蹇")
("bi" "寞实突峡窦")
("bj" "穿割寄宁崎守学宇掌峙字刿剀剜岈岢峥崞嵛搴窬")
("bk" "尝宏崧嵫")
("bl" "案寐宋棠寨崃嵘窠粜")
("bm" "岸峰罕军牢宰岍峄嶂嶙")
("bn" "岁穸")
("bo" "崩岗宦岿峭窝宵寓岌岖岚峒崤嵩嵴宥甯")
("bq" "岩岑宕")
("br" "宝窜审崭岬峤屮")
("bs" "安宾穴宴寅黉冥崾嵝窭")
("bt" "宠党冠究觉凯寇宽窥寥岂冗它完宛巍宪屹冤宅屺岘岜崦嵬宄觊窀窕")
("bu" "窗富宿宙岫崮嵋窆窨窳")
("bv" "察崇祟宗岽嵊寮泶")
("bx" "蜜蚩")
("by" "峨空宣宜岷崆崴嵯嶝鲎")
("bz" "额嵌赛赏窄巅颛")
("ca" "殿鼓慧履麦坡慰志坂埝墁懿屐彀毂觳恝恚悫赧")
("cb" "击屈堀罄")
("cc" "壁堆雇圭埋声尸士土屋垆垤堙耋")
("cd" "场赤坊房赫劫尽局均考垮耪劈韧扇塌韦坞圬坜坳埸埽塄骜鹛耢翥翩麴")
("ce" "都郝却熨")
("cf" "垢壕吉嘉居培譬启塔塘喜坫耜耠謦")
("cg" "表壤袁展垠襞")
("ch" "超趁堤靛赴赶起趋趣趟越赵走屣赳趄趔趑趱")
("ci" "埃块契堠獒戾麸")
("cj" "封静剧坷刷寺尉孝圩埘埒屙孱挈擘耔耨")
("ck" "层去坛耘")
("cl" "熬垛末屎未煮堞墚檗熹耒")
("cm" "辟埠丰耕坪屏犀幸肇埤墀鼙羼戽聱")
("cn" "鏊鐾")
("co" "敖臂扁墩坟埂圾肩教埔青墒赦属坍臀屑堰垌垧垴埚堋塥墉彗扃耥耦耩")
("cq" "砉磬耱")
("cr" "坤圳圻埕璧")
("cs" "屡填屦嫠嬖耧")
("ct" "耙地耗境壳坑老尼彭屁尾艳圪圮圯垅坨坭垲垸埯堍尻甏甓觌耄扈耖靓")
("cu" "尺毒堵届眉墙屠增者坩坶馨咫韬耆瞽赭")
("cv" "坏尿素埏埭塬綮纛")
("cw" "圹")
("cx" "螯螫")
("cy" "城壶堪垃坯坦屉墟盐壹域垣址昼坻垭埴韫盍鳌")
("cz" "坝坎款责赘卦坼垓埙扉颉")
("da" "变憋竣恋凌叛敲忍忘意毅恣憝戆")
("db" "峦宀籼")
("dc" "翟户童耀雍壮准塾壅旌")
("dd" "帝方粉冯冷旁券刃市弯为亦羽韵丶冫劭劾於旆鸾鹑鹨鹫翊粝粼")
("de" "部郭郊郎那邵邙邡鄣")
("df" "豪豢吝韶司糖誊言冶誉粘站召咨啻")
("dg" "哀褒裹粮良旅衰襄衣衷装衮袤亵裒饔")
("dh" "凝旋蹩")
("di" "凑奖决类头状族奕糇糗")
("dj" "亨剂将净刻刘挛孪判剖拳亭享削籽冽旖")
("dk" "玄凇糍")
("dl" "糕桨米烹亲熟栾桊粢糅")
("dm" "瓣半弊辨辩辫粹翠斗辉举料率弃辛章卒弈羿")
("dn" "銮")
("do" "敝敞当凋端敦放高膏糊交精粳靖朗离糯商尚数文肖效夜裔义育斋脔肓膂飒旃敉糈")
("dp" "斓")
("dr" "冲齐望新丫州主丬齑")
("ds" "粪六娄凄旗妄兴翼妆姿妾娈")
("dt" "充瓷刀刁光毫竟竞就卷亢况亮施习彦赢彰兖亳嬴蠃羸冼瓿氅旄旎旒粑糁")
("du" "酱竭眷盲亩瞥粕瓤畜音糟之昶粞糌")
("dv" "冰糙冻浆京糠辣凉凛紊永禀竦粽")
("dw" "产广疒")
("dx" "蛮糨")
("dy" "鳖斌戳粗盗减立粒戮氓孰亡卫翌亠冱鲞")
("dz" "卞颤次赣亥颜资歆颃颏")
("ea" "陵熄隐阪陂陬燮煅熳")
("eb" "灿陆")
("ec" "陛堕隆炉灶坠陧陲")
("ed" "防烬烤煽陶烯灼骘炀炜")
("ee" "火炎卩阝郯焱")
("ef" "焙烙陪熔阽焐焓")
("eg" "限隈煨")
("eh" "陡")
("ei" "焕炔陕燠")
("ej" "阿灯附剡烀爝")
("ek" "烩炫")
("el" "除煤燃燥隰")
("em" "烽焊降障阵阡阱陴烨烊焯")
("eo" "炳隔炯炬隋阴隅煳煸熵")
("ep" "焖")
("eq" "炻")
("er" "煌阶隍炷")
("es" "炽烘")
("et" "炒炕陇炮阮烧陀烷院阢陟隗炖炝")
("eu" "陌陷烟焰阳熘熠燔")
("ev" "爆陈际炼燎烁随隧隙隳煺燧")
("ex" "烛")
("ey" "隘烂陋烃险阻陉煜煊")
("ez" "炊队烦陨炸阼陔")
("fa" "跋唆叹吱吣呶唛唿啵啜嗖嗫嗄嗯嗳嘬噫跛跽踱蹑躞")
("fb" "咄嘧")
("fc" "哩吐唾哇唯唑喱喹喔噻嚯跬踵躔")
("fd" "叼吊吩号鹃跨另骂吗鸣嗣蹋踢蹄啼吻嗡呜勋哟叨叻呖呤咚呦哧唠唏啭啕嘞鹗鹭趵躅")
("fe" "鄙鄂哪郧郢叩咴唧啖啷啾嘟燹踯")
("ff" "咕哈嚎踞喀咖咯口路吕品器啥嘻嚣唁啄咭唔喏嗒喙噱囗豕跏跆踟踮踣")
("fg" "跟嚷喂哌哝哏囔踉饕")
("fh" "嚏足啶")
("fi" "唉跌吠喉唤哭吴嗅跃呋呔唳嗾噗噢趺蹊蹼")
("fj" "啊别踌叮蹲咐剐呵哼呼嚼喇哮呀吁喻咛咧唰嗬跗蹰")
("fk" "吆哙")
("fl" "踩呆跺嘿嘛嗓味躁噪咻哚咪啉喋嗪噍踝蹀蹂")
("fm" "哗啤叶哔咩哞唪啐嗥噼趼跸踔")
("fn" "哆哕嗲")
("fo" "哎蹦哺嘲喘距啃呐啮呕哨吸响咬踊嘱嘴呙咂哐哽啁唷喃喁喟嗷嗝嗍嘣嘀噙嚆嚅趿跚跤踹踽蹁蹒")
("fp" "躏")
("fq" "吟跖")
("fr" "呈蹿叫呻嘶听啸吖吲呷哜哳跻")
("fs" "叭哄趴只唼喽嗔嘤")
("ft" "吧吵吃吨跪吼唬吭咙呢咆跑呛吮跳兄邑咒叱叽吒呒呓呃吡哓呲咣咿咤唣嘭跄跎跷跣蹴黾鼍")
("fu" "蹭唱躇蹈噶喝啪嗜踏咽咱呱哂喵喈喑嗨嘈噜噌蹯")
("fv" "咏踪哒嗉嗦嗵嘌嘹噤嚓跞跹踺")
("fx" "虽嗤")
("fy" "蹬嘎喊践咀啦哦呸噬嘘喧哑噎喳趾咝嗟嗑嗌嘁噔戢蹉躐")
("fz" "吹啡咳喷嗽吓员咋卟呗咔咦唢啧噘颚踬蹶躜")
("ga" "拔搬扳报拨撮掇撼技攫捻披摄授搜投援摅摁")
("gb" "掘摇拙")
("gc" "捶摧挫垫挂护捏摊推握撞捱擢攉")
("gd" "扮搀捣拂拐拘拷挎捞拎掳扔势掏携扬抟拗掬搦鸷")
("ge" "揪挪抑掷揶")
("gf" "搭掂据扣括撂拈拾誓抬搪捂招哲拮捃掊掾")
("gg" "攘振扌搌擐攮")
("gh" "捷提捉踅")
("gi" "挨扶换抉摸挟揍捩揆")
("gj" "捌搏撑持打拧抒挣挚拊捋掎揄撙")
("gk" "摆")
("gl" "操搽抹热揉探揲搡摭")
("gm" "拌掸掉抖捍挥撵抨捧拼扦摔揖择拚捭摒擀擗")
("gn" "拶")
("go" "捕撤揣挡搞拒捐抠撇擒撒扫捎擞捅掖拥摘掮揠搠撖")
("gp" "搁扪")
("gq" "拓")
("gr" "挤拴撕押折拄抻挢撺擤")
("gs" "按扒摈拱接搂撰撄")
("gt" "把抱掺抄扼抚搅抗揽拢抡挠抛批抢撬扰挑拖托挖挽掩扎执挹搋")
("gu" "播插抽搐措揭揩捆擂描拇拍掐指抓掴揞搛摺撸")
("gv" "擦拣撩掠挞挺挝掭捺摞攥絷")
("gw" "扩")
("gx" "搔蛰蜇")
("gy" "扯搓担抵捡扛控拉拦抿扭擅拭找拯拽揸揎")
("gz" "拆撅拟排扑损掀攒掼揿撷贽")
("ha" "波渡汉浸浚滤漫没泌泼沁淑汊溲溆滠漶懑")
("hb" "汕")
("hc" "灌沪淮涅滩洼潍涯淫泸湮渥潼濉濯")
("hd" "渤沸汾沟鸿涝沥溺沛沏汤淘涕湾污泻淤滞沔沩泐泠洵浠溻滂瀚")
("he" "淡烫泖湫")
("hf" "涪沽浩活洁潞洛洽溶沿浴沾沼治洳浯涿涫溏澹濠")
("hg" "滚浪浓派涨裟")
("hh" "淀氵浞漩")
("hi" "澳涣漠汰沃溪泱浃渎溴濮")
("hj" "测淳浮河泞涛汀游渝洌浏浔涮湔溥溽滹漪澍潺挲")
("hk" "法滋泫泓浍淞")
("hl" "滁涤梁粱淋滦沫柒渠染深涂澡沐沭洙涞渫溱溧")
("hm" "淬洱汗浑津淖湃潭洋泽漳汁滓沣泮洚浒漭")
("hn" "汐淦滏鋈鎏")
("ho" "潮澈滴洞涵湖滑激汲漓漏满沤浦清溯淌湍渭涡消淆汹液涌汶洧涓潋澉潸潲濡瀹灞")
("hp" "涧澜润")
("hq" "涔")
("hr" "济渐汪沂渊浙洲注淅淠渖湟滢潇澌濞")
("hs" "滨滇洪婆汝演浜淇溟潢漤瀵娑")
("ht" "沧沉池溉港混浇流沦渺泥泡澎沙涉沈渗洗淹汔汜沅沌沆泷沲沱洮浼浣渑淝滟滗漉瀛")
("hu" "泊泛海涸酒渴泪溜潘潜泅洒滔湘油淄汨汩泔泗洇洄洎涠渚湎湄溷漕潴濂")
("hv" "涟潦漂瀑漆添涎漾泳源泺涑淙渌潆漯")
("hx" "浊")
("hy" "澄汇溅江沮滥汽泣浅涩湿温泄汛溢渔渣湛泯泾洹洫湓渲溘澧澶瀣鲨")
("hz" "濒溃漱渍汴浈濑灏")
("ia" "谩设态诹谂谖谡")
("ib" "谣讪诎")
("ic" "谨奎谁诖")
("id" "谤谗词访夯讳夸太询诱诩谔谛谫鹌鹩")
("ie" "谈诙")
("if" "话诺语诂诏诒诘诟诰诼谘谵")
("ii" "大读诀犬误讠诶谟谳")
("ij" "订夺奇诗讨谢讶谆刳剞诃诤谕")
("ik" "讼套")
("il" "谍课谋诛诔谯")
("im" "奔计讲评牵谭详许译讦诨谇耷")
("io" "调讽请诵谓议诌讴讵讷诓诮谑谝谪谲奁飙")
("ip" "谰")
("ir" "训诠诳夼")
("is" "识诿")
("it" "诧讹诡谎讥记论谬讫说奄谚诊诜谠匏")
("iu" "奋诲谱谦奢谐诣诸谄谒谙谮瓠")
("iv" "诞谅谜奈谴谏")
("iy" "诚诫让试诬讯谊证诅讧诋谌谥谧谶")
("iz" "诽讣该认诉诈谀欹")
("ja" "菠葱菱蔓惹蕊芯夔芰芟茇菝菽菔葸葭蒽蕙蕞薏")
("jb" "茁")
("jc" "茬董芦墓鞋芏茌茔荏堇萑蕹薹藿")
("jd" "荡蒂芳芬苟节鞠菊劳勒荔幕募蔫葡勤鹊芍苏萄苇药艿芎芾苈芴苓茑荀荩莠莺菸萼蓦蓊蒡鹋鹳鞫")
("je" "荧鄞茚茆荻")
("jf" "菇警苦落蒙菩茄蓉茹若苫苔营苕莒茗萜菅蓓")
("jg" "蓑苌茛莨蒎蒗")
("jh" "蓰")
("ji" "获荚葵莫英芙茯荬葜蒺蔟鞅")
("jj" "薄荷菏蓟荐蒋荆苛莉茅摹孽擎蔚芽芋蒯劐艹苻荇荨荮荸莳莩葑葶蓐薅蘅鞯")
("jk" "芸荟菘")
("jl" "苯菜茶蕉莱荣燕藻蘸蔗蒸茉茱荼葆蓁蕖薰藁蘖檠鞣")
("jm" "草革荤井莽苹萍茸薛葬芊荜荦莘萆萃葺蕈薜藓")
("jn" "萝蓥")
("jo" "艾蔽鞭葫敬萌藕莆蒲鞘散荫芨苣芮苒苘茼茭莴莜菁菡葚蒿蓠蒴蔹薇薮薷鞲鞴")
("jp" "蔺")
("jq" "蘑芩菪")
("jr" "芥靳芹萧薪莹荞荃荠菥蕲鞒")
("js" "鞍共黄萎荽萁萋蒌蕻")
("jt" "芭靶苞蓖苍范花荒藐莎蔬芜巷靴艺苑艽芄芑芗芫苊芘苋芤茏荛茈茺莸莞莼菟菀葩甍蔸蔻蓼薨觏觐鞔")
("ju" "蔼曹藩葛藉菌蕾苗暮蔷薯昔蓄茵芝著苷苜茜茴莓菖萏菰葙蒈蓍蒹蓿蕤瞢蕃沓")
("jv" "蔡恭莲慕蓬水蒜藤莛荥荪萘萦藜蘧蘩淼綦鞑")
("jw" "萨")
("jx" "茧萤")
("jy" "藏茎蓝芒茫茂蔑蕴廿芷芪苎苤苴茕苠茳荭莪莅莶菹葳蒇萱蕺薤靼")
("jz" "茨菲颧苁芡苄苡荑莰萸蒉蓣蔌蕨蘼颟")
("ka" "彼惩怠德伎假仅俊您侵傻役悠偬後恁愆皴")
("kb" "倔仙岱徭")
("kc" "堡催佳垒任仕侄俚傩僮垡隹雠")
("kd" "傍彻传仿份佛伶仍伤伺伟伪仂仞佝佟侉俜彷徇鸺鹪隽")
("ke" "伙仰御邰炱煲")
("kf" "倍估侣售俗台像信佑伽佶偌倌倨僖儋")
("kg" "袋很依伥侬偎儇")
("kh" "促徒徙")
("ki" "伏侯候侠矣佚俣俟倏")
("kj" "侧待倒得俘俯傅付何衡街例俐侍停偷衔行衙衍倚仔劁仃伢俦衢")
("kk" "偿侩亻仫厶彳")
("kl" "保集焦傈僳体熊休徐侏倮僬徕黛")
("km" "伴华件律牟僻仟什佯仵佴侔俸倬俾弁徉牮隼")
("kn" "侈")
("ko" "傲便侗徽俩偶佩偏俏儒使倘微仪佣仗做伛攸侑佾佼俪俑倩倜偃儆徜徵徼")
("kp" "们")
("kr" "价侨伸往仲住侪徨")
("ks" "供俱佞倭偻傧")
("kt" "俺参仇化侥倦傀佬伦能倪凭他修伊亿优允仉仡仳佤伧伉佗伲侃佻傥僦毵")
("ku" "佰伯倡储佃徊借儡僧侮循偕偈僭畚")
("kv" "傣健僚你俅傺")
("kw" "俨")
("ky" "代但低俄伐俭僵径仁叁位伍征值佐仨伫倥徂")
("kz" "贷货赁徘仆倾似债侦作佧俳偾")
("la" "板愁椒棱秘权穗梭稳想枝杈椴懋稔稷馥")
("lb" "嵇")
("lc" "杜桂榷稚桩椎栌柽桎棰槿樘")
("ld" "榜构楞棉柿梯稀朽秀杨杓杩枥枋栉枵柃枸栲栩棼榻樗秭")
("le" "梆郴焚榔柳秋椰棂楸")
("lf" "椽格棺和枷稼秸桔枯檬梧橡杏栝梏椐榀榕橼檐稆黏")
("lg" "根枨榱稂穰")
("lh" "楚樾")
("li" "樊模楔秧秩椟楱")
("lj" "材橱村季柯李利柠攀树椅榆杼桁桴椁榭樽稃")
("lk" "私松桧")
("ll" "本杰棵梨林木森术株榇榛樵灬秣秫稞黧")
("lm" "稗棒秤杆秆科犁样樟杵枰桦梓棹楫榉榫槔槲樨")
("ln" "秽梦移椤")
("lo" "柄稠档枫稿梗柜极框枚棚梢稍枢桐桶椭檄校栅杖枘柩桷楠榧槁榍橄檎橘")
("lp" "榈")
("lq" "柘")
("lr" "程桥栓枉析种柱柙")
("ls" "横积婪楼棋委樱枳桉槟稹")
("lt" "彬概棍杭槐机麓秒穆枪橇杉梳税桃秃桅魏札枕杌杞枇杪枧杷栊栀柁栳桡桄桤梵桫榄秕")
("lu" "柏槽椿稻柑稽楷榴梅栖相香杳柚桕楮楣槠樯橹檑穑皙")
("lv" "杯标称栋禁黎黍棕柰栎梃椋楗棣楝槌檩檫")
("ly" "查橙杠桓检槛栏檀械栈植租柢桠椹楂槎楦楹槭")
("lz" "核朴颓榨柞枞柝桢橛")
("ma" "被翅轰惠友支嘏勰辍祓衩裰")
("mc" "基垄堑社雄在墼轳轾衽")
("md" "办帮勃布初带韩翰驾勘力切协枣专转轫祠鸠鸪鸫鹁鹕裼")
("me" "邦邯灰祁郁郏")
("mf" "古加裙辖右裕轱轺辂軎祜禧袷袼裾褡")
("mg" "囊丧袭辕辗禳裉裱袈裘")
("mi" "袄夫袱夹卖献奏轶辏祆禊袂")
("mj" "博才衬刺存祷褥事寿输孛剌哿轲轷襻")
("mk" "祛")
("ml" "架来裸某秦袜杂椠橐焘禚褓")
("mm" "车奉辜卉辑裤聋十斡祥轩斟卅辇辚礻禅衤袢裨")
("mn" "錾")
("mo" "朝敷甫辅故胡祸较救吏辆南期有丈辙辋敕衲裆褙褊襦")
("mp" "裥")
("mq" "砻衿")
("mr" "轿祈神斯斩辁裎")
("ms" "龚妻其真轵祺褛")
("mt" "规轨辊兢九克礼龙轮袍七乾衫视屯丸旭也尤轧祝馗尢尥尬尴轭轸辄辘祀祧褫")
("mu" "春辐福甘褐替袖暂轴啬辎旮褚褶舂")
("mv" "东棘柬襟禄求束索泰褪轹祢裢")
("mx" "蠢襁蠹")
("my" "裁矗戴截盔轻甚袒栽哉载整直祖左轼戟戡祉祗裣褴")
("mz" "补颠顿褂贺颊赖欺软爽夷贲赉赍祚祯")
("na" "惫镀锻饭急馒镊鳃怨皱馊钗钣钹铋铍锓锪锶锼锾镘镬镱鲅鲮鲰鲶鳆鳗")
("nb" "鳐")
("nc" "雏锤鲤锥饪馑钍铿锂锉镗锺雒鲈鲑鲣")
("nd" "镑馋锄钓冬钙钩锦钧铃饰饲锑钨务锡夕锈鸳饧饬钫钸铈铐铞铴铹锔锷镌镯觞鲂鳄鳎鳓")
("ne" "灸铆锹炙邹钬铘锬鲫鳅")
("nf" "铬各馆咎锯铝铭名铅象詹钻饴彖钴铪铷锆锘锫镓鲇鲐鲒鳝")
("ng" "镶铱银飧馕锒锿")
("nh" "锭镟")
("ni" "镁铁奂饫馍钛铗锲镆镞镤觖")
("nj" "钉铡争铸饽钊钌钶铮锊锕锝锵镎鲋鲟鲥鳟")
("nk" "铉铥")
("nl" "钵镍然煞条馀桀铢铩铼锞镳稣鲦鲽")
("nm" "饼饵锋解鳞钎鲜锌彝针舛钭铎铒铧锛镡斛觯鲆")
("nn" "多金锣饣钅鑫")
("no" "钢镐锅铰角饺钠铺铜销钥刍饷馓钜钷铕铛锖镉镛镝镦鲔鲕鲛鲠鲡鲭鲷鳊鳕鳙")
("np" "钔锎锏镧")
("nq" "钤")
("nr" "钾钟钏钰铨锃镩鲚鳇")
("ns" "馁镇夤馔钕铵镂镔")
("nt" "饱鲍钞钝钒龟饥镜免勉饶锐色兔危铣饨馄彘钆钇钐钪钯铊铌铑铙铠铫铯铳锍锟锩觥鱿鲩鲲鲵")
("nu" "备铂处错久镭镰馏鲁锚钳馅铀锗夂昝眢钼钿铟锢锱锴锸镅镏镥镨觚鲳鲴鲻鳍")
("nv" "祭键鲸链镣钚铄铤镖镙镲觫鲢鲧鳏鳔")
("nw" "铲")
("nx" "触蚀蟹镪螽蠡鳋")
("ny" "饿饯锰钮钱鱼饩馇馐钲钺钽铖铽锇镒镫鲺鳢")
("nz" "钡负馈欠钦锁外锨饮钋镄镢鲱鲼鳜")
("oa" "贩凤服腹股殴腮悬臆肢臌慝骰")
("ob" "罂")
("oc" "雕肚胜膛腥臃赃脏胪脞塍膣")
("od" "膀肠赐肪肺购胯肋鸥鹏腾希胁胸匝帚助赅肟朐腭鹦翳鹘髑")
("oe" "脚灵郄郗郾酆赕")
("of" "胳赂匿赔赡膳胎贴同周叵豳贻豚膪朦骷骺骼髂")
("og" "脓账胀赈")
("oh" "腚")
("oi" "肤膜赎医肽朕腠")
("oj" "脖膊财腑刚刹删则肘刈赙刖脬腧")
("ok" "县幽肱脍")
("ol" "杀熙脎脒臊髁")
("om" "肝胖脾用肼胼膦髀")
("on" "夙")
("oo" "败册风脯冈骨贿胶脑朋区网凶腋爻匾肭肴胴脶腈腩膈")
("or" "臣凰匠匡脐匣肿胛胂骱")
("os" "胺具腆腰婴媵膑髅髌")
("ot" "肮胞脆肥肌见膨匹甩彤脱腕匦鬯瓯贶肜朊肫胧胗胱脘腌飑飓飕飚髋")
("ou" "贬赌腊赠脂赚胍胭腼臁")
("ov" "膘脉赊髓腿膝腺凼赇胨脲腙腱滕")
("oy" "丹胆赋肛贱巨脸皿腻胚腔且月贼贮罔弑彐胝胫腽膻骶")
("oz" "贝匪骸内欧肉卧颐胰匮赜赆肷胩胙胲腓腴欷")
("pa" "缎缓闷缀阌绂绫绶缌缦")
("pb" "绌")
("pc" "缠闺维缍")
("pd" "闯缔纺纷幻绵闹纫纬绣绚幼约终闱阏绋绔绨鸶鹇")
("pe" "绑")
("pf" "阁给结阔络缮绍问缘辔闾绐绺绾")
("pg" "阆缳飨")
("ph" "绽缇")
("pi" "续阕缑")
("pj" "闭缚纡纣纾绗绮缛")
("pk" "绘闳纭幺")
("pl" "绦闲缫缲")
("pm" "绊阐绰缉闻纤绎绛缂")
("po" "绷编绸纲级缴绞绢纳纹闵阚绉绠绡绱缏缟缡")
("pp" "门纟")
("pr" "纠闰绅闸")
("ps" "缕绥缨织阒阗缜缤")
("pt" "纯纪绝缆纶绕纱绳统乡阉阅闶阄阋纥纨纰绲绻缈缪")
("pu" "间缅缩细绪阎阃阊阍绀缁缃缗缙缣缯")
("pv" "缝阑练绿综闼缒缥缧缭缱糸")
("pw" "纩")
("px" "闽")
("py" "阀红继缄经纽绒丝线纸组闩闫阈阖绁缢缰畿")
("pz" "阂绩闪纵绯缋缬缵")
("qa" "忌骏皮破恿驭骢愍")
("qb" "础")
("qc" "硅驴骓碓")
("qd" "磅骋弗弓劲驹码马乃砌弱书勇粥砖勐弼驽骛骟砀砺砩碲鹜鹬")
("qe" "郡碳")
("qf" "君骆豫砧骤骀硌碚礞")
("qg" "碾张骧磙")
("qh" "碇疋")
("qi" "癸买驮硖")
("qj" "碍剥导了矛骑寻予孕子刭孑孓驸骣砑硎礴")
("qk" "磁弘弦砝")
("ql" "碟礁柔骒磔磉磲")
("qm" "碑弹磷砰群碎研异弭驿骅骈犟聿矸砗")
("qn" "矽鍪")
("qo" "驳碉改函及硼骗驱确孺驶硝硬砸孜鬻驺骊砜砹硐碥礅甬胥")
("qq" "磊石矜")
("qr" "骄砷肃驯引驻鼐肀斫")
("qs" "碘磺巽婺骐骥")
("qt" "弛驰凳矾己孔硫砒砂疏巳驼碗砚已尹卺巯艴孢骁骖矶砘砣硗碜")
("qu" "承孤弧硒驷骝砭硇碡碣瞀")
("qv" "泵砾隶碌录骡弥孙尕骠礤")
("qw" "矿")
("qx" "蛋强骚蝥蟊")
("qy" "碴丑磋登碱硷疆磕孟民碰验盈丞亟弪驵戤砼砥砬硭硪碹磴礓")
("qz" "费孩骇颈砍颇硕预阙砟碛")
("ra" "悲毖玻患瑟忠帔幔瑗瑕瑷璁")
("rb" "瑶")
("rc" "幢坚理帷幄瑾璀")
("rd" "卜畅巾玲玛师帅鸯与玉冂帏玮玢翡")
("re" "邮邶邺琊琰鬏")
("rf" "帖琢玷珈珞琚瑭璩璐髫髻")
("rg" "长琅裴帐鬟")
("rh" "璇")
("ri" "央奘帙幞瑛璞")
("rj" "刂帱玎珂珩琦瑜")
("rk" "珐")
("rl" "琳珠琛璨髹")
("rm" "辈毕弄肆芈幛珥珲璋")
("rn" "鉴")
("ro" "背归瑚璃玫冉瑞珊肾史收凿玟斐黹黻黼髯")
("rq" "碧琴")
("rr" "斑班串断申王中丨凵爿珏")
("rs" "典冀帜珙琪璜璎鬓")
("rt" "北比毙电帆瑰幌览琉琶琵玩现珍玑珑珧琥琨琬髟髡髦髭鬈")
("ru" "幅皆旧临帽帕曲由帼幡珀瑁瑙")
("rv" "环紧琼球鬃琏琮")
("rx" "蜚")
("ry" "盎监韭世竖业曳盅戕玳珉鬣")
("rz" "非贵玖琐贤以帧帻顼瓒贳")
("sa" "慈忿妓奴怒嫂恕媳总媛嫒恙羧")
("sb" "岔")
("sc" "妒妊塑娃姓坌娌")
("sd" "弟妨分剪羚妈奶努翁翔爷兮帑弩妁姊妫娉娣嫣嫦蠲鹆鹈鹚鹣翦")
("se" "郸娜郑鄯羰")
("sf" "姑谷嫁如善始兽嬉")
("sg" "娘娠冁婊")
("sh" "婕")
("si" "奠羹关嫉美妖娱嫫猷")
("sj" "好前剃尊妤婀婷孥孳")
("sk" "公兹嬷")
("sl" "羔煎媒妹姝槊")
("sm" "并单奸羊妍姘婢婵嫜")
("sn" "爹釜")
("so" "嫡父妇姬娟嫩朔婿妪姗姣娲婧胬媾")
("sp" "娴")
("sq" "妗")
("sr" "斧娇婶养")
("ss" "八姜女嫔")
("st" "爸兑姥娩妙妮瓶羌她婉瓮姚妃妩妣娆姹娓媲甑")
("su" "婚兼媚姆普酋首嫌姻曾着妯娼嫱孀羯")
("sv" "絮嫖嫘")
("sx" "媸")
("sy" "差娥盖姐兰盆羞益馘妞妲娅媪嬗羝羟羲")
("sz" "颁贫歉颂羡姨欲姒")
("ta" "爱般版段发反忽毁受艘息悉殷鼗叟爰殳憩皈鹱舨")
("tb" "岳岙舢")
("tc" "垂牡壬生牲重舻艟")
("td" "翱豹币帛匆岛的甸鹅翻躬勾舅句卵鸟乓勺甥乌物勿匈旬粤匀乜勹匍訇匐劬巛鸨鸲鸱鸹鹄鹎鹞舄舫鼢")
("te" "卯卿邱印邬邸邾郇郜郛郫鄱爨")
("tf" "船告貉后舌吞牯牾牿皓艨貂鼯")
("tg" "袅")
("th" "疑")
("ti" "奥臭犊失夭奚牍貘鼷")
("tj" "豺掣剁孵刮乎剿爵刨射身剩手特制刎劓孚犄掰搿舸")
("tk" "丢么舷")
("tl" "采巢躲朵皋禾熏朱枭牒臬貅")
("tm" "拜卑辞阜牛牌千升释舜衅肄睾廾舁鼾")
("tn" "够")
("to" "敌牧躯躺向禹舟犏犒敫牖皎舣艄")
("tq" "磐")
("tr" "鼻川乖皇斤片乔所玺璺舯")
("ts" "兵妥舆犋鼹")
("tt" "皑包彩舱兜舵儿凡鬼航几舰魁乱毛貌觅乒魄乳毯鸵皖先皂毡兆丿匕乇卮胤凫彡邕牝牦毪毳毽氇氆虢舭艉貔魅魃魉魈魍魑鼽")
("tu" "白舶囱盾乏番瓜昏臼看留爬甜牺舀釉旨爪自囟甾眚皤瓞舳舾艏艚貊鼬")
("tv" "秉乘尔乐泉舔艇系犍繇")
("tw" "豸")
("ty" "盘丘氏鼠我血氐盥舐衄舡艋齄")
("tz" "斥靠贸顺欣须颖赞质歃颀颍臾舴")
("ua" "恩恳曼暖思暇愚最矍暧睃瞍畈黢")
("ub" "黜")
("uc" "垦里量墨睦畦墅睡瞳星曜眭睚睢瞠疃罹雎瞿")
("ud" "母男盼蜀图围鸭易勖囫囹嬲昀眄睇羁黝")
("ue" "昂瞅即炅昴")
("uf" "固回略晤瞎瞻昭圄晗晷眙罟詈黠")
("ug" "晨匙畏眼圜曩艮")
("uh" "睫是题韪")
("ui" "默因映昊暌睽畎黩")
("uj" "畴盯罚畸时剔团野睁囝盱町")
("uk" "罢眩昙")
("ul" "睬果黑困昧眯瞧照杲曛煦睐罴")
("um" "旱畔瞬田晕早罩圉旰晔晖眸睥瞵")
("un" "罗夥眵黟")
("uo" "睛眶瞒明圃晴晌胃瞩禺囿圊晡暾胄眍瞰畋罱")
("uq" "黔")
("ur" "鼎国甲界旺晰昕畀")
("us" "囡晏暝瞑")
("ut" "巴囤晃既昆冕毗圈入四眺晚毋晓影园兕囵旯昵晁氍盹眇眈眦睨畛畹罨黪")
("uu" "暗凹昌睹晦晶冒瞄晒暑曙署凸眨曷罾黯")
("uv" "暴景累晾曝瞟罘黥")
("uw" "旷")
("uy" "旦瞪盟眠目日显曰置戥昱晟暄曦睑瞌罡暨")
("uz" "贯颗囚歇圆罪昨颢")
("va" "返逡遐")
("vb" "遥")
("vc" "尘雀廷逵暹")
("vd" "边递迹劣迈透违巡遢")
("ve" "迎逖")
("vf" "遣适遂迢造逐追迦迨逅逭遽邃")
("vg" "退")
("vi" "达迭尖送")
("vj" "过辽迂逾遵迓")
("vk" "运")
("vl" "迷述途遮")
("vm" "迸避逢建进连迁迕逄遴邂")
("vn" "逻")
("vo" "遍通邀遇这迥逋逦逍遄遨遘")
("vr" "逞逛近逝遑")
("vs" "逶")
("vt" "逆迄少逃选逸远迤邈")
("vu" "逼迟道迪遁遏迫省遭遒遛")
("vv" "逮还速小逊廴辶迩逑逯尜")
("vy" "逗迅延迳邋")
("vz" "遗迮")
("wa" "度废感疲瘦厦疫愿狻庋痣瘕瘛瘢瘾癔癜")
("wb" "癌疝")
("wc" "厘狸庐瘫猩压雁庄座狴獾廑廛痤瘗癃癯")
("wd" "狗厉励历狮疼席疡鹰犸狒鹧疖疠疬痨瘀")
("we" "狄廓廊痰邝")
("wf" "痴唇瘩店痞唐狺猞痂痦瘃")
("wg" "辰痕狠狼猿猥餍")
("wh" "蹙")
("wi" "猴痪疾庆狭厌狱瘊瘼")
("wj" "厕厨府厚痢疗摩狞辱厅序狰痔劂狩猁猗疔疴瘌麝")
("wk" "狯痃麽")
("wl" "床麻糜庶狳猓猱獯庥橥麇麋")
("wm" "瘁库癣痒瘴厍犴猝獐獬庠庳廨瘅癖麟")
("wn" "猡鏖")
("wo" "病猜疯腐猾狡疟瘸痛痈庸狷猢猬廒膺瘠")
("wp" "痫")
("wq" "磨")
("wr" "痹疥狂痊厣厮狎疰癍麈")
("ws" "痿瘘癀瘿麒")
("wt" "疤庇瘪疮疵厄犯疙厩廖鹿魔庞犹疹犰狁狍猊獍庀庑庖庵疣疱痧瘳魇麾麂")
("wu" "猖狐疚廉猎瘤猫庙厢猪厝靥猸庹疳痼")
("wv" "康庭原狲猕獠廪瘭瘰瘵縻")
("ww" "厂犭犷")
("wx" "独瘙蜃")
("wy" "成底痘痉狙疽猛戚盛戍威瘟戊咸戌应症狃狨猃猹臧疸痖瘥")
("wz" "狈庚顾靡獭仄厥赝獗庾赓痄痍痱瘐癞癫")
("xa" "蝮螋螅蟋蟪蠖蠼簸")
("xc" "蛙蛏蛭蝰螳笙")
("xd" "第筋蚂筛蛎蛉蚴蛳蜴螃笃笫笏笱笥筠")
("xe" "螂筇")
("xf" "答蛤管蜘篆蛄蛞螗蟓蟮蠓蟾笤笳笞筘箬")
("xi" "簇筷笑蚨蛱蜈蟆篌")
("xj" "簿筹等符箭蚜蚵蜊蜉蝓蝣竽筝")
("xk" "篡蚣")
("xl" "笨蝶蛛蜍蜾蝾螓篥")
("xm" "蚌蝉蜂竿算蚪蛘蛑蜱蝌蟒蟑蟀笄筚箨箪簟")
("xn" "箩")
("xo" "篙箍蝴筐篱篇蠕筒蚊蜗蚁蛹蚋蚺蛟蛸蜻蜩蝻蝙螨螭笈笸筻筲筱箐箧篝篚")
("xp" "简")
("xr" "蝗蛀蚧蚓蛴蜥筌箅箫篁簖")
("xs" "簧箕篓螟蜞蝼蟥")
("xt" "笆笔笼蛇笋蜕蝇筑虬虮虼蚍蚬蚝蛲蜣蜷蜿蟛笕筅筢箢篦篪篼簏")
("xu" "箔笛蛔籍蜡箱蝎蚶蚰蛐蝈蝽蝠蝤螬蟠蠊笊箸箝簪籀")
("xv" "策螺篷蜒纂蜓螈螵笾筵")
("xx" "虫")
("xy" "蛾筏蛊虹笺篮签蛆虻蚯蜮蜢蠛竺笪笠筮箜箴篾簋簦")
("xz" "虾蚱笮箦篑簌籁")
("ya" "聪恶覆憨惑恐聂取酸霞夏殁忑恧豉")
("yc" "霍型醒雅至垩霪霾")
("yd" "动酚功亏零聘巧万雾殉鸦焉酌丐劢殇鸢鸸鹂鹉聆翮雩雳霈")
("ye" "耿聊灭邪邢耶邗邛邴邳郅郦鄄鄢鄹酃")
("yf" "殆否聚酷酪露吾聒酤酩醅醣醵")
("yg" "裂酿震餮")
("yh" "醍趸跫")
("yi" "联酞天殃醭")
("yj" "醇寸到丁副哥划酵刊可列耐刑牙于亍孬剽殍耵聍酊酎酹")
("yk" "云酝")
("yl" "栗烈霖殊酥粟臻酴醮醺")
("ym" "耳干歼开霹平醉殚覃酐")
("yn" "歹銎")
("yo" "霸甭丙而敢更攻丽两飘酮霄需酗雪雨再政致鬲聃酾醐醑雯霰")
("yr" "酬画醛丌亓酲霁")
("ys" "娶耍要职殡霎")
("yt" "雹耽巩魂霓配翘死瓦豌无形尧乙元甄兀殄觋虺酏酡酰醌醪鼋")
("yu" "百醋酣晋雷酶霉面瓢霜西酉酯霭")
("yv" "不汞醚票示忝霆")
("yw" "严酽")
("yx" "蚕融虿蛩")
("yy" "残耻豆二贰飞戈工互或戒戎三虱式歪巫武五亚一盂盏正殖丕亘噩匚弋忒甙殂殓殛殪戋戛戬豇醢醯醴")
("yz" "顶歌贡贾顽下项页殒昃聩顸颞颥酢霏")
("za" "复虑念歧叔怂叙愈怎攴忐")
("zb" "缶")
("zc" "雌罐卢坐壑矬雉龌")
("zd" "鸽龄令虏鸬翎翕")
("ze" "邻命卸郐")
("zf" "含合舍占知訾龆龉")
("zg" "餐食衾龈")
("zh" "龊")
("zi" "缺矢虞")
("zj" "创刽剑拿舒俞竹罅")
("zk" "会")
("zl" "柴点余桌籴榘粲")
("zm" "年伞耸午舞斜卓颦")
("zo" "齿脊矩肯敛敏虐禽龋龠攵虔觜")
("zq" "今砦")
("zr" "个矫介全矧")
("zs" "矮")
("zt" "彪步仓此虎仑乞毓乩瓴觇觎觑毹龛虍龀龅龇")
("zu" "督卤每智卣睿畲")
("zv" "繁紫氽佘汆")
("zy" "氨丛氮短氛氟缸氦盒氯氖企气氢氰上些虚氧战止仝佥俎戗氕氘氙氚氡氩氤氪氲鹾龃鳘")
("zz" "从卡领颅频顷人贪乍贞众赀欤歙颌颔")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:
