/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.sclibrary;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.user.User;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SCLibraryGen {
    private final EditingPreferences ep;
    private String purpleLibraryName = "purpleFour";
    private String redLibraryName = "redFour";
    private String scLibraryName = "sclib";
    private Library purpleLibrary;
    private Library redLibrary;
    private Library scLibrary;
    private List<StdCellSpec> scellSpecs = new ArrayList<StdCellSpec>();
    private PrimitiveNode pin;
    private Variable.Key sizeKey;
    public static final Variable.Key STANDARDCELL = Variable.newKey("ATTR_StandardCell");
    public static final Variable.Key DONOTEXTRACTFORDSPF = Variable.newKey("ATTR_ExcludeFromDSPFExtraction");
    private static final int blueColorIndex = EGraphics.makeIndex(Color.blue);

    public SCLibraryGen(EditingPreferences ep) {
        this.pin = Generic.tech().invisiblePinNode;
        this.sizeKey = Variable.findKey("ATTR_X");
        this.ep = ep;
    }

    public void setPurpleRedLibs(String purpleLibraryName, String redLibraryName) {
        this.purpleLibraryName = purpleLibraryName;
        this.redLibraryName = redLibraryName;
    }

    public void setOutputLibName(String name) {
        this.scLibraryName = name;
    }

    public void addStandardCell(String type, String sizes) {
        if ((sizes = sizes.trim()).equals("")) {
            return;
        }
        String[] ss = sizes.split("\\s+");
        double[] sss = new double[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            sss[i] = Double.parseDouble(ss[i]);
        }
        this.scellSpecs.add(new StdCellSpec(type, sss));
    }

    public boolean generate(StdCellParams sc, String libraryName) {
        this.purpleLibrary = Library.findLibrary(this.purpleLibraryName);
        if (this.purpleLibrary == null) {
            this.prErr("Purple library \"" + this.purpleLibraryName + "\" is not loaded.");
            return false;
        }
        this.redLibrary = Library.findLibrary(this.redLibraryName);
        if (this.redLibrary == null) {
            this.prErr("Red library \"" + this.redLibraryName + "\" is not loaded.");
            return false;
        }
        this.prMsg("Using purple library \"" + this.purpleLibraryName + "\" and red library \"" + this.redLibraryName + "\"");
        this.scLibraryName = libraryName;
        this.scLibrary = Library.findLibrary(this.scLibraryName);
        if (this.scLibrary == null) {
            this.scLibrary = Library.newInstance(this.scLibraryName, null);
            this.prMsg("Created standard cell library " + this.scLibraryName);
        }
        this.prMsg("Using standard cell library " + this.scLibraryName);
        sc.enableNCC(this.purpleLibraryName);
        for (StdCellSpec stdcell : this.scellSpecs) {
            for (double d : stdcell.sizes) {
                Cell schcell;
                String cellname = sc.sizedName(stdcell.type, d);
                Cell laycell = this.scLibrary.findNodeProto((cellname = cellname.substring(0, cellname.indexOf(123))) + "{lay}");
                if (laycell == null && (laycell = GateLayoutGenerator.generateCell(this.scLibrary, sc, stdcell.type, d)) == null) {
                    this.prErr("Error creating layout cell " + stdcell.type + " of size " + d);
                    continue;
                }
                Cell iconcell = this.scLibrary.findNodeProto(cellname + "{ic}");
                if (iconcell == null) {
                    this.copyIconCell(stdcell.type, this.purpleLibrary, cellname, this.scLibrary, d);
                }
                if ((schcell = this.scLibrary.findNodeProto(cellname + "{sch}")) == null) {
                    this.copySchCell(stdcell.type, this.purpleLibrary, cellname, this.scLibrary, d, this.ep);
                }
                schcell = this.scLibrary.findNodeProto(cellname + "{sch}");
                ArrayList<Cell> cells = new ArrayList<Cell>();
                cells.add(schcell);
                SCLibraryGen.markStandardCell(cells, null);
            }
        }
        return true;
    }

    private boolean copyIconCell(String name, Library lib, String toName, Library toLib, double size2) {
        Cell iconcell = toLib.findNodeProto(toName + "{ic}");
        Cell fromIconCell = lib.findNodeProto(name + "{ic}");
        if (iconcell == null && fromIconCell != null) {
            iconcell = Cell.copyNodeProto(fromIconCell, toLib, toName, false);
            if (iconcell == null) {
                this.prErr("Unable to copy purple cell " + fromIconCell.describe(false) + " to library " + toLib);
                return false;
            }
            NodeInst sizeni = NodeInst.makeInstance(this.pin, this.ep, EPoint.ORIGIN, 0.0, 0.0, iconcell);
            sizeni.newVar(Artwork.ART_MESSAGE, (Object)new Double(size2), this.ep.getAnnotationTextDescriptor().withColorIndex(blueColorIndex));
            Iterator<Geometric> it = iconcell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                ai.newVar(Artwork.ART_COLOR, (Object)new Integer(blueColorIndex), this.ep);
            }
            it = iconcell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.newVar(Artwork.ART_COLOR, (Object)new Integer(blueColorIndex), this.ep);
            }
            if (iconcell.isParam(this.sizeKey) && iconcell.getCellGroup() != null) {
                iconcell.getCellGroup().delParam((Variable.AttrKey)this.sizeKey);
            }
        }
        return true;
    }

    private boolean copySchCell(String name, Library lib, String toName, Library toLib, double size2, EditingPreferences ep) {
        Cell schcell = toLib.findNodeProto(toName + "{sch}");
        Cell fromSchCell = lib.findNodeProto(name + "{sch}");
        if (schcell == null && fromSchCell != null) {
            Cell np;
            NodeInst ni;
            Iterator<NodeInst> it;
            schcell = Cell.copyNodeProto(fromSchCell, toLib, toName, false);
            if (schcell == null) {
                this.prErr("Unable to copy purple cell " + fromSchCell.describe(false) + " to library " + toLib);
                return false;
            }
            Cell iconcell = toLib.findNodeProto(toName + "{ic}");
            Cell fromIconCell = lib.findNodeProto(name + "{ic}");
            if (iconcell != null && fromIconCell != null) {
                it = schcell.getNodes();
                while (it.hasNext()) {
                    ni = it.next();
                    if (!ni.isCellInstance() || (np = (Cell)ni.getProto()) != fromIconCell) continue;
                    ni.replace(iconcell, ep, true, true, true);
                }
            }
            if (schcell.isParam(this.sizeKey) && schcell.getCellGroup() != null) {
                schcell.getCellGroup().delParam((Variable.AttrKey)this.sizeKey);
            }
            if (schcell.getVar(Verilog.VERILOG_TEMPLATE_KEY) != null) {
                schcell.delVar(Verilog.VERILOG_TEMPLATE_KEY);
            }
            it = schcell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                if (!ni.isCellInstance()) continue;
                np = (Cell)ni.getProto();
                if (np.getLibrary() == this.redLibrary && ni.isDefinedParameter(this.sizeKey)) {
                    ni.updateParam(this.sizeKey, size2, ep);
                }
                if (!np.isIconOf(schcell)) continue;
                ni.delParameter(this.sizeKey);
            }
        }
        return true;
    }

    public static void markStandardCellJob(List<Cell> standardCells, List<Cell> notStandardCells) {
        CreateVar job = new CreateVar(standardCells, notStandardCells, STANDARDCELL);
        job.startJob();
    }

    public static void markStandardCell(List<Cell> standardCells, List<Cell> notStandardCells) {
        CreateVar job = new CreateVar(standardCells, notStandardCells, STANDARDCELL);
        job.doIt();
    }

    public static void markDoNotExtractForDSPFJob(List<Cell> cells) {
        CreateVar job = new CreateVar(cells, null, DONOTEXTRACTFORDSPF);
        job.startJob();
    }

    public static Set<Cell> getStandardCellsInHierarchy(Cell topCell) {
        StandardCellHierarchy cells = new StandardCellHierarchy();
        HierarchyEnumerator.enumerateCell(topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)cells);
        return cells.getStandardCellsInHier();
    }

    public static boolean isStandardCell(Cell cell) {
        Cell schcell = cell.getMainSchematicInGroup();
        if (schcell != null) {
            cell = schcell;
        }
        return cell.getVar(STANDARDCELL) != null;
    }

    public static boolean isMarkedDoNotExtractForDSPF(Cell cell) {
        Cell schcell = cell.getMainSchematicInGroup();
        if (schcell != null) {
            cell = schcell;
        }
        return cell.getVar(DONOTEXTRACTFORDSPF) != null;
    }

    private void prErr(String msg) {
        System.out.println("Standard Cell Library Generator Error: " + msg);
    }

    private void prMsg(String msg) {
        System.out.println("Standard Cell Library Generator: " + msg);
    }

    public static class StandardCellHierarchy
    extends HierarchyEnumerator.Visitor {
        private static final Integer standardCell = new Integer(0);
        private static final Integer containsStandardCell = new Integer(1);
        private static final Integer doesNotContainStandardCell = new Integer(2);
        private Map<Cell, Integer> standardCellMap = new HashMap<Cell, Integer>();
        private Map<String, Cell> standardCellsByName = new HashMap<String, Cell>();
        private List<VarContext> standardCellContexts = new ArrayList<VarContext>();
        private Map<VarContext, VarContext> emptyCellContexts = new HashMap<VarContext, VarContext>();
        private Map<VarContext, VarContext> containsStandardCellContexts = new HashMap<VarContext, VarContext>();
        private Set<Cell> doNotExtractForDSPF = new HashSet<Cell>();
        private boolean nameConflict = false;

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (SCLibraryGen.isMarkedDoNotExtractForDSPF(cell)) {
                this.doNotExtractForDSPF.add(cell);
            }
            if (this.standardCellMap.get(cell) == doesNotContainStandardCell) {
                this.emptyCellContexts.put(info.getContext(), info.getContext());
                return false;
            }
            if (SCLibraryGen.isStandardCell(cell)) {
                this.standardCellContexts.add(info.getContext());
                if (!this.standardCellMap.containsKey(cell)) {
                    this.standardCellMap.put(cell, standardCell);
                    Cell otherCell = this.standardCellsByName.get(cell.getName());
                    if (otherCell != null && otherCell != cell) {
                        System.out.println("Error: multiple standard cells with same name not allowed: " + cell.libDescribe() + " and " + otherCell.libDescribe());
                        this.nameConflict = true;
                    } else {
                        this.standardCellsByName.put(cell.getName(), cell);
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell proto;
            NodeInst ni;
            Cell cell = info.getCell();
            VarContext context = info.getContext();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                proto = ni.getProtoEquivalent();
                if (proto == null) {
                    proto = (Cell)ni.getProto();
                }
                if (!this.containsStandardCell(proto) && this.standardCellMap.get(proto) != standardCell) continue;
                this.standardCellMap.put(cell, containsStandardCell);
                this.containsStandardCellContexts.put(context, context);
                return;
            }
            this.standardCellMap.put(cell, doesNotContainStandardCell);
            this.emptyCellContexts.put(context, context);
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = it.next();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                proto = ni.getProtoEquivalent();
                if (proto == null) {
                    proto = (Cell)ni.getProto();
                }
                if (this.standardCellMap.get(proto) != doesNotContainStandardCell) continue;
                VarContext nicontext = context.push(ni);
                this.emptyCellContexts.remove(nicontext);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public boolean containsStandardCell(Cell cell) {
            return this.standardCellMap.get(cell) == containsStandardCell;
        }

        public Set<Cell> getStandardCellsInHier() {
            return this.getCells(standardCell);
        }

        public Set<Cell> getContainsStandardCellsInHier() {
            return this.getCells(containsStandardCell);
        }

        public Set<Cell> getDoesNotContainStandardCellsInHier() {
            return this.getCells(doesNotContainStandardCell);
        }

        public boolean getNameConflict() {
            return this.nameConflict;
        }

        public List<VarContext> getStandardCellsContextsInHier() {
            return this.standardCellContexts;
        }

        public Set<String> getContainsStandardCellContextsInHier() {
            Set<VarContext> contexts = this.containsStandardCellContexts.keySet();
            TreeSet<String> sorted2 = new TreeSet<String>();
            for (VarContext context : contexts) {
                String s = context.getInstPath("/");
                sorted2.add(s);
            }
            return sorted2;
        }

        public Set<String> getEmptyCellContextsInHier() {
            Set<VarContext> contexts = this.emptyCellContexts.keySet();
            TreeSet<String> sorted2 = new TreeSet<String>();
            for (VarContext context : contexts) {
                String s = context.getInstPath("/");
                sorted2.add(s);
            }
            return sorted2;
        }

        public Set<Cell> getCellsMarkedToNotExtractForDSPF() {
            return this.doNotExtractForDSPF;
        }

        private Set<Cell> getCells(Integer type) {
            TreeSet<Cell> set = new TreeSet<Cell>();
            for (Map.Entry<Cell, Integer> entry : this.standardCellMap.entrySet()) {
                if (entry.getValue() != type) continue;
                set.add(entry.getKey());
            }
            return set;
        }
    }

    private static class CreateVar
    extends Job {
        private List<Cell> standardCells;
        private List<Cell> notStandardCells;
        private Variable.Key varName;

        public CreateVar(List<Cell> standardCells, List<Cell> notStandardCells, Variable.Key varName) {
            super("Create Var", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.standardCells = standardCells;
            this.notStandardCells = notStandardCells;
            this.varName = varName;
        }

        @Override
        public boolean doIt() {
            EditingPreferences ep = this.getEditingPreferences();
            TextDescriptor td = ep.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
            if (this.standardCells != null) {
                for (Cell cell : this.standardCells) {
                    cell.newVar(this.varName, (Object)new Integer(1), td);
                }
            }
            if (this.notStandardCells != null) {
                for (Cell cell : this.notStandardCells) {
                    cell.delVar(this.varName);
                }
            }
            return true;
        }
    }

    private static class StdCellSpec {
        private String type;
        private double[] sizes;

        private StdCellSpec(String type, double[] sizes) {
            this.type = type;
            this.sizes = sizes;
        }
    }
}

