/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.text.Name;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class NameImpl
extends Name {
    private static final boolean USE_STRING_NUMBER_ORDER = false;
    private final String ns;
    private NameImpl[] subnames;
    private final NameImpl basename;
    private final int numSuffix;
    private int flags;
    private static volatile NameImpl[] allNames = new NameImpl[1];
    private static int allNamesCount = 0;

    public final String toString() {
        return this.ns;
    }

    @Override
    public int compareTo(Name name) {
        return this.ns.compareTo(((NameImpl)name).ns);
    }

    @Override
    public final boolean isValid() {
        return (this.flags & 1) == 0;
    }

    @Override
    public final boolean isTempname() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean hasDuplicates() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean hasEmptySubnames() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isList() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isBus() {
        return this.subnames != null;
    }

    @Override
    public NameImpl subname(int i) {
        if (this.subnames == null) {
            if (i != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }
        return this.subnames[i];
    }

    @Override
    public int busWidth() {
        return this.subnames == null ? 1 : this.subnames.length;
    }

    @Override
    public NameImpl getBasename() {
        return this.basename;
    }

    @Override
    public int getNumSuffix() {
        return this.numSuffix;
    }

    @Override
    public NameImpl findSuffixed(int i) {
        if (i < 0 || this.basename == null) {
            return null;
        }
        String basenameString = this.basename.ns.substring(0, this.basename.ns.length() - 1);
        return NameImpl.newTrimmedName(basenameString + i, true);
    }

    static NameImpl newTrimmedName(String ns, boolean clone2) {
        return NameImpl.findTrimmedName(ns, true, clone2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NameImpl findTrimmedName(String ns, boolean create, boolean clone2) {
        NameImpl n;
        NameImpl[] hash = allNames;
        int i = ns.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] != null) {
            n = hash[i];
            if (n.ns.equals(ns)) {
                return n;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        Class<NameImpl> clazz = NameImpl.class;
        synchronized (NameImpl.class) {
            if (hash == allNames && allNames[i] == null) {
                if (!create) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return null;
                }
                if (allNamesCount * 2 <= hash.length - 3) {
                    if (clone2) {
                        ns = new String(ns);
                        clone2 = false;
                    }
                    n = new NameImpl(ns);
                    if (hash != allNames || hash[i] != null) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return NameImpl.newTrimmedName(ns, false);
                    }
                    hash[i] = n;
                    ++allNamesCount;
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return n;
                }
                NameImpl.rehash();
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return NameImpl.findTrimmedName(ns, create, clone2);
        }
    }

    private static void rehash() {
        NameImpl[] oldHash = allNames;
        int newSize = oldHash.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        NameImpl[] newHash = new NameImpl[GenMath.primeSince(newSize)];
        for (NameImpl n : oldHash) {
            if (n == null) continue;
            int i = n.ns.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = n;
        }
        allNames = newHash;
    }

    private NameImpl(String s) {
        this.ns = s;
        int suffix = -1;
        NameImpl base = null;
        try {
            this.flags = NameImpl.checkNameThrow(this.ns);
        }
        catch (NumberFormatException e) {
            this.flags = 1;
        }
        if ((this.flags & 1) == 0 && (this.flags & 0x10) != 0) {
            int l;
            for (l = this.ns.length(); l > 0 && TextUtils.isDigit(this.ns.charAt(l - 1)); --l) {
            }
            if (l == this.ns.length() - 1 && this.ns.charAt(this.ns.length() - 1) == '0') {
                base = this;
                suffix = 0;
            } else {
                base = NameImpl.newTrimmedName(this.ns.substring(0, l) + '0', false);
                suffix = Integer.parseInt(this.ns.substring(l));
            }
        }
        this.numSuffix = suffix;
        this.basename = base;
        if (this.flags == 1) {
            return;
        }
        if ((this.flags & 4) == 0) {
            return;
        }
        if (this.isList()) {
            this.makeListSubNames();
            return;
        }
        int split2 = this.ns.indexOf(91);
        if (split2 == 0) {
            split2 = this.ns.lastIndexOf(91);
        }
        if (split2 == 0) {
            this.makeBracketSubNames();
        } else {
            this.makeSplitSubNames(split2);
        }
    }

    private void makeListSubNames() {
        ArrayList<NameImpl> subs = new ArrayList<NameImpl>();
        int beg = 0;
        while (beg <= this.ns.length()) {
            int end;
            for (end = beg; end < this.ns.length() && this.ns.charAt(end) != ','; ++end) {
                if (this.ns.charAt(end) != '[') continue;
                while (this.ns.charAt(end) != ']') {
                    ++end;
                }
            }
            NameImpl nm = NameImpl.newTrimmedName(this.ns.substring(beg, end), true);
            for (int j = 0; j < nm.busWidth(); ++j) {
                subs.add(nm.subname(j));
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void makeBracketSubNames() {
        ArrayList<NameImpl> subs = new ArrayList<NameImpl>();
        int beg = 1;
        while (beg < this.ns.length()) {
            int colon2;
            int end = this.ns.indexOf(44, beg);
            if (end < 0) {
                end = this.ns.length() - 1;
            }
            if ((colon2 = this.ns.indexOf(58, beg)) < 0 || colon2 >= end) {
                NameImpl nm = NameImpl.newTrimmedName("[" + this.ns.substring(beg, end) + "]", false);
                subs.add(nm);
            } else {
                int i;
                int ind2;
                int ind1 = Integer.parseInt(this.ns.substring(beg, colon2));
                if (ind1 < (ind2 = Integer.parseInt(this.ns.substring(colon2 + 1, end)))) {
                    for (i = ind1; i <= ind2; ++i) {
                        subs.add(NameImpl.newTrimmedName("[" + i + "]", false));
                    }
                } else {
                    for (i = ind1; i >= ind2; --i) {
                        subs.add(NameImpl.newTrimmedName("[" + i + "]", false));
                    }
                }
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void setSubnames(List<NameImpl> subs) {
        this.subnames = new NameImpl[subs.size()];
        subs.toArray(this.subnames);
        Object[] sorted2 = new NameImpl[subs.size()];
        subs.toArray(sorted2);
        Arrays.sort(sorted2);
        for (int i = 1; i < sorted2.length; ++i) {
            if (!sorted2[i].equals(sorted2[i - 1])) continue;
            this.flags |= 0x20;
            break;
        }
    }

    private void makeSplitSubNames(int split2) {
        if (split2 < 0 || split2 >= this.ns.length()) {
            System.out.println("HEY! string is '" + this.ns + "' but want index " + split2);
            return;
        }
        NameImpl baseName = NameImpl.newTrimmedName(this.ns.substring(0, split2), true);
        NameImpl indexList = NameImpl.newTrimmedName(this.ns.substring(split2), true);
        this.subnames = new NameImpl[baseName.busWidth() * indexList.busWidth()];
        for (int i = 0; i < baseName.busWidth(); ++i) {
            String bs = baseName.subname(i).toString();
            for (int j = 0; j < indexList.busWidth(); ++j) {
                String is = indexList.subname(j).toString();
                this.subnames[i * indexList.busWidth() + j] = NameImpl.newTrimmedName(bs + is, false);
            }
        }
        if (baseName.hasDuplicates() || indexList.hasDuplicates()) {
            this.flags |= 0x20;
        }
    }
}

