/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InteractiveRouter
extends Router {
    private List<Highlight> startRouteHighlights = new ArrayList<Highlight>();
    private boolean started;
    private EditWindow wnd;
    private final EditingPreferences ep;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;
    private Map<Technology, Boolean> hasCurvedPins = new HashMap<Technology, Boolean>();

    public InteractiveRouter(EditingPreferences ep) {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
        this.wnd = null;
        this.tool = Routing.getRoutingTool();
        this.ep = ep;
    }

    public String toString() {
        return "Interactive Router";
    }

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElementPort var3, Point2D var4, Point2D var5, Point2D var6, PolyMerge var7, VerticalRoute var8, boolean var9, boolean var10, boolean var11, Rectangle2D var12);

    public void startInteractiveRoute(EditWindow wnd) {
        this.wnd = wnd;
        this.startRouteHighlights.clear();
        for (Highlight h : wnd.getHighlighter().getHighlights()) {
            this.startRouteHighlights.add(h);
        }
        wnd.clearHighlighting();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlighter highlighter = this.wnd.getHighlighter();
        highlighter.clear();
        highlighter.setHighlightList(this.startRouteHighlights);
        highlighter.finished();
        this.wnd = null;
        this.started = false;
    }

    public void makeRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        EditingPreferences ep = wnd.getEditingPreferences();
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, ep, true, true, null, null);
        wnd.clearHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(EditWindow wnd, PortInst startPort, ArcProto arc) {
        EditingPreferences ep = wnd.getEditingPreferences();
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Point2D.Double startLoc = new Point2D.Double(startPort.getPoly().getCenterX(), startPort.getPoly().getCenterY());
        Poly poly = InteractiveRouter.getConnectingSite(startPort, startLoc, ep, -1.0);
        RouteElementPort startRE = RouteElementPort.existingPortInst(startPort, poly, ep);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        VerticalRoute vroute = VerticalRoute.newRoute(startPort.getPortProto(), arc);
        if (!vroute.isSpecificationSucceeded()) {
            this.cancelInteractiveRoute();
            return false;
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        Router.ContactSize sizer = new Router.ContactSize(startPort, null, startLoc, startLoc, startLoc, startArc, endArc, false, ep);
        Rectangle2D contactArea = sizer.getContactSize();
        EDimension contactSize = new EDimension(contactArea.getWidth(), contactArea.getHeight());
        int startAngle = sizer.getStartAngle();
        double startArcWidth = sizer.getStartWidth();
        Cell cell = wnd.getCell();
        Route vertRoute = vroute.buildRoute(cell, startLoc, contactSize, startAngle, null, ep);
        for (RouteElement re : vertRoute) {
            if (!route.contains(re)) {
                route.add(re);
            }
            route.setEnd(vertRoute.getEnd());
        }
        if (route.replacePin(startRE, vertRoute.getStart(), null, ep)) {
            route.remove(startRE);
            if (route.getStart() == startRE) {
                route.setStart(vertRoute.getStart());
            }
        } else {
            InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startLoc, startLoc, startArc, startArcWidth, startAngle, true, true, null, null);
        }
        wnd.finishedHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        new MakeVerticalRouteJob(this, route, cell, true);
        this.started = false;
        return true;
    }

    public void highlightRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        EditingPreferences ep = wnd.getEditingPreferences();
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, ep, true, true, null, null);
        this.highlightRoute(wnd, route, cell);
    }

    public void highlightRoute(EditWindow wnd, Route route, Cell cell) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        wnd.clearHighlighting();
        for (RouteElement e : route) {
            e.addHighlightArea(wnd.getHighlighter());
        }
        wnd.finishedHighlighting();
    }

    public Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked, PolyMerge stayInside, EditingPreferences ep, boolean extendArcHead, boolean extendArcTail, Rectangle2D contactArea, EDimension alignment) {
        Technology tech;
        PortInst startPI;
        NodeInst startNI;
        ArcInst ai;
        PortProto endPort;
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        if (startObj == endObj) {
            return route;
        }
        RouteElementPort startRE = null;
        RouteElementPort endRE = null;
        startObj = InteractiveRouter.filterRouteObject(startObj, clicked);
        endObj = InteractiveRouter.filterRouteObject(endObj, clicked);
        PortProto startPort = InteractiveRouter.getRoutePort(startObj, ep);
        if (startPort == null) {
            return route;
        }
        if (endObj == null) {
            ArcProto useArc = InteractiveRouter.getArcToUse(startPort, null);
            if (useArc == null) {
                return route;
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            if (pn == null) {
                System.out.println("No primitive node found for arc '" + useArc.getName() + "'");
                return route;
            }
            endPort = pn.getPort(0);
        } else {
            endPort = InteractiveRouter.getRoutePort(endObj, ep);
        }
        VerticalRoute vroute = VerticalRoute.newRoute(startPort, endPort);
        if (!vroute.isSpecificationSucceeded()) {
            return new Route();
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        double startArcWidth = 0.0;
        double endArcWidth = 0.0;
        startArcWidth = InteractiveRouter.getArcWidthToUse(startObj, startArc, 0, true, ep);
        double d = endArcWidth = endObj == null ? startArcWidth : InteractiveRouter.getArcWidthToUse(endObj, endArc, 0, true, ep);
        if (startArc == endArc) {
            if (startArcWidth > endArcWidth) {
                endArcWidth = startArcWidth;
            }
            if (endArcWidth > startArcWidth) {
                startArcWidth = endArcWidth;
            }
        }
        if (extendArcHead) {
            boolean bl = extendArcHead = startArc.getDefaultInst(ep).isHeadExtended() || endArc.getDefaultInst(ep).isHeadExtended();
        }
        if (extendArcTail) {
            extendArcTail = startArc.getDefaultInst(ep).isTailExtended() || endArc.getDefaultInst(ep).isTailExtended();
        }
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked, ep, startArcWidth);
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked, ep, endArcWidth);
        Poly startPolyFull = InteractiveRouter.getConnectingSite(startObj, clicked, ep, -1.0);
        Poly endPolyFull = InteractiveRouter.getConnectingSite(endObj, clicked, ep, -1.0);
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint, startPoly, endPoly, startArc, endArc, alignment, ep);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean contactsOnEndObject = true;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElementPort.existingPortInst(existingStartPort, startPoly, ep);
        }
        if (startObj instanceof ArcInst) {
            ai = (ArcInst)startObj;
            startRE = this.findArcConnectingPoint(route, ai, startPoint, stayInside, alignment);
            if (startRE.getPortInst() == ai.getHeadPortInst() && extendArcHead) {
                extendArcHead = ai.isHeadExtended();
            }
            if (startRE.getPortInst() == ai.getTailPortInst() && extendArcHead) {
                extendArcHead = ai.isTailExtended();
            }
            if (startRE.isBisectArcPin()) {
                contactsOnEndObject = false;
            }
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElementPort.existingPortInst(existingEndPort, endPoly, ep);
            }
            if (endObj instanceof ArcInst) {
                ai = (ArcInst)endObj;
                endRE = this.findArcConnectingPoint(route, ai, endPoint, stayInside, alignment);
                if (endRE.getPortInst() == ai.getHeadPortInst() && extendArcTail) {
                    extendArcTail = ai.isHeadExtended();
                }
                if (endRE.getPortInst() == ai.getTailPortInst() && extendArcTail) {
                    extendArcTail = ai.isTailExtended();
                }
                if (endRE.isBisectArcPin()) {
                    contactsOnEndObject = true;
                }
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("Warning: can't route to " + endObj + " because it has no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                PortInst startPi = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPi.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startAi = (ArcInst)startObj;
                useArc = startAi.getProto();
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth(ep) - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight(ep) - so.getHighYOffset() - so.getLowYOffset(), Orientation.IDENT, ep);
        }
        if (startRE.isBisectArcPin()) {
            contactsOnEndObject = false;
        }
        if (endRE != null && endRE.isBisectArcPin()) {
            contactsOnEndObject = true;
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        Point2D cornerLoc = InteractiveRouter.getCornerLocation(startPoint, endPoint, clicked, startArc, endArc, contactsOnEndObject, stayInside, contactArea, startPolyFull, endPolyFull, ep);
        int startAngle = GenMath.figureAngle(startPoint, cornerLoc);
        int endAngle = GenMath.figureAngle(endPoint, cornerLoc);
        Router.ContactSize sizer = new Router.ContactSize(startObj, endObj, startPoint, endPoint, cornerLoc, startArc, endArc, false, ep);
        contactArea = sizer.getContactSize();
        startAngle = sizer.getStartAngle();
        endAngle = sizer.getEndAngle();
        startArcWidth = sizer.getStartWidth();
        endArcWidth = sizer.getEndWidth();
        if (startObj instanceof PortInst && (startNI = (startPI = (PortInst)startObj).getNodeInst()).getFunction().isPin() && startNI.getNumConnections() == 1 && this.hasCurvedPins(tech = ((PrimitiveNode)startNI.getProto()).getTechnology(), startArc)) {
            MutableBoolean flip;
            int backAngle;
            Connection con = startNI.getConnections().next();
            Connection oCon = con.getArc().getConnection(1 - con.getEndIndex());
            PortInst prevPI = oCon.getPortInst();
            EPoint previous = oCon.getLocation();
            int forwardAngle = GenMath.figureAngle(startPoint, cornerLoc);
            int angleDiff = this.getAngleDiff(forwardAngle, backAngle = GenMath.figureAngle(startPoint, previous), flip = new MutableBoolean(false));
            PrimitiveNode pn = this.findCurvedPin(tech, angleDiff);
            if (pn != null) {
                Orientation orient = this.getCurvedBendOrientation(backAngle + 900, flip);
                EPoint curveCenter = this.getCurvedBendLocation(pn, orient, angleDiff, startPoint);
                Poly prevPoly = new Poly(Poly.from(prevPI.getCenter()));
                startRE = RouteElementPort.existingPortInst(prevPI, prevPoly, ep);
                startRE.setShowHighlight(false);
                route.add(startRE);
                route.setEnd(endRE);
                route.add(RouteElementArc.deleteArc(con.getArc(), ep));
                route.add(RouteElementPort.deleteNode(startNI, ep));
                NodeInst dNi = NodeInst.makeDummyInstance(pn, ep, curveCenter, pn.getDefWidth(ep), pn.getDefHeight(ep), orient);
                PrimitivePort primPort1 = pn.getPort(0);
                PrimitivePort primPort2 = pn.getPort(1);
                EPoint portLoc1 = dNi.findPortInstFromProto(primPort1).getCenter();
                EPoint portLoc2 = dNi.findPortInstFromProto(primPort2).getCenter();
                RouteElementPort newPinRE1 = RouteElementPort.newNode(cell, pn, primPort1, curveCenter, pn.getDefWidth(ep), pn.getDefHeight(ep), orient, ep);
                newPinRE1.setConnectingSite(new Poly(Poly.from(portLoc1)));
                route.add(newPinRE1);
                RouteElementPort newPinRE2 = RouteElementPort.newNodeOtherPort(cell, newPinRE1, primPort2, ep);
                newPinRE2.setConnectingSite(new Poly(Poly.from(portLoc2)));
                route.setStart(newPinRE2);
                RouteElementArc rea1 = InteractiveRouter.addConnectingArc(route, cell, startRE, newPinRE1, prevPI.getCenter(), portLoc1, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
                rea1.setShowHighlight(false);
                InteractiveRouter.addConnectingArc(route, cell, endRE, newPinRE2, endPoint, portLoc2, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
                return route;
            }
        }
        route.setStart(startRE);
        route.setEnd(endRE);
        if (startArc != endArc) {
            EDimension contactSize = new EDimension(contactArea.getWidth(), contactArea.getHeight());
            Route vertRoute = vroute.buildRoute(cell, cornerLoc, contactSize, startAngle, stayInside, ep);
            for (RouteElement re : vertRoute) {
                if (route.contains(re)) continue;
                route.add(re);
            }
            if (route.replacePin(startRE, vertRoute.getStart(), stayInside, ep)) {
                route.remove(startRE);
                if (route.getStart() == startRE) {
                    route.setStart(vertRoute.getStart());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
            if (route.replacePin(endRE, vertRoute.getEnd(), stayInside, ep)) {
                route.remove(endRE);
                if (route.getEnd() == endRE) {
                    route.setEnd(vertRoute.getEnd());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, endRE, vertRoute.getEnd(), endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
        } else {
            if (route.replaceBisectPin(startRE, endRE)) {
                route.remove(startRE);
                return route;
            }
            if (route.replaceBisectPin(endRE, startRE)) {
                route.remove(endRE);
                route.setEnd(startRE);
                return route;
            }
            int angle = DBMath.figureAngle(startPoint, endPoint);
            int angleIncrement = startArc.getAngleIncrement(ep);
            if (angleIncrement == 0 || angle % (10 * angleIncrement) == 0) {
                InteractiveRouter.addConnectingArc(route, cell, startRE, endRE, startPoint, endPoint, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
            } else {
                MutableBoolean flip;
                int angleDiff;
                PrimitiveNode pn;
                tech = startArc.getTechnology();
                if (startArc == endArc && this.hasCurvedPins(tech, startArc) && (pn = this.findCurvedPin(tech, angleDiff = this.getAngleDiff(startAngle, endAngle, flip = new MutableBoolean(false)))) != null) {
                    Orientation orient = this.getCurvedBendOrientation(endAngle + 2700, flip);
                    EPoint curveCenter = this.getCurvedBendLocation(pn, orient, angleDiff, cornerLoc);
                    NodeInst dNi = NodeInst.makeDummyInstance(pn, ep, curveCenter, pn.getDefWidth(ep), pn.getDefHeight(ep), orient);
                    PrimitivePort primPort1 = pn.getPort(0);
                    PrimitivePort primPort2 = pn.getPort(1);
                    EPoint portLoc1 = dNi.findPortInstFromProto(primPort1).getCenter();
                    EPoint portLoc2 = dNi.findPortInstFromProto(primPort2).getCenter();
                    RouteElementPort newPinRE1 = RouteElementPort.newNode(cell, pn, primPort1, curveCenter, pn.getDefWidth(ep), pn.getDefHeight(ep), orient, ep);
                    newPinRE1.setConnectingSite(new Poly(Poly.from(portLoc1)));
                    route.add(newPinRE1);
                    RouteElementPort newPinRE2 = RouteElementPort.newNodeOtherPort(cell, newPinRE1, primPort2, ep);
                    newPinRE2.setConnectingSite(new Poly(Poly.from(portLoc2)));
                    route.add(newPinRE2);
                    InteractiveRouter.addConnectingArc(route, cell, startRE, newPinRE2, startPoint, portLoc2, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
                    InteractiveRouter.addConnectingArc(route, cell, endRE, newPinRE1, endPoint, portLoc1, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
                    return route;
                }
                PrimitiveNode pn2 = startArc.findOverridablePinProto(ep);
                SizeOffset so = pn2.getProtoSizeOffset();
                double defwidth = pn2.getDefWidth(ep) - so.getHighXOffset() - so.getLowXOffset();
                double defheight = pn2.getDefHeight(ep) - so.getHighYOffset() - so.getLowYOffset();
                RouteElementPort pinRE = RouteElementPort.newNode(cell, pn2, pn2.getPort(0), cornerLoc, defwidth, defheight, Orientation.IDENT, ep);
                route.add(pinRE);
                InteractiveRouter.addConnectingArc(route, cell, startRE, pinRE, startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
                InteractiveRouter.addConnectingArc(route, cell, endRE, pinRE, endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
        }
        return route;
    }

    private boolean hasCurvedPins(Technology tech, ArcProto arc) {
        Boolean hasIt = this.hasCurvedPins.get(tech);
        if (hasIt == null) {
            hasIt = Boolean.FALSE;
            Iterator<PrimitiveNode> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pn = it.next();
                if (!pn.isCurvedPin() || !pn.getPort(0).connectsTo(arc)) continue;
                hasIt = Boolean.TRUE;
                break;
            }
            this.hasCurvedPins.put(tech, hasIt);
        }
        return hasIt;
    }

    private int getAngleDiff(int startAngle, int endAngle, MutableBoolean flip) {
        flip.setValue(false);
        if (startAngle > endAngle) {
            if (startAngle - endAngle > 1800) {
                endAngle += 3600;
            }
        } else if (endAngle - startAngle > 1800) {
            startAngle += 3600;
        }
        int angleDiff = Math.abs(startAngle - endAngle);
        if (startAngle > endAngle) {
            flip.setValue(true);
        }
        return angleDiff;
    }

    private Orientation getCurvedBendOrientation(int angle, MutableBoolean flip) {
        Orientation orient = Orientation.fromAngle(angle % 3600);
        if (flip.booleanValue()) {
            orient = orient.concatenate(Orientation.X);
        }
        return orient;
    }

    private EPoint getCurvedBendLocation(PrimitiveNode pn, Orientation orient, int angleDiff, Point2D ctr) {
        Point2D coord;
        NodeInst dNi = NodeInst.makeDummyInstance((NodeProto)pn, this.ep);
        ERectangle bounds = dNi.getBounds();
        if (angleDiff == 900) {
            coord = new Point2D.Double(-bounds.getWidth() / 2.0, -bounds.getHeight() / 2.0);
        } else {
            coord = GenMath.intersect(new Point2D.Double(bounds.getMinX(), bounds.getMinY()), 225, new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), 900);
            coord.setLocation(-coord.getX(), -coord.getY());
        }
        coord = orient.transformPoint(coord);
        EPoint curveCenter = EPoint.fromLambda(ctr.getX() + coord.getX(), ctr.getY() + coord.getY());
        return curveCenter;
    }

    private PrimitiveNode findCurvedPin(Technology tech, int desiredAngle) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            int p2Angle;
            PrimitiveNode pn = it.next();
            if (!pn.isCurvedPin()) continue;
            PrimitivePort pp1 = null;
            PrimitivePort pp2 = null;
            Iterator<PrimitivePort> pIt = pn.getPrimitivePorts();
            while (pIt.hasNext()) {
                PrimitivePort pp = pIt.next();
                if (pp1 == null) {
                    pp1 = pp;
                    continue;
                }
                if (pp2 != null) continue;
                pp2 = pp;
            }
            if (pp1 == null || pp2 == null) continue;
            NodeInst dNi = NodeInst.makeDummyInstance((NodeProto)pn, this.ep);
            ERectangle bounds = dNi.getBounds();
            EPoint ctr = EPoint.fromLambda(bounds.getMinX(), bounds.getMinY());
            PortInst p1 = dNi.findPortInstFromProto(pp1);
            PortInst p2 = dNi.findPortInstFromProto(pp2);
            EPoint p1ctr = p1.getCenter();
            EPoint p2ctr = p2.getCenter();
            int p1Angle = GenMath.figureAngle(ctr, p1ctr);
            int aDiff = Math.abs(p1Angle - (p2Angle = GenMath.figureAngle(ctr, p2ctr)));
            if (aDiff > 1800) {
                aDiff = 3600 - aDiff;
            }
            if ((aDiff = 1800 - aDiff) != desiredAngle) continue;
            return pn;
        }
        return null;
    }

    protected static ElectricObject filterRouteObject(ElectricObject routeObj, Point2D clicked) {
        if (routeObj instanceof NodeInst) {
            return ((NodeInst)routeObj).findClosestPortInst(clicked);
        }
        if (routeObj instanceof Export) {
            Export exp = (Export)routeObj;
            return exp.getOriginalPort();
        }
        return routeObj;
    }

    protected static PortProto getRoutePort(ElectricObject routeObj, EditingPreferences ep) {
        assert (!(routeObj instanceof NodeInst));
        if (routeObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)routeObj;
            PrimitiveNode pn = ai.getProto().findOverridablePinProto(ep);
            return pn.getPort(0);
        }
        if (routeObj instanceof PortInst) {
            PortInst pi = (PortInst)routeObj;
            return pi.getPortProto();
        }
        return null;
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint, Poly startPoly, Poly endPoly, ArcProto startArc, ArcProto endArc, EDimension alignment, EditingPreferences ep) {
        Point2D[] points2;
        Point2D[] points1;
        Point2D intersection2;
        boolean overlapY;
        double upperBoundX;
        double lowerBoundX;
        boolean manhattan;
        if (alignment == null) {
            alignment = ep.getAlignmentToGrid();
        }
        if (startPoly.getBox() == null && startPoly.getPoints().length != 2 || endPoly != null && endPoly.getBox() == null && endPoly.getPoints().length != 2) {
            startPoint.setLocation(startPoly.closestPoint(clicked));
            if (endPoly == null) {
                endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            } else {
                endPoint.setLocation(endPoly.closestPoint(clicked));
            }
            return;
        }
        Rectangle2D.Double startBounds = new Rectangle2D.Double(startPoly.getBounds2D().getX(), startPoly.getBounds2D().getY(), startPoly.getBounds2D().getWidth(), startPoly.getBounds2D().getHeight());
        InteractiveRouter.getAlignedCenter(startBounds, alignment, startPoint);
        boolean bl = manhattan = startArc.getAngleIncrement(ep) == 90;
        if (startObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)startObj;
            if (manhattan && (ai.getHeadLocation().getX() == ai.getTailLocation().getX() || ai.getHeadLocation().getY() == ai.getTailLocation().getY())) {
                double x2 = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX(), alignment.getWidth());
                double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY(), alignment.getHeight());
                startPoint.setLocation(x2, y);
            } else {
                startPoint.setLocation(GenMath.closestPointToLine((Point2D)ai.getHeadLocation(), (Point2D)ai.getTailLocation(), clicked));
                manhattan = false;
            }
        }
        if (endPoly == null) {
            int angleIncrement = endArc.getAngleIncrement(ep);
            endPoint.setLocation(InteractiveRouter.getClosestAngledPoint(startPoint, clicked, angleIncrement, alignment));
            if (startArc.getTechnology() == Artwork.tech()) {
                endPoint.setLocation(clicked);
            }
            return;
        }
        Rectangle2D.Double endBounds = new Rectangle2D.Double(endPoly.getBounds2D().getX(), endPoly.getBounds2D().getY(), endPoly.getBounds2D().getWidth(), endPoly.getBounds2D().getHeight());
        InteractiveRouter.getAlignedCenter(endBounds, alignment, endPoint);
        if (endObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)endObj;
            if (manhattan && (ai.getHeadLocation().getX() == ai.getTailLocation().getX() || ai.getHeadLocation().getY() == ai.getTailLocation().getY())) {
                double x3 = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX(), alignment.getWidth());
                double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY(), alignment.getHeight());
                endPoint.setLocation(x3, y);
            } else {
                endPoint.setLocation(GenMath.closestPointToLine((Point2D)ai.getHeadLocation(), (Point2D)ai.getTailLocation(), startPoint));
                int increment = startArc.getAngleIncrement(ep);
                if (increment > 0 && increment < 90) {
                    Point2D bestEnd = null;
                    double bestDist = Double.MAX_VALUE;
                    for (int a = 0; a < 180; a += increment) {
                        double dist;
                        Point2D intPt = GenMath.intersect(ai.getHeadLocation(), ai.getAngle(), startPoint, a * 10);
                        if (intPt == null || !(intPt.getX() >= Math.min(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || intPt.getX() <= Math.max(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || intPt.getY() >= Math.min(ai.getHeadLocation().getY(), ai.getTailLocation().getY())) && !(intPt.getY() <= Math.max(ai.getHeadLocation().getY(), ai.getTailLocation().getY())) || !((dist = intPt.distance(clicked)) < bestDist)) continue;
                        bestDist = dist;
                        bestEnd = intPt;
                    }
                    if (bestEnd != null) {
                        endPoint.setLocation(bestEnd.getX(), bestEnd.getY());
                    }
                }
                if (endPoint.getX() < Math.min(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || endPoint.getX() > Math.max(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || endPoint.getY() < Math.min(ai.getHeadLocation().getY(), ai.getTailLocation().getY()) || endPoint.getY() > Math.max(ai.getHeadLocation().getY(), ai.getTailLocation().getY())) {
                    if ((startPoint.getX() < Math.min(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || startPoint.getX() > Math.max(ai.getHeadLocation().getX(), ai.getTailLocation().getX())) && (startPoint.getY() >= Math.min(ai.getHeadLocation().getY(), ai.getTailLocation().getY()) || startPoint.getY() <= Math.max(ai.getHeadLocation().getY(), ai.getTailLocation().getY()))) {
                        Point2D intPt = GenMath.intersect(ai.getHeadLocation(), ai.getAngle(), startPoint, 0);
                        if (intPt == null) {
                            System.out.println("Error: Could not determine intersection of " + ai.getAngle() + "-degree line through (" + ai.getHeadLocation().getX() + "," + ai.getHeadLocation().getY() + ") and 0-degree line through (" + startPoint.getX() + "," + startPoint.getY() + ")");
                        } else {
                            endPoint.setLocation(intPt);
                        }
                    } else if ((startPoint.getY() < Math.min(ai.getHeadLocation().getY(), ai.getTailLocation().getY()) || startPoint.getY() > Math.max(ai.getHeadLocation().getY(), ai.getTailLocation().getY())) && (startPoint.getX() >= Math.min(ai.getHeadLocation().getX(), ai.getTailLocation().getX()) || startPoint.getX() <= Math.max(ai.getHeadLocation().getX(), ai.getTailLocation().getX()))) {
                        Point2D intPt = GenMath.intersect(ai.getHeadLocation(), ai.getAngle(), startPoint, 900);
                        if (intPt == null) {
                            System.out.println("Error: Could not determine intersection of " + ai.getAngle() + "-degree line through (" + ai.getHeadLocation().getX() + "," + ai.getHeadLocation().getY() + ") and 90-degree line through (" + startPoint.getX() + "," + startPoint.getY() + ")");
                        } else {
                            endPoint.setLocation(intPt);
                        }
                    } else {
                        double x4 = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX(), alignment.getWidth());
                        double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY(), alignment.getHeight());
                        endPoint.setLocation(x4, y);
                    }
                }
                manhattan = false;
            }
        }
        boolean overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
        double lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
        double upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
        boolean bl2 = overlapY = lowerBoundY <= upperBoundY;
        if (ep.isFatWires()) {
            Rectangle2D.Double startObjBounds = new Rectangle2D.Double(startPoly.getBounds2D().getX(), startPoly.getBounds2D().getY(), startPoly.getBounds2D().getWidth(), startPoly.getBounds2D().getHeight());
            Rectangle2D.Double endObjBounds = new Rectangle2D.Double(endPoly.getBounds2D().getX(), endPoly.getBounds2D().getY(), endPoly.getBounds2D().getWidth(), endPoly.getBounds2D().getHeight());
            boolean objsOverlap = false;
            if (startObjBounds != null && endObjBounds != null && startArc == endArc && startObjBounds.intersects(endObjBounds)) {
                objsOverlap = true;
            }
            Point2D.Double startCenter = new Point2D.Double(startBounds.getCenterX(), startBounds.getCenterY());
            Point2D.Double endCenter = new Point2D.Double(endBounds.getCenterX(), endBounds.getCenterY());
            InteractiveRouter.gridAlignWithinBounds(startCenter, startBounds, alignment);
            InteractiveRouter.gridAlignWithinBounds(endCenter, endBounds, alignment);
            boolean startObjInEndObjInX = false;
            boolean startObjInEndObjInY = false;
            boolean endObjInStartObjInX = false;
            boolean endObjInStartObjInY = false;
            if (startObjBounds.getMinX() >= endObjBounds.getMinX() && startObjBounds.getMaxX() <= endObjBounds.getMaxX()) {
                startObjInEndObjInX = true;
            }
            if (startObjBounds.getMinY() >= endObjBounds.getMinY() && startObjBounds.getMaxY() <= endObjBounds.getMaxY()) {
                startObjInEndObjInY = true;
            }
            if (endObjBounds.getMinX() >= startObjBounds.getMinX() && endObjBounds.getMaxX() <= startObjBounds.getMaxX()) {
                endObjInStartObjInX = true;
            }
            if (endObjBounds.getMinY() >= startObjBounds.getMinY() && endObjBounds.getMaxY() <= startObjBounds.getMaxY()) {
                endObjInStartObjInY = true;
            }
            if (!objsOverlap || !overlapX) {
                if (startObj instanceof PortInst && !endObjInStartObjInX) {
                    ((Rectangle2D)startBounds).setRect(((Point2D)startCenter).getX(), ((RectangularShape)startBounds).getY(), 0.0, ((RectangularShape)startBounds).getHeight());
                }
                if (endObj instanceof PortInst && !startObjInEndObjInX) {
                    ((Rectangle2D)endBounds).setRect(((Point2D)endCenter).getX(), ((RectangularShape)endBounds).getY(), 0.0, ((RectangularShape)endBounds).getHeight());
                }
            }
            if (!objsOverlap || !overlapY) {
                if (startObj instanceof PortInst && !endObjInStartObjInY) {
                    ((Rectangle2D)startBounds).setRect(((RectangularShape)startBounds).getX(), ((Point2D)startCenter).getY(), ((RectangularShape)startBounds).getWidth(), 0.0);
                }
                if (endObj instanceof PortInst && !startObjInEndObjInY) {
                    ((Rectangle2D)endBounds).setRect(((RectangularShape)endBounds).getX(), ((Point2D)endCenter).getY(), ((RectangularShape)endBounds).getWidth(), 0.0);
                }
            }
            overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
            lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
            upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
            boolean bl3 = overlapY = lowerBoundY <= upperBoundY;
        }
        if (startPoly.getPoints().length == 2 && endPoly.getPoints().length == 2 && (intersection2 = InteractiveRouter.getIntersection(points1 = startPoly.getPoints(), points2 = endPoly.getPoints())) != null) {
            if (Job.getDebug()) {
                System.out.println("===========================================================");
                System.out.println("Start Poly: " + points1[0] + ", " + points1[1]);
                System.out.println("End Poly: " + points2[0] + ", " + points2[1]);
                System.out.println("Intersection Point: " + intersection2);
                System.out.println("===========================================================");
            }
            startPoint.setLocation(intersection2);
            endPoint.setLocation(intersection2);
            return;
        }
        if (manhattan) {
            if (lowerBoundX <= upperBoundX) {
                double x5 = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX(), alignment.getWidth());
                startPoint.setLocation(x5, startPoint.getY());
                endPoint.setLocation(x5, endPoint.getY());
            } else if (startBounds.getMinX() > endBounds.getMaxX()) {
                startPoint.setLocation(startBounds.getMinX(), startPoint.getY());
                endPoint.setLocation(endBounds.getMaxX(), endPoint.getY());
            } else {
                startPoint.setLocation(startBounds.getMaxX(), startPoint.getY());
                endPoint.setLocation(endBounds.getMinX(), endPoint.getY());
            }
            if (lowerBoundY <= upperBoundY) {
                double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY(), alignment.getHeight());
                startPoint.setLocation(startPoint.getX(), y);
                endPoint.setLocation(endPoint.getX(), y);
            } else if (startBounds.getMinY() > endBounds.getMaxY()) {
                startPoint.setLocation(startPoint.getX(), startBounds.getMinY());
                endPoint.setLocation(endPoint.getX(), endBounds.getMaxY());
            } else {
                startPoint.setLocation(startPoint.getX(), startBounds.getMaxY());
                endPoint.setLocation(endPoint.getX(), endBounds.getMinY());
            }
        }
    }

    private static void gridAlignWithinBounds(Point2D pt, Rectangle2D bounds, EDimension alignment) {
        if (alignment == null) {
            return;
        }
        double x2 = pt.getX();
        double y = pt.getY();
        if (alignment.getWidth() > 0.0) {
            double xfloor = Math.floor(x2 / alignment.getWidth()) * alignment.getWidth();
            double xceil = Math.ceil(x2 / alignment.getWidth()) * alignment.getWidth();
            if (xfloor >= bounds.getMinX() && xfloor <= bounds.getMaxX()) {
                x2 = xfloor;
            } else if (xceil >= bounds.getMinX() && xceil <= bounds.getMaxX()) {
                x2 = xceil;
            }
        }
        if (alignment.getHeight() > 0.0) {
            double yfloor = Math.floor(y / alignment.getHeight()) * alignment.getHeight();
            double yceil = Math.ceil(y / alignment.getHeight()) * alignment.getHeight();
            if (yfloor >= bounds.getMinY() && yfloor <= bounds.getMaxY()) {
                y = yfloor;
            } else if (yceil >= bounds.getMinY() && yceil <= bounds.getMaxY()) {
                y = yceil;
            }
        }
        pt.setLocation(x2, y);
    }

    private static void getAlignedCenter(Rectangle2D bounds, EDimension alignment, Point2D ctr) {
        double cX = bounds.getCenterX();
        double cY = bounds.getCenterY();
        if (alignment != null) {
            if (alignment.getWidth() > 0.0) {
                double newX;
                long xxL;
                double xx = cX / alignment.getWidth();
                if (xx != (double)(xxL = Math.round(xx)) && (newX = (double)xxL * alignment.getWidth()) >= bounds.getMinX() && newX <= bounds.getMaxX()) {
                    cX = newX;
                }
                double lX = Math.ceil(bounds.getMinX() / alignment.getWidth()) * alignment.getWidth();
                double hX = Math.floor(bounds.getMaxX() / alignment.getWidth()) * alignment.getWidth();
                if (lX <= bounds.getMaxX() && hX >= bounds.getMinX()) {
                    bounds.setRect(lX, bounds.getMinY(), hX - lX, bounds.getHeight());
                }
            }
            if (alignment.getHeight() > 0.0) {
                double newY;
                long yyL;
                double yy = cY / alignment.getHeight();
                if (yy != (double)(yyL = Math.round(yy)) && (newY = (double)yyL * alignment.getHeight()) >= bounds.getMinY() && newY <= bounds.getMaxY()) {
                    cY = newY;
                }
                double lY = Math.ceil(bounds.getMinY() / alignment.getHeight()) * alignment.getHeight();
                double hY = Math.floor(bounds.getMaxY() / alignment.getHeight()) * alignment.getHeight();
                if (lY <= bounds.getMaxY() && hY >= bounds.getMinY()) {
                    bounds.setRect(bounds.getMinX(), lY, bounds.getWidth(), hY - lY);
                }
            }
        }
        ctr.setLocation(cX, cY);
    }

    public static Point2D getIntersection(Point2D[] points1, Point2D[] points2) {
        double[] co2;
        if (DBMath.areEquals(points1[0], points1[1]) || DBMath.areEquals(points2[0], points2[1])) {
            if (Job.getDebug()) {
                System.out.println("Line is a singular point in InteractiveRouter.getIntersection");
            }
            return null;
        }
        Line2D.Double line1 = new Line2D.Double(points1[0], points1[1]);
        Line2D.Double line2 = new Line2D.Double(points2[0], points2[1]);
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double[] co1 = InteractiveRouter.getLineCoeffs(line1);
        double det = co1[0] * (co2 = InteractiveRouter.getLineCoeffs(line2))[1] - co2[0] * co1[1];
        if (det == 0.0) {
            if (points1[0].getX() == points2[0].getX() && points1[0].getY() == points2[0].getY()) {
                return points1[0];
            }
            if (points1[0].getX() == points2[1].getX() && points1[0].getY() == points2[1].getY()) {
                return points1[0];
            }
            if (points1[1].getX() == points2[0].getX() && points1[1].getY() == points2[0].getY()) {
                return points1[1];
            }
            if (points1[1].getX() == points2[1].getX() && points1[1].getY() == points2[1].getY()) {
                return points1[1];
            }
            return null;
        }
        double x2 = (co2[1] * co1[2] - co1[1] * co2[2]) / det;
        double y = (co1[0] * co2[2] - co2[0] * co1[2]) / det;
        return new Point2D.Double(x2, y);
    }

    private static double[] getLineCoeffs(Line2D line) {
        double A = line.getP2().getY() - line.getP1().getY();
        double B = line.getP1().getX() - line.getP2().getX();
        double C = A * line.getP1().getX() + B * line.getP1().getY();
        return new double[]{A, B, C};
    }

    protected static Rectangle2D getBounds(ElectricObject obj) {
        NodeInst ni;
        NodeProto np;
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            obj = pi.getNodeInst();
        }
        if (obj instanceof NodeInst && (np = (ni = (NodeInst)obj).getProto()) instanceof PrimitiveNode) {
            return ni.getBounds();
        }
        return null;
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked, EditingPreferences ep, double arcWidth) {
        PortInst pi;
        assert (clicked != null);
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            if (ni.isCellInstance()) {
                return ni.getShapeOfPort(pp);
            }
            return ni.getShapeOfPortForWiringTool(pp, clicked, ep, arcWidth);
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Poly poly = new Poly(arc.getHeadLocation(), arc.getTailLocation());
            return poly;
        }
        return null;
    }

    protected static Rectangle2D getLayerArea(ElectricObject obj, Layer layer) {
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            NodeProto np = ni.getProto();
            if (np instanceof Cell) {
                return null;
            }
            if (np instanceof PrimitiveNode) {
                PrimitiveNode pn = (PrimitiveNode)np;
                if (pn.getFunction().isPin()) {
                    Rectangle2D horiz = null;
                    Rectangle2D vert = null;
                    Iterator<Connection> it = pi.getConnections();
                    while (it.hasNext()) {
                        Connection conn = it.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getProto().getLayerIterator().next() != layer) continue;
                        int angle = ai.getDefinedAngle();
                        if (angle % 1800 == 0) {
                            horiz = horiz == null ? ai.getBounds() : horiz.createUnion(ai.getBounds());
                        }
                        if ((angle + 900) % 1800 != 0) continue;
                        if (vert == null) {
                            vert = ai.getBounds();
                            continue;
                        }
                        vert = ((Rectangle2D)vert).createUnion(ai.getBounds());
                    }
                    return horiz.createIntersection(vert);
                }
                if (pn.getFunction().isContact()) {
                    Poly p = ni.getBaseShape();
                    return p.getBounds2D();
                }
            }
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        return null;
    }

    protected RouteElementPort findArcConnectingPoint(Route route, ArcInst arc, Point2D connectingPoint, PolyMerge stayInside, EDimension alignment) {
        EPoint head2 = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head2, this.ep);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail, this.ep);
        if (head2.equals(connectingPoint)) {
            return headRE;
        }
        if (tail.equals(connectingPoint)) {
            return tailRE;
        }
        return this.bisectArc(route, arc, connectingPoint, stayInside, alignment);
    }

    protected RouteElementPort bisectArc(Route route, ArcInst arc, Point2D bisectPoint, PolyMerge stayInside, EDimension alignment) {
        Cell cell = arc.getParent();
        EPoint head2 = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        PrimitiveNode pn = arc.getProto().findOverridablePinProto(this.ep);
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth(this.ep) - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight(this.ep) - so.getHighYOffset() - so.getLowYOffset();
        RouteElementPort newPinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height, Orientation.IDENT, this.ep);
        newPinRE.setBisectArcPin(true);
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head2, this.ep);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail, this.ep);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name1 = null;
        String name2 = null;
        String nameToUse = arc.getName();
        if (arc.getNameKey().isTempname()) {
            nameToUse = null;
        }
        if (head2.distance(bisectPoint) > tail.distance(bisectPoint)) {
            name1 = nameToUse;
        } else {
            name2 = nameToUse;
        }
        boolean extendArcFromHeadSide = InteractiveRouter.getExtendArcEnd(newPinRE, bisectPoint, arc.getLambdaBaseWidth(), arc.getProto(), arc.getAngle(), arc.isTailExtended(), alignment);
        boolean extendArcFromTailSide = InteractiveRouter.getExtendArcEnd(newPinRE, bisectPoint, arc.getLambdaBaseWidth(), arc.getProto(), arc.getAngle(), arc.isHeadExtended(), alignment);
        RouteElementArc newHeadArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), headRE, newPinRE, head2, bisectPoint, name1, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, arc.isHeadExtended(), extendArcFromHeadSide, stayInside);
        RouteElementArc newTailArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), newPinRE, tailRE, bisectPoint, tail, name2, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, extendArcFromTailSide, arc.isTailExtended(), stayInside);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElementArc deleteArcRE = RouteElementArc.deleteArc(arc, this.ep);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected static Point2D getCornerLocation(Point2D startLoc, Point2D endLoc, Point2D clicked, ArcProto startArc, ArcProto endArc, boolean contactsOnEndObj, PolyMerge stayInside, Rectangle2D contactArea, Poly startPolyFull, Poly endPolyFull, EditingPreferences ep) {
        if (contactArea != null) {
            return new Point2D.Double(contactArea.getCenterX(), contactArea.getCenterY());
        }
        boolean singleArc = false;
        if (startArc == endArc) {
            int inc = 10 * startArc.getAngleIncrement(ep);
            if (inc == 0) {
                singleArc = true;
            } else {
                int ang = GenMath.figureAngle(startLoc, endLoc);
                if (ang % inc == 0) {
                    singleArc = true;
                }
            }
        } else if (DBMath.areEquals(startLoc.getX(), endLoc.getX()) || DBMath.areEquals(startLoc.getY(), endLoc.getY())) {
            singleArc = true;
        }
        if (singleArc) {
            if (contactsOnEndObj) {
                return new Point2D.Double(endLoc.getX(), endLoc.getY());
            }
            return new Point2D.Double(startLoc.getX(), startLoc.getY());
        }
        Point2D.Double cornerLoc = null;
        Point2D.Double pin1 = new Point2D.Double(startLoc.getX(), endLoc.getY());
        Point2D.Double pin2 = new Point2D.Double(endLoc.getX(), startLoc.getY());
        int clickedQuad = InteractiveRouter.findQuadrant(endLoc, clicked);
        int pin1Quad = InteractiveRouter.findQuadrant(endLoc, pin1);
        int pin2Quad = InteractiveRouter.findQuadrant(endLoc, pin2);
        int oppositeQuad = (clickedQuad + 2) % 4;
        cornerLoc = pin1;
        if (pin2Quad == clickedQuad) {
            cornerLoc = pin2;
        } else if (pin1Quad == clickedQuad) {
            cornerLoc = pin1;
        } else if (pin1Quad == oppositeQuad) {
            cornerLoc = pin2;
        }
        if (startPolyFull != null && endPolyFull != null && startPolyFull.intersects(endPolyFull)) {
            boolean usepin1 = false;
            boolean usepin2 = false;
            if (startPolyFull.contains(pin1) && endPolyFull.contains(pin1)) {
                usepin1 = true;
            }
            if (startPolyFull.contains(pin2) && endPolyFull.contains(pin2)) {
                usepin2 = true;
            }
            if (usepin1 && !usepin2) {
                cornerLoc = pin1;
            }
            if (usepin2 && !usepin1) {
                cornerLoc = pin2;
            }
        }
        ArcProto useArc = startArc;
        if (!contactsOnEndObj) {
            useArc = endArc;
        }
        if (stayInside != null && useArc != null) {
            double pinSize = useArc.getDefaultLambdaBaseWidth(ep);
            Layer pinLayer = useArc.getLayerIterator().next();
            Rectangle2D.Double pin1Rect = new Rectangle2D.Double(((Point2D)pin1).getX() - pinSize / 2.0, ((Point2D)pin1).getY() - pinSize / 2.0, pinSize, pinSize);
            Rectangle2D.Double pin2Rect = new Rectangle2D.Double(((Point2D)pin2).getX() - pinSize / 2.0, ((Point2D)pin2).getY() - pinSize / 2.0, pinSize, pinSize);
            if (stayInside.contains(pinLayer, pin1Rect)) {
                cornerLoc = pin1;
            } else if (stayInside.contains(pinLayer, pin2Rect)) {
                cornerLoc = pin2;
            }
        }
        return cornerLoc;
    }

    protected static void updateContactArea(Rectangle2D contactArea, RouteElementPort re, Point2D cornerLoc, double arcWidth, int arcAngle) {
        if (arcAngle % 1800 == 0 && contactArea.getHeight() < arcWidth) {
            contactArea.setRect(contactArea.getX(), contactArea.getCenterY() - arcWidth / 2.0, contactArea.getWidth(), arcWidth);
        }
        if ((arcAngle + 900) % 1800 == 0 && contactArea.getWidth() < arcWidth) {
            contactArea.setRect(contactArea.getCenterX() - arcWidth / 2.0, contactArea.getY(), arcWidth, contactArea.getHeight());
        }
    }

    protected static RouteElementArc addConnectingArc(Route route, Cell cell, RouteElementPort startRE, RouteElementPort endRE, Point2D startPoint, Point2D endPoint, ArcProto arc, double width, int arcAngle, boolean extendArcHead, boolean extendArcTail, PolyMerge stayInside, EDimension alignment) {
        if (extendArcHead) {
            extendArcHead = InteractiveRouter.getExtendArcEnd(startRE, startPoint, width, arc, arcAngle, extendArcHead, alignment);
        }
        if (extendArcTail) {
            extendArcTail = InteractiveRouter.getExtendArcEnd(endRE, endPoint, width, arc, arcAngle, extendArcTail, alignment);
        }
        RouteElementArc reArc = RouteElementArc.newArc(cell, arc, width, startRE, endRE, startPoint, endPoint, null, null, null, extendArcHead, extendArcTail, stayInside);
        reArc.setArcAngle(arcAngle);
        route.add(reArc);
        return reArc;
    }

    protected static boolean getExtendArcEnd(RouteElementPort re, Point2D point, double arcWidth, ArcProto arc, int arcAngle, boolean defExtends, EDimension alignment) {
        PrimitiveNode pn;
        NodeProto np = re.getNodeProto();
        if (np == null) {
            return defExtends;
        }
        if (np instanceof PrimitiveNode && (pn = (PrimitiveNode)np).getFunction().isContact()) {
            EDimension size2 = re.getNodeSize();
            if (arcAngle % 1800 == 0 && arcWidth > size2.getWidth()) {
                return false;
            }
            if ((arcAngle + 900) % 1800 == 0 && arcWidth > size2.getHeight()) {
                return false;
            }
        }
        if (alignment != null) {
            if (arcAngle == -1) {
                arcAngle = 0;
            }
            if (arcAngle % 1800 == 0) {
                if (InteractiveRouter.isNumberAligned(point.getX(), alignment.getWidth()) && !InteractiveRouter.isNumberAligned(point.getX() + arcWidth / 2.0, alignment.getWidth())) {
                    return false;
                }
                if (!InteractiveRouter.isNumberAligned(point.getX(), alignment.getWidth()) && InteractiveRouter.isNumberAligned(point.getX() + arcWidth / 2.0, alignment.getWidth())) {
                    return true;
                }
            }
            if ((arcAngle + 900) % 1800 == 0) {
                if (InteractiveRouter.isNumberAligned(point.getY(), alignment.getHeight()) && !InteractiveRouter.isNumberAligned(point.getY() + arcWidth / 2.0, alignment.getHeight())) {
                    return false;
                }
                if (!InteractiveRouter.isNumberAligned(point.getY(), alignment.getHeight()) && InteractiveRouter.isNumberAligned(point.getY() + arcWidth / 2.0, alignment.getHeight())) {
                    return true;
                }
            }
        }
        return defExtends;
    }

    private static boolean isNumberAligned(double number2, double alignment) {
        return number2 % alignment == 0.0;
    }

    protected static double getClosestValue(double min2, double max2, double clicked, double alignment) {
        if (alignment > 0.0) {
            double newMax = Math.floor(max2 / alignment) * alignment;
            if (newMax > max2) {
                newMax = max2;
            }
            if (newMax < min2) {
                newMax = min2;
            }
            max2 = newMax;
            double newMin = Math.ceil(min2 / alignment) * alignment;
            if (newMin > max2) {
                newMin = max2;
            }
            if (newMin < min2) {
                newMin = min2;
            }
            min2 = newMin;
            clicked = (double)Math.round(clicked / alignment) * alignment;
        }
        if (clicked >= max2) {
            return max2;
        }
        if (clicked <= min2) {
            return min2;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    public static Point2D getClosestAngledPoint(Point2D startPoint, Point2D clicked, int angleIncrement, EDimension alignment) {
        int nearest;
        double yFinal;
        double xFinal;
        double y;
        double x2;
        int nearest2;
        int nearest1;
        if ((angleIncrement = Math.abs(angleIncrement) * 10) == 0) {
            return clicked;
        }
        if (angleIncrement == 900) {
            return InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked);
        }
        int angle = DBMath.figureAngle(startPoint, clicked);
        for (nearest1 = angle / angleIncrement * angleIncrement; nearest1 < 0; nearest1 += 3600) {
        }
        if (nearest1 >= 3600) {
            nearest1 %= 3600;
        }
        int n = nearest2 = angle < 0 ? nearest1 - angleIncrement : nearest1 + angleIncrement;
        while (nearest2 < 0) {
            nearest2 += 3600;
        }
        if (nearest2 >= 3600) {
            nearest2 %= 3600;
        }
        double distance = clicked.distance(startPoint);
        Point2D.Double p1 = new Point2D.Double(distance * DBMath.cos(nearest1), distance * DBMath.sin(nearest1));
        Point2D.Double p2 = new Point2D.Double(distance * DBMath.cos(nearest2), distance * DBMath.sin(nearest2));
        if (p2.distance(x2 = clicked.getX() - startPoint.getX(), y = clicked.getY() - startPoint.getY()) < p1.distance(x2, y)) {
            xFinal = DBMath.round(((Point2D)p2).getX() + startPoint.getX());
            yFinal = DBMath.round(((Point2D)p2).getY() + startPoint.getY());
            nearest = nearest2;
        } else {
            xFinal = DBMath.round(((Point2D)p1).getX() + startPoint.getX());
            yFinal = DBMath.round(((Point2D)p1).getY() + startPoint.getY());
            nearest = nearest1;
        }
        Point2D.Double result2 = new Point2D.Double(xFinal, yFinal);
        int direction = -1;
        if (nearest == 0 || nearest == 1800) {
            direction = 0;
        }
        if (nearest == 900 || nearest == 2700) {
            direction = 1;
        }
        if (direction >= 0) {
            DBMath.gridAlign(result2, alignment, direction);
        } else if (alignment.getWidth() > 0.0 && alignment.getHeight() > 0.0) {
            int gridAngle;
            long ix = Math.round(startPoint.getX() / alignment.getWidth());
            long iy = Math.round(startPoint.getY() / alignment.getHeight());
            double fx = (double)ix * alignment.getWidth();
            double fy = (double)iy * alignment.getHeight();
            if (DBMath.areEquals(fx, startPoint.getX()) && DBMath.areEquals(fy, startPoint.getY()) && nearest / (gridAngle = DBMath.figureAngle(alignment.getWidth(), alignment.getHeight())) * gridAngle == nearest) {
                DBMath.gridAlign(result2, alignment);
            }
        }
        return result2;
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max2;
        double min2;
        if (bound1 < bound2) {
            min2 = bound1;
            max2 = bound2;
        } else {
            min2 = bound2;
            max2 = bound1;
        }
        return point >= min2 && point <= max2;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head2 = line.getP1();
        Point2D tail = line.getP2();
        if (head2.getX() < tail.getX()) {
            minX = head2.getX();
            maxX = tail.getX();
        } else {
            minX = tail.getX();
            maxX = head2.getX();
        }
        if (head2.getY() < tail.getY()) {
            minY = head2.getY();
            maxY = tail.getY();
        } else {
            minY = tail.getY();
            maxY = head2.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    protected static int findQuadrant(Point2D refPoint, Point2D pt) {
        double angle = Math.atan((pt.getY() - refPoint.getY()) / (pt.getX() - refPoint.getX()));
        if (pt.getX() < refPoint.getX()) {
            angle += Math.PI;
        }
        if (angle > -0.7853981633974483 && angle <= 0.7853981633974483) {
            return 0;
        }
        if (angle > 0.7853981633974483 && angle <= 2.356194490192345) {
            return 1;
        }
        if (angle > 2.356194490192345 && angle <= 3.9269908169872414) {
            return 2;
        }
        return 3;
    }

    private static class MakeVerticalRouteJob
    extends Router.CreateRouteJob {
        protected MakeVerticalRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), route, cell, verbose, Routing.getRoutingTool());
        }

        @Override
        public boolean doIt() throws JobException {
            PortInst pi;
            NodeInst ni;
            if (!super.doIt()) {
                return false;
            }
            EditingPreferences ep = this.getEditingPreferences();
            RouteElementPort startRE = this.route.getStart();
            if (startRE.getAction() == RouteElement.RouteElementAction.existingPortInst && (ni = (pi = startRE.getPortInst()).getNodeInst()).getProto().getFunction().isPin()) {
                CircuitChangeJobs.Reconnect re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true, this.getEditingPreferences());
                if (re != null) {
                    re.reconnectArcs(ep);
                }
                if (!ni.hasExports()) {
                    ni.kill();
                }
            }
            return true;
        }
    }
}

