/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ErrorLoggerTree {
    public static final String errorNode = "ERRORS";
    private static final DefaultMutableTreeNode errorTree = new DefaultMutableTreeNode("ERRORS");
    private static final TreePath errorPath = new TreePath("Explorer").pathByAddingChild(errorTree);
    static DefaultMutableTreeNode currentLogger;
    private static final ErrorLogger networkErrorLogger;
    private static DefaultMutableTreeNode networkTree;
    private static DefaultMutableTreeNode drcTree;

    public static boolean hasLogger(ErrorLogger logger) {
        return ErrorLoggerTree.indexOf(logger) >= 0;
    }

    public static void addLogger(ErrorLogger logger, boolean explain, boolean terminate2) {
        logger.termLogging_(terminate2);
        if (logger.getNumLogs() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new AddLogger(logger, explain));
    }

    public static void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        SwingUtilities.invokeLater(new UpdateNetwork(cell.getId(), errors));
    }

    public static void updateDrcErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        SwingUtilities.invokeLater(new UpdateDrc(cell.getId(), newErrors, delErrors));
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return errorTree;
    }

    public static void reportSingleGeometry(boolean separateWindow) {
        if (currentLogger == null) {
            System.out.println("No errors to report");
            return;
        }
        ((ErrorLoggerTreeNode)ErrorLoggerTree.currentLogger.getUserObject()).reportSingleGeometry_(true, separateWindow);
    }

    public static String reportNextMessage(boolean separateWindow) {
        if (currentLogger == null) {
            return "No errors to report";
        }
        return ((ErrorLoggerTreeNode)ErrorLoggerTree.currentLogger.getUserObject()).reportNextMessage_(true, separateWindow);
    }

    public static String reportPrevMessage(boolean separateWindow) {
        if (currentLogger == null) {
            return "No errors to report";
        }
        return ((ErrorLoggerTreeNode)ErrorLoggerTree.currentLogger.getUserObject()).reportPrevMessage_(separateWindow);
    }

    public static void showCurrentErrors() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (currentLogger == null) {
            return;
        }
        Job.getUserInterface().getCurrentEditWindow_().clearHighlighting();
        ErrorLoggerTreeNode node = (ErrorLoggerTreeNode)currentLogger.getUserObject();
        int index = ErrorLoggerTree.indexOf(node);
        ErrorLoggerTree.highlightLogger(index, -1);
        Job.getUserInterface().getCurrentEditWindow_().finishedHighlighting();
    }

    private static void explain(ErrorLogger logger) {
        String extraMsg = "errors/warnings";
        if (logger.getNumErrors() == 0) {
            extraMsg = "warnings";
        } else if (logger.getNumWarnings() == 0) {
            extraMsg = "errors";
        }
        String msg = logger.getInfo();
        System.out.println(msg);
        if (logger.getNumLogs() > 0) {
            System.out.println("Type > and < to step through " + extraMsg + ", or open the ERRORS view in the explorer");
        }
        if (logger.getNumErrors() > 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg, logger.getSystem() + " finished with Errors", 1);
        }
    }

    private static DefaultMutableTreeNode addLogger(int index, ErrorLogger logger) {
        ErrorLoggerTreeNode tn = new ErrorLoggerTreeNode(logger);
        UserInterfaceMain.addDatabaseChangeListener(tn);
        ErrorLoggerDefaultMutableTreeNode newNode = new ErrorLoggerDefaultMutableTreeNode(tn);
        int[] childIndices = new int[]{index};
        Object[] children2 = new DefaultMutableTreeNode[]{newNode};
        ErrorLoggerTree.setCurrent(-1);
        errorTree.insert(newNode, index);
        currentLogger = newNode;
        ExplorerTreeModel.fireTreeNodesInserted(errorTree, errorPath, childIndices, children2);
        ErrorLoggerTree.updateTree(newNode);
        return newNode;
    }

    private static void removeLogger(int index) {
        if (errorTree.getChildCount() <= index) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)errorTree.getChildAt(index);
        ErrorLoggerTreeNode treeNode = (ErrorLoggerTreeNode)node.getUserObject();
        UserInterfaceMain.removeDatabaseChangeListener(treeNode);
        ErrorLogger drcErrorLogger = DRC.getDRCIncrementalLogger();
        if (treeNode.getLogger() == drcErrorLogger) {
            drcErrorLogger.clearAllLogs();
        }
        if (node == networkTree) {
            networkTree = null;
        }
        if (node == drcTree) {
            drcTree = null;
        }
        if (node == currentLogger) {
            currentLogger = null;
        }
        int[] childIndices = new int[]{index};
        Object[] children2 = new DefaultMutableTreeNode[]{node};
        errorTree.remove(index);
        ExplorerTreeModel.fireTreeNodesRemoved(errorTree, errorPath, childIndices, children2);
    }

    private static void highlightLogger(int index, int sortKey) {
        EditWindow ew = EditWindow.getCurrent();
        if (ew == null) {
            return;
        }
        Highlighter h = ew.getHighlighter();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)errorTree.getChildAt(index);
        ErrorLoggerTreeNode eltn = (ErrorLoggerTreeNode)node.getUserObject();
        ErrorLogger el = eltn.getLogger();
        EDatabase database = EDatabase.clientDatabase();
        for (int i = 0; i < el.getNumLogs(); ++i) {
            ErrorLogger.MessageLog ml = el.getLog(i);
            if (sortKey >= 0 && ml.getSortKey() != sortKey) continue;
            Iterator<ErrorHighlight> it = ml.getHighlights();
            while (it.hasNext()) {
                ErrorHighlight eh = it.next();
                eh.addToHighlighter(h, database);
            }
        }
    }

    private static void updateTree(DefaultMutableTreeNode loggerNode) {
        ErrorLoggerTreeNode eltn;
        ErrorLogger logger;
        TreePath loggerPath = errorPath.pathByAddingChild(loggerNode);
        int oldChildCount = loggerNode.getChildCount();
        if (oldChildCount != 0) {
            int[] childIndex = new int[oldChildCount];
            Object[] children2 = new DefaultMutableTreeNode[oldChildCount];
            for (int i = 0; i < oldChildCount; ++i) {
                childIndex[i] = i;
                children2[i] = (DefaultMutableTreeNode)loggerNode.getChildAt(i);
            }
            loggerNode.removeAllChildren();
            ExplorerTreeModel.fireTreeNodesRemoved(errorTree, loggerPath, childIndex, children2);
        }
        if ((logger = (eltn = (ErrorLoggerTreeNode)loggerNode.getUserObject()).logger).getNumLogs() == 0) {
            return;
        }
        HashMap<Integer, DefaultMutableTreeNode> sortKeyMap = new HashMap<Integer, DefaultMutableTreeNode>();
        Map<Integer, String> sortKeyGroupNamesMap = logger.getSortKeyToGroupNames();
        if (sortKeyGroupNamesMap != null) {
            for (Map.Entry<Integer, String> e : sortKeyGroupNamesMap.entrySet()) {
                String name = e.getValue();
                Integer key = e.getKey();
                DefaultMutableTreeNode grpNode = new DefaultMutableTreeNode(new ErrorLoggerGroupNode(name, key, eltn));
                loggerNode.add(grpNode);
                sortKeyMap.put(key, grpNode);
            }
        }
        Iterator<ErrorLogger.MessageLog> it = logger.getLogs();
        while (it.hasNext()) {
            ErrorLogger.MessageLog el = it.next();
            DefaultMutableTreeNode groupNode = loggerNode;
            if (logger.getSortKeyToGroupNames() != null && (groupNode = (DefaultMutableTreeNode)sortKeyMap.get(new Integer(el.getSortKey()))) == null) {
                groupNode = loggerNode;
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(el);
            groupNode.add(node);
        }
        int newChildCount = loggerNode.getChildCount();
        int[] childIndex = new int[newChildCount];
        Object[] children3 = new DefaultMutableTreeNode[newChildCount];
        for (int i = 0; i < newChildCount; ++i) {
            childIndex[i] = i;
            children3[i] = (DefaultMutableTreeNode)loggerNode.getChildAt(i);
        }
        ExplorerTreeModel.fireTreeNodesInserted(errorTree, loggerPath, childIndex, children3);
    }

    private static void setCurrent(int index) {
        int oldIndex;
        int n = oldIndex = currentLogger != null ? ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)currentLogger.getUserObject()) : -1;
        if (index == oldIndex) {
            return;
        }
        currentLogger = index >= 0 ? (DefaultMutableTreeNode)errorTree.getChildAt(index) : null;
        int l = 0;
        if (oldIndex >= 0) {
            ++l;
        }
        if (index >= 0) {
            ++l;
        }
        int[] childIndex = new int[l];
        Object[] children2 = new TreeNode[l];
        l = 0;
        if (oldIndex >= 0 && oldIndex < index) {
            childIndex[l] = oldIndex;
            children2[l] = errorTree.getChildAt(oldIndex);
            ++l;
        }
        if (index >= 0) {
            childIndex[l] = index;
            children2[l] = errorTree.getChildAt(index);
            ++l;
        }
        if (oldIndex >= 0 && oldIndex > index) {
            childIndex[l] = oldIndex;
            children2[l] = errorTree.getChildAt(oldIndex);
            ++l;
        }
        ExplorerTreeModel.fireTreeNodesChanged(errorTree, errorPath, childIndex, children2);
    }

    private static int indexOf(ErrorLoggerTreeNode tn) {
        int numLoggers = errorTree.getChildCount();
        for (int i = 0; i < numLoggers; ++i) {
            if (((DefaultMutableTreeNode)errorTree.getChildAt(i)).getUserObject() != tn) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(ErrorLogger logger) {
        int numLoggers = errorTree.getChildCount();
        for (int i = 0; i < numLoggers; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)errorTree.getChildAt(i);
            ErrorLoggerTreeNode errorLoggerTreeNode = (ErrorLoggerTreeNode)defaultMutableTreeNode.getUserObject();
            if (errorLoggerTreeNode.logger != logger) continue;
            return i;
        }
        return -1;
    }

    public static void importLogger() {
        String fileName = OpenFile.chooseInputFile(FileType.XML, "Read ErrorLogger");
        if (fileName == null) {
            return;
        }
        try {
            ErrorLogger.XMLParser parser = new ErrorLogger.XMLParser();
            ErrorLogger logger = parser.process(TextUtils.makeURLToFile(fileName), true);
            ErrorLoggerTree.addLogger(logger, false, true);
        }
        catch (Exception e) {
            System.out.println("Error loading " + fileName);
            return;
        }
    }

    public static void deleteAllLoggers() {
        for (int i = errorTree.getChildCount() - 1; i >= 0; --i) {
            ErrorLoggerTree.removeLogger(i);
        }
    }

    public static void deleteLogger(ExplorerTree ex) {
        TreePath[] paths = ex.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            Object clickedObject;
            Object obj = paths[i].getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode) || !((clickedObject = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof ErrorLoggerTreeNode)) continue;
            int index = ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)clickedObject);
            ErrorLoggerTree.removeLogger(index);
        }
    }

    public static void exportLogger(ErrorLoggerTreeNode node) {
        ErrorLogger logger = node.getLogger();
        String filePath = null;
        try {
            filePath = OpenFile.chooseOutputFile(FileType.XML, null, "ErrorLoggerSave.xml");
            if (filePath == null) {
                return;
            }
            logger.exportErrorLogger(filePath);
        }
        catch (Exception se) {
            if (Job.getDebug()) {
                se.printStackTrace();
            }
            System.out.println("Error creating " + filePath);
        }
    }

    public static void showAllLogger(ExplorerTree ex) {
        Job.getUserInterface().getCurrentEditWindow_().clearHighlighting();
        TreePath[] paths = ex.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            Object obj = paths[i].getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode)) continue;
            Object clickedObject = ((DefaultMutableTreeNode)obj).getUserObject();
            if (clickedObject instanceof ErrorLoggerTreeNode) {
                int index = ErrorLoggerTree.indexOf((ErrorLoggerTreeNode)clickedObject);
                ErrorLoggerTree.highlightLogger(index, -1);
                continue;
            }
            if (clickedObject instanceof ErrorLoggerGroupNode) {
                ErrorLoggerGroupNode egn = (ErrorLoggerGroupNode)clickedObject;
                int sortKey = egn.getSortKey();
                int index = ErrorLoggerTree.indexOf(egn.getParentNode());
                ErrorLoggerTree.highlightLogger(index, sortKey);
                continue;
            }
            if (!(clickedObject instanceof ErrorLogger.MessageLog)) continue;
            ErrorLogger.MessageLog ml = (ErrorLogger.MessageLog)clickedObject;
            EditWindow ew = EditWindow.getCurrent();
            if (ew == null) {
                return;
            }
            Highlighter h = ew.getHighlighter();
            EDatabase database = EDatabase.clientDatabase();
            Iterator<ErrorHighlight> it = ml.getHighlights();
            while (it.hasNext()) {
                ErrorHighlight eh = it.next();
                eh.addToHighlighter(h, database);
            }
        }
        Job.getUserInterface().getCurrentEditWindow_().finishedHighlighting();
    }

    public static void setCurrentLogger(ErrorLoggerTreeNode node) {
        int index = ErrorLoggerTree.indexOf(node);
        ErrorLoggerTree.setCurrent(index);
    }

    static {
        networkErrorLogger = ErrorLogger.newInstance("Network Errors");
    }

    public static class ErrorLoggerTreeNode
    implements DatabaseChangeListener {
        private ErrorLogger logger;
        private int currentLogNumber = -1;
        private ErrorLogger.MessageLog currentMsgLog;
        private int currentMsgLogGeoIndex;

        ErrorLoggerTreeNode(ErrorLogger log2) {
            this.logger = log2;
        }

        public void setLogNumber(int number2) {
            this.currentLogNumber = number2;
            this.currentMsgLog = this.logger.getLog(number2);
        }

        public ErrorLogger getLogger() {
            return this.logger;
        }

        public String toString() {
            return "ErrorLogger Information: " + this.logger.getInfo();
        }

        private int getNextMessageNumber() {
            int currentLogNumber = this.currentLogNumber;
            if (currentLogNumber < this.logger.getNumLogs() - 1) {
                ++currentLogNumber;
            } else {
                if (this.logger.getNumLogs() <= 0) {
                    return -1;
                }
                currentLogNumber = 0;
            }
            return currentLogNumber;
        }

        private void reportSingleGeometry_(boolean showHigh, boolean separateWindow) {
            if (this.currentMsgLog == null) {
                this.currentLogNumber = this.getNextMessageNumber();
                if (this.currentLogNumber < 0) {
                    return;
                }
                this.currentMsgLog = this.logger.getLog(this.currentLogNumber);
                this.currentMsgLogGeoIndex = 0;
            }
            Job.getUserInterface().reportLog(this.currentMsgLog, showHigh, separateWindow, this.currentMsgLogGeoIndex);
            this.currentMsgLogGeoIndex = this.currentMsgLogGeoIndex < this.currentMsgLog.getNumHighlights() - 1 ? this.currentMsgLogGeoIndex + 1 : 0;
        }

        private String reportNextMessage_(boolean showHigh, boolean separateWindow) {
            this.currentLogNumber = this.getNextMessageNumber();
            if (this.currentLogNumber < 0) {
                return "No " + this.logger.getSystem() + " errors";
            }
            return this.reportLog(this.currentLogNumber, showHigh, separateWindow);
        }

        private String reportPrevMessage_(boolean separateWindow) {
            if (this.currentLogNumber > 0) {
                --this.currentLogNumber;
            } else {
                if (this.logger.getNumLogs() <= 0) {
                    return "No " + this.logger.getSystem() + " errors";
                }
                this.currentLogNumber = this.logger.getNumLogs() - 1;
            }
            return this.reportLog(this.currentLogNumber, true, separateWindow);
        }

        private String reportLog(int logNumber, boolean showHigh, boolean separateWindow) {
            if (logNumber < 0 || logNumber >= this.logger.getNumLogs()) {
                return this.logger.getSystem() + ": no such error or warning " + (logNumber + 1) + ", only " + this.logger.getNumLogs() + " errors.";
            }
            this.currentMsgLog = this.logger.getLog(logNumber);
            this.currentMsgLogGeoIndex = 0;
            String extraMsg = null;
            extraMsg = logNumber < this.logger.getNumErrors() ? " error " + (logNumber + 1) + " of " + this.logger.getNumErrors() : " warning " + (logNumber + 1 - this.logger.getNumErrors()) + " of " + this.logger.getNumWarnings();
            String message = Job.getUserInterface().reportLog(this.currentMsgLog, showHigh, separateWindow, -1);
            return this.logger.getSystem() + extraMsg + ": " + message;
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent e) {
            boolean changed = false;
            for (int i = this.logger.getNumLogs() - 1; i >= 0; --i) {
                ErrorLogger.MessageLog err2 = this.logger.getLog(i);
                if (err2.isValid(EDatabase.clientDatabase())) continue;
                this.logger.deleteLog(i);
                if (i < this.currentLogNumber) {
                    --this.currentLogNumber;
                } else if (i == this.currentLogNumber) {
                    this.currentLogNumber = 0;
                }
                changed = true;
            }
            if (!changed) {
                return;
            }
            int index = ErrorLoggerTree.indexOf(this);
            if (index < 0) {
                return;
            }
            if (this.logger.getNumLogs() == 0) {
                ErrorLoggerTree.removeLogger(index);
            } else {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (wf != null) {
                    ExplorerTree tree = wf.getExplorerTab();
                    ExplorerTreeModel etm = tree.model();
                    ExplorerTree.KeepTreeExpansion kte = new ExplorerTree.KeepTreeExpansion(tree, etm.getRoot(), etm, errorPath);
                    ErrorLoggerTree.updateTree((DefaultMutableTreeNode)errorTree.getChildAt(index));
                    kte.restore();
                }
            }
        }
    }

    public static class ErrorLoggerGroupNode {
        private String name;
        private int sortKey;
        private ErrorLoggerTreeNode parent;

        ErrorLoggerGroupNode(String s, int k, ErrorLoggerTreeNode p) {
            this.name = s;
            this.sortKey = k;
            this.parent = p;
        }

        public int getSortKey() {
            return this.sortKey;
        }

        public ErrorLoggerTreeNode getParentNode() {
            return this.parent;
        }

        public boolean equals(Object x2) {
            if (x2 instanceof ErrorLoggerGroupNode) {
                ErrorLoggerGroupNode elgn = (ErrorLoggerGroupNode)x2;
                if (elgn.name.equals(this.name) && elgn.parent == this.parent) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ErrorLoggerDefaultMutableTreeNode
    extends DefaultMutableTreeNode {
        ErrorLoggerDefaultMutableTreeNode(ErrorLoggerTreeNode tn) {
            super(tn);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private static class UpdateDrc
    implements Runnable {
        private CellId cellId;
        private List<ErrorLogger.MessageLog> newErrors;
        private List<ErrorLogger.MessageLog> delErrors;

        UpdateDrc(CellId cId, List<ErrorLogger.MessageLog> newErrs, List<ErrorLogger.MessageLog> delErrs) {
            this.cellId = cId;
            if (newErrs != null) {
                this.newErrors = new ArrayList<ErrorLogger.MessageLog>(newErrs);
            }
            if (delErrs != null) {
                this.delErrors = new ArrayList<ErrorLogger.MessageLog>(delErrs);
            }
        }

        @Override
        public void run() {
            int index;
            Cell cell = EDatabase.clientDatabase().getCell(this.cellId);
            if (cell == null) {
                return;
            }
            ErrorLogger drcErrorLogger = DRC.getDRCIncrementalLogger();
            drcErrorLogger.addMessages(this.newErrors);
            drcErrorLogger.deleteMessages(this.delErrors);
            drcErrorLogger.termLogging_(true);
            int n = index = networkTree != null ? 1 : 0;
            if (drcErrorLogger.getNumLogs() == 0) {
                if (drcTree != null) {
                    ErrorLoggerTree.removeLogger(errorTree.getIndex(drcTree));
                }
                return;
            }
            if (drcTree == null) {
                drcTree = ErrorLoggerTree.addLogger(index, drcErrorLogger);
            }
            ErrorLoggerTree.updateTree(drcTree);
            ErrorLoggerTree.setCurrent(index);
        }
    }

    private static class UpdateNetwork
    implements Runnable {
        private CellId cellId;
        private List<ErrorLogger.MessageLog> errors;

        UpdateNetwork(CellId cellId, List<ErrorLogger.MessageLog> errors) {
            this.cellId = cellId;
            this.errors = new ArrayList<ErrorLogger.MessageLog>(errors);
        }

        @Override
        public void run() {
            Cell cell = EDatabase.clientDatabase().getCell(this.cellId);
            if (cell == null) {
                return;
            }
            boolean changed = networkErrorLogger.clearLogs(cell) || !this.errors.isEmpty();
            networkErrorLogger.addMessages(this.errors);
            if (!changed) {
                return;
            }
            networkErrorLogger.termLogging_(true);
            if (networkErrorLogger.getNumLogs() == 0) {
                ErrorLoggerTree.removeLogger(0);
                return;
            }
            if (networkTree == null) {
                networkTree = ErrorLoggerTree.addLogger(0, networkErrorLogger);
            }
            ErrorLoggerTree.updateTree(networkTree);
            ErrorLoggerTree.setCurrent(0);
        }
    }

    private static class AddLogger
    implements Runnable {
        private ErrorLogger logger;
        private boolean explain;

        AddLogger(ErrorLogger logger, boolean explain) {
            this.logger = logger;
            this.explain = explain;
        }

        @Override
        public void run() {
            int i = ErrorLoggerTree.indexOf(this.logger);
            if (i >= 0) {
                ErrorLoggerTree.updateTree((DefaultMutableTreeNode)errorTree.getChildAt(i));
            } else {
                ErrorLoggerTree.addLogger(errorTree.getChildCount(), this.logger);
                if (this.explain) {
                    ErrorLoggerTree.explain(this.logger);
                }
            }
        }
    }
}

