/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.simulation.BusSample;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.WaveformZoom;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import com.sun.electric.tool.user.waveform.DragButton;
import com.sun.electric.tool.user.waveform.HorizRuler;
import com.sun.electric.tool.user.waveform.StepSize;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Panel
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private static final boolean USE_VOLATILE_IMAGE = false;
    private static final boolean USE_ANTIALIASING = false;
    private static final int PANELGAP = 2;
    private WaveformWindow waveWindow;
    private Dimension sz;
    private boolean szValid;
    private Signal<?> xAxisSignal;
    private LinkedHashMap<JComponent, WaveSignal> waveSignals = new LinkedHashMap();
    private JPanel signalButtons;
    private int signalButtonsHighIndex;
    private JScrollPane signalButtonsPane;
    private JPanel leftHalf;
    private JPanel rightHalf;
    private DragButton panelTitle;
    private JButton close;
    private JButton hide;
    private JButton deleteSignal;
    private JButton deleteAllSignals;
    private double minXPosition;
    private double maxXPosition;
    private double analogLowValue;
    private double analogHighValue;
    private double analogRange;
    private boolean draggingMain;
    private boolean draggingExt;
    private boolean draggingVertAxis;
    private boolean draggingArea;
    private List<Rectangle2D> measurementList;
    private Rectangle2D curMeasurement;
    private boolean selected;
    private boolean hidden;
    private HorizRuler horizRulerPanel;
    private boolean horizRulerPanelLogarithmic;
    private boolean vertPanelLogarithmic;
    private int panelNumber;
    private double dragStartXD;
    private double dragStartYD;
    private double dragEndXD;
    private double dragEndYD;
    private int vertAxisPos;
    private double smallestXValue;
    private double smallestYValue;
    private Color background = null;
    private long lastClick = 0L;
    private static final Color gridColor = new Color(0x808080);
    private static final BasicStroke farDottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 12.0f}, 0.0f);
    private static final int CONTROLPOINTSIZE = 6;
    private static final int VERTLABELWIDTH = 60;
    private static final ImageIcon iconHidePanel = Resources.getResource(WaveformWindow.class, "ButtonSimHide.gif");
    private static final ImageIcon iconClosePanel = Resources.getResource(WaveformWindow.class, "ButtonSimClose.gif");
    private static final ImageIcon iconDeleteSignal = Resources.getResource(WaveformWindow.class, "ButtonSimDelete.gif");
    private static final ImageIcon iconDeleteAllSignals = Resources.getResource(WaveformWindow.class, "ButtonSimDeleteAll.gif");
    private static final Cursor dragXPositionCursor = ToolBar.readCursor("CursorDragTime.gif", 8, 8);
    private boolean needRepaintOffscreenImage;
    private Image offscreen;

    public Panel(WaveformWindow waveWindow, int height) {
        this.waveWindow = waveWindow;
        this.selected = false;
        this.panelNumber = waveWindow.getNewPanelNumber();
        this.vertAxisPos = 60;
        this.horizRulerPanelLogarithmic = false;
        this.vertPanelLogarithmic = false;
        this.xAxisSignal = null;
        this.measurementList = new ArrayList<Rectangle2D>();
        this.curMeasurement = null;
        this.sz = new Dimension(50, height);
        this.szValid = false;
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.setLayout(new FlowLayout());
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setXAxisRange(waveWindow.getLowDefaultHorizontalRange(), waveWindow.getHighDefaultHorizontalRange());
        this.leftHalf = new WaveformWindow.OnePanel(this, waveWindow);
        this.leftHalf.setLayout(new GridBagLayout());
        this.leftHalf.setPreferredSize(new Dimension(100, height));
        new DropTarget(this.leftHalf, 0x40000000, waveWindow.waveformDropTarget, true);
        this.panelTitle = new DragButton("" + Integer.toString(this.panelNumber), this.panelNumber);
        this.panelTitle.setToolTipText("Identification number of this waveform panel (drag the number to rearrange panels)");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 1);
        this.panelTitle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Panel.this.panelTitleClicked(evt);
            }
        });
        this.leftHalf.add((Component)this.panelTitle, gbc);
        this.close = new JButton(iconClosePanel);
        this.close.setBorderPainted(false);
        this.close.setDefaultCapable(false);
        this.close.setToolTipText("Close this waveform panel");
        Dimension minWid = new Dimension(iconClosePanel.getIconWidth() + 4, iconClosePanel.getIconHeight() + 4);
        this.close.setMinimumSize(minWid);
        this.close.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 1, 0, 2);
        this.leftHalf.add((Component)this.close, gbc);
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Panel.this.closePanel();
            }
        });
        this.hide = new JButton(iconHidePanel);
        this.hide.setBorderPainted(false);
        this.hide.setDefaultCapable(false);
        this.hide.setToolTipText("Hide this waveform panel");
        minWid = new Dimension(iconHidePanel.getIconWidth() + 4, iconHidePanel.getIconHeight() + 4);
        this.hide.setMinimumSize(minWid);
        this.hide.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.leftHalf.add((Component)this.hide, gbc);
        this.hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Panel.this.hidePanel();
            }
        });
        this.deleteSignal = new JButton(iconDeleteSignal);
        this.deleteSignal.setBorderPainted(false);
        this.deleteSignal.setDefaultCapable(false);
        this.deleteSignal.setToolTipText("Remove selected signals from this panel");
        minWid = new Dimension(iconDeleteSignal.getIconWidth() + 4, iconDeleteSignal.getIconHeight() + 4);
        this.deleteSignal.setMinimumSize(minWid);
        this.deleteSignal.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.leftHalf.add((Component)this.deleteSignal, gbc);
        this.deleteSignal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Panel.this.deleteSignalFromPanel();
            }
        });
        this.deleteAllSignals = new JButton(iconDeleteAllSignals);
        this.deleteAllSignals.setBorderPainted(false);
        this.deleteAllSignals.setDefaultCapable(false);
        this.deleteAllSignals.setToolTipText("Remove all signals from this panel");
        minWid = new Dimension(iconDeleteAllSignals.getIconWidth() + 4, iconDeleteAllSignals.getIconHeight() + 4);
        this.deleteAllSignals.setMinimumSize(minWid);
        this.deleteAllSignals.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 4);
        this.leftHalf.add((Component)this.deleteAllSignals, gbc);
        this.deleteAllSignals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Panel.this.deleteAllSignalsFromPanel();
            }
        });
        this.signalButtonsHighIndex = 0;
        this.signalButtons = new JPanel();
        this.signalButtons.setLayout(new GridBagLayout());
        this.signalButtonsPane = new JScrollPane(this.signalButtons);
        this.signalButtonsPane.setHorizontalScrollBarPolicy(31);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.leftHalf.add((Component)this.signalButtonsPane, gbc);
        this.rightHalf = new JPanel();
        this.rightHalf.setLayout(new GridBagLayout());
        this.rightHalf.setPreferredSize(new Dimension(100, height));
        new DropTarget(this, 0x40000000, waveWindow.waveformDropTarget, true);
        if (!waveWindow.isXAxisLocked()) {
            this.addHorizRulerPanel();
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 0, 2, 0);
        this.rightHalf.add((Component)this, gbc);
        waveWindow.addPanel(this);
        waveWindow.getWaveformTable().repaint();
        waveWindow.getWaveformTable().doLayout();
        waveWindow.getWaveformTable().updateUI();
        waveWindow.rebuildPanelList();
        waveWindow.redrawAllPanels();
    }

    public WaveformWindow getWaveWindow() {
        return this.waveWindow;
    }

    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    public JPanel getLeftHalf() {
        return this.leftHalf;
    }

    public JPanel getRightHalf() {
        return this.rightHalf;
    }

    private void makeLinear() {
        this.setPanelLogarithmicVertically(false);
    }

    private void makeLogarithmic() {
        this.setPanelLogarithmicVertically(true);
    }

    public void setPanelLogarithmicVertically(boolean logarithmic) {
        this.vertPanelLogarithmic = logarithmic;
        this.repaintContents();
    }

    public boolean isAnalog() {
        for (JComponent comp : this.waveSignals.keySet()) {
            WaveSignal ws = this.waveSignals.get(comp);
            Signal<?> sig = ws.getSignal();
            if (sig.isDigital()) continue;
            return true;
        }
        return false;
    }

    public JPanel getSignalButtons() {
        return this.signalButtons;
    }

    public JScrollPane getSignalButtonsPane() {
        return this.signalButtonsPane;
    }

    public int getPanelNumber() {
        return this.panelNumber;
    }

    public void setPanelLogarithmicHorizontally(boolean logarithmic) {
        this.horizRulerPanelLogarithmic = logarithmic;
        this.horizRulerPanel.repaint();
    }

    public boolean isPanelLogarithmicHorizontally() {
        if (this.waveWindow.isXAxisLocked()) {
            return this.waveWindow.isWaveWindowLogarithmic();
        }
        return this.horizRulerPanelLogarithmic;
    }

    public boolean isPanelLogarithmicVertically() {
        return this.vertPanelLogarithmic;
    }

    public int getVertAxisPos() {
        return this.vertAxisPos;
    }

    public void setVertAxisPos(int x2) {
        this.vertAxisPos = x2;
    }

    public Dimension getSz() {
        return this.sz;
    }

    public void addSignal(WaveSignal sig, JComponent comp) {
        this.waveSignals.put(comp, sig);
        this.updatePanelTitle();
    }

    public void updatePanelTitle() {
        String panelTitleName = "" + this.panelNumber;
        if (this.waveSignals.size() != 1) {
            panelTitleName = this.waveSignals.size() != 0 ? panelTitleName + ": (" + this.waveSignals.size() + " SIGNALS)" : panelTitleName + ": (NO SIGNALS)";
        } else {
            boolean signalsVisible = false;
            JTable table = this.waveWindow.getWaveformTable();
            for (int i = 0; i < table.getRowCount(); ++i) {
                int rowHeight;
                if (this != this.waveWindow.getPanel(i) || (rowHeight = table.getRowHeight(i)) < 55) continue;
                signalsVisible = true;
            }
            if (!signalsVisible) {
                Collection<WaveSignal> justOneWS = this.waveSignals.values();
                WaveSignal ws = justOneWS.iterator().next();
                Signal<?> sig = ws.getSignal();
                panelTitleName = panelTitleName + ": " + sig.getSignalName();
            }
        }
        this.panelTitle.setText(panelTitleName);
    }

    public void removeSignal(JComponent panel) {
        if (this.signalButtons != null) {
            this.signalButtons.remove(panel);
        }
        this.waveSignals.remove(panel);
        this.updatePanelTitle();
    }

    public void removeAllSignals() {
        this.waveSignals.clear();
        this.updatePanelTitle();
    }

    public List<WaveSignal> getSignals() {
        ArrayList<WaveSignal> signals = new ArrayList<WaveSignal>();
        for (JComponent comp : this.waveSignals.keySet()) {
            WaveSignal ws = this.waveSignals.get(comp);
            signals.add(ws);
        }
        return signals;
    }

    public int getNumSignals() {
        return this.waveSignals.size();
    }

    public int getNewSignalButtonIndex() {
        return this.signalButtonsHighIndex++;
    }

    public WaveSignal findWaveSignal(Signal<?> sig) {
        for (JComponent comp : this.waveSignals.keySet()) {
            WaveSignal ws = this.waveSignals.get(comp);
            if (ws.getSignal() != sig) continue;
            return ws;
        }
        return null;
    }

    public WaveSignal findWaveSignal(JComponent comp) {
        WaveSignal sig = this.waveSignals.get(comp);
        return sig;
    }

    public JComponent findButton(WaveSignal ws) {
        for (JComponent comp : this.waveSignals.keySet()) {
            WaveSignal oWs = this.waveSignals.get(comp);
            if (oWs != ws) continue;
            return comp;
        }
        return null;
    }

    private void deleteSignalFromPanel() {
        this.waveWindow.deleteSignalFromPanel(this);
    }

    private void deleteAllSignalsFromPanel() {
        this.waveWindow.deleteAllSignalsFromPanel(this);
    }

    public void addHorizRulerPanel() {
        this.horizRulerPanel = new HorizRuler(this, this.waveWindow);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.rightHalf.add((Component)this.horizRulerPanel, gbc);
    }

    public void removeHorizRulerPanel() {
        this.rightHalf.remove(this.horizRulerPanel);
        this.horizRulerPanel = null;
    }

    public HorizRuler getHorizRuler() {
        return this.horizRulerPanel;
    }

    public Signal<?> getXAxisSignal() {
        return this.xAxisSignal;
    }

    public void setXAxisSignal(Signal<?> sig) {
        this.xAxisSignal = sig;
    }

    public void hidePanel() {
        this.waveWindow.hidePanel(this);
    }

    public void closePanel() {
        this.waveWindow.closePanel(this);
        this.waveWindow.saveSignalOrder();
    }

    public void toggleBusContents() {
        Collection<WaveSignal> theSignals = this.waveSignals.values();
        if (theSignals.size() != 1) {
            return;
        }
        WaveSignal ws = theSignals.iterator().next();
        if (!ws.getSignal().isDigital()) {
            return;
        }
        Signal<?> sDSig = ws.getSignal();
        Signal<?>[] bussedSignals = sDSig.getBusMembers();
        if (bussedSignals == null) {
            return;
        }
        boolean opened = false;
        for (Signal<?> subSig : bussedSignals) {
            WaveSignal subWs = this.waveWindow.findDisplayedSignal(subSig);
            if (subWs == null) continue;
            opened = true;
            break;
        }
        if (opened) {
            ArrayList<Panel> allPanels = new ArrayList<Panel>();
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                allPanels.add(it.next());
            }
            for (Signal<?> subSig : bussedSignals) {
                WaveSignal subWs = this.waveWindow.findDisplayedSignal(subSig);
                if (subWs == null) continue;
                Panel wp = subWs.getPanel();
                this.waveWindow.closePanel(wp);
                allPanels.remove(wp);
            }
        } else {
            int increment = 1;
            this.waveWindow.stopEditing();
            for (Signal<?> subSig : bussedSignals) {
                Panel wp = this.waveWindow.makeNewPanel(-1);
                WaveSignal wsig = new WaveSignal(wp, subSig);
                this.waveWindow.removePanel(wsig.getPanel());
                int destIndex = this.waveWindow.getPanelIndex(this);
                this.waveWindow.addPanel(wsig.getPanel(), destIndex + increment);
                ++increment;
            }
            this.waveWindow.reloadTable();
        }
        this.waveWindow.validatePanel();
        this.waveWindow.saveSignalOrder();
    }

    public void setXAxisRange(double leftEdge, double rightEdge) {
        if (leftEdge == rightEdge) {
            rightEdge = leftEdge + 1.0E-8;
        }
        this.minXPosition = leftEdge;
        this.maxXPosition = rightEdge;
    }

    public double getMinXAxis() {
        return this.minXPosition;
    }

    public double getMaxXAxis() {
        return this.maxXPosition;
    }

    public void fitToSignal(Signal<?> sig) {
        double lowValue = Double.MAX_VALUE;
        double highValue = -1.7976931348623157E308;
        for (WaveSignal wSig : this.getSignals()) {
            Signal<?> sSig = wSig.getSignal();
            if (sig != null && sig != sSig) continue;
            lowValue = Math.min(lowValue, sSig.getMinValue());
            highValue = Math.max(highValue, sSig.getMaxValue());
        }
        double range2 = highValue - lowValue;
        if (range2 == 0.0) {
            range2 = 2.0;
        }
        double rangeExtra = range2 / 10.0;
        this.setYAxisRange(lowValue - rangeExtra, highValue + rangeExtra);
        this.makeSelectedPanel(-1, -1);
        this.repaintWithRulers();
    }

    public void setYAxisRange(double low, double high) {
        if (low == high) {
            low -= 0.5;
            high += 0.5;
        }
        this.analogLowValue = low;
        this.analogHighValue = high;
        this.analogRange = this.analogHighValue - this.analogLowValue;
    }

    public double getYAxisRange() {
        return this.analogRange;
    }

    public double getYAxisLowValue() {
        return this.analogLowValue;
    }

    public double getYAxisHighValue() {
        return this.analogHighValue;
    }

    public int convertXDataToScreen(double value2) {
        boolean log2 = this.waveWindow.isWaveWindowLogarithmic();
        if (!this.waveWindow.isXAxisLocked()) {
            log2 = this.horizRulerPanelLogarithmic;
        }
        if (log2) {
            if (value2 <= this.smallestXValue) {
                value2 = this.smallestXValue;
            }
            double logValue = Math.log10(value2);
            double winMinX = this.minXPosition;
            if (winMinX <= 0.0) {
                winMinX = this.smallestXValue;
            }
            double logWinMinX = Math.log10(winMinX);
            double winMaxX = this.maxXPosition;
            if (winMaxX <= 0.0) {
                winMaxX = this.smallestXValue;
            }
            double logWinMaxX = Math.log10(winMaxX);
            double x2 = (logValue - logWinMinX) / (logWinMaxX - logWinMinX) * (double)(this.sz.width - this.vertAxisPos) + (double)this.vertAxisPos;
            return (int)x2;
        }
        double x3 = (value2 - this.minXPosition) / (this.maxXPosition - this.minXPosition) * (double)(this.sz.width - this.vertAxisPos) + (double)this.vertAxisPos;
        return (int)x3;
    }

    public double convertXScreenToData(int x2) {
        boolean log2 = this.waveWindow.isWaveWindowLogarithmic();
        if (!this.waveWindow.isXAxisLocked()) {
            log2 = this.horizRulerPanelLogarithmic;
        }
        if (log2) {
            double winMinX = this.minXPosition;
            if (winMinX <= 0.0) {
                winMinX = this.smallestXValue;
            }
            double logWinMinX = Math.log10(winMinX);
            double winMaxX = this.maxXPosition;
            if (winMaxX <= 0.0) {
                winMaxX = this.smallestXValue;
            }
            double logWinMaxX = Math.log10(winMaxX);
            double xValue = Math.pow(10.0, (double)(x2 - this.vertAxisPos) / (double)(this.sz.width - this.vertAxisPos) * (logWinMaxX - logWinMinX) + logWinMinX);
            return xValue;
        }
        double xValue = (double)(x2 - this.vertAxisPos) / (double)(this.sz.width - this.vertAxisPos) * (this.maxXPosition - this.minXPosition) + this.minXPosition;
        return xValue;
    }

    public int convertYDataToScreen(double value2) {
        if (this.vertPanelLogarithmic) {
            if (value2 <= this.smallestYValue) {
                value2 = this.smallestYValue;
            }
            double logValue = Math.log10(value2);
            double winMinY = this.analogLowValue;
            if (winMinY <= 0.0) {
                winMinY = this.smallestYValue;
            }
            double logWinMinY = Math.log10(winMinY);
            double winMaxY = this.analogHighValue;
            if (winMaxY <= 0.0) {
                winMaxY = this.smallestYValue;
            }
            double logWinMaxY = Math.log10(winMaxY);
            double y = (double)(this.sz.height - 1) - (logValue - logWinMinY) / (logWinMaxY - logWinMinY) * (double)(this.sz.height - 1);
            return (int)y;
        }
        double y = (double)(this.sz.height - 1) - (value2 - this.analogLowValue) / this.analogRange * (double)(this.sz.height - 1);
        return (int)y;
    }

    public double convertYScreenToData(int y) {
        if (this.vertPanelLogarithmic) {
            double winMinY = this.analogLowValue;
            if (winMinY <= 0.0) {
                winMinY = this.smallestYValue;
            }
            double logWinMinY = Math.log10(winMinY);
            double winMaxY = this.analogHighValue;
            if (winMaxY <= 0.0) {
                winMaxY = this.smallestYValue;
            }
            double logWinMaxY = Math.log10(winMaxY);
            double yValue = Math.pow(10.0, logWinMinY - (double)(y - this.sz.height + 1) * (logWinMaxY - logWinMinY) / (double)(this.sz.height - 1));
            return yValue;
        }
        double value2 = 0.0;
        if (this.sz.height > 1) {
            value2 = this.analogLowValue - (double)(y - this.sz.height + 1) * this.analogRange / (double)(this.sz.height - 1);
        }
        return value2;
    }

    public void repaintWithRulers() {
        if (this.horizRulerPanel != null) {
            this.horizRulerPanel.repaint();
        } else {
            this.waveWindow.getMainHorizRuler().repaint();
        }
        this.repaintContents();
    }

    public void repaintContents() {
        this.needRepaintOffscreenImage = true;
        this.waveWindow.getWaveformTable().repaint();
    }

    public Image getWaveImage() {
        return this.offscreen;
    }

    @Override
    public void paint(Graphics g) {
        this.sz = this.getSize();
        this.szValid = true;
        int wid = this.sz.width;
        int hei = this.sz.height;
        BufferedImage offscreen = (BufferedImage)this.offscreen;
        if (offscreen == null || offscreen.getWidth() != wid || offscreen.getHeight() != hei) {
            offscreen = new BufferedImage(wid, hei, 1);
            this.offscreen = offscreen;
            this.needRepaintOffscreenImage = true;
        }
        if (this.needRepaintOffscreenImage) {
            this.repaintOffscreenImage(wid, hei);
        }
        g.drawImage(offscreen, 0, 0, null);
        Dimension tableSz = this.waveWindow.getWaveformTable().getSize();
        Point screenLoc = this.waveWindow.getWaveformTable().getLocationOnScreen();
        this.waveWindow.setScreenXSize(screenLoc.x + tableSz.width - wid, screenLoc.x + tableSz.width);
        this.paintDragging((Graphics2D)g, wid, hei);
    }

    private void repaintOffscreenImage(int wid, int hei) {
        this.needRepaintOffscreenImage = false;
        Graphics2D offscreenGraphics = (Graphics2D)this.offscreen.getGraphics();
        offscreenGraphics.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_BACKGROUND)));
        offscreenGraphics.fillRect(0, 0, wid, hei);
        this.drawPanelContents(wid, hei, offscreenGraphics, null, null);
        offscreenGraphics.dispose();
    }

    private void paintDragging(Graphics2D g, int wid, int hei) {
        g.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_FOREGROUND)));
        g.setStroke(Highlight.dashedLine);
        int x2 = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        if (x2 >= this.vertAxisPos) {
            g.drawLine(x2, 0, x2, hei);
        }
        g.setStroke(farDottedLine);
        x2 = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (x2 >= this.vertAxisPos) {
            g.drawLine(x2, 0, x2, hei);
        }
        g.setStroke(Highlight.solidLine);
        if (this.draggingArea) {
            int lowX = Math.min(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD));
            int highX = Math.max(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD));
            int lowY = Math.min(this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
            int highY = Math.max(this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
            g.drawLine(lowX, lowY, lowX, highY);
            g.drawLine(lowX, highY, highX, highY);
            g.drawLine(highX, highY, highX, lowY);
            g.drawLine(highX, lowY, lowX, lowY);
        }
        for (Rectangle2D meas : this.measurementList) {
            int xPos;
            int yPos;
            int yPosText;
            int lowX = Math.min(this.convertXDataToScreen(meas.getMinX()), this.convertXDataToScreen(meas.getMaxX()));
            int highX = Math.max(this.convertXDataToScreen(meas.getMinX()), this.convertXDataToScreen(meas.getMaxX()));
            int lowY = Math.min(this.convertYDataToScreen(meas.getMinY()), this.convertYDataToScreen(meas.getMaxY()));
            int highY = Math.max(this.convertYDataToScreen(meas.getMinY()), this.convertYDataToScreen(meas.getMaxY()));
            g.drawLine(lowX, lowY, lowX, highY);
            g.drawLine(lowX, highY, highX, highY);
            g.drawLine(highX, highY, highX, lowY);
            g.drawLine(highX, lowY, lowX, lowY);
            double lowXValue = this.convertXScreenToData(lowX);
            double highXValue = this.convertXScreenToData(highX);
            double lowValue = this.convertYScreenToData(highY);
            double highValue = this.convertYScreenToData(lowY);
            g.setFont(this.waveWindow.getFont());
            String lowXValueString = TextUtils.convertToEngineeringNotation(lowXValue, "s");
            GlyphVector gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), lowXValueString);
            Rectangle2D glyphBounds = gv.getLogicalBounds();
            int textWid = (int)glyphBounds.getWidth();
            int textHei = (int)glyphBounds.getHeight();
            int textY = (lowY + highY) / 2;
            g.drawString(lowXValueString, lowX - textWid - 6, textY + textHei / 2 - 10);
            g.drawLine(lowX - 1, textY, lowX - textWid, textY);
            g.drawLine(lowX - 1, textY, lowX - 6, textY + 4);
            g.drawLine(lowX - 1, textY, lowX - 6, textY - 4);
            String highXValueString = TextUtils.convertToEngineeringNotation(highXValue, "s");
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), highXValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            int highXValueTextWid = textWid;
            g.drawString(highXValueString, highX + 6, textY + textHei / 2 - 10);
            g.drawLine(highX + 1, textY, highX + textWid, textY);
            g.drawLine(highX + 1, textY, highX + 6, textY + 4);
            g.drawLine(highX + 1, textY, highX + 6, textY - 4);
            String xDiffString = TextUtils.convertToEngineeringNotation(highXValue - lowXValue, "s");
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), xDiffString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            if (textWid + 24 < highX - lowX) {
                yPosText = highY + textHei * 5;
                yPos = yPosText - textHei / 2;
                int xCtr = (highX + lowX) / 2;
                g.drawString(xDiffString, xCtr - textWid / 2, yPosText);
                g.drawLine(lowX, yPos, xCtr - textWid / 2 - 2, yPos);
                g.drawLine(highX, yPos, xCtr + textWid / 2 + 2, yPos);
                g.drawLine(lowX, yPos, lowX + 5, yPos + 4);
                g.drawLine(lowX, yPos, lowX + 5, yPos - 4);
                g.drawLine(highX, yPos, highX - 5, yPos + 4);
                g.drawLine(highX, yPos, highX - 5, yPos - 4);
            } else {
                yPosText = highY + textHei * 5;
                yPos = yPosText - textHei / 2;
                g.drawString(xDiffString, highX + 12, yPosText);
                g.drawLine(lowX, yPos, lowX - 10, yPos);
                g.drawLine(highX, yPos, highX + 10, yPos);
                g.drawLine(lowX, yPos, lowX - 5, yPos + 4);
                g.drawLine(lowX, yPos, lowX - 5, yPos - 4);
                g.drawLine(highX, yPos, highX + 5, yPos + 4);
                g.drawLine(highX, yPos, highX + 5, yPos - 4);
            }
            if (!this.isAnalog()) continue;
            String lowValueString = TextUtils.convertToEngineeringNotation(highValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), lowValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            int xP = (lowX + highX) / 2;
            int yText = lowY - 10 - textHei;
            g.drawString(lowValueString, xP, yText - 2);
            g.drawLine(xP, lowY - 1, xP, yText);
            g.drawLine(xP, lowY - 1, xP + 4, lowY - 5);
            g.drawLine(xP, lowY - 1, xP - 4, lowY - 5);
            String highValueString = TextUtils.convertToEngineeringNotation(lowValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), highValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            yText = highY + 10 + textHei;
            g.drawString(highValueString, xP, yText + textHei + 2);
            g.drawLine(xP, highY + 1, xP, yText);
            g.drawLine(xP, highY + 1, xP + 4, highY + 5);
            g.drawLine(xP, highY + 1, xP - 4, highY + 5);
            String valueDiffString = TextUtils.convertToEngineeringNotation(highValue - lowValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), valueDiffString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            if (textHei + 12 < highY - lowY) {
                xPos = highX + highXValueTextWid + 30;
                int yCtr = (highY + lowY) / 2;
                g.drawString(valueDiffString, xPos + 2, yCtr + textHei / 2);
                g.drawLine(xPos, lowY, xPos, highY);
                g.drawLine(xPos, lowY, xPos + 4, lowY + 5);
                g.drawLine(xPos, lowY, xPos - 4, lowY + 5);
                g.drawLine(xPos, highY, xPos + 4, highY - 5);
                g.drawLine(xPos, highY, xPos - 4, highY - 5);
                continue;
            }
            xPos = highX + highXValueTextWid + 30;
            g.drawString(valueDiffString, xPos + 4, lowY - textHei / 2 - 4);
            g.drawLine(xPos, lowY, xPos, lowY - 10);
            g.drawLine(xPos, highY, xPos, highY + 10);
            g.drawLine(xPos, lowY, xPos + 4, lowY - 5);
            g.drawLine(xPos, lowY, xPos - 4, lowY - 5);
            g.drawLine(xPos, highY, xPos + 4, highY + 5);
            g.drawLine(xPos, highY, xPos - 4, highY + 5);
        }
    }

    private void drawPanelContents(int wid, int hei, Graphics2D localGraphics, Rectangle2D bounds, List<PolyBase> polys) {
        double value2;
        StepSize ss;
        if (this.waveWindow.isShowGrid()) {
            if (localGraphics != null) {
                localGraphics.setStroke(Highlight.dottedLine);
                localGraphics.setColor(gridColor);
            }
            double displayedXLow = this.convertXScreenToData(this.vertAxisPos);
            double displayedXHigh = this.convertXScreenToData(wid);
            ss = new StepSize(displayedXHigh, displayedXLow, 10);
            if (ss.getSeparation() != 0.0) {
                value2 = ss.getLowValue();
                while (true) {
                    if (value2 >= displayedXLow) {
                        if (value2 > ss.getHighValue()) break;
                        int x2 = this.convertXDataToScreen(value2);
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(x2, 0.0), new Point2D.Double(x2, hei)}));
                        } else {
                            localGraphics.drawLine(x2, 0, x2, hei);
                        }
                    }
                    value2 += ss.getSeparation();
                }
            }
            if ((ss = new StepSize(this.analogHighValue, this.analogLowValue, 5)).getSeparation() != 0.0) {
                value2 = ss.getLowValue();
                while (true) {
                    if (value2 >= this.analogLowValue) {
                        if (value2 > this.analogHighValue || value2 > ss.getHighValue()) break;
                        int y = this.convertYDataToScreen(value2);
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos, y), new Point2D.Double(wid, y)}));
                        } else {
                            localGraphics.drawLine(this.vertAxisPos, y, wid, y);
                        }
                    }
                    value2 += ss.getSeparation();
                }
            }
            if (localGraphics != null) {
                localGraphics.setStroke(Highlight.solidLine);
            }
        }
        this.processSignals(localGraphics, bounds, polys);
        if (localGraphics != null) {
            this.processControlPoints(localGraphics, bounds);
        }
        if (polys != null) {
            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos, 0.0), new Point2D.Double(this.vertAxisPos, hei)}));
        } else {
            localGraphics.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_FOREGROUND)));
            localGraphics.drawLine(this.vertAxisPos, 0, this.vertAxisPos, hei);
            if (this.selected) {
                localGraphics.drawLine(this.vertAxisPos - 1, 0, this.vertAxisPos - 1, hei);
                localGraphics.drawLine(this.vertAxisPos - 2, 0, this.vertAxisPos - 2, hei - 1);
                localGraphics.drawLine(this.vertAxisPos - 3, 0, this.vertAxisPos - 3, hei - 2);
            }
        }
        if (this.isAnalog()) {
            double displayedLow = this.convertYScreenToData(hei);
            double displayedHigh = this.convertYScreenToData(0);
            ss = new StepSize(displayedHigh, displayedLow, 5);
            if (ss.getSeparation() != 0.0) {
                value2 = ss.getLowValue();
                if (localGraphics != null) {
                    localGraphics.setFont(this.waveWindow.getFont());
                }
                int lastY = -1;
                int ySeparation = this.convertYDataToScreen(value2) - this.convertYDataToScreen(value2 + ss.getSeparation());
                int textSkip = 100;
                if (ySeparation > 0) {
                    textSkip = 20 / ySeparation;
                }
                int textSkipPos = 0;
                int i = 0;
                while (!(value2 > displayedHigh)) {
                    if (value2 >= displayedLow) {
                        int y = this.convertYDataToScreen(value2);
                        if (lastY >= 0) {
                            int addedTicks = (lastY - y) / 20;
                            for (int j = 1; j < addedTicks; ++j) {
                                int intY = (lastY - y) / addedTicks * j + y;
                                if (polys != null) {
                                    polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 5, intY), new Point2D.Double(this.vertAxisPos, intY)}));
                                    continue;
                                }
                                localGraphics.drawLine(this.vertAxisPos - 5, intY, this.vertAxisPos, intY);
                            }
                        }
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 10, y), new Point2D.Double(this.vertAxisPos, y)}));
                        } else {
                            localGraphics.drawLine(this.vertAxisPos - 10, y, this.vertAxisPos, y);
                        }
                        if (--textSkipPos <= 0) {
                            textSkipPos = textSkip;
                            String yValue = TextUtils.convertToEngineeringNotation(value2, null, ss.getStepScale() + 3);
                            if (polys != null) {
                                Poly poly = new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 12, y)});
                                poly.setStyle(Poly.Type.TEXTRIGHT);
                                poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(6));
                                poly.setString(yValue);
                                polys.add(poly);
                            } else {
                                int xPos;
                                GlyphVector gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), yValue);
                                Rectangle2D glyphBounds = gv.getLogicalBounds();
                                int height = (int)glyphBounds.getHeight();
                                int yPos = y + height / 2;
                                if (yPos - height <= 0) {
                                    yPos = height + 1;
                                }
                                if (yPos >= hei) {
                                    yPos = hei;
                                }
                                if ((xPos = this.vertAxisPos - 10 - (int)glyphBounds.getWidth() - 2) < 0) {
                                    xPos = 0;
                                }
                                localGraphics.drawString(yValue, xPos, yPos);
                            }
                        }
                        lastY = y;
                    }
                    value2 += ss.getSeparation();
                    ++i;
                }
            }
        }
    }

    public void dumpDataCSV(PrintWriter pw) {
        for (WaveSignal ws : this.waveSignals.values()) {
            Signal<?> as = ws.getSignal();
            Signal.View<?> waveform = as.getExactView();
            int numEvents = waveform.getNumEvents();
            for (int i = 0; i < numEvents; ++i) {
                Object samp = waveform.getSample(i);
                double time = waveform.getTime(i);
                if (samp instanceof SweptSample) {
                    SweptSample sws = (SweptSample)samp;
                    for (int s = 0; s < sws.getWidth(); ++s) {
                        Object ss = sws.getSweep(s);
                        pw.println("\"" + time + "\",\"" + s + "\",\"" + ((ScalarSample)ss).getValue() + "\"");
                    }
                    continue;
                }
                if (samp instanceof DigitalSample) {
                    DigitalSample ds = (DigitalSample)samp;
                    String value2 = ds.isLogic0() ? "0" : (ds.isLogic1() ? "1" : (ds.isLogicX() ? "X" : (ds.isLogicZ() ? "Z" : "?")));
                    pw.println("\"" + time + "\",\"" + value2 + "\"");
                    continue;
                }
                if (samp instanceof BusSample) {
                    BusSample bs = (BusSample)samp;
                    boolean isX = false;
                    boolean isZ = false;
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < bs.getWidth(); ++j) {
                        DigitalSample ds = (DigitalSample)bs.getTrace(j);
                        if (ds.isLogicX()) {
                            isX = true;
                            break;
                        }
                        if (ds.isLogicZ()) {
                            isZ = true;
                            break;
                        }
                        if (ds.isLogic0()) {
                            sb.append("0");
                            continue;
                        }
                        if (ds.isLogic1()) {
                            sb.append("1");
                            continue;
                        }
                        sb.append("?");
                    }
                    String number2 = sb.toString();
                    if (isX) {
                        number2 = "X";
                    } else if (isZ) {
                        number2 = "Z";
                    }
                    pw.println("\"" + time + "\",\"" + number2 + "\"");
                    continue;
                }
                ScalarSample ss = (ScalarSample)samp;
                pw.println("\"" + time + "\",\"" + ss.getValue() + "\"");
            }
            pw.println();
        }
    }

    private static String pad2(String s) {
        return s.length() >= 2 ? s : Panel.pad2("0" + s);
    }

    void dumpDataForGnuplot(PrintWriter pw) {
        this.dumpDataForGnuplot(pw, -1.7976931348623157E308, Double.MAX_VALUE, "");
    }

    void dumpDataForGnuplot(PrintWriter pw, double min2, double max2, String sep) {
        int numSweeps;
        String[] sweepNames;
        boolean first = true;
        int linetype = 1;
        for (WaveSignal ws : this.waveSignals.values()) {
            boolean used = false;
            sweepNames = ws.getSignal().getSignalCollection().getSweepNames();
            numSweeps = sweepNames == null ? 1 : sweepNames.length;
            for (int s = 0; s < numSweeps; ++s) {
                if (!first) {
                    pw.print(sep);
                }
                pw.print(" '-' with lines ");
                Color c = ws.getColor();
                pw.print(" lt " + linetype + " ");
                pw.print("lc rgb \"#" + Panel.pad2(Integer.toString(c.getRed() & 0xFF, 16)) + Panel.pad2(Integer.toString(c.getGreen() & 0xFF, 16)) + Panel.pad2(Integer.toString(c.getBlue() & 0xFF, 16)) + "\" ");
                pw.print(" title \"" + ws.getSignal().getFullName() + "\" ");
                first = false;
                used = true;
            }
            if (!used) continue;
            ++linetype;
        }
        for (WaveSignal ws : this.waveSignals.values()) {
            Signal<?> as = ws.getSignal();
            sweepNames = ws.getSignal().getSignalCollection().getSweepNames();
            numSweeps = sweepNames == null ? 1 : sweepNames.length;
            Signal.View<?> waveform = as.getExactView();
            int numEvents = waveform.getNumEvents();
            for (int s = 0; s < numSweeps; ++s) {
                pw.println();
                for (int i = 0; i < numEvents; ++i) {
                    Object samp = waveform.getSample(i);
                    double time = waveform.getTime(i);
                    if (time < min2 || time > max2) continue;
                    if (samp instanceof SweptSample) {
                        SweptSample sws = (SweptSample)samp;
                        Object ss = sws.getSweep(s);
                        pw.println(time + " " + ss);
                        continue;
                    }
                    pw.println(time + " " + samp);
                }
                pw.println("e");
                pw.println();
            }
        }
    }

    private List<WaveSelection> processSignals(Graphics g, Rectangle2D bounds, List<PolyBase> forPs) {
        ArrayList<WaveSelection> selectedObjects = null;
        if (bounds != null) {
            selectedObjects = new ArrayList<WaveSelection>();
        }
        Signal<?> xSignal = this.xAxisSignal;
        if (this.waveWindow.isXAxisLocked()) {
            xSignal = this.waveWindow.getXAxisSignalAll();
        }
        Collection<WaveSignal> sigs = this.waveSignals.values();
        int sigIndex = 0;
        Color light = null;
        for (WaveSignal ws : sigs) {
            if (g != null) {
                if (this.waveWindow.getPrintingMode() == 2) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(ws.getColor());
                }
                Color c = ws.getColor();
                light = new Color(c.getRed(), c.getGreen(), c.getBlue(), 85);
            }
            if (forPs != null) {
                int hei = this.sz.height;
                double yPos = hei / 2;
                Poly.Type style = Poly.Type.TEXTRIGHT;
                if (sigs.size() > 1) {
                    if (sigIndex == sigs.size() - 1) {
                        style = Poly.Type.TEXTBOTRIGHT;
                    } else if (sigIndex == 0) {
                        style = Poly.Type.TEXTTOPRIGHT;
                    }
                    yPos = (double)(hei * sigIndex) / (double)(sigs.size() - 1);
                }
                Poly poly = new Poly(new Point2D[]{new Point2D.Double(0.0, yPos)});
                poly.setStyle(style);
                poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(12));
                poly.setString(ws.getSignal().getFullName());
                forPs.add(poly);
            }
            ++sigIndex;
            ws.getSignal().plot(this, g, ws, light, forPs, bounds, selectedObjects, xSignal);
        }
        return selectedObjects;
    }

    private List<WaveSelection> processControlPoints(Graphics g, Rectangle2D bounds) {
        ArrayList<WaveSelection> selectedObjects = null;
        if (bounds != null) {
            selectedObjects = new ArrayList<WaveSelection>();
        }
        block0: for (WaveSignal ws : this.waveSignals.values()) {
            double xValue;
            int x2;
            Double[] points;
            if (g != null) {
                g.setColor(ws.getColor());
            }
            if ((points = ws.getSignal().getControlPoints()) == null) continue;
            if (g != null) {
                g.setColor(ws.getColor());
            }
            for (int i = 0; i < points.length && !this.processABox(g, (x2 = this.convertXDataToScreen(xValue = points[i].doubleValue())) - 6, this.sz.height - 12, x2 + 6, this.sz.height, bounds, null, selectedObjects, ws, true, xValue); ++i) {
                boolean found = false;
                if (bounds == null && ws.getSelectedControlPoints() != null) {
                    for (int j = 0; j < ws.getSelectedControlPoints().length; ++j) {
                        if (ws.getSelectedControlPoints()[j] != xValue) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                g.setColor(Color.GREEN);
                if (this.processABox(g, x2 - 6 + 2, this.sz.height - 12 + 2, x2 + 6 - 2, this.sz.height - 2, bounds, null, selectedObjects, ws, true, xValue)) continue block0;
                g.setColor(ws.getColor());
            }
        }
        return selectedObjects;
    }

    public boolean processABox(Graphics g, int lX, int lY, int hX, int hY, Rectangle2D bounds, List<PolyBase> forPs, List<WaveSelection> result2, WaveSignal ws, boolean controlPoint, double controlXValue) {
        if (bounds != null) {
            if ((double)hX > bounds.getMinX() && (double)lX < bounds.getMaxX() && (double)hY > bounds.getMinY() && (double)lY < bounds.getMaxY()) {
                if (forPs != null) {
                    PolyBase poly = new PolyBase((lX + hX) / 2, (lY + hY) / 2, hX - lX, hY - lY);
                    poly.setStyle(Poly.Type.FILLED);
                    poly.setLayer(Artwork.tech().defaultLayer);
                    forPs.add(poly);
                    return false;
                }
                WaveSelection wSel = new WaveSelection();
                wSel.ws = ws;
                wSel.controlPoint = controlPoint;
                wSel.controlXValue = controlXValue;
                result2.add(wSel);
                return true;
            }
            return false;
        }
        if (hX <= this.vertAxisPos) {
            return false;
        }
        if (lX < this.vertAxisPos) {
            lX = this.vertAxisPos;
        }
        g.fillRect(lX, lY, hX - lX, hY - lY);
        return false;
    }

    public boolean processALine(Graphics g, int fX, int fY, int tX, int tY, Rectangle2D bounds, List<PolyBase> forPs, List<WaveSelection> result2, WaveSignal ws, int sweepNum) {
        if (bounds != null) {
            Point2D.Double from2 = new Point2D.Double(fX, fY);
            Point2D.Double to2 = new Point2D.Double(tX, tY);
            if (!GenMath.clipLine(from2, to2, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY())) {
                if (forPs != null) {
                    forPs.add(new PolyBase(new Point2D[]{from2, to2}));
                    return false;
                }
                WaveSelection wSel = new WaveSelection();
                wSel.ws = ws;
                wSel.controlPoint = false;
                result2.add(wSel);
                return true;
            }
            return false;
        }
        if (fX < this.vertAxisPos || tX < this.vertAxisPos) {
            Point2D.Double from3 = new Point2D.Double(fX, fY);
            Point2D.Double to3 = new Point2D.Double(tX, tY);
            if (GenMath.clipLine(from3, to3, (double)this.vertAxisPos, (double)this.sz.width, 0.0, (double)this.sz.height)) {
                return false;
            }
            fX = (int)((Point2D)from3).getX();
            fY = (int)((Point2D)from3).getY();
            tX = (int)((Point2D)to3).getX();
            tY = (int)((Point2D)to3).getY();
        }
        g.drawLine(fX, fY, tX, tY);
        boolean highlighted = ws.isHighlighted();
        if (ws.getPanel().waveWindow.getHighlightedSweep() >= 0) {
            boolean bl = highlighted = ws.getPanel().waveWindow.getHighlightedSweep() == sweepNum;
        }
        if (highlighted) {
            if (fX == tX) {
                g.drawLine(fX - 1, fY, tX - 1, tY);
                g.drawLine(fX + 1, fY, tX + 1, tY);
            } else if (fY == tY) {
                g.drawLine(fX, fY + 1, tX, tY + 1);
                g.drawLine(fX, fY - 1, tX, tY - 1);
            } else {
                int xDelta = 0;
                int yDelta = 1;
                if (Math.abs(fX - tX) < Math.abs(fY - tY)) {
                    xDelta = 1;
                    yDelta = 0;
                }
                g.drawLine(tX + xDelta, tY + yDelta, fX + xDelta, fY + yDelta);
                g.drawLine(tX - xDelta, tY - yDelta, fX - xDelta, fY - yDelta);
            }
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        this.waveWindow.vcrClickStop();
        this.makeSelectedPanel(evt.getX(), evt.getY());
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (wp.draggingArea) {
                wp.repaintContents();
            }
            wp.draggingArea = false;
        }
        if (evt.getClickCount() == 2 && evt.getX() < this.vertAxisPos) {
            new WaveformZoom(TopLevel.getCurrentJFrame(), this.analogLowValue, this.analogHighValue, this.minXPosition, this.maxXPosition, this.waveWindow, this);
            return;
        }
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt)) {
            if ((evt.getModifiersEx() & 0x40) != 0) {
                mode = ToolBar.CursorMode.ZOOM;
            } else if (evt.getX() < this.vertAxisPos) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Linear");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Panel.this.makeLinear();
                    }
                });
                menu.add(item);
                item = new JMenuItem("Logarithmic");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Panel.this.makeLogarithmic();
                    }
                });
                menu.add(item);
                menu.show(this, evt.getX(), evt.getY());
                return;
            }
        }
        Iterator<Panel> it2 = this.waveWindow.getPanels();
        while (it2.hasNext()) {
            it2.next().curMeasurement = null;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mousePressedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mousePressedPan(evt);
        } else {
            this.mousePressedSelect(evt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
            mode = ToolBar.CursorMode.ZOOM;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseReleasedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseReleasedPan(evt);
        } else {
            this.mouseReleasedSelect(evt);
        }
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel panel = it.next();
            panel.curMeasurement = null;
            if (mode != ToolBar.CursorMode.MEASURE) continue;
            panel.draggingArea = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseMovedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseMovedPan(evt);
        } else {
            this.mouseMovedSelect(evt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
            mode = ToolBar.CursorMode.ZOOM;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseDraggedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseDraggedPan(evt);
        } else {
            this.mouseDraggedSelect(evt);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.waveWindow.vcrClickStop();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    private void panelTitleClicked(ActionEvent evt) {
        long delay2 = evt.getWhen() - this.lastClick;
        this.lastClick = evt.getWhen();
        if (delay2 < (long)TopLevel.getDoubleClickSpeed()) {
            this.toggleBusContents();
            return;
        }
        Set<JComponent> set = this.waveSignals.keySet();
        if (set.size() != 1) {
            return;
        }
        JComponent comp = set.iterator().next();
        WaveSignal ws = this.waveSignals.get(comp);
        if ((evt.getModifiers() & 1) == 0) {
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                wp.clearHighlightedSignals();
            }
            this.addHighlightedSignal(ws, true);
            this.makeSelectedPanel(-1, -1);
        } else if (ws.isHighlighted()) {
            this.removeHighlightedSignal(ws, true);
        } else {
            this.addHighlightedSignal(ws, true);
        }
        this.waveWindow.crossProbeWaveformToEditWindow();
    }

    private List<WaveSelection> findSignalsInArea(int lX, int hX, int lY, int hY) {
        double swap;
        double lXd = Math.min(lX, hX) - 2;
        double hXd = Math.max(lX, hX) + 2;
        double hYd = Math.min(lY, hY) - 2;
        double lYd = Math.max(lY, hY) + 2;
        if (lXd > hXd) {
            swap = lXd;
            lXd = hXd;
            hXd = swap;
        }
        if (lYd > hYd) {
            swap = lYd;
            lYd = hYd;
            hYd = swap;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(lXd, lYd, hXd - lXd, hYd - lYd);
        List<WaveSelection> sigs = this.processSignals(null, bounds, null);
        List<WaveSelection> cps = this.processControlPoints(null, bounds);
        for (WaveSelection ws : sigs) {
            cps.add(ws);
        }
        return cps;
    }

    public List<PolyBase> getPolysForPrinting() {
        if (!this.szValid) {
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                if (!wp.szValid) continue;
                this.sz = wp.sz;
                this.szValid = true;
                break;
            }
        }
        this.sz = this.getSize();
        ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
        this.drawPanelContents(this.sz.width, this.sz.height, null, new Rectangle2D.Double(this.vertAxisPos, 0.0, this.sz.width, this.sz.height), polys);
        return polys;
    }

    public void clearMeasurements() {
        this.measurementList.clear();
        this.curMeasurement = null;
        this.repaintContents();
    }

    public void mousePressedSelect(MouseEvent evt) {
        this.draggingVertAxis = false;
        this.draggingExt = false;
        this.draggingMain = false;
        int mainX = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        if (Math.abs(mainX - evt.getX()) < 5) {
            this.draggingMain = true;
            return;
        }
        int extX = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (Math.abs(extX - evt.getX()) < 5) {
            this.draggingExt = true;
            return;
        }
        if (Math.abs(this.vertAxisPos - evt.getX()) < 5) {
            this.draggingVertAxis = true;
            return;
        }
        Point pt = new Point(evt.getX(), evt.getY());
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
            pt = this.snapPoint(pt);
        }
        double xV = this.convertXScreenToData(pt.x);
        double yV = this.convertYScreenToData(pt.y);
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.measurementList.clear();
                this.curMeasurement = null;
                return;
            }
            this.curMeasurement = new Rectangle2D.Double(xV, yV, 0.0, 0.0);
            this.measurementList.add(this.curMeasurement);
        }
        this.dragEndXD = this.dragStartXD = xV;
        this.dragEndYD = this.dragStartYD = yV;
        this.draggingArea = true;
    }

    private Point getPointIfClose(int x2, int y, Point pt) {
        if (Math.abs(x2 - pt.x) < 8 && Math.abs(y - pt.y) < 8) {
            pt.x = x2;
            pt.y = y;
            return pt;
        }
        return null;
    }

    private Point getPointIfCloseToLine(Point2D lstPt, Point2D thisPt, Point2D snap) {
        Point2D closest = GenMath.closestPointToSegment(lstPt, thisPt, snap);
        if (closest.distance(snap) < 5.0) {
            Point pt = new Point((int)Math.round(closest.getX()), (int)Math.round(closest.getY()));
            return pt;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Point snapPoint(Point pt) {
        ArrayList allViews = new ArrayList();
        for (WaveSignal waveSignal : this.waveSignals.values()) {
            Signal<?> signal = waveSignal.getSignal();
            if (signal.isDigital()) continue;
            allViews.add(signal.getRasterView(signal.getMinTime(), signal.getMaxTime(), this.sz.width));
        }
        for (Signal.View view : allViews) {
            void var5_10;
            boolean bl = false;
            while (var5_10 < view.getNumEvents()) {
                RangeSample rs = (RangeSample)view.getSample((int)var5_10);
                if (rs != null) {
                    Object max2;
                    int x2 = this.convertXDataToScreen(view.getTime((int)var5_10));
                    Object min2 = rs.getMin();
                    if (min2 instanceof SweptSample) {
                        SweptSample ss = (SweptSample)min2;
                        for (int s = 0; s < ss.getWidth(); ++s) {
                            Object sweepSample = ss.getSweep(s);
                            int y = this.convertYDataToScreen(((ScalarSample)sweepSample).getValue());
                            Point closePoint = this.getPointIfClose(x2, y, pt);
                            if (closePoint == null) continue;
                            return closePoint;
                        }
                    } else {
                        int y = this.convertYDataToScreen(((ScalarSample)min2).getValue());
                        Point closePoint = this.getPointIfClose(x2, y, pt);
                        if (closePoint != null) {
                            return closePoint;
                        }
                    }
                    if ((max2 = rs.getMax()) instanceof SweptSample) {
                        SweptSample ss = (SweptSample)max2;
                        for (int s = 0; s < ss.getWidth(); ++s) {
                            Object sweepSample = ss.getSweep(s);
                            int y = this.convertYDataToScreen(((ScalarSample)sweepSample).getValue());
                            Point closePoint = this.getPointIfClose(x2, y, pt);
                            if (closePoint == null) continue;
                            return closePoint;
                        }
                    } else {
                        int y = this.convertYDataToScreen(((ScalarSample)max2).getValue());
                        Point closePoint = this.getPointIfClose(x2, y, pt);
                        if (closePoint != null) {
                            return closePoint;
                        }
                    }
                }
                ++var5_10;
            }
        }
        Point2D.Double snap = new Point2D.Double(pt.x, pt.y);
        for (Signal.View view : allViews) {
            Point2D.Double lastPt = null;
            ArrayList<Point2D.Double> lastSweepMinPts = new ArrayList<Point2D.Double>();
            ArrayList<Point2D.Double> lastSweepMaxPts = new ArrayList<Point2D.Double>();
            for (int i = 0; i < view.getNumEvents(); ++i) {
                Point close;
                Object max3;
                RangeSample rs = (RangeSample)view.getSample(i);
                if (rs == null) continue;
                int x3 = this.convertXDataToScreen(view.getTime(i));
                Object min3 = rs.getMin();
                if (min3 instanceof SweptSample) {
                    SweptSample ss = (SweptSample)min3;
                    for (int s = 0; s < ss.getWidth(); ++s) {
                        Point2D lstPt;
                        Point close2;
                        Object sweepSample = ss.getSweep(s);
                        int y = this.convertYDataToScreen(((ScalarSample)sweepSample).getValue());
                        Point2D.Double thisPt = new Point2D.Double(x3, y);
                        if (s < lastSweepMinPts.size() && (close2 = this.getPointIfCloseToLine(lstPt = (Point2D)lastSweepMinPts.get(s), thisPt, snap)) != null) {
                            return close2;
                        }
                        while (lastSweepMinPts.size() <= s) {
                            lastSweepMinPts.add(null);
                        }
                        lastSweepMinPts.set(s, thisPt);
                    }
                } else {
                    Point close3;
                    int y = this.convertYDataToScreen(((ScalarSample)min3).getValue());
                    Point2D.Double thisPt = new Point2D.Double(x3, y);
                    if (lastPt != null && (close3 = this.getPointIfCloseToLine(lastPt, thisPt, snap)) != null) {
                        return close3;
                    }
                    lastPt = thisPt;
                }
                if ((max3 = rs.getMax()) instanceof SweptSample) {
                    SweptSample ss = (SweptSample)max3;
                    for (int s = 0; s < ss.getWidth(); ++s) {
                        Point2D lstPt;
                        Point close4;
                        Object sweepSample = ss.getSweep(s);
                        int y = this.convertYDataToScreen(((ScalarSample)sweepSample).getValue());
                        Point2D.Double thisPt = new Point2D.Double(x3, y);
                        if (s < lastSweepMaxPts.size() && (close4 = this.getPointIfCloseToLine(lstPt = (Point2D)lastSweepMaxPts.get(s), thisPt, snap)) != null) {
                            return close4;
                        }
                        while (lastSweepMaxPts.size() <= s) {
                            lastSweepMaxPts.add(null);
                        }
                        lastSweepMaxPts.set(s, thisPt);
                    }
                    continue;
                }
                int y = this.convertYDataToScreen(((ScalarSample)max3).getValue());
                Point2D.Double thisPt = new Point2D.Double(x3, y);
                if (lastPt != null && (close = this.getPointIfCloseToLine(lastPt, thisPt, snap)) != null) {
                    return close;
                }
                lastPt = thisPt;
            }
        }
        return pt;
    }

    public void mouseReleasedSelect(MouseEvent evt) {
        if (this.draggingArea) {
            this.draggingArea = false;
            Panel wp = (Panel)evt.getSource();
            if (ToolBar.getCursorMode() != ToolBar.CursorMode.MEASURE && ToolBar.getSelectMode() == ToolBar.SelectMode.OBJECTS) {
                List<WaveSelection> selectedObjects = wp.findSignalsInArea(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD), this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
                if ((evt.getModifiers() & 1) == 0) {
                    this.clearHighlightedSignals();
                    for (WaveSelection wSel : selectedObjects) {
                        if (wSel.controlPoint) {
                            wSel.ws.addSelectedControlPoint(wSel.controlXValue);
                        }
                        wp.addHighlightedSignal(wSel.ws, false);
                    }
                } else {
                    for (WaveSelection wSel : selectedObjects) {
                        WaveSignal ws = wSel.ws;
                        if (ws.isHighlighted()) {
                            if (wSel.controlPoint) {
                                ws.removeSelectedControlPoint(wSel.controlXValue);
                            }
                            this.removeHighlightedSignal(ws, false);
                            continue;
                        }
                        if (wSel.controlPoint) {
                            ws.addSelectedControlPoint(wSel.controlXValue);
                        }
                        wp.addHighlightedSignal(ws, false);
                    }
                }
                wp.waveWindow.crossProbeWaveformToEditWindow();
            }
        }
        this.repaintContents();
    }

    public void mouseDraggedSelect(MouseEvent evt) {
        if (this.draggingMain) {
            if (evt.getX() <= 0) {
                return;
            }
            double value2 = this.convertXScreenToData(evt.getX());
            this.waveWindow.setMainXPositionCursor(value2);
            this.waveWindow.repaintAllPanels();
        } else if (this.draggingExt) {
            if (evt.getX() <= 0) {
                return;
            }
            double value3 = this.convertXScreenToData(evt.getX());
            this.waveWindow.setExtensionXPositionCursor(value3);
            this.waveWindow.repaintAllPanels();
        } else if (this.draggingVertAxis) {
            if (evt.getX() <= 0) {
                return;
            }
            if (this.waveWindow.isXAxisLocked()) {
                Iterator<Panel> it = this.waveWindow.getPanels();
                while (it.hasNext()) {
                    Panel wp = it.next();
                    wp.vertAxisPos = evt.getX();
                }
                this.waveWindow.redrawAllPanels();
                this.waveWindow.getMainHorizRuler().repaint();
            } else {
                this.vertAxisPos = evt.getX();
                this.repaintWithRulers();
            }
        } else if (this.draggingArea) {
            int yp;
            HashSet<Panel> measureWindows = new HashSet<Panel>();
            Point cPt = new Point();
            Panel curPanel = this;
            measureWindows.add(curPanel);
            JTable table = this.waveWindow.getWaveformTable();
            int startPanel = 0;
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (this != this.waveWindow.getPanel(i)) continue;
                startPanel = i;
                break;
            }
            Rectangle bou = evt.getComponent().getBounds();
            if (yp >= bou.y && yp < bou.y + bou.height) {
                cPt.setLocation(evt.getX(), evt.getY());
            } else {
                int curPanelNum = startPanel;
                if (yp < bou.y) {
                    for (yp = evt.getY(); yp < bou.y && curPanelNum > 0; yp += table.getRowHeight(curPanelNum)) {
                        measureWindows.add(this.waveWindow.getPanel(--curPanelNum));
                    }
                } else if (yp >= bou.y + bou.height) {
                    while (yp >= bou.y + bou.height && curPanelNum + 1 < table.getRowCount()) {
                        yp -= table.getRowHeight(curPanelNum);
                        measureWindows.add(this.waveWindow.getPanel(++curPanelNum));
                    }
                }
                curPanel = this.waveWindow.getPanel(curPanelNum);
                cPt.setLocation(evt.getX(), yp);
            }
            cPt = curPanel.snapPoint(cPt);
            this.dragEndXD = curPanel.convertXScreenToData(cPt.x);
            this.dragEndYD = curPanel.convertYScreenToData(cPt.y);
            if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE && !ClickZoomWireListener.isRightMouse(evt)) {
                Iterator<Panel> it = this.waveWindow.getPanels();
                while (it.hasNext()) {
                    it.next().draggingArea = false;
                }
                for (Panel wp : measureWindows) {
                    if (wp.curMeasurement == null) {
                        wp.curMeasurement = new Rectangle2D.Double();
                        wp.measurementList.add(wp.curMeasurement);
                    }
                    wp.curMeasurement.setRect(this.dragStartXD, this.dragStartYD, this.dragEndXD - this.dragStartXD, this.dragEndYD - this.dragStartYD);
                    wp.dragStartXD = this.dragStartXD;
                    wp.dragStartYD = this.dragStartYD;
                    wp.dragEndXD = this.dragEndXD;
                    wp.dragEndYD = this.dragEndYD;
                    wp.draggingArea = true;
                    wp.repaint();
                }
            }
            this.repaint();
        }
    }

    public void mouseMovedSelect(MouseEvent evt) {
        int mainX = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        int extX = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (Math.abs(mainX - evt.getX()) < 5 || Math.abs(extX - evt.getX()) < 5 || Math.abs(this.vertAxisPos - evt.getX()) < 5) {
            this.setCursor(dragXPositionCursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void clearHighlightedSignals() {
        for (WaveSignal ws : this.waveSignals.values()) {
            if (!ws.isHighlighted()) continue;
            ws.setHighlighted(false);
            ws.clearSelectedControlPoints();
            if (ws.getButton() == null) continue;
            ws.getButton().setBackground(this.background);
        }
        this.waveWindow.setHighlightedSweep(-1);
        this.repaintContents();
    }

    public void addHighlightedSignal(WaveSignal ws, boolean repaintContents) {
        if (ws.getButton() != null) {
            if (this.background == null) {
                this.background = ws.getButton().getBackground();
            }
            ws.getButton().setBackground(new Color(User.getColor(User.ColorPrefType.WAVE_BACKGROUND)));
        }
        ws.setHighlighted(true);
        this.waveWindow.setHighlightedSweep(-1);
        if (repaintContents) {
            this.repaintContents();
        }
    }

    public void removeHighlightedSignal(WaveSignal ws, boolean repaintContents) {
        ws.setHighlighted(false);
        if (ws.getButton() != null) {
            ws.getButton().setBackground(this.background);
        }
        this.waveWindow.setHighlightedSweep(-1);
        if (repaintContents) {
            this.repaintContents();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void makeSelectedPanel(int x2, int y) {
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!wp.selected || wp == this) continue;
            wp.selected = false;
            wp.repaintContents();
        }
        if (!this.selected) {
            this.selected = true;
            this.repaintContents();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void mousePressedZoom(MouseEvent evt) {
        this.dragStartXD = this.convertXScreenToData(evt.getX());
        this.dragStartYD = this.convertYScreenToData(evt.getY());
        ZoomAndPanListener.setProperCursor(evt);
        this.draggingArea = true;
    }

    public void mouseReleasedZoom(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        this.draggingArea = false;
        double lowXValue = Math.min(this.dragEndXD, this.dragStartXD);
        double highXValue = Math.max(this.dragEndXD, this.dragStartXD);
        double xRange = highXValue - lowXValue;
        lowXValue -= xRange / 8.0;
        highXValue += xRange / 8.0;
        double lowValue = Math.min(this.dragEndYD, this.dragStartYD);
        double highValue = Math.max(this.dragEndYD, this.dragStartYD);
        double valueRange = highValue - lowValue;
        lowValue -= valueRange / 8.0;
        highValue += valueRange / 8.0;
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!this.waveWindow.isXAxisLocked() && wp != this) continue;
            if ((evt.getModifiers() & 1) == 0 || ClickZoomWireListener.isRightMouse(evt)) {
                if (wp.getMinXAxis() > wp.getMaxXAxis()) {
                    wp.setXAxisRange(highXValue, lowXValue);
                } else {
                    wp.setXAxisRange(lowXValue, highXValue);
                }
                if (wp == this) {
                    wp.setYAxisRange(lowValue, highValue);
                }
            } else {
                double oldRange = wp.maxXPosition - wp.minXPosition;
                double min2 = (lowXValue + highXValue) / 2.0 - oldRange;
                double max2 = (lowXValue + highXValue) / 2.0 + oldRange;
                if (wp.getMinXAxis() > wp.getMaxXAxis()) {
                    wp.setXAxisRange(max2, min2);
                } else {
                    wp.setXAxisRange(min2, max2);
                }
                if (wp == this) {
                    wp.setYAxisRange((lowValue + highValue) / 2.0 - wp.analogRange, (lowValue + highValue) / 2.0 + wp.analogRange);
                }
            }
            wp.repaintWithRulers();
        }
    }

    public void mouseDraggedZoom(MouseEvent evt) {
        if (this.draggingArea) {
            this.dragEndXD = this.convertXScreenToData(evt.getX());
            this.dragEndYD = this.convertYScreenToData(evt.getY());
            this.repaint();
        }
    }

    public void mouseMovedZoom(MouseEvent evt) {
    }

    public void mousePressedPan(MouseEvent evt) {
        this.dragStartXD = this.convertXScreenToData(evt.getX());
        this.dragStartYD = this.convertYScreenToData(evt.getY());
    }

    public void mouseReleasedPan(MouseEvent evt) {
    }

    public void mouseDraggedPan(MouseEvent evt) {
        this.dragEndXD = this.convertXScreenToData(evt.getX());
        double dXValue = this.dragEndXD - this.dragStartXD;
        this.dragEndYD = this.convertYScreenToData(evt.getY());
        double dYValue = this.dragEndYD - this.dragStartYD;
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!this.waveWindow.isXAxisLocked() && wp != this) continue;
            wp.setXAxisRange(wp.minXPosition - dXValue, wp.maxXPosition - dXValue);
            if (wp == this) {
                this.setYAxisRange(this.analogLowValue - dYValue, this.analogHighValue - dYValue);
            }
            wp.repaintWithRulers();
        }
        this.dragStartXD = this.dragEndXD;
        this.dragStartYD = this.dragEndYD;
    }

    public void mouseMovedPan(MouseEvent evt) {
    }

    public static class WaveSelection {
        WaveSignal ws;
        boolean controlPoint;
        double controlXValue;
    }
}

