/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.Node;

public class SplayTree {
    private Node root;
    private Node header = new Node();

    public SplayTree() {
        this.clear();
    }

    public void clear() {
        this.root = null;
        this.header.children[2] = null;
        this.header.children[3] = null;
    }

    public void insert(Node key) {
        key.children[2] = null;
        key.children[3] = null;
        if (this.root == null) {
            this.root = key;
            return;
        }
        this.splay(key);
        int c = key.f - this.root.f;
        if (c == 0) {
            assert (false) : "Duplicate item to be inserted into splay tree";
            return;
        }
        Node n = key;
        if (c < 0) {
            n.children[2] = this.root.children[2];
            n.children[3] = this.root;
            this.root.children[2] = null;
        } else {
            n.children[3] = this.root.children[3];
            n.children[2] = this.root;
            this.root.children[3] = null;
        }
        this.root = n;
    }

    public void remove(Node key) {
        this.splay(key);
        if (key.f != this.root.f) {
            assert (false) : "Item not found in splay tree";
            return;
        }
        if (this.root.children[2] == null) {
            this.root = this.root.children[3];
        } else {
            Node x2 = this.root.children[3];
            this.root = this.root.children[2];
            this.splay(key);
            this.root.children[3] = x2;
        }
    }

    public Node findMin() {
        Node x2 = this.root;
        if (this.root == null) {
            return null;
        }
        while (x2.children[2] != null) {
            x2 = x2.children[2];
        }
        this.splay(x2);
        return x2;
    }

    public Node find(Node key) {
        if (this.root == null) {
            return null;
        }
        this.splay(key);
        if (this.root.f != key.f) {
            return null;
        }
        return this.root;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    private void splay(Node key) {
        Node r;
        Node l = r = this.header;
        Node t = this.root;
        this.header.children[3] = null;
        this.header.children[2] = null;
        while (true) {
            Node y;
            if (key.f < t.f) {
                if (t.children[2] == null) break;
                if (key.f < t.children[2].f) {
                    y = t.children[2];
                    t.children[2] = y.children[3];
                    y.children[3] = t;
                    t = y;
                    if (t.children[2] == null) break;
                }
                r.children[2] = t;
                r = t;
                t = t.children[2];
                continue;
            }
            if (key.f <= t.f || t.children[3] == null) break;
            if (key.f > t.children[3].f) {
                y = t.children[3];
                t.children[3] = y.children[2];
                y.children[2] = t;
                t = y;
                if (t.children[3] == null) break;
            }
            l.children[3] = t;
            l = t;
            t = t.children[3];
        }
        l.children[3] = t.children[2];
        r.children[2] = t.children[3];
        t.children[2] = this.header.children[3];
        t.children[3] = this.header.children[2];
        this.root = t;
    }
}

