/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import com.sun.electric.util.math.MutableInterval;
import java.math.BigDecimal;

public class UnivariateTaylorModel {
    private static double[] NULL_DOUBLE_ARRAY = new double[0];
    private static MutableInterval ENTIRE = new MutableInterval().assignEntire();
    private final double[] coeff;
    private final MutableInterval remainder;
    private final MutableInterval evalRemainder;

    private UnivariateTaylorModel(double[] coeff, double inf, double sup) {
        this.coeff = coeff;
        this.remainder = new MutableInterval(inf, sup);
        double evalRound = 0.0;
        this.evalRemainder = new MutableInterval(-evalRound, evalRound);
        this.evalRemainder.add(this.remainder);
    }

    private UnivariateTaylorModel(double[] coeff) {
        this.coeff = coeff;
        this.remainder = this.evalRemainder = ENTIRE;
    }

    public static UnivariateTaylorModel newInstance(double x) {
        double[] coeff = NULL_DOUBLE_ARRAY;
        double inf = 0.0;
        double sup = 0.0;
        if (Double.NEGATIVE_INFINITY < x && x < Double.POSITIVE_INFINITY) {
            coeff = new double[]{x};
        } else if (x == Double.POSITIVE_INFINITY) {
            coeff = new double[]{Double.MAX_VALUE};
            sup = x;
        } else if (x == Double.NEGATIVE_INFINITY) {
            inf = x;
            coeff = new double[]{-1.7976931348623157E308};
        } else {
            inf = -1.7976931348623157E308;
            sup = Double.MAX_VALUE;
        }
        return new UnivariateTaylorModel(coeff, inf, sup);
    }

    public static UnivariateTaylorModel newInstance(MutableInterval x) {
        return null;
    }

    public int size() {
        return this.coeff.length;
    }

    public double coeff(int k) {
        return k < this.coeff.length ? this.coeff[k] : 0.0;
    }

    public MutableInterval getRemainder() {
        return new MutableInterval(this.remainder);
    }

    public void eval(MutableInterval result2, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result2.assignEntire();
            return;
        }
        double value2 = 0.0;
        double sumAbs = 0.0;
        for (int k = this.coeff.length - 1; k >= 0; --k) {
            value2 = value2 * t + this.coeff[k];
            sumAbs += Math.abs(this.coeff[k]);
        }
        result2.add(this.evalRemainder);
    }

    public void eval2(MutableInterval result2, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result2.assignEntire();
            return;
        }
        result2.assign(0);
        MutableInterval ti = new MutableInterval(t);
        for (int k = this.coeff.length - 1; k >= 0; --k) {
            result2.mul(ti).add(new MutableInterval(this.coeff[k]));
        }
        result2.add(this.remainder);
    }

    public void eval3(MutableInterval result2, double t) {
        double sup;
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result2.assignEntire();
            return;
        }
        BigDecimal tb = BigDecimal.valueOf(t);
        BigDecimal ib = BigDecimal.valueOf(0L);
        BigDecimal sb = BigDecimal.valueOf(0L);
        for (int k = this.coeff.length - 1; k >= 0; --k) {
            ib.multiply(tb);
            sb.multiply(tb);
            if (t < 0.0) {
                BigDecimal b = ib;
                ib = sb;
                sb = b;
            }
            BigDecimal cb = BigDecimal.valueOf(this.coeff[k]);
            ib.add(cb);
            sb.add(cb);
        }
        ib.add(new BigDecimal(this.remainder.inf()));
        sb.add(new BigDecimal(this.remainder.sup()));
        double inf = ib.doubleValue();
        if (!ib.equals(BigDecimal.valueOf(inf))) {
            inf = MutableInterval.prev(inf);
        }
        if (!sb.equals(BigDecimal.valueOf(sup = sb.doubleValue()))) {
            sup = MutableInterval.next(sup);
        }
        result2.assign(inf, sup);
    }

    public void eval3(MutableInterval[] results, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            for (MutableInterval result2 : results) {
                result2.assignEntire();
            }
            return;
        }
        BigDecimal tb = BigDecimal.valueOf(t);
        BigDecimal[] lb = new BigDecimal[results.length];
        BigDecimal[] hb = new BigDecimal[results.length];
        for (int i = 0; i < results.length; ++i) {
            lb[i] = hb[i] = BigDecimal.valueOf(0L);
        }
    }

    public void evalAtZero(MutableInterval result2) {
        if (this.coeff.length >= 1) {
            result2.assign(this.coeff[0]);
            result2.add(this.remainder);
        } else {
            result2.assignEmpty();
        }
    }

    public void evalAtPlusOne(MutableInterval result2) {
        result2.assign(0);
        for (int k = this.coeff.length - 1; k >= 0; --k) {
            result2.add(this.coeff[k]);
        }
        result2.add(this.remainder);
    }

    public void evalAtMinusOne(MutableInterval result2) {
        result2.assign(0);
        for (int k = this.coeff.length - 1; k >= 0; --k) {
            result2.add((k & 1) == 0 ? this.coeff[k] : -this.coeff[k]);
        }
        result2.add(this.remainder);
    }

    public UnivariateTaylorModel negate() {
        double[] newCoeff = new double[this.coeff.length];
        for (int k = 0; k < this.coeff.length; ++k) {
            newCoeff[k] = -this.coeff[k];
        }
        return new UnivariateTaylorModel(newCoeff, -this.remainder.sup(), -this.remainder.inf());
    }

    public UnivariateTaylorModel multiplyNaive(double x) {
        double[] newCoeff = new double[this.size()];
        for (int k = 0; k < newCoeff.length; ++k) {
            newCoeff[k] = this.coeff[k] * x;
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel addNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, Math.max(this.size(), x.size()));
        double[] newCoeff = new double[maxSize];
        for (int k = 0; k < newCoeff.length; ++k) {
            newCoeff[k] = this.coeff(k) + x.coeff(k);
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel subtractNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, Math.max(this.size(), x.size()));
        double[] newCoeff = new double[maxSize];
        for (int k = 0; k < newCoeff.length; ++k) {
            newCoeff[k] = this.coeff(k) + x.coeff(k);
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel multiplyNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, this.size() + x.size() - 1);
        if (x.size() < maxSize) {
            return x.multiplyNaive(this, maxSize);
        }
        double[] newCoeff = new double[maxSize];
        for (int k = 0; k < newCoeff.length; ++k) {
            double s = 0.0;
            for (int l = 0; l < this.size(); ++l) {
                s += this.coeff(l) * x.coeff(k - l);
            }
            newCoeff[k] = s;
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    private UnivariateTaylorModel check() {
        for (double c : this.coeff) {
            assert (-1.7976931348623157E308 <= c && c <= Double.MAX_VALUE);
        }
        return this;
    }
}

