/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorageWrapper;
import com.sun.electric.database.geometry.btree.FilePageStorage;
import com.sun.electric.database.geometry.btree.unboxed.UnboxedInt;
import java.util.Random;
import java.util.TreeMap;

public class BTreeTest {
    public static void main(String[] s) throws Exception {
        if (s.length != 4) {
            System.err.println("");
            System.err.println("usage: java " + BTree.class.getName() + " <maxsize> <numops> <cachesize> <seed>");
            System.err.println("");
            System.err.println("  Creates a BTree and runs random operations on both it and an in-memory TreeMap.");
            System.err.println("  Reports any disagreements.");
            System.err.println("");
            System.err.println("    <maxsize>   maximum number of entries in the tree, or 0 for no limit");
            System.err.println("    <numops>    number of operations to perform, or 0 for no limit");
            System.err.println("    <cachesize> number of pages to cache in memory, or 0 for no cache");
            System.err.println("    <seed>      seed for random number generator, in hex");
            System.err.println("");
            System.exit(-1);
        }
        Random rand = new Random(Integer.parseInt(s[3], 16));
        int cachesize = Integer.parseInt(s[2]);
        int numops = Integer.parseInt(s[1]);
        int maxsize = Integer.parseInt(s[0]);
        boolean size = false;
        CachingPageStorageWrapper ps = new CachingPageStorageWrapper(FilePageStorage.create(), cachesize, false);
        BTree btree = new BTree(ps, UnboxedInt.instance, UnboxedInt.instance, null, null);
        TreeMap<Integer, Integer> tm = new TreeMap<Integer, Integer>();
        int puts = 0;
        int gets = 0;
        int deletes = 0;
        int misses = 0;
        boolean inserts = false;
        long lastprint = 0L;
        boolean do_tm = true;
        boolean do_bt = true;
        block6: for (int i = 0; numops == 0 || i < numops; ++i) {
            if (System.currentTimeMillis() - lastprint > 200L) {
                lastprint = System.currentTimeMillis();
                System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
            }
            int key = rand.nextInt() % 1000000;
            switch (rand.nextInt() % 3) {
                case 0: {
                    Integer tget = do_tm ? (Integer)tm.get(key) : null;
                    Integer bget = do_bt ? btree.getValFromKey(key) : null;
                    ++gets;
                    if (!do_tm || !do_bt) continue block6;
                    if (tget == null && bget == null) {
                        ++misses;
                        continue block6;
                    }
                    if (tget != null && bget != null && tget.equals(bget)) continue block6;
                    System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
                    System.out.println();
                    System.out.println();
                    throw new RuntimeException("  disagreement on key " + key + ": btree=" + bget + ", treemap=" + tget);
                }
                case 1: {
                    int ord;
                    int sz = do_bt ? btree.size() : tm.size();
                    int n = ord = sz == 0 ? 0 : Math.abs(rand.nextInt()) % sz;
                    Integer tget = do_tm ? (sz == 0 ? null : tm.values().toArray(new Integer[0])[ord]) : null;
                    Integer bget = do_bt ? btree.getValFromOrd(ord) : null;
                    ++gets;
                    if (!do_tm || !do_bt || tget == null && bget == null || tget != null && bget != null && tget.equals(bget)) continue block6;
                    System.out.print("\r puts=" + puts + " gets=" + (gets - misses) + "/" + gets + " deletes=" + deletes);
                    System.out.println();
                    System.out.println();
                    System.out.println("dump:");
                    throw new RuntimeException("  disagreement on ordinal " + ord + ": btree=" + bget + ", treemap=" + tget);
                }
                case 2: {
                    int val = rand.nextInt();
                    boolean already_there = false;
                    if (do_tm) {
                        if (do_bt) {
                            already_there = tm.get(key) != null;
                        }
                        tm.put(key, val);
                    }
                    if (do_bt) {
                        if (!do_tm) {
                            boolean bl = already_there = btree.getValFromKey(key) != null;
                        }
                        if (already_there) {
                            btree.replace(key, val);
                        } else {
                            btree.insert(key, val);
                        }
                    }
                    ++puts;
                    continue block6;
                }
                case 3: {
                    ++deletes;
                }
            }
        }
    }
}

