/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.Launcher;
import com.sun.electric.StartupPrefs;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.FileMenu;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        String serverMachineName;
        String loggingFilePath;
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        if (Main.hasCommandLineOption(argsList, "-v")) {
            System.out.println(Version.getVersion());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-version")) {
            System.out.println(Version.getApplicationInformation());
            System.out.println("\t" + Version.getVersionInformation());
            System.out.println("\t" + Version.getCopyrightInformation());
            System.out.println("\t" + Version.getWarrantyInformation());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-help")) {
            System.out.println("Usage (without plugins):");
            System.out.println("\tjava -jar electric.jar [electric-options]");
            System.out.println("Usage (with plugins):");
            System.out.println("\tjava -classpath electric.jar<delim>{list of plugins} com.sun.electric.Launcher [electric-options]");
            System.out.println("\t\twhere <delim> is OS-dependant separator (colon or semicolon)");
            System.out.println("\nOptions:");
            System.out.println("\t-mdi: multiple document interface mode");
            System.out.println("\t-sdi: single document interface mode");
            System.out.println("\t-NOMINMEM: ignore minimum memory provided for JVM");
            System.out.println("\t-s <script name>: bean shell script to execute");
            System.out.println("\t-version: version information");
            System.out.println("\t-v: brief version information");
            System.out.println("\t-debug: debug mode. Extra information is available");
            System.out.println("\t-threads <numThreads>: recommended size of thread pool for Job execution.");
            System.out.println("\t-logging <filePath>: log server events in a binary file");
            System.out.println("\t-socket <socket>: socket port for client/server interaction");
            System.out.println("\t-batch: running in batch mode.");
            System.out.println("\t-server: dump trace of snapshots");
            System.out.println("\t-client <machine name>: replay trace of snapshots");
            System.out.println("\t-help: this message");
            System.exit(0);
        }
        Mode runMode = Mode.FULL_SCREEN;
        String pipeOptions = "";
        if (Main.hasCommandLineOption(argsList, "-debug")) {
            pipeOptions = pipeOptions + " -debug";
            Job.setDebug(true);
        }
        if (Main.hasCommandLineOption(argsList, "-extraDebug")) {
            pipeOptions = pipeOptions + " -extraDebug";
            Job.LOCALDEBUGFLAG = true;
        }
        String numThreadsString = Main.getCommandLineOption(argsList, "-threads");
        int numThreads = 0;
        if (numThreadsString != null) {
            numThreads = TextUtils.atoi(numThreadsString);
            if (numThreads > 0) {
                pipeOptions = pipeOptions + " -threads " + numThreads;
            } else {
                System.out.println("Invalid option -threads " + numThreadsString);
            }
        }
        if ((loggingFilePath = Main.getCommandLineOption(argsList, "-logging")) != null) {
            pipeOptions = pipeOptions + " -logging " + loggingFilePath;
        }
        String socketString = Main.getCommandLineOption(argsList, "-socket");
        int socketPort = 0;
        if (socketString != null) {
            socketPort = TextUtils.atoi(socketString);
            if (socketPort > 0) {
                pipeOptions = pipeOptions + " -socket " + socketPort;
            } else {
                System.out.println("Invalid option -socket " + socketString);
            }
        }
        Main.hasCommandLineOption(argsList, "-NOMINMEM");
        if (Main.hasCommandLineOption(argsList, "-pipeserver")) {
            ActivityLogger.initialize("electricserver.log", true, true, true);
            Job.pipeServer(numThreads, loggingFilePath, socketPort);
            return;
        }
        ActivityLogger.initialize("electric.log", true, true, true);
        if (Main.hasCommandLineOption(argsList, "-batch")) {
            runMode = Mode.BATCH;
        }
        if (Main.hasCommandLineOption(argsList, "-server")) {
            if (runMode != Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Mode.SERVER));
            }
            runMode = Mode.SERVER;
        }
        if ((serverMachineName = Main.getCommandLineOption(argsList, "-client")) != null) {
            if (runMode != Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
        }
        boolean pipe = false;
        boolean pipedebug = false;
        if (Main.hasCommandLineOption(argsList, "-pipe")) {
            if (runMode != Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
            pipe = true;
        }
        if (Main.hasCommandLineOption(argsList, "-pipedebug")) {
            if (runMode != Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Mode.CLIENT));
            }
            runMode = Mode.CLIENT;
            pipe = true;
            pipedebug = true;
        }
        UserInterfaceMain.Mode mode = null;
        if (Main.hasCommandLineOption(argsList, "-mdi")) {
            mode = UserInterfaceMain.Mode.MDI;
        }
        if (Main.hasCommandLineOption(argsList, "-sdi")) {
            mode = UserInterfaceMain.Mode.SDI;
        }
        AbstractUserInterface ui = runMode == Mode.FULL_SCREEN || runMode == Mode.CLIENT ? new UserInterfaceMain(argsList, mode, true) : new UserInterfaceDummy(-1);
        MessagesStream.getMessagesStream();
        TextDescriptor.cacheSize();
        Tool.initAllTools();
        Pref.lockCreation();
        EDatabase database = new EDatabase(IdManager.stdIdManager.getInitialSnapshot());
        EDatabase.setClientDatabase(database);
        InitDatabase job = new InitDatabase(argsList);
        if (runMode == Mode.CLIENT) {
            IdManager.stdIdManager.setReadOnly();
            if (pipe) {
                try {
                    Process process = Launcher.invokePipeserver(pipeOptions, pipedebug);
                    Job.pipeClient(process, ui, job, pipedebug);
                }
                catch (IOException e) {
                    System.exit(1);
                }
            } else {
                Job.socketClient(serverMachineName, socketPort, ui, job);
            }
        } else {
            EDatabase.setServerDatabase(database);
            Job.initJobManager(numThreads, loggingFilePath, socketPort, ui, job);
        }
    }

    private static boolean hasCommandLineOption(List<String> argsList, String option) {
        for (int i = 0; i < argsList.size(); ++i) {
            if (!argsList.get(i).equals(option)) continue;
            argsList.remove(i);
            return true;
        }
        return false;
    }

    private static String getCommandLineOption(List<String> argsList, String option) {
        for (int i = 0; i < argsList.size() - 1; ++i) {
            if (!argsList.get(i).equals(option)) continue;
            argsList.remove(i);
            if (argsList.get(i).startsWith("-")) {
                System.out.println("Bad command line option: " + option + " " + argsList.get(i + 1));
                return null;
            }
            return argsList.remove(i);
        }
        return null;
    }

    public static void openCommandLineLibs(List<String> argsList) {
        for (int i = 0; i < argsList.size(); ++i) {
            String arg = argsList.get(i);
            if (arg.startsWith("-")) {
                System.out.println("Command line option " + arg + " not understood, ignoring.");
                continue;
            }
            URL url = TextUtils.makeURLToFile(arg);
            if (url == null) continue;
            User.setWorkingDirectory(TextUtils.getFilePath(url));
            FileType.setDatabaseGroupPath(User.getWorkingDirectory());
            FileMenu.openLibraryCommand(url);
        }
    }

    public static long getMemoryUsage() {
        Main.collectGarbage();
        Main.collectGarbage();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Main.collectGarbage();
        Main.collectGarbage();
        long freeMemory = Runtime.getRuntime().freeMemory();
        return totalMemory - freeMemory;
    }

    private static void collectGarbage() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitProjectSettings
    extends Job {
        private Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        List<String> argsList;

        private InitProjectSettings(List<String> argsList) {
            super("Init project preferences", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            Preferences prefRoot = Pref.getPrefRoot();
            for (Map.Entry<Setting, Object> e : this.getDatabase().getSettings().entrySet()) {
                Setting setting = e.getKey();
                Object value = setting.getValueFromPreferences(prefRoot);
                if (value.equals(e.getValue())) continue;
                this.changeBatch.add(setting, value);
            }
            this.argsList = argsList;
        }

        @Override
        public boolean doIt() throws JobException {
            this.getDatabase().implementSettingChanges(this.changeBatch);
            return true;
        }

        @Override
        public void terminateOK() {
            Job.getExtendedUserInterface().finishInitialization();
            String beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
            Main.openCommandLineLibs(this.argsList);
            if (beanShellScript != null) {
                EvalJavaBsh.runScript(beanShellScript);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitDatabase
    extends Job {
        private Map<String, Object> paramValuesByXmlPath = Technology.getParamValuesByXmlPath();
        private String softTechnologies = StartupPrefs.getSoftTechnologies();
        private transient List<String> argsList;
        private Library mainLib;

        private InitDatabase(List<String> argsList) {
            super("Init database", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsList;
        }

        @Override
        public boolean doIt() throws JobException {
            Technology.initAllTechnologies(this.getDatabase(), this.paramValuesByXmlPath, this.softTechnologies);
            Library clipLib = Library.newInstance(Clipboard.clipCellId.libId.libName, null);
            clipLib.setHidden();
            Cell.newInstance(clipLib, Clipboard.clipCellId.cellName.toString()).setTechnology(this.getTechPool().getGeneric());
            this.mainLib = Library.newInstance("noname", null);
            if (this.mainLib == null) {
                return false;
            }
            this.fieldVariableChanged("mainLib");
            this.mainLib.clearChanged();
            return true;
        }

        @Override
        public void terminateOK() {
            new InitProjectSettings(this.argsList).startJobOnMyResult();
            User.setCurrentLibrary(this.mainLib);
        }

        @Override
        public void terminateFail(Throwable jobException) {
            System.out.println("Initialization failed");
            System.exit(1);
        }
    }

    public static class UserInterfaceDummy
    extends AbstractUserInterface {
        private PrintStream stdout = System.out;
        private PrintWriter printWriter = null;

        public UserInterfaceDummy(int connectionId) {
            super(connectionId);
        }

        public void startProgressDialog(String type, String filePath) {
        }

        public void stopProgressDialog() {
        }

        public void setProgressValue(int pct) {
        }

        public void setProgressNote(String message) {
        }

        public String getProgressNote() {
            return null;
        }

        public EDatabase getDatabase() {
            return EDatabase.clientDatabase();
        }

        public EditWindow_ getCurrentEditWindow_() {
            return null;
        }

        public EditWindow_ needCurrentEditWindow_() {
            System.out.println("Batch mode Electric has no needed windows");
            return null;
        }

        public Cell getCurrentCell() {
            throw new IllegalStateException("Batch mode Electric has no current Cell");
        }

        public Cell needCurrentCell() {
            throw new IllegalStateException("Batch mode Electric has no current Cell");
        }

        public void repaintAllWindows() {
        }

        public void adjustReferencePoint(Cell cell, double cX, double cY) {
        }

        public int getDefaultTextSize() {
            return 14;
        }

        public EditWindow_ displayCell(Cell cell) {
            return null;
        }

        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
            System.out.println(logger.getInfo());
        }

        public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, Geometric[] gPair, int position) {
            return log.getMessageString();
        }

        public void showErrorMessage(String message, String title) {
            System.out.println(message);
        }

        public void showErrorMessage(String[] message, String title) {
            System.out.println(message);
        }

        public void showInformationMessage(String message, String title) {
            System.out.println(message);
        }

        public void printMessage(String message, boolean newLine) {
            if (newLine) {
                this.stdout.println(message);
                if (this.printWriter != null) {
                    this.printWriter.println(message);
                }
            } else {
                this.stdout.print(message);
                if (this.printWriter != null) {
                    this.printWriter.print(message);
                }
            }
        }

        public void saveMessages(String filePath) {
            try {
                if (this.printWriter != null) {
                    this.printWriter.close();
                    this.printWriter = null;
                }
                if (filePath == null) {
                    return;
                }
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            }
            catch (IOException e) {
                System.err.println("Error creating " + filePath);
                System.out.println("Error creating " + filePath);
                return;
            }
            System.out.println("Messages will be saved to " + filePath);
        }

        public boolean confirmMessage(Object message) {
            return true;
        }

        public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
            System.out.println(message + " CHOOSING " + defaultChoice);
            for (int i = 0; i < choices.length; ++i) {
                if (!choices[i].equals(defaultChoice)) continue;
                return i;
            }
            return 0;
        }

        public String askForInput(Object message, String title, String def) {
            return def;
        }

        protected void terminateJob(EJob ejob) {
            this.printMessage("Job " + ejob, true);
        }

        protected void showJobQueue(Job.Inform[] jobQueue) {
            this.printMessage("JobQueue: ", false);
            for (Job.Inform jobInfo : jobQueue) {
                this.printMessage(" " + jobInfo, false);
            }
            this.printMessage("", true);
        }

        protected void addEvent(Client.ServerEvent serverEvent) {
            serverEvent.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        FULL_SCREEN,
        BATCH,
        SERVER,
        CLIENT;

    }
}

