/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCellGroup
extends EDialog {
    private static Preferences prefs = Preferences.userNodeForPackage(ChangeCellGroup.class);
    private static final String selectedRadioButton = "ChangeCellGroup-WhichMoveType";
    private List<Cell> cellsToRegroup;
    private List<Cell.CellGroup> cellGroups;
    private JButton apply;
    private ButtonGroup buttonGroup1;
    private JButton cancel;
    private JComboBox cellGroupsComboBox;
    private JLabel cellNameLabel;
    private JPanel jPanel1;
    private JPanel mainPanel;
    private JRadioButton moveOwnCellGroup;
    private JRadioButton moveToCellGroup;

    public ChangeCellGroup(Frame parent, boolean modal, List<Cell> cellsToRegroup, Library initialLibrary) {
        super(parent, modal);
        this.setTitle("Change Cell Group");
        this.cellsToRegroup = cellsToRegroup;
        this.cellGroups = new ArrayList<Cell.CellGroup>();
        this.initComponents();
        this.cellNameLabel.setText("Change Cell Group for: " + cellsToRegroup.get(0));
        this.populateCellGroupsComboBox(cellsToRegroup, initialLibrary);
        int selected = prefs.getInt(selectedRadioButton, 0);
        this.cellGroupsComboBox.setEnabled(false);
        switch (selected) {
            case 0: {
                this.moveOwnCellGroup.setSelected(true);
                break;
            }
            case 1: {
                this.moveToCellGroup.setSelected(true);
            }
        }
        if (cellsToRegroup.size() > 1) {
            this.moveToCellGroup.setSelected(true);
            this.moveOwnCellGroup.setEnabled(false);
        }
        this.pack();
        this.finishInitialization();
    }

    private void populateCellGroupsComboBox(List<Cell> cellsToRegroup, Library lib) {
        this.cellGroups.clear();
        this.cellGroupsComboBox.removeAllItems();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            Cell.CellGroup cg = c.getCellGroup();
            if (cg == null) continue;
            boolean inList = false;
            for (Cell rgCell : cellsToRegroup) {
                if (cg != rgCell.getCellGroup()) continue;
                inList = true;
                break;
            }
            if (inList || this.cellGroups.contains(cg)) continue;
            this.cellGroups.add(cg);
        }
        Collections.sort(this.cellGroups, new CellGroupComparator());
        for (Cell.CellGroup cg : this.cellGroups) {
            this.cellGroupsComboBox.addItem(cg.getName());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.cellNameLabel = new JLabel();
        this.moveOwnCellGroup = new JRadioButton();
        this.moveToCellGroup = new JRadioButton();
        this.cellGroupsComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.apply = new JButton();
        this.cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ChangeCellGroup.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.cellNameLabel.setText("cellName");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.mainPanel.add((Component)this.cellNameLabel, gridBagConstraints);
        this.moveOwnCellGroup.setText("Move to it's own cell group");
        this.buttonGroup1.add(this.moveOwnCellGroup);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.moveOwnCellGroup, gridBagConstraints);
        this.moveToCellGroup.setText("Move to Cell Group: ");
        this.buttonGroup1.add(this.moveToCellGroup);
        this.moveToCellGroup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChangeCellGroup.this.moveToCellGroupItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.moveToCellGroup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.cellGroupsComboBox, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.apply.setText("OK");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeCellGroup.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.apply, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeCellGroup.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.cancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void moveToCellGroupItemStateChanged(ItemEvent evt) {
        boolean selected = this.moveToCellGroup.isSelected();
        this.cellGroupsComboBox.setEnabled(selected);
    }

    private void applyActionPerformed(ActionEvent evt) {
        Cell newGroupCell = null;
        boolean doIt = true;
        if (this.moveOwnCellGroup.isSelected()) {
            Cell cell = this.cellsToRegroup.get(0);
            if (cell.getCellGroup() != null && cell.getCellGroup().getNumCells() == 1) {
                doIt = false;
            }
        } else if (this.moveToCellGroup.isSelected()) {
            int selected = this.cellGroupsComboBox.getSelectedIndex();
            Cell.CellGroup newGroup = (Cell.CellGroup)this.cellGroups.toArray()[selected];
            newGroupCell = newGroup.getCells().next();
        }
        if (doIt) {
            new ChangeCellGroupJob(this.cellsToRegroup, newGroupCell);
        }
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        int selected = 0;
        selected = this.moveOwnCellGroup.isSelected() ? 0 : selected;
        selected = this.moveToCellGroup.isSelected() ? 1 : selected;
        prefs.putInt(selectedRadioButton, selected);
        this.setVisible(false);
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeCellGroupJob
    extends Job {
        private List<Cell> cellsToRegroup;
        private Cell newGroupCell;

        ChangeCellGroupJob(List<Cell> cellsToRegroup, Cell newGroupCell) {
            super("Change Cell Group", User.getUserTool(), Job.Type.CHANGE, cellsToRegroup.get(0), cellsToRegroup.get(0), Job.Priority.USER);
            this.cellsToRegroup = cellsToRegroup;
            this.newGroupCell = newGroupCell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell.CellGroup newGroup = null;
            if (this.newGroupCell != null) {
                newGroup = this.newGroupCell.getCellGroup();
            }
            for (Cell cell : this.cellsToRegroup) {
                if (newGroup != null && cell.getCellGroup() == newGroup) continue;
                cell.setCellGroup(newGroup);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellGroupComparator
    implements Comparator<Cell.CellGroup> {
        private CellGroupComparator() {
        }

        @Override
        public int compare(Cell.CellGroup cg1, Cell.CellGroup cg2) {
            String s1 = cg1.getName();
            String s2 = cg2.getName();
            return s1.compareTo(s2);
        }
    }
}

