/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;

public class TechTypeTSMC180
extends TechType {
    private static final long serialVersionUID = 0L;
    private static final String[] LAYER_NAMES = new String[]{"Polysilicon-1", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6"};
    public static final TechType TSMC180 = new TechTypeTSMC180();

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private TechTypeTSMC180() {
        super(Technology.findTechnology("TSMC180"), LAYER_NAMES);
        TechTypeTSMC180.error(this.wellWidth != 17.0, "wrong value in Tech");
        this.wellSurroundDiff = 4.3;
        this.gateExtendPastMOS = 2.5;
        this.p1Width = 1.8;
        this.p1ToP1Space = 2.7;
        this.p1M1Width = 5.0;
        this.gateToGateSpace = 3.0;
        this.gateToDiffContSpace = 1.1;
        this.diffContWidth = 5.0;
        this.gateLength = 1.8;
        this.offsetLShapePolyContact = 1.6;
        this.offsetTShapePolyContact = 3.4;
        this.selectSpace = 4.4;
        this.selectSurroundDiffInTrans = 1.8;
        this.selectSurround = 0.0;
        this.selectSurroundDiffInActiveContact = 1.0;
        this.selectSurroundDiffAlongGateInTrans = 3.6;
    }

    private Object readResolve() {
        return TSMC180;
    }

    @Override
    public double roundToGrid(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    @Override
    public TechType.MosInst newNmosInst(double x, double y, double w, double l, Cell parent) {
        return new TechType.MosInst.MosInstH('n', x, y, w, l, parent);
    }

    @Override
    public TechType.MosInst newPmosInst(double x, double y, double w, double l, Cell parent) {
        return new TechType.MosInst.MosInstH('p', x, y, w, l, parent);
    }

    @Override
    public String name() {
        return "TSMC180";
    }

    @Override
    public int getNumMetals() {
        return 6;
    }

    @Override
    public double reservedToLambda(int layer, double nbTracks) {
        double m1via = 4.0;
        double m1sp = 3.0;
        double m1SP = 6.0;
        double m6via = 5.0;
        double m6sp = 4.0;
        double m6SP = 8.0;
        if (layer != 6) {
            return 2.0 * m1SP - m1sp + nbTracks * (m1via + m1sp);
        }
        return 2.0 * m6SP - m6sp + nbTracks * (m6via + m6sp);
    }
}

