/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ncc.HighlightTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightEquivalent {
    private static void prln(String s) {
        System.out.println(s);
    }

    private void highlightEquivalentNet(Network n, Equivalence e, CellContext cc) {
        HighlightEquivalent.prln("Finding equivalent of Network: " + n.describe(false));
        HierarchyEnumerator.NetNameProxy eqProx = e.findEquivalentNetShortingResistors(cc.context, n);
        if (eqProx == null) {
            HighlightEquivalent.prln("Can't find an equivalent network.");
            return;
        }
        VarContext eqCtxt = eqProx.getContext();
        Cell eqCell = eqProx.leafCell();
        Highlighter h = HighlightTools.getHighlighter(eqCell, eqCtxt);
        HighlightTools.highlightNetNamed(h, eqCell, eqProx.leafName());
    }

    private Network selectNet(Set<Network> netSet) {
        ArrayList<Network> nets = new ArrayList<Network>(netSet);
        if (nets.size() == 1) {
            return (Network)nets.get(0);
        }
        HashMap<String, Network> nameToNet = new HashMap<String, Network>();
        Object[] names = new String[nets.size()];
        int i = 0;
        for (Network n : nets) {
            String netNm = n.getName();
            nameToNet.put(netNm, n);
            names[i++] = netNm;
        }
        Arrays.sort(names, new NameCompare());
        String name = (String)JOptionPane.showInputDialog(null, "Select the Network you want to find the match of", "Select Network:", -1, null, names, names[0]);
        if (name == null) {
            return null;
        }
        return (Network)nameToNet.get(name);
    }

    private void highlightEquivOfNet(Set<Network> nets, Equivalence e, CellContext cc) {
        Network n = this.selectNet(nets);
        if (n == null) {
            return;
        }
        this.highlightEquivalentNet(n, e, cc);
    }

    private List<Nodable> findNodablesFrom(NodeInst ni) {
        ArrayList<Nodable> nodables = new ArrayList<Nodable>();
        Cell c = ni.getParent();
        Iterator<Nodable> it = c.getNetlist(false).getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getNodeInst() != ni) continue;
            nodables.add(no);
        }
        return nodables;
    }

    private Nodable selectNodable(List<Nodable> nodes) {
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        HashMap<String, Nodable> nameToNode = new HashMap<String, Nodable>();
        Object[] names = new String[nodes.size()];
        int i = 0;
        for (Nodable n : nodes) {
            String nodeNm = n.getName();
            nameToNode.put(nodeNm, n);
            names[i++] = nodeNm;
        }
        Arrays.sort(names, new NameCompare());
        String name = (String)JOptionPane.showInputDialog(null, "Select the Instance you want to find the match of", "Select Instance:", -1, null, names, names[0]);
        if (name == null) {
            return null;
        }
        return (Nodable)nameToNode.get(name);
    }

    private void highlightEquivOfNodeInst(NodeInst ni, Equivalence e, CellContext cc) {
        HighlightEquivalent.prln("Find the equivalent of NodeInst: " + ni.describe(false));
        List<Nodable> nodables = this.findNodablesFrom(ni);
        LayoutLib.error(nodables.size() == 0, "No Nodable for NodeInst?");
        Nodable node = this.selectNodable(nodables);
        if (node == null) {
            return;
        }
        HierarchyEnumerator.NodableNameProxy eqProx = e.findEquivalentNode(cc.context, node);
        if (eqProx == null) {
            HighlightEquivalent.prln(" No equivalent Node found.");
            return;
        }
        Nodable eqNo = eqProx.getNodable();
        NodeInst eqNi = eqNo instanceof NodeInst ? (NodeInst)eqNo : eqNo.getNodeInst();
        Cell eqCell = eqProx.leafCell();
        VarContext eqCtxt = eqProx.getContext();
        Highlighter h = HighlightTools.getHighlighter(eqCell, eqCtxt);
        h.addElectricObject(eqNi, eqCell);
    }

    private void highlightEquivOfGeometric(List<Geometric> geoms, Equivalence e, CellContext cc) {
        Geometric g = geoms.iterator().next();
        if (!(g instanceof NodeInst)) {
            HighlightEquivalent.prln("Highlighted object is not a nodeInst: ");
            g.getInfo();
            return;
        }
        this.highlightEquivOfNodeInst((NodeInst)g, e, cc);
    }

    private void highlight1() {
        NccResults results = NccJob.getLastNccResults();
        if (results == null) {
            HighlightEquivalent.prln("No saved NCC results.  Please run NCC first.");
            return;
        }
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            HighlightEquivalent.prln("No current Window");
            return;
        }
        CellContext cc = NccUtils.getCellContext(wnd);
        NccResult r = results.getResultFromRootCells();
        Equivalence e = r.getEquivalence();
        List<Geometric> geoms = wnd.getHighlightedEObjs(true, false);
        if (geoms.size() > 0) {
            this.highlightEquivOfGeometric(geoms, e, cc);
            return;
        }
        Set<Network> nets = wnd.getHighlightedNetworks();
        if (nets.size() > 0) {
            this.highlightEquivOfNet(nets, e, cc);
            return;
        }
        HighlightEquivalent.prln("No arc or node is selected");
    }

    private HighlightEquivalent() {
        this.highlight1();
    }

    public static void highlight() {
        new HighlightEquivalent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameCompare
    implements Comparator<String> {
        private NameCompare() {
        }

        @Override
        public int compare(String nm1, String nm2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(nm1, nm2);
        }
    }
}

