/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.Cell_;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.NodeInst_;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class CellContents {
    final Cell_ cell;
    NodeInst_[] nodes;
    final TreeMap orderedNodes = new TreeMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    CellContents(Cell_ cell) {
        if (!$assertionsDisabled && cell.contentsRef != null) {
            throw new AssertionError();
        }
        this.cell = cell;
        cell.contentsRef = new SoftReference<CellContents>(this);
        this.nodes = new NodeInst_[cell.nodes.length];
        this.restore();
    }

    void unlink() {
        if (!$assertionsDisabled && this.nodes == null) {
            throw new AssertionError();
        }
        this.orderedNodes.clear();
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].unlink();
        }
        if (!$assertionsDisabled && this.cell.contentsRef.get() != this) {
            throw new AssertionError();
        }
        this.nodes = null;
        this.cell.contentsRef.clear();
        this.cell.contentsRef = null;
    }

    void restore() {
        int i;
        ImmutableNodeInst[] inodes = this.cell.nodes;
        if (this.nodes.length < inodes.length) {
            NodeInst_[] newNodes = new NodeInst_[inodes.length];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            this.nodes = newNodes;
        }
        boolean orderChanged = false;
        for (i = 0; i < this.nodes.length; ++i) {
            ImmutableNodeInst ini = i < inodes.length ? inodes[i] : null;
            NodeInst_ ni = this.nodes[i];
            if (ini != null && ni == null) {
                orderChanged = true;
                this.nodes[i] = new NodeInst_(i, this, ini);
                continue;
            }
            if (ini != null && ni != null) {
                if (ini == ni.d) continue;
                if (ini.name != ni.d.name) {
                    orderChanged = true;
                }
                ni.restore(ini);
                continue;
            }
            if (ini != null || ni == null) continue;
            orderChanged = true;
            ni.unlink();
        }
        if (orderChanged) {
            this.orderedNodes.clear();
            for (i = 0; i < this.nodes.length; ++i) {
                this.orderedNodes.put(this.nodes[i].d.name, this.nodes[i]);
            }
        }
    }

    void check() {
        if (!$assertionsDisabled && this.nodes == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            NodeInst_ node = this.nodes[i];
            if (node == null) continue;
            node.check();
            if (!$assertionsDisabled && this.orderedNodes.get(node.d.name) != node) {
                throw new AssertionError();
            }
        }
        Iterator it = this.orderedNodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String name = (String)e.getKey();
            NodeInst_ ni = (NodeInst_)e.getValue();
            if (!$assertionsDisabled && this.nodes[ni.id] != ni) {
                throw new AssertionError();
            }
        }
    }

    void checkLinked() {
        if (!$assertionsDisabled && this.cell.contentsRef.get() != this) {
            throw new AssertionError();
        }
        this.cell.checkLinked();
    }

    static {
        $assertionsDisabled = !CellContents.class.desiredAssertionStatus();
    }
}

