/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.jemNets.NccNameProxy;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.PinType;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Transistor
extends Part {
    public static final TypeTable TYPES = new TypeTable();
    private static final List PIN_TYPES = new ArrayList();
    private final int[] term_coeffs;
    private double width;
    private final double length;
    private final Type type;

    public Set getPinTypes() {
        int t = this.type.getOrdinal();
        ArrayList l1 = (ArrayList)PIN_TYPES.get(t);
        int c = this.isCapacitor() ? 1 : 0;
        ArrayList l2 = (ArrayList)l1.get(c);
        int s = this.numSeries() - 1;
        Set pinTypes = (Set)l2.get(s);
        return pinTypes;
    }

    private Transistor(Type np, NccNameProxy.PartNameProxy name, double width, double length, Wire[] pins) {
        super(name, pins);
        this.type = np;
        this.width = width;
        this.length = length;
        LayoutLib.error(this.type == null, "null type?");
        this.term_coeffs = CoeffGen.getCoeffArray(pins.length);
    }

    private boolean matchForward(Transistor t) {
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] == t.pins[i]) continue;
            return false;
        }
        return true;
    }

    private boolean matchReverse(Transistor t) {
        for (int i = 0; i < this.pins.length; ++i) {
            int j = this.pins.length - 1 - i;
            if (this.pins[i] == t.pins[j]) continue;
            return false;
        }
        return true;
    }

    private boolean samePinsAs(Transistor t) {
        if (this.pins.length != t.pins.length) {
            return false;
        }
        return this.matchForward(t) || this.matchReverse(t);
    }

    private void flip() {
        for (int i = 0; i < this.pins.length / 2; ++i) {
            int j = this.pins.length - 1 - i;
            Wire w = this.pins[i];
            this.pins[i] = this.pins[j];
            this.pins[j] = w;
        }
    }

    private Wire hiDiff() {
        return this.pins[this.pins.length - 1];
    }

    private Wire loDiff() {
        return this.pins[0];
    }

    public Transistor(Type np, NccNameProxy.PartNameProxy name, double width, double length, Wire src, Wire gate, Wire drn) {
        this(np, name, width, length, new Wire[]{src, gate, drn});
    }

    public Type getType() {
        return this.type;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isThisGate(int x) {
        return x != 0 && x != this.pins.length - 1;
    }

    public int numSeries() {
        return this.pins.length - 2;
    }

    public int[] getTermCoefs() {
        return this.term_coeffs;
    }

    public boolean touchesAtGate(Wire w) {
        for (int i = 1; i < this.pins.length - 1; ++i) {
            if (w != this.pins[i]) continue;
            return true;
        }
        return false;
    }

    public boolean touchesOneDiffPinAndNoOtherPins(Wire w) {
        return w == this.pins[0] ^ w == this.pins[this.pins.length - 1] && !this.touchesAtGate(w);
    }

    public boolean isCapacitor() {
        return this.pins[0] == this.pins[this.pins.length - 1];
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.term_coeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.type.hashCode());
    }

    public boolean parallelMerge(Part p) {
        if (!(p instanceof Transistor)) {
            return false;
        }
        Transistor t = (Transistor)p;
        if (this == t) {
            return false;
        }
        if (!this.isLike(t)) {
            return false;
        }
        if (!this.samePinsAs(t)) {
            return false;
        }
        this.width += t.width;
        t.setDeleted();
        return true;
    }

    public int typeCode() {
        int tw = 4;
        return 1 + ((this.isCapacitor() ? 1 : 0) << 4) + (this.type.getOrdinal() << 5) + (this.numSeries() << 5 + TYPES.log2NumTypes());
    }

    public String typeString() {
        String t = this.type.name;
        String c = this.isCapacitor() ? "_CAP" : "";
        String h = this.pins.length == 3 ? "" : "_" + (this.pins.length - 2) + "stack";
        return t + c + h;
    }

    public String valueDescription() {
        return "W=" + NccUtils.round(this.width, 2) + " L=" + NccUtils.round(this.length, 2);
    }

    public String connectionDescription(int n) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            msg = i == 0 ? msg + "S=" : (i == this.pins.length - 1 ? msg + " D=" : (this.pins.length == 3 ? msg + " G=" : msg + " G" + i + "="));
            msg = msg + this.pins[i].getName();
        }
        return msg;
    }

    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = i == 0 ? s + "S" : (i == this.pins.length - 1 ? s + "D" : (this.pins.length == 3 ? s + "G" : s + "G" + i));
        }
        return s;
    }

    public boolean isLike(Transistor t) {
        return this.type == t.type && this.length == t.length;
    }

    public static boolean joinOnWire(Wire w) {
        if (w.isDeleted()) {
            return false;
        }
        if (w.getPort() != null) {
            return false;
        }
        HashSet<Transistor> trans = new HashSet<Transistor>();
        Iterator it = w.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (p.isDeleted()) continue;
            if (!(p instanceof Transistor)) {
                return false;
            }
            Transistor t = (Transistor)p;
            if (!t.touchesOneDiffPinAndNoOtherPins(w)) {
                return false;
            }
            trans.add(t);
            if (trans.size() <= 2) continue;
            return false;
        }
        if (trans.size() != 2) {
            return false;
        }
        it = trans.iterator();
        Transistor ta = (Transistor)it.next();
        Transistor tb = (Transistor)it.next();
        Transistor.error(ta.getParent() != tb.getParent(), "mismatched parents?");
        if (!ta.isLike(tb)) {
            return false;
        }
        if (ta.width != tb.width) {
            return false;
        }
        if (ta.hiDiff() != w) {
            ta.flip();
        }
        if (tb.loDiff() != w) {
            tb.flip();
        }
        Transistor.error(ta.hiDiff() != w || tb.loDiff() != w, "joinOnWire: diffusion connections corrupted");
        Wire[] mergedPins = new Wire[ta.pins.length + tb.pins.length - 2];
        for (int aNdx = 0; aNdx < ta.pins.length - 1; ++aNdx) {
            mergedPins[aNdx] = ta.pins[aNdx];
        }
        for (int bNdx = 1; bNdx < tb.pins.length; ++bNdx) {
            mergedPins[aNdx++] = tb.pins[bNdx];
        }
        Transistor stack = new Transistor(ta.getType(), ta.getNameProxy(), ta.getWidth(), ta.getLength(), mergedPins);
        Circuit parent = tb.getParent();
        parent.adopt(stack);
        ta.setDeleted();
        tb.setDeleted();
        w.setDeleted();
        return true;
    }

    public Integer computeHashCode() {
        int sumLo = 0;
        int sumHi = 0;
        for (int i = 0; i < (this.pins.length + 1) / 2; ++i) {
            sumLo += this.pins[i].getCode() * this.term_coeffs[i];
            int j = this.pins.length - 1 - i;
            sumHi += this.pins[j].getCode() * this.term_coeffs[j];
        }
        return new Integer(sumLo * sumHi);
    }

    static {
        Iterator it = TYPES.iterator();
        while (it.hasNext()) {
            Type type = (Type)it.next();
            ArrayList tList = new ArrayList();
            PIN_TYPES.add(tList);
            for (int j = 0; j < 2; ++j) {
                ArrayList cList = new ArrayList();
                tList.add(cList);
                boolean cap = j != 0;
                for (int numSeries = 1; numSeries <= 5; ++numSeries) {
                    HashSet<PinType> pinTypes = new HashSet<PinType>();
                    cList.add(pinTypes);
                    pinTypes.add(new DiffType(type, numSeries, cap));
                    int maxHeight = (numSeries + 1) / 2;
                    for (int gateHeight = 1; gateHeight <= maxHeight; ++gateHeight) {
                        pinTypes.add(new GateType(type, numSeries, gateHeight, cap));
                    }
                }
            }
        }
    }

    private static class CoeffGen {
        private static ArrayList coeffArrays = new ArrayList();

        private CoeffGen() {
        }

        private static void ensureListEntry(int numPins) {
            while (coeffArrays.size() - 1 < numPins) {
                coeffArrays.add(null);
            }
        }

        public static int[] getCoeffArray(int numPins) {
            CoeffGen.ensureListEntry(numPins);
            int[] coeffArray = (int[])coeffArrays.get(numPins);
            if (coeffArray == null) {
                coeffArray = new int[numPins];
                for (int i = 0; i < (numPins + 1) / 2; ++i) {
                    int j = numPins - 1 - i;
                    int nthPrime = 30 + i + numPins;
                    coeffArray[i] = coeffArray[j] = Primes.get(nthPrime);
                }
                coeffArrays.set(numPins, coeffArray);
            }
            return coeffArray;
        }
    }

    private static class DiffType
    implements PinType {
        private final int numSeries;
        private final Type np;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Transistor)) {
                return 0;
            }
            Transistor t = (Transistor)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int count = 0;
            if (t.pins[0] == w) {
                ++count;
            }
            if (t.pins[this.numSeries + 1] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np.getName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            return t + c + h + " diffusion";
        }

        public DiffType(Type np, int numSeries, boolean cap) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            this.np = np;
            this.numSeries = numSeries;
            this.cap = cap;
        }
    }

    private static class GateType
    implements PinType {
        private final int numSeries;
        private final Type np;
        private final int gateHeight;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Transistor)) {
                return 0;
            }
            Transistor t = (Transistor)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int loGate = this.gateHeight;
            int hiGate = this.numSeries + 1 - this.gateHeight;
            int numPins = this.numSeries + 2;
            int count = 0;
            if (t.pins[loGate] == w) {
                ++count;
            }
            if (loGate != hiGate && t.pins[hiGate] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np.getName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            int hiGate = this.numSeries + 1 - this.gateHeight;
            String g = "";
            if (this.numSeries > 2) {
                g = this.gateHeight + (this.gateHeight == hiGate ? "" : "/" + hiGate);
            }
            return t + c + h + " gate" + g;
        }

        public GateType(Type np, int numSeries, int gateHeight, boolean cap) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            LayoutLib.error(gateHeight > highestGateInLowerHalfOfStack, "bad gate Height");
            this.np = np;
            this.numSeries = numSeries;
            this.gateHeight = gateHeight;
            this.cap = cap;
        }
    }

    public static class TypeTable {
        private int numTypes = 0;
        private int log2NumTypes;
        private ArrayList types = new ArrayList();
        private HashMap nameToType = new HashMap();
        private HashMap longNameToType = new HashMap();

        private void add(String typeName, String longTypeName) {
            Type t = new Type(this.numTypes++, typeName);
            LayoutLib.error(this.nameToType.containsKey(typeName), "duplicate type name");
            this.nameToType.put(typeName, t);
            LayoutLib.error(this.longNameToType.containsKey(longTypeName), "duplicate long type name");
            this.longNameToType.put(longTypeName, t);
            this.types.add(t);
            this.log2NumTypes = (int)Math.ceil(Math.log(this.numTypes) / Math.log(2.0));
        }

        private TypeTable() {
            this.add("NMOS", "N-Transistor");
            this.add("NMOS-VTH", "VTH-N-Transistor");
            this.add("NMOS-VTL", "VTL-N-Transistor");
            this.add("NMOS-NT", "NT-N-Transistor");
            this.add("NMOS-OD18", "OD18-N-Transistor");
            this.add("PMOS", "P-Transistor");
            this.add("PMOS-VTH", "VTH-P-Transistor");
            this.add("PMOS-VTL", "VTL-P-Transistor");
            this.add("PMOS-OD18", "OD18-P-Transistor");
        }

        public int log2NumTypes() {
            return this.log2NumTypes;
        }

        public Iterator iterator() {
            return this.types.iterator();
        }

        public Type get(String nm) {
            return (Type)this.nameToType.get(nm);
        }

        public Type getTypeFromLongName(String nm) {
            return (Type)this.longNameToType.get(nm);
        }
    }

    public static class Type {
        private String name;
        private int ordinal;

        private Type(int ord, String s) {
            this.ordinal = ord;
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }
}

